/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.NegotiationPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class NegotiationPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements NegotiationPersonMassChangeService {
    private static final String NEGOTIATION = "negotiation";
    private static final String NEGOTIATION_WARNINGS = "negotiationWarnings";

    public List<Negotiation> getNegotiationChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<Negotiation> negotiationChangeCandidates = new ArrayList<Negotiation>();
        ArrayList negotiations = new ArrayList();
        if (personMassChange.getNegotiationPersonMassChange().requiresChange()) {
            negotiations.addAll(this.getNegotiations(personMassChange));
        }
        for (Negotiation negotiation : negotiations) {
            if (!this.isNegotiationChangeCandidate(personMassChange, negotiation)) continue;
            negotiationChangeCandidates.add(negotiation);
        }
        for (Negotiation negotiationChangeCandidate : negotiationChangeCandidates) {
            if (negotiationChangeCandidate.getDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(negotiationChangeCandidate);
        }
        return negotiationChangeCandidates;
    }

    private List<Negotiation> getNegotiations(PersonMassChange personMassChange) {
        return new ArrayList<Negotiation>(this.getBusinessObjectService().findAll(Negotiation.class));
    }

    private boolean isNegotiationChangeCandidate(PersonMassChange personMassChange, Negotiation negotiation) {
        boolean isNegotiationChangeCandidate = false;
        if (personMassChange.getNegotiationPersonMassChange().isNegotiator()) {
            isNegotiationChangeCandidate |= this.isNegotiatorChangeCandidate(personMassChange, negotiation);
        }
        return isNegotiationChangeCandidate;
    }

    private boolean isNegotiatorChangeCandidate(PersonMassChange personMassChange, Negotiation negotiation) {
        return this.isPersonIdMassChange(personMassChange, negotiation.getNegotiatorPersonId());
    }

    public void performPersonMassChange(PersonMassChange personMassChange, List<Negotiation> negotiationChangeCandidates) {
        for (Negotiation negotiationChangeCandidate : negotiationChangeCandidates) {
            if (!negotiationChangeCandidate.getDocument().getPessimisticLocks().isEmpty()) continue;
            this.performNegotiatorPersonMassChange(personMassChange, negotiationChangeCandidate);
        }
    }

    private void performNegotiatorPersonMassChange(PersonMassChange personMassChange, Negotiation negotiation) {
        if (personMassChange.getNegotiationPersonMassChange().isNegotiator()) {
            KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
            negotiation.setNegotiatorPersonId(kcPerson.getPersonId());
            negotiation.setNegotiatorName(kcPerson.getFullName());
            this.getBusinessObjectService().save((PersistableBusinessObject)negotiation);
        }
    }

    private void reportSoftError(Negotiation negotiation) {
        Long negotiationId = negotiation.getNegotiationId();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", new String[]{NEGOTIATION, String.valueOf(negotiationId)});
    }

    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((Negotiation)parent).getNegotiationId().toString();
    }

    protected String getDocumentName() {
        return NEGOTIATION;
    }

    protected String getWarningKey() {
        return NEGOTIATION_WARNINGS;
    }
}

