/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.ProposalLogPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class ProposalLogPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements ProposalLogPersonMassChangeService {
    private static final String PROPOSAL_LOG = "proposal log";
    private static final String PROPOSAL_LOG_WARNINGS = "propLogWarnings";

    public List<ProposalLog> getProposalLogChangeCandidates(PersonMassChange personMassChange) {
        HashSet<ProposalLog> proposalLogChangeCandidates = new HashSet<ProposalLog>();
        ArrayList proposalLogs = new ArrayList();
        if (personMassChange.getProposalLogPersonMassChange().requiresChange()) {
            proposalLogs.addAll(this.getBusinessObjectService().findAll(ProposalLog.class));
        }
        for (ProposalLog proposalLog : proposalLogs) {
            if (!this.isProposalLogChangeCandidate(personMassChange, proposalLog)) continue;
            proposalLogChangeCandidates.add(proposalLog);
        }
        return new ArrayList<ProposalLog>(proposalLogChangeCandidates);
    }

    private boolean isProposalLogChangeCandidate(PersonMassChange personMassChange, ProposalLog proposalLog) {
        return this.isPersonIdMassChange(personMassChange, proposalLog.getPiId()) || this.isRolodexIdMassChange(personMassChange, proposalLog.getRolodexId());
    }

    public void performPersonMassChange(PersonMassChange personMassChange, List<ProposalLog> proposalLogChangeCandidates) {
        for (ProposalLog proposalLogChangeCandidate : proposalLogChangeCandidates) {
            if (personMassChange.getReplacerPersonId() != null) {
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                proposalLogChangeCandidate.setPiId(kcPerson.getPersonId());
                proposalLogChangeCandidate.setRolodexId(null);
                proposalLogChangeCandidate.setPiName(kcPerson.getFullName());
            } else if (personMassChange.getReplacerRolodexId() != null) {
                Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId().intValue());
                proposalLogChangeCandidate.setPiId(null);
                proposalLogChangeCandidate.setRolodexId(rolodex.getRolodexId());
                proposalLogChangeCandidate.setPiName(rolodex.getFullName());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)proposalLogChangeCandidate);
        }
    }

    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((ProposalLog)parent).getProposalNumber();
    }

    protected String getDocumentName() {
        return PROPOSAL_LOG;
    }

    protected String getWarningKey() {
        return PROPOSAL_LOG_WARNINGS;
    }
}

