/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.printing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.kuali.kra.printing.PersonSignaturePrintHelper;

public class PersonSignatureLocationHelper
extends PDFTextStripper {
    private StringBuffer documentText = new StringBuffer();
    private List<String> signatureTags;
    private String currentSignatureTag;
    private boolean signatureTagExists = false;
    private List<PersonSignaturePrintHelper> personSignatureLocations;
    private HashMap<String, Vector<Float>> signatureTagPositions;

    public PersonSignatureLocationHelper(List<String> signatureTags) throws IOException {
        super.setSortByPosition(true);
        this.setPersonSignatureLocations(new ArrayList());
        this.setSignatureTagPositions(new HashMap());
        this.setSignatureTags(signatureTags);
    }

    protected void processTextPosition(TextPosition text) {
        this.getDocumentText().append(text.getCharacter());
        this.matchSignatureTagAndRecordPosition(text);
        if (this.isSignatureTagFound()) {
            int totalSignatureStartChar = this.getCountMatchOfSignatureTagFirstCharacter();
            int positionInCollection = this.getStartCharacterXposition().size() - totalSignatureStartChar;
            float coordinateXofStart = ((Float)this.getStartCharacterXposition().get(positionInCollection)).floatValue();
            this.setSignatureTagExists(true);
            PersonSignaturePrintHelper signaturePrintHelper = new PersonSignaturePrintHelper();
            signaturePrintHelper.setCoordinateX(coordinateXofStart);
            signaturePrintHelper.setCoordinateY(text.getTextPos().getYPosition());
            this.getPersonSignatureLocations().add(signaturePrintHelper);
        }
    }

    private void matchSignatureTagAndRecordPosition(TextPosition text) {
        for (String signatureTag : this.getSignatureTags()) {
            if (!signatureTag.startsWith(text.getCharacter())) continue;
            Vector<Float> startCharacterXposition = (Vector<Float>)this.getSignatureTagPositions().get(signatureTag);
            if (startCharacterXposition == null) {
                startCharacterXposition = new Vector<Float>();
            }
            startCharacterXposition.add(Float.valueOf(text.getTextPos().getXPosition()));
            this.getSignatureTagPositions().put(signatureTag, startCharacterXposition);
        }
    }

    private boolean isSignatureTagFound() {
        boolean signatureTagFound = false;
        for (String signatureTag : this.getSignatureTags()) {
            if (!this.getDocumentText().toString().endsWith(signatureTag)) continue;
            this.setCurrentSignatureTag(signatureTag);
            signatureTagFound = true;
            break;
        }
        return signatureTagFound;
    }

    protected int getCountMatchOfSignatureTagFirstCharacter() {
        String firstChar = Character.toString(this.getCurrentSignatureTag().charAt(0));
        return StringUtils.countMatches((String)this.getCurrentSignatureTag(), (String)firstChar);
    }

    public StringBuffer getDocumentText() {
        return this.documentText;
    }

    public void setDocumentText(StringBuffer documentText) {
        this.documentText = documentText;
    }

    public List<String> getSignatureTags() {
        return this.signatureTags;
    }

    public void setSignatureTags(List<String> signatureTags) {
        this.signatureTags = signatureTags;
    }

    public boolean isSignatureTagExists() {
        return this.signatureTagExists;
    }

    public void setSignatureTagExists(boolean signatureTagExists) {
        this.signatureTagExists = signatureTagExists;
    }

    public List<PersonSignaturePrintHelper> getPersonSignatureLocations() {
        return this.personSignatureLocations;
    }

    public void setPersonSignatureLocations(List<PersonSignaturePrintHelper> personSignatureLocations) {
        this.personSignatureLocations = personSignatureLocations;
    }

    protected Vector<Float> getStartCharacterXposition() {
        return (Vector)this.getSignatureTagPositions().get(this.getCurrentSignatureTag());
    }

    public HashMap<String, Vector<Float>> getSignatureTagPositions() {
        return this.signatureTagPositions;
    }

    public void setSignatureTagPositions(HashMap<String, Vector<Float>> signatureTagPositions) {
        this.signatureTagPositions = signatureTagPositions;
    }

    public String getCurrentSignatureTag() {
        return this.currentSignatureTag;
    }

    public void setCurrentSignatureTag(String currentSignatureTag) {
        this.currentSignatureTag = currentSignatureTag;
    }
}

