/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.printing.service.impl;

import java.util.List;
import java.util.Map;
import org.kuali.kra.common.printing.CurrentReportBean;
import org.kuali.kra.common.printing.PendingReportBean;
import org.kuali.kra.dao.CurrentReportDao;
import org.kuali.kra.dao.PendingReportDao;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.CurrentProposalPrint;
import org.kuali.kra.printing.print.PendingProposalPrint;
import org.kuali.kra.printing.service.CurrentAndPendingReportService;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CurrentAndPendingReportServiceImpl
implements CurrentAndPendingReportService {
    private CurrentReportDao currentReportDao;
    private PendingReportDao pendingReportDao;
    private PrintingService printingService;
    private CurrentProposalPrint currentProposalPrint;
    private PendingProposalPrint pendingProposalPrint;

    public void setCurrentReportDao(CurrentReportDao currentReportDao) {
        this.currentReportDao = currentReportDao;
    }

    public void setPendingReportDao(PendingReportDao pendingReportDao) {
        this.pendingReportDao = pendingReportDao;
    }

    public void setCurrentProposalPrint(CurrentProposalPrint currentProposalPrint) {
        this.currentProposalPrint = currentProposalPrint;
    }

    public void setPendingProposalPrint(PendingProposalPrint pendingProposalPrint) {
        this.pendingProposalPrint = pendingProposalPrint;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public List<CurrentReportBean> loadCurrentReportData(String personId) {
        List data;
        try {
            data = this.currentReportDao.queryForCurrentSupport(personId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public List<PendingReportBean> loadPendingReportData(String personId) {
        List data;
        try {
            data = this.pendingReportDao.queryForPendingSupport(personId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public AttachmentDataSource printCurrentAndPendingSupportReport(String reportName, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        CurrentProposalPrint printable = null;
        if (reportName.equals("Current Report")) {
            reportParameters.put("Current Report Beans", this.loadCurrentReportData((String)reportParameters.get("personId")));
            printable = this.currentProposalPrint;
        } else if (reportName.equals("Pending Report")) {
            reportParameters.put("Pending Report Beans", this.loadPendingReportData((String)reportParameters.get("personId")));
            printable = this.pendingProposalPrint;
        }
        printable.setPrintableBusinessObject(null);
        printable.setReportParameters(reportParameters);
        source = this.printingService.print((Printable)printable);
        source.setFileName(reportName.replace(' ', '_') + ".pdf");
        return source;
    }
}

