/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.printing.service.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.PrintableAttachment;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PrintingServiceImpl
implements PrintingService {
    private static final Log LOG = LogFactory.getLog(PrintingServiceImpl.class);
    private DateTimeService dateTimeService = null;
    private WatermarkService watermarkService;
    private ConfigurationService kualiConfigurationService;

    protected Map<String, byte[]> getPrintBytes(Printable printableArtifact) throws PrintingException {
        try {
            Map streamMap = printableArtifact.renderXML();
            try {
                String loggingEnable = this.kualiConfigurationService.getPropertyValueAsString("print.logging.enable");
                if (loggingEnable != null && Boolean.parseBoolean(loggingEnable)) {
                    this.logPrintDetails(streamMap);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getMessage());
            }
            LinkedHashMap<String, byte[]> pdfByteMap = new LinkedHashMap<String, byte[]>();
            FopFactory fopFactory = FopFactory.newInstance();
            int xslCount = 0;
            if (printableArtifact.getXSLTemplates() != null) {
                for (Source source : printableArtifact.getXSLTemplates()) {
                    StreamSource xslt = (StreamSource)source;
                    this.createPdfWithFOP(streamMap, pdfByteMap, fopFactory, ++xslCount, xslt, printableArtifact);
                }
            } else if (printableArtifact.getXSLTemplateWithBookmarks() != null) {
                Map templatesWithBookmarks = printableArtifact.getXSLTemplateWithBookmarks();
                for (Map.Entry templatesWithBookmark : templatesWithBookmarks.entrySet()) {
                    StreamSource xslt = (StreamSource)templatesWithBookmark.getValue();
                    this.createPdfWithFOP(streamMap, pdfByteMap, fopFactory, xslCount, xslt, (String)templatesWithBookmark.getKey(), printableArtifact);
                }
            }
            if (printableArtifact.getAttachments() != null) {
                pdfByteMap.putAll(printableArtifact.getAttachments());
            }
            return pdfByteMap;
        }
        catch (FOPException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new PrintingException(e.getMessage(), (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new PrintingException(e.getMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new PrintingException(e.getMessage(), (Throwable)e);
        }
    }

    protected void createPdfWithFOP(Map<String, byte[]> streamMap, Map<String, byte[]> pdfByteMap, FopFactory fopFactory, int xslCount, StreamSource xslt, Printable printableArtifact) throws FOPException, TransformerException {
        this.createPdfWithFOP(streamMap, pdfByteMap, fopFactory, xslCount, xslt, null, printableArtifact);
    }

    protected void createPdfWithFOP(Map<String, byte[]> streamMap, Map<String, byte[]> pdfByteMap, FopFactory fopFactory, int xslCount, StreamSource xslt, String bookmark, Printable printableArtifact) throws FOPException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslt);
        for (Map.Entry<String, byte[]> xmlData : streamMap.entrySet()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlData.getValue());
            StreamSource src = new StreamSource(inputStream);
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)outputStream);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            byte[] pdfBytes = outputStream.toByteArray();
            if (pdfBytes == null || pdfBytes.length <= 0) continue;
            String pdfMapKey = bookmark == null ? this.createBookMark(xslCount, xmlData.getKey()) : bookmark;
            pdfByteMap.put(pdfMapKey, pdfBytes);
        }
    }

    protected String createBookMark(int xslCount, String bookmarkKey) {
        String pdfMapKey = bookmarkKey + (xslCount == 1 ? "" : " " + xslCount);
        return pdfMapKey;
    }

    public AttachmentDataSource print(Printable printableArtifacts) throws PrintingException {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        printables.add(printableArtifacts);
        return this.print(printables);
    }

    public AttachmentDataSource print(List<Printable> printableArtifactList) throws PrintingException {
        return this.print(printableArtifactList, false);
    }

    public AttachmentDataSource print(List<Printable> printableArtifactList, boolean headerFooterRequired) throws PrintingException {
        PrintableAttachment printablePdf = null;
        ArrayList<String> bookmarksList = new ArrayList<String>();
        ArrayList<byte[]> pdfBaosList = new ArrayList<byte[]>();
        for (Printable printableArtifact : printableArtifactList) {
            Map printBytes = this.getPrintBytes(printableArtifact);
            for (String bookmark : printBytes.keySet()) {
                byte[] pdfBytes = (byte[])printBytes.get(bookmark);
                if (!this.isPdfGoodToMerge(pdfBytes)) continue;
                bookmarksList.add(bookmark);
                pdfBaosList.add(pdfBytes);
            }
        }
        printablePdf = new PrintableAttachment();
        byte[] mergedPdfBytes = this.mergePdfBytes(pdfBaosList, bookmarksList, headerFooterRequired);
        if (mergedPdfBytes == null) {
            mergedPdfBytes = new byte[]{};
        }
        printablePdf.setContent(mergedPdfBytes);
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getReportName());
        fileName.append(".pdf");
        printablePdf.setFileName(fileName.toString());
        printablePdf.setContentType("application/pdf");
        return printablePdf;
    }

    protected boolean isPdfGoodToMerge(byte[] pdfBytes) {
        try {
            new PdfReader(pdfBytes);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getReportName() {
        String dateString = this.getDateTimeService().getCurrentDate().toString();
        return StringUtils.deleteWhitespace((String)dateString);
    }

    protected byte[] mergePdfBytes(List<byte[]> pdfBytesList, List<String> bookmarksList, boolean headerFooterRequired) throws PrintingException {
        PdfReader reader;
        Document document = null;
        PdfWriter writer = null;
        ByteArrayOutputStream mergedPdfReport = new ByteArrayOutputStream();
        int totalNumOfPages = 0;
        PdfReader[] pdfReaderArr = new PdfReader[pdfBytesList.size()];
        int pdfReaderCount = 0;
        for (byte[] fileBytes : pdfBytesList) {
            LOG.debug((Object)("File Size " + fileBytes.length + " For " + bookmarksList.get(pdfReaderCount)));
            reader = null;
            try {
                pdfReaderArr[pdfReaderCount] = reader = new PdfReader(fileBytes);
                ++pdfReaderCount;
                totalNumOfPages += reader.getNumberOfPages();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HeaderFooter footer = null;
        if (headerFooterRequired) {
            Calendar calendar = this.dateTimeService.getCurrentCalendar();
            String dateString = this.formateCalendar(calendar);
            StringBuilder footerPhStr = new StringBuilder();
            footerPhStr.append(" of ");
            footerPhStr.append(totalNumOfPages);
            footerPhStr.append(this.getWhitespaceString(76));
            footerPhStr.append(this.getWhitespaceString(76));
            footerPhStr.append(this.getWhitespaceString(60));
            footerPhStr.append(dateString);
            Font font = FontFactory.getFont((String)"Times", (float)8.0f, (int)0, (Color)Color.BLACK);
            Phrase beforePhrase = new Phrase("Page ", font);
            Phrase afterPhrase = new Phrase(footerPhStr.toString(), font);
            footer = new HeaderFooter(beforePhrase, afterPhrase);
            footer.setAlignment(7);
            footer.setBorderWidth(0.0f);
        }
        for (int count = 0; count < pdfReaderArr.length; ++count) {
            reader = pdfReaderArr[count];
            if (reader == null) {
                LOG.debug((Object)("Empty PDF byetes found for " + bookmarksList.get(count)));
                continue;
            }
            int nop = reader.getNumberOfPages();
            if (count == 0) {
                document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)mergedPdfReport);
                }
                catch (DocumentException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw new PrintingException(e.getMessage(), (Throwable)e);
                }
                if (footer != null) {
                    document.setFooter(footer);
                }
                document.open();
            }
            PdfContentByte cb = writer.getDirectContent();
            int pageCount = 0;
            while (pageCount < nop) {
                document.setPageSize(reader.getPageSize(++pageCount));
                document.newPage();
                if (footer != null) {
                    document.setFooter(footer);
                }
                PdfImportedPage page = writer.getImportedPage(reader, pageCount);
                cb.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                PdfOutline root = cb.getRootOutline();
                if (pageCount != 1) continue;
                String pageName = bookmarksList.get(count);
                cb.addOutline(new PdfOutline(root, new PdfDestination(2), pageName), pageName);
            }
        }
        if (document != null) {
            try {
                document.close();
                return mergedPdfReport.toByteArray();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception occured because the generated PDF document has no pages", (Throwable)e);
            }
        }
        return null;
    }

    protected String formateCalendar(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("M/d/yy h:mm a");
        return dateFormat.format(calendar.getTime());
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected String getWhitespaceString(int length) {
        StringBuffer sb = new StringBuffer();
        char[] whiteSpace = new char[length];
        Arrays.fill(whiteSpace, ' ');
        sb.append(whiteSpace);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logPrintDetails(Map<String, byte[]> xmlStreamMap) throws PrintingException {
        byte[] xmlBytes = null;
        String xmlString = null;
        String loggingDirectory = this.kualiConfigurationService.getPropertyValueAsString("print.logging.directory");
        Iterator<String> it = xmlStreamMap.keySet().iterator();
        if (loggingDirectory != null) {
            BufferedWriter out = null;
            try {
                while (it.hasNext()) {
                    String key = it.next();
                    xmlBytes = xmlStreamMap.get(key);
                    xmlString = new String(xmlBytes);
                    String dateString = this.getDateTimeService().getCurrentTimestamp().toString();
                    String reportName = StringUtils.deleteWhitespace((String)key);
                    String createdTime = StringUtils.replaceChars((String)StringUtils.deleteWhitespace((String)dateString), (String)":", (String)"_");
                    File dir = new File(loggingDirectory);
                    if (!dir.exists() || !dir.isDirectory()) {
                        dir.mkdirs();
                    }
                    File file = new File(dir, reportName + createdTime + ".xml");
                    out = new BufferedWriter(new FileWriter(file));
                    out.write(xmlString);
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public WatermarkService getWatermarkService() {
        return this.watermarkService;
    }

    public void setWatermarkService(WatermarkService watermarkService) {
        this.watermarkService = watermarkService;
    }
}

