/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.bo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.bo.KcAttachment;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeStatus;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.NarrativeTask;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyMaintainable;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;

public class Narrative
extends KraPersistableBusinessObjectBase
implements HierarchyMaintainable,
KcAttachment {
    private static final Log LOG = LogFactory.getLog(Narrative.class);
    private String proposalNumber;
    private Integer moduleNumber;
    private String comments;
    private String contactName;
    private String emailAddress;
    private Integer moduleSequenceNumber;
    private String moduleStatusCode;
    private String moduleTitle;
    private String narrativeTypeCode;
    private String phoneNumber;
    private NarrativeType narrativeType;
    private NarrativeStatus narrativeStatus;
    private String fileName;
    private String contentType;
    private List<NarrativeUserRights> narrativeUserRights;
    private List<NarrativeAttachment> narrativeAttachmentList = new ArrayList(1);
    private transient FormFile narrativeFile;
    private String institutionalAttachmentTypeCode;
    private Timestamp timestampDisplay;
    private String uploadUserDisplay;
    private String uploadUserFullName;
    private String hierarchyProposalNumber;
    private boolean hiddenInHierarchy;

    public Narrative() {
        this.narrativeUserRights = new ArrayList();
    }

    protected String findLoggedInUserPersonId() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalId();
    }

    public Integer getModuleNumber() {
        return this.moduleNumber;
    }

    public void setModuleNumber(Integer moduleNumber) {
        this.moduleNumber = moduleNumber;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Integer getModuleSequenceNumber() {
        return this.moduleSequenceNumber;
    }

    public void setModuleSequenceNumber(Integer moduleSequenceNumber) {
        this.moduleSequenceNumber = moduleSequenceNumber;
    }

    public String getModuleStatusCode() {
        return this.moduleStatusCode;
    }

    public void setModuleStatusCode(String moduleStatusCode) {
        this.moduleStatusCode = moduleStatusCode;
    }

    public String getModuleTitle() {
        return this.moduleTitle;
    }

    public void setModuleTitle(String moduleTitle) {
        this.moduleTitle = moduleTitle;
    }

    public String getNarrativeTypeCode() {
        return this.narrativeTypeCode;
    }

    public void setNarrativeTypeCode(String narrativeTypeCode) {
        this.narrativeTypeCode = narrativeTypeCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public NarrativeType getNarrativeType() {
        return this.narrativeType;
    }

    public void setNarrativeType(NarrativeType narrativeType) {
        this.narrativeType = narrativeType;
    }

    public List<NarrativeUserRights> getNarrativeUserRights() {
        if (this.narrativeUserRights != null) {
            Collections.sort(this.narrativeUserRights, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.narrativeUserRights;
    }

    public void setNarrativeUserRights(List<NarrativeUserRights> narrativeUserRights) {
        this.narrativeUserRights = narrativeUserRights;
    }

    public NarrativeStatus getNarrativeStatus() {
        return this.narrativeStatus;
    }

    public void setNarrativeStatus(NarrativeStatus narrativeStatus) {
        this.narrativeStatus = narrativeStatus;
    }

    public List<NarrativeAttachment> getNarrativeAttachmentList() {
        return this.narrativeAttachmentList;
    }

    public void setNarrativeAttachmentList(List<NarrativeAttachment> narrativePdfList) {
        this.narrativeAttachmentList = narrativePdfList;
    }

    public FormFile getNarrativeFile() {
        return this.narrativeFile;
    }

    public void setNarrativeFile(FormFile narrativeFile) {
        this.narrativeFile = narrativeFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getInstitutionalAttachmentTypeCode() {
        return this.narrativeTypeCode;
    }

    public void setInstitutionalAttachmentTypeCode(String institutionalAttachmentTypeCode) {
        this.narrativeTypeCode = institutionalAttachmentTypeCode;
    }

    public boolean getDownloadAttachment(String userId) {
        if (this.getNarrativeUserRights().isEmpty()) {
            this.refreshReferenceObject("narrativeUserRights");
        }
        TaskAuthorizationService taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthorizationService.isAuthorized(userId, (Task)new NarrativeTask("downloadNarrative", this.getDocument(), this));
    }

    public boolean getReplaceAttachment(String userId) {
        if (this.getNarrativeUserRights().isEmpty()) {
            this.refreshReferenceObject("narrativeUserRights");
        }
        TaskAuthorizationService taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthorizationService.isAuthorized(userId, (Task)new NarrativeTask("replaceNarrative", this.getDocument(), this));
    }

    public boolean getDeleteAttachment(String userId) {
        if (this.getNarrativeUserRights().isEmpty()) {
            this.refreshReferenceObject("narrativeUserRights");
        }
        TaskAuthorizationService taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthorizationService.isAuthorized(userId, (Task)new NarrativeTask("deleteNarrative", this.getDocument(), this));
    }

    public boolean getModifyNarrativeRights(String userId) {
        if (this.getNarrativeUserRights().isEmpty()) {
            this.refreshReferenceObject("narrativeUserRights");
        }
        TaskAuthorizationService taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthorizationService.isAuthorized(userId, (Task)new NarrativeTask("modifyNarrativeRights", this.getDocument(), this));
    }

    private ProposalDevelopmentDocument getDocument() {
        ProposalDevelopmentDocument doc = null;
        ProposalDevelopmentForm form = (ProposalDevelopmentForm)KNSGlobalVariables.getKualiForm();
        if (form != null) {
            doc = form.getProposalDevelopmentDocument();
        }
        return doc;
    }

    public void populateAttachment() {
        FormFile narrativeFile = this.getNarrativeFile();
        if (narrativeFile == null) {
            return;
        }
        try {
            byte[] narrativeFileData = narrativeFile.getFileData();
            if (narrativeFileData.length > 0) {
                NarrativeAttachment narrativeAttachment;
                if (this.getNarrativeAttachmentList().isEmpty()) {
                    narrativeAttachment = new NarrativeAttachment();
                    this.getNarrativeAttachmentList().add(narrativeAttachment);
                } else {
                    narrativeAttachment = (NarrativeAttachment)this.getNarrativeAttachmentList().get(0);
                    if (narrativeAttachment == null) {
                        narrativeAttachment = new NarrativeAttachment();
                        this.getNarrativeAttachmentList().set(0, narrativeAttachment);
                    }
                }
                String fileName = narrativeFile.getFileName();
                narrativeAttachment.setFileName(fileName);
                narrativeAttachment.setContentType(narrativeFile.getContentType());
                narrativeAttachment.setNarrativeData(narrativeFile.getFileData());
                narrativeAttachment.setProposalNumber(this.getProposalNumber());
                narrativeAttachment.setModuleNumber(this.getModuleNumber());
                this.setFileName(narrativeAttachment.getFileName());
                this.setContentType(narrativeAttachment.getContentType());
            } else {
                this.getNarrativeAttachmentList().clear();
            }
        }
        catch (FileNotFoundException e) {
            this.getNarrativeAttachmentList().clear();
        }
        catch (IOException e) {
            this.getNarrativeAttachmentList().clear();
        }
    }

    public NarrativeUserRights getNarrativeUserRight(int index) {
        while (this.getNarrativeUserRights().size() <= index) {
            this.getNarrativeUserRights().add(new NarrativeUserRights());
        }
        return (NarrativeUserRights)this.getNarrativeUserRights().get(index);
    }

    public void clearAttachment() {
        this.getNarrativeAttachmentList().clear();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getNarrativeUserRights());
        return managedLists;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.contactName == null ? 0 : this.contactName.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.moduleNumber == null ? 0 : this.moduleNumber.hashCode());
        result = 31 * result + (this.moduleSequenceNumber == null ? 0 : this.moduleSequenceNumber.hashCode());
        result = 31 * result + (this.moduleStatusCode == null ? 0 : this.moduleStatusCode.hashCode());
        result = 31 * result + (this.moduleTitle == null ? 0 : this.moduleTitle.hashCode());
        result = 31 * result + (this.narrativeStatus == null ? 0 : this.narrativeStatus.hashCode());
        result = 31 * result + (this.narrativeType == null ? 0 : this.narrativeType.hashCode());
        result = 31 * result + (this.narrativeTypeCode == null ? 0 : this.narrativeTypeCode.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.proposalNumber == null ? 0 : this.proposalNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Narrative other = (Narrative)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.contactName == null ? other.contactName != null : !this.contactName.equals(other.contactName)) {
            return false;
        }
        if (this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.moduleNumber == null ? other.moduleNumber != null : !this.moduleNumber.equals(other.moduleNumber)) {
            return false;
        }
        if (this.moduleSequenceNumber == null ? other.moduleSequenceNumber != null : !this.moduleSequenceNumber.equals(other.moduleSequenceNumber)) {
            return false;
        }
        if (this.moduleStatusCode == null ? other.moduleStatusCode != null : !this.moduleStatusCode.equals(other.moduleStatusCode)) {
            return false;
        }
        if (this.moduleTitle == null ? other.moduleTitle != null : !this.moduleTitle.equals(other.moduleTitle)) {
            return false;
        }
        if (this.narrativeStatus == null ? other.narrativeStatus != null : !this.narrativeStatus.equals((Object)other.narrativeStatus)) {
            return false;
        }
        if (this.narrativeType == null ? other.narrativeType != null : !this.narrativeType.equals((Object)other.narrativeType)) {
            return false;
        }
        if (this.narrativeTypeCode == null ? other.narrativeTypeCode != null : !this.narrativeTypeCode.equals(other.narrativeTypeCode)) {
            return false;
        }
        if (this.phoneNumber == null ? other.phoneNumber != null : !this.phoneNumber.equals(other.phoneNumber)) {
            return false;
        }
        return !(this.proposalNumber == null ? other.proposalNumber != null : !this.proposalNumber.equals(other.proposalNumber));
    }

    public int hierarchyHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.contactName == null ? 0 : this.contactName.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.moduleNumber == null ? 0 : this.moduleNumber.hashCode());
        result = 31 * result + (this.moduleSequenceNumber == null ? 0 : this.moduleSequenceNumber.hashCode());
        result = 31 * result + (this.moduleStatusCode == null ? 0 : this.moduleStatusCode.hashCode());
        result = 31 * result + (this.moduleTitle == null ? 0 : this.moduleTitle.hashCode());
        result = 31 * result + (this.narrativeStatus == null ? 0 : this.narrativeStatus.hashCode());
        result = 31 * result + (this.narrativeType == null ? 0 : this.narrativeType.hashCode());
        result = 31 * result + (this.narrativeTypeCode == null ? 0 : this.narrativeTypeCode.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        return result;
    }

    public Timestamp getTimestampDisplay() {
        return this.timestampDisplay;
    }

    public void setTimestampDisplay(Timestamp timestampDisplay) {
        this.timestampDisplay = timestampDisplay;
    }

    public String getUploadUserDisplay() {
        return this.uploadUserDisplay;
    }

    public void setUploadUserDisplay(String uploadUserDisplay) {
        this.uploadUserDisplay = uploadUserDisplay;
    }

    public String getUploadUserFullName() {
        return this.uploadUserFullName;
    }

    public void setUploadUserFullName(String uploadUserFullName) {
        this.uploadUserFullName = uploadUserFullName;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getData() {
        if (this.getNarrativeAttachmentList().isEmpty()) {
            return null;
        }
        return ((NarrativeAttachment)this.getNarrativeAttachmentList().get(0)).getContent();
    }

    public String getIconPath() {
        return ((KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class)).getFileTypeIcon((KcAttachment)this);
    }

    public String getName() {
        return this.getFileName();
    }

    public String getType() {
        return this.getContentType();
    }
}

