/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.bo;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;

public class ProposalPersonComparator
implements Comparator<ProposalPerson> {
    private static final Log LOG = LogFactory.getLog(ProposalPersonComparator.class);

    private KeyPersonnelService getKeyPersonnelService() {
        return (KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class);
    }

    @Override
    public int compare(ProposalPerson person1, ProposalPerson person2) {
        int retval = 0;
        DevelopmentProposal proposal = person1.getDevelopmentProposal();
        if (person1.isInvestigator() || person2.isInvestigator()) {
            if (this.getKeyPersonnelService().isPrincipalInvestigator(person1) || this.getKeyPersonnelService().isPrincipalInvestigator(person2)) {
                if (this.getKeyPersonnelService().isPrincipalInvestigator(person1)) {
                    --retval;
                }
                if (this.getKeyPersonnelService().isPrincipalInvestigator(person2)) {
                    ++retval;
                }
            } else if (proposal.isSponsorNihMultiplePi() && (this.getKeyPersonnelService().isCoInvestigator(person1) || this.getKeyPersonnelService().isCoInvestigator(person2))) {
                if (person1.isMultiplePi()) {
                    --retval;
                }
                if (person2.isMultiplePi()) {
                    ++retval;
                }
            }
        } else if (person1.isInvestigator()) {
            --retval;
        } else if (person2.isInvestigator()) {
            ++retval;
        }
        if (retval == 0) {
            retval = this.massageOrdinalNumber(person1).compareTo(this.massageOrdinalNumber(person2));
        }
        if (retval == 0) {
            if (StringUtils.isNotBlank((String)person1.getFullName())) {
                retval = person1.getLastName().compareTo(person2.getLastName());
            } else if (StringUtils.isNotBlank((String)person2.getLastName())) {
                --retval;
            }
        }
        LOG.info((Object)("retval = " + retval));
        return retval;
    }

    private Integer massageOrdinalNumber(ProposalPerson person) {
        return person.getOrdinalPosition() != null ? person.getOrdinalPosition() : -1;
    }
}

