/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.bo;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;

public class ProposalSite
extends KraPersistableBusinessObjectBase {
    private static final long serialVersionUID = -1657749549230077805L;
    public static final int PROPOSAL_SITE_APPLICANT_ORGANIZATION = 1;
    public static final int PROPOSAL_SITE_PERFORMING_ORGANIZATION = 2;
    public static final int PROPOSAL_SITE_OTHER_ORGANIZATION = 3;
    public static final int PROPOSAL_SITE_PERFORMANCE_SITE = 4;
    private String proposalNumber;
    private Integer siteNumber;
    private String locationName;
    private Integer locationTypeCode;
    private String organizationId;
    private Organization organization;
    private Integer rolodexId;
    private Rolodex rolodex;
    private List<CongressionalDistrict> congressionalDistricts = new ArrayList();

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setSiteNumber(Integer siteNumber) {
        this.siteNumber = siteNumber;
    }

    public Integer getSiteNumber() {
        return this.siteNumber;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationTypeCode(Integer locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    public Integer getLocationTypeCode() {
        return this.locationTypeCode;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setRolodexId(Integer rolodexId) {
        if (this.rolodexId != null && !this.rolodexId.equals(rolodexId)) {
            this.congressionalDistricts.clear();
        }
        this.rolodexId = rolodexId;
        this.refreshReferenceObject("rolodex");
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setCongressionalDistricts(List<CongressionalDistrict> congressionalDistricts) {
        this.congressionalDistricts = congressionalDistricts;
    }

    public List<CongressionalDistrict> getCongressionalDistricts() {
        return this.congressionalDistricts;
    }

    public void addCongressionalDistrict(CongressionalDistrict congressionalDistrict) {
        this.congressionalDistricts.add(congressionalDistrict);
    }

    public void deleteCongressionalDistrict(int districtIndex) {
        this.congressionalDistricts.remove(districtIndex);
    }

    public void setDefaultCongressionalDistrict(CongressionalDistrict congressionalDistrict) {
        if (!this.contains(congressionalDistrict.getCongressionalDistrict())) {
            this.congressionalDistricts.add(0, congressionalDistrict);
        }
    }

    private boolean contains(String congressionalDistrictIdentifier) {
        for (CongressionalDistrict district : this.congressionalDistricts) {
            if (!StringUtils.equals((String)district.getCongressionalDistrict(), (String)congressionalDistrictIdentifier)) continue;
            return true;
        }
        return false;
    }

    public CongressionalDistrict getDefaultCongressionalDistrict() {
        if (this.congressionalDistricts == null || this.congressionalDistricts.isEmpty()) {
            return null;
        }
        return (CongressionalDistrict)this.congressionalDistricts.get(0);
    }

    public String getFirstCongressionalDistrictName() {
        CongressionalDistrict firstDistrict = this.getDefaultCongressionalDistrict();
        if (firstDistrict == null) {
            return "";
        }
        return firstDistrict.getCongressionalDistrict();
    }

    public void setDefaultCongressionalDistrictIdentifier(String districtIdentifier) {
        if (!StringUtils.isEmpty((String)districtIdentifier) && !this.contains(districtIdentifier)) {
            this.congressionalDistricts.clear();
            CongressionalDistrict defaultDistrict = new CongressionalDistrict();
            defaultDistrict.setCongressionalDistrict(districtIdentifier);
            defaultDistrict.setProposalNumber(this.proposalNumber);
            defaultDistrict.setSiteNumber(this.siteNumber);
            this.setDefaultCongressionalDistrict(defaultDistrict);
        }
    }

    public void initializeDefaultCongressionalDistrict() {
        String defaultDistrict;
        Organization organization = this.getOrganization();
        if (organization != null && !StringUtils.isEmpty((String)(defaultDistrict = organization.getCongressionalDistrict()))) {
            this.setDefaultCongressionalDistrictIdentifier(defaultDistrict);
        }
    }
}

