/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.bo;

import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class BudgetSubAwardPeriodDetail
extends BudgetAssociate {
    private static final long serialVersionUID = 2327612798304765405L;
    @DeepCopyIgnore
    private Long budgetSubAwardDetailId;
    private Integer subAwardNumber;
    private Long budgetId;
    private Integer budgetPeriod;
    private BudgetDecimal directCost = BudgetDecimal.ZERO;
    private BudgetDecimal indirectCost = BudgetDecimal.ZERO;
    private BudgetDecimal costShare = BudgetDecimal.ZERO;
    private BudgetDecimal totalCost = BudgetDecimal.ZERO;
    private transient boolean amountsModified = false;

    public BudgetSubAwardPeriodDetail() {
    }

    public BudgetSubAwardPeriodDetail(BudgetSubAwards subAward, BudgetPeriod period) {
        this.subAwardNumber = subAward.getSubAwardNumber();
        this.budgetId = period.getBudgetId();
        this.budgetPeriod = period.getBudgetPeriod();
    }

    public Long getBudgetSubAwardDetailId() {
        return this.budgetSubAwardDetailId;
    }

    public void setBudgetSubAwardDetailId(Long budgetSubAwardDetailId) {
        this.budgetSubAwardDetailId = budgetSubAwardDetailId;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public BudgetDecimal getDirectCost() {
        return this.directCost;
    }

    public void setDirectCost(BudgetDecimal directCost) {
        if (!ObjectUtils.equals((Object)this.directCost, (Object)directCost)) {
            this.amountsModified = true;
        }
        this.directCost = directCost;
    }

    public BudgetDecimal getIndirectCost() {
        return this.indirectCost;
    }

    public void setIndirectCost(BudgetDecimal indirectCost) {
        if (!ObjectUtils.equals((Object)this.indirectCost, (Object)indirectCost)) {
            this.amountsModified = true;
        }
        this.indirectCost = indirectCost;
    }

    public BudgetDecimal getCostShare() {
        return this.costShare;
    }

    public void setCostShare(BudgetDecimal costShare) {
        if (!ObjectUtils.equals((Object)this.costShare, (Object)costShare)) {
            this.amountsModified = true;
        }
        this.costShare = costShare;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public BudgetDecimal getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(BudgetDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }

    public void computeTotal() {
        BudgetDecimal total = this.getDirectCost() == null ? BudgetDecimal.ZERO : this.getDirectCost();
        total = (BudgetDecimal)total.add((AbstractKualiDecimal)(this.getIndirectCost() == null ? BudgetDecimal.ZERO : this.getIndirectCost()));
        total = (BudgetDecimal)total.add((AbstractKualiDecimal)(this.getCostShare() == null ? BudgetDecimal.ZERO : this.getCostShare()));
        this.setTotalCost(total);
    }

    public boolean isAmountsModified() {
        return this.amountsModified;
    }

    public void setAmountsModified(boolean amountsModified) {
        this.amountsModified = amountsModified;
    }
}

