/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.document;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetColumnsToAlter;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetColumnsToAlterMaintainableImpl
extends KraMaintainableImpl {
    private static Map<String, String> validationClassesMap = new HashMap();

    public void prepareForSave() {
        super.prepareForSave();
        BudgetColumnsToAlter budgetCol = (BudgetColumnsToAlter)this.businessObject;
        KraPersistenceStructureService persistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        Map columnToAttrMap = persistenceStructureService.getDBColumnToObjectAttributeMap(Budget.class);
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService(DataDictionaryService.class);
        AttributeDefinition attrDefinition = dataDictionaryService.getDataDictionary().getBusinessObjectEntry(Budget.class.getName()).getAttributeDefinition((String)columnToAttrMap.get(budgetCol.getColumnName()));
        if (attrDefinition == null) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.columnName", "error.proposalcolumnstoalter.attributeNotFound", new String[0]);
            return;
        }
        if (attrDefinition.getLabel().length() > 30) {
            budgetCol.setColumnLabel(attrDefinition.getLabel().substring(0, 29));
        } else {
            budgetCol.setColumnLabel(attrDefinition.getLabel());
        }
        budgetCol.setDataLength(attrDefinition.getMaxLength());
        String dataType = null;
        if (attrDefinition.getValidationPattern() != null) {
            String validationPattern = attrDefinition.getValidationPattern().getClass().getName();
            dataType = (String)validationClassesMap.get(validationPattern);
            if (dataType == null) {
                dataType = "STRING";
            }
        } else {
            dataType = "STRING";
        }
        budgetCol.setDataType(dataType);
    }

    static {
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaValidationPattern", "STRING");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern", "DATE");
        validationClassesMap.put("org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern", "NUMBER");
    }
}

