/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.document.authorizer;

import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.document.authorization.BudgetTask;
import org.kuali.kra.budget.document.authorizer.BudgetAuthorizer;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.krad.document.Document;

public class ModifyProposalBudgetAuthorizer
extends BudgetAuthorizer {
    public boolean isAuthorized(String userId, BudgetTask task) {
        KraDocumentRejectionService documentRejectionService = (KraDocumentRejectionService)KraServiceLocator.getService(KraDocumentRejectionService.class);
        BudgetDocument budgetDocument = task.getBudgetDocument();
        ProposalDevelopmentDocument doc = (ProposalDevelopmentDocument)budgetDocument.getParentDocument();
        boolean rejectedDocument = documentRejectionService.isDocumentOnInitialNode(doc.getDocumentNumber());
        return (!this.kraWorkflowService.isInWorkflow((Document)doc) || rejectedDocument) && this.hasParentPermission(userId, (BudgetParentDocument)doc, "Modify Budget") && doc.getDevelopmentProposal().getSubmitFlag() == false;
    }

    private boolean isBudgetCompleted(ProposalDevelopmentDocument proposalDoc, BudgetDocument budgetDocument) {
        if (!proposalDoc.getDevelopmentProposal().isProposalComplete()) {
            return false;
        }
        for (BudgetDocumentVersion budgetVersion : proposalDoc.getBudgetDocumentVersions()) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag() || !budgetVersion.getBudgetVersionOverview().getBudgetVersionNumber().equals(budgetDocument.getBudget().getBudgetVersionNumber())) continue;
            return true;
        }
        return false;
    }
}

