/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.service.impl;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.XfaForm;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardAttachment;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardFiles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetSubAwardService;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.formmapping.FormMappingLoader;
import org.kuali.kra.s2s.util.GrantApplicationHash;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * Exception performing whole class analysis ignored.
 */
public class BudgetSubAwardServiceImpl
implements BudgetSubAwardService {
    private static final String DUPLICATE_FILE_NAMES = "Duplicate PDF Attachment File Names";
    private static final String XFA_NS = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final Log LOG = LogFactory.getLog(BudgetSubAwardServiceImpl.class);
    private ParameterService parameterService;
    private BudgetService budgetService;
    private BusinessObjectService businessObjectService;

    public void populateBudgetSubAwardFiles(Budget budget, BudgetSubAwards subAward, String newFileName, byte[] newFileData) {
        subAward.setSubAwardStatusCode(Integer.valueOf(1));
        BudgetSubAwardFiles newSubAwardFile = new BudgetSubAwardFiles();
        newSubAwardFile.setSubAwardXfdFileData(newFileData);
        subAward.getBudgetSubAwardAttachments().clear();
        subAward.getBudgetSubAwardFiles().clear();
        subAward.getBudgetSubAwardFiles().add(newSubAwardFile);
        boolean subawardBudgetExtracted = false;
        try {
            byte[] pdfFileContents = newSubAwardFile.getSubAwardXfdFileData();
            subAward.setSubAwardXfdFileData(pdfFileContents);
            PdfReader reader = new PdfReader(pdfFileContents);
            byte[] xmlContents = this.getXMLFromPDF(reader);
            boolean bl = subawardBudgetExtracted = xmlContents != null && xmlContents.length > 0;
            if (subawardBudgetExtracted) {
                Map fileMap = this.extractAttachments(reader);
                this.updateXML(xmlContents, fileMap, subAward, budget);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Not able to extract xml from pdf", (Throwable)e);
            subawardBudgetExtracted = false;
        }
        newSubAwardFile.setSubAwardXfdFileData(subAward.getSubAwardXfdFileData());
        if (subawardBudgetExtracted) {
            newSubAwardFile.setSubAwardXmlFileData(new String(subAward.getSubAwardXmlFileData()));
        }
        newSubAwardFile.setSubAwardXfdFileName(newFileName);
        newSubAwardFile.setBudgetId(subAward.getBudgetId());
        newSubAwardFile.setSubAwardNumber(subAward.getSubAwardNumber());
        subAward.setSubAwardXfdFileName(newFileName);
        subAward.setXfdUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXfdUpdateTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        subAward.setXmlUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXmlUpdateTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
    }

    public void removeSubAwardAttachment(BudgetSubAwards subAward) {
        subAward.setFormName(null);
        subAward.setNamespace(null);
        subAward.setSubAwardXfdFileData(null);
        subAward.setSubAwardXfdFileName(null);
        subAward.setSubAwardXmlFileData(null);
        subAward.setXfdUpdateUser(null);
        subAward.getBudgetSubAwardAttachments().clear();
        subAward.getBudgetSubAwardFiles().clear();
        subAward.setXfdUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXfdUpdateTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        subAward.setXmlUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXmlUpdateTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
    }

    public void prepareBudgetSubAwards(Budget budget) {
        this.populateBudgetSubAwardAttachments(budget);
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                BudgetSubAwardPeriodDetail detail = null;
                for (BudgetSubAwardPeriodDetail curDetail : subAward.getBudgetSubAwardPeriodDetails()) {
                    if (!ObjectUtils.equals((Object)curDetail.getBudgetPeriod(), (Object)period.getBudgetPeriod())) continue;
                    detail = curDetail;
                    break;
                }
                if (detail != null) continue;
                subAward.getBudgetSubAwardPeriodDetails().add(new BudgetSubAwardPeriodDetail(subAward, period));
            }
        }
    }

    public void generateSubAwardLineItems(BudgetSubAwards subAward, Budget budget) {
        BudgetDecimal amountChargeFA = new BudgetDecimal(25000);
        String directLtCostElement = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_DIRECT_LT_25K");
        String directGtCostElement = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_DIRECT_GT_25K");
        String inDirectLtCostElement = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_LT_25K");
        String inDirectGtCostElement = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_GT_25K");
        for (BudgetSubAwardPeriodDetail detail : subAward.getBudgetSubAwardPeriodDetails()) {
            BudgetLineItem gt;
            BudgetLineItem lt;
            BudgetDecimal gtValue;
            BudgetDecimal ltValue;
            BudgetPeriod budgetPeriod = this.findBudgetPeriod(detail, budget);
            List currentLineItems = this.findSubAwardLineItems(budgetPeriod, subAward.getSubAwardNumber());
            for (BudgetLineItem item : currentLineItems) {
                item.setDirectCost(BudgetDecimal.ZERO);
                item.setCostSharingAmount(BudgetDecimal.ZERO);
                item.setSubAwardNumber(subAward.getSubAwardNumber());
                item.setLineItemDescription(subAward.getOrganizationName());
            }
            if (BudgetDecimal.returnZeroIfNull((BudgetDecimal)detail.getDirectCost()).isNonZero() || this.hasBeenChanged(detail, true)) {
                ltValue = this.lesserValue(detail.getDirectCost(), amountChargeFA);
                gtValue = (BudgetDecimal)detail.getDirectCost().subtract((AbstractKualiDecimal)ltValue);
                lt = this.findOrCreateLineItem(currentLineItems, detail, subAward, budgetPeriod, directLtCostElement);
                lt.setLineItemCost(ltValue);
                gt = this.findOrCreateLineItem(currentLineItems, detail, subAward, budgetPeriod, directGtCostElement);
                gt.setLineItemCost(gtValue);
                amountChargeFA = (BudgetDecimal)amountChargeFA.subtract((AbstractKualiDecimal)ltValue);
            }
            if (BudgetDecimal.returnZeroIfNull((BudgetDecimal)detail.getIndirectCost()).isNonZero() || this.hasBeenChanged(detail, false)) {
                ltValue = this.lesserValue(detail.getIndirectCost(), amountChargeFA);
                gtValue = (BudgetDecimal)detail.getIndirectCost().subtract((AbstractKualiDecimal)ltValue);
                lt = this.findOrCreateLineItem(currentLineItems, detail, subAward, budgetPeriod, inDirectLtCostElement);
                lt.setLineItemCost(ltValue);
                gt = this.findOrCreateLineItem(currentLineItems, detail, subAward, budgetPeriod, inDirectGtCostElement);
                gt.setLineItemCost(gtValue);
                amountChargeFA = (BudgetDecimal)amountChargeFA.subtract((AbstractKualiDecimal)ltValue);
            }
            Collections.sort(currentLineItems, new /* Unavailable Anonymous Inner Class!! */);
            Iterator iter = currentLineItems.iterator();
            while (iter.hasNext()) {
                BudgetLineItem lineItem = (BudgetLineItem)iter.next();
                if (BudgetDecimal.returnZeroIfNull((BudgetDecimal)lineItem.getLineItemCost()).isZero()) {
                    budgetPeriod.getBudgetLineItems().remove(lineItem);
                    iter.remove();
                    continue;
                }
                if (budgetPeriod.getBudgetLineItems().contains(lineItem)) continue;
                budgetPeriod.getBudgetLineItems().add(lineItem);
            }
            if (currentLineItems.isEmpty() || !BudgetDecimal.returnZeroIfNull((BudgetDecimal)detail.getCostShare()).isNonZero()) continue;
            ((BudgetLineItem)currentLineItems.get(0)).setCostSharingAmount(detail.getCostShare());
        }
    }

    private boolean hasBeenChanged(BudgetSubAwardPeriodDetail detail, boolean checkDirect) {
        boolean changed = false;
        if (detail != null && detail.getBudgetSubAwardDetailId() != null) {
            HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
            primaryKeys.put("SUBAWARD_PERIOD_DETAIL_ID", detail.getBudgetSubAwardDetailId());
            BudgetSubAwardPeriodDetail dbDetail = (BudgetSubAwardPeriodDetail)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(BudgetSubAwardPeriodDetail.class, primaryKeys);
            changed = checkDirect ? !BudgetDecimal.returnZeroIfNull((BudgetDecimal)detail.getDirectCost()).equals((Object)BudgetDecimal.returnZeroIfNull((BudgetDecimal)dbDetail.getDirectCost())) : !BudgetDecimal.returnZeroIfNull((BudgetDecimal)detail.getIndirectCost()).equals((Object)BudgetDecimal.returnZeroIfNull((BudgetDecimal)dbDetail.getIndirectCost()));
        }
        return changed;
    }

    protected BudgetPeriod findBudgetPeriod(BudgetSubAwardPeriodDetail detail, Budget budget) {
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            if (!ObjectUtils.equals((Object)detail.getBudgetPeriod(), (Object)period.getBudgetPeriod())) continue;
            return period;
        }
        return null;
    }

    protected BudgetDecimal lesserValue(BudgetDecimal num1, BudgetDecimal num2) {
        if (num1.isLessThan((AbstractKualiDecimal)num2)) {
            return num1;
        }
        return num2;
    }

    protected BudgetLineItem findOrCreateLineItem(List<BudgetLineItem> lineItems, BudgetSubAwardPeriodDetail subAwardDetail, BudgetSubAwards subAward, BudgetPeriod budgetPeriod, String costElement) {
        for (BudgetLineItem curLineItem : lineItems) {
            if (!StringUtils.equals((String)curLineItem.getCostElement(), (String)costElement)) continue;
            return curLineItem;
        }
        BudgetLineItem newLineItem = new BudgetLineItem();
        newLineItem.setCostElement(costElement);
        newLineItem.setSubAwardNumber(subAwardDetail.getSubAwardNumber());
        newLineItem.setLineItemDescription(subAward.getOrganizationName());
        this.getBudgetService().populateNewBudgetLineItem(newLineItem, budgetPeriod);
        lineItems.add(newLineItem);
        return newLineItem;
    }

    protected List<BudgetLineItem> findSubAwardLineItems(BudgetPeriod budgetPeriod, Integer subAwardNumber) {
        ArrayList<BudgetLineItem> lineItems = new ArrayList<BudgetLineItem>();
        if (budgetPeriod.getBudgetLineItems() != null) {
            for (BudgetLineItem item : budgetPeriod.getBudgetLineItems()) {
                if (!ObjectUtils.equals((Object)item.getSubAwardNumber(), (Object)subAwardNumber)) continue;
                lineItems.add(item);
            }
        }
        return lineItems;
    }

    protected String getLoggedInUserNetworkId() {
        return GlobalVariables.getUserSession().getPrincipalName();
    }

    protected byte[] getXMLFromPDF(PdfReader reader) throws Exception {
        XfaForm xfaForm = reader.getAcroFields().getXfa();
        Document domDocument = xfaForm.getDomDocument();
        if (domDocument == null) {
            return null;
        }
        Element documentElement = domDocument.getDocumentElement();
        Element datasetsElement = (Element)documentElement.getElementsByTagNameNS("http://www.xfa.org/schema/xfa-data/1.0/", "datasets").item(0);
        Element dataElement = (Element)datasetsElement.getElementsByTagNameNS("http://www.xfa.org/schema/xfa-data/1.0/", "data").item(0);
        Element xmlElement = (Element)dataElement.getChildNodes().item(0);
        Node budgetElement = this.getBudgetElement(xmlElement);
        byte[] serializedXML = XfaForm.serializeDoc((Node)budgetElement);
        return serializedXML;
    }

    private Node getBudgetElement(Element xmlElement) throws Exception {
        Element budgetAttachment;
        Node budgetNode = xmlElement;
        NodeList budgetAttachments = XPathAPI.selectNodeList((Node)xmlElement, (String)"//*[local-name(.) = 'BudgetAttachments']");
        if (budgetAttachments != null && budgetAttachments.getLength() > 0 && (budgetAttachment = (Element)budgetAttachments.item(0)).hasChildNodes()) {
            budgetNode = budgetAttachment.getFirstChild();
        }
        return budgetNode;
    }

    protected Map extractAttachments(PdfReader reader) throws IOException {
        Iterator i;
        PdfDictionary embFiles;
        HashMap<Object, Object> fileMap = new HashMap<Object, Object>();
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
        if (names != null && (embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(new PdfName("EmbeddedFiles")))) != null) {
            HashMap embMap = PdfNameTree.readTree((PdfDictionary)embFiles);
            i = embMap.values().iterator();
            while (i.hasNext()) {
                PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)i.next()));
                Object[] fileInfo = BudgetSubAwardServiceImpl.unpackFile((PdfReader)reader, (PdfDictionary)filespec);
                if (fileMap.containsKey(fileInfo[0])) {
                    throw new RuntimeException("Duplicate PDF Attachment File Names");
                }
                fileMap.put(fileInfo[0], fileInfo[1]);
            }
        }
        for (int k = 1; k <= reader.getNumberOfPages(); ++k) {
            PdfArray annots = (PdfArray)PdfReader.getPdfObject((PdfObject)reader.getPageN(k).get(PdfName.ANNOTS));
            if (annots == null) continue;
            i = annots.getArrayList().listIterator();
            while (i.hasNext()) {
                PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)i.next()));
                PdfName subType = (PdfName)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.SUBTYPE));
                if (!PdfName.FILEATTACHMENT.equals((Object)subType)) continue;
                PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.FS));
                Object[] fileInfo = BudgetSubAwardServiceImpl.unpackFile((PdfReader)reader, (PdfDictionary)filespec);
                if (fileMap.containsKey(fileInfo[0])) {
                    throw new RuntimeException("Duplicate PDF Attachment File Names");
                }
                fileMap.put(fileInfo[0], fileInfo[1]);
            }
        }
        return fileMap;
    }

    protected static Object[] unpackFile(PdfReader reader, PdfDictionary filespec) throws IOException {
        Object[] arr = new Object[2];
        if (filespec == null) {
            return null;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.TYPE));
        if (!PdfName.F.equals((Object)type) && !PdfName.FILESPEC.equals((Object)type)) {
            return null;
        }
        PdfDictionary ef = (PdfDictionary)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.EF));
        if (ef == null) {
            return null;
        }
        PdfString fn = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.F));
        if (fn == null) {
            return null;
        }
        File fLast = new File(fn.toUnicodeString());
        PRStream prs = (PRStream)PdfReader.getPdfObject((PdfObject)ef.get(PdfName.F));
        if (prs == null) {
            return null;
        }
        byte[] attachmentByte = PdfReader.getStreamBytes((PRStream)prs);
        arr[0] = fLast.getName();
        arr[1] = attachmentByte;
        return arr;
    }

    public boolean updateSubAwardBudgetDetails(Budget budget, BudgetSubAwards budgetSubAward, List<String[]> errors) throws Exception {
        boolean result = true;
        if (budgetSubAward.getSubAwardXfdFileData() == null || budgetSubAward.getSubAwardXfdFileData().length == 0) {
            errors.add(new String[]{"newSubAward.subAwardFile.notExtracted"});
            return false;
        }
        PdfReader reader = new PdfReader(budgetSubAward.getSubAwardXfdFileData());
        byte[] xmlContents = this.getXMLFromPDF(reader);
        if (xmlContents == null) {
            return false;
        }
        DocumentBuilderFactory domParserFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlContents);
        Document document = domParser.parse(byteArrayInputStream);
        NodeList budgetYearList = XPathAPI.selectNodeList((Node)document, (String)"//*[local-name(.) = 'BudgetYear']");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean fnfForm = StringUtils.contains((String)budgetSubAward.getFormName(), (String)"RR_FedNonFedBudget");
        for (int i = 0; i < budgetYearList.getLength(); ++i) {
            Date endDate;
            Node budgetYear = budgetYearList.item(i);
            Node startDateNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"BudgetPeriodStartDate");
            Node endDateNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"BudgetPeriodEndDate");
            Date startDate = dateFormat.parse(startDateNode.getTextContent());
            BudgetSubAwardPeriodDetail periodDetail = this.findBudgetSubAwardPeriodDetail(budget, budgetSubAward, startDate, endDate = dateFormat.parse(endDateNode.getTextContent()));
            if (periodDetail != null) {
                Node indirectCostNode;
                Node directCostNode;
                Node costShareNode = null;
                if (fnfForm) {
                    directCostNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"DirectCosts/FederalSummary");
                    indirectCostNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"IndirectCosts/TotalIndirectCosts/FederalSummary");
                    costShareNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"TotalCosts/NonFederalSummary");
                } else {
                    directCostNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"DirectCosts");
                    indirectCostNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"IndirectCosts/TotalIndirectCosts");
                }
                if (directCostNode != null) {
                    periodDetail.setDirectCost(new BudgetDecimal((double)Float.parseFloat(directCostNode.getTextContent())));
                }
                if (indirectCostNode != null) {
                    periodDetail.setIndirectCost(new BudgetDecimal((double)Float.parseFloat(indirectCostNode.getTextContent())));
                }
                if (costShareNode != null) {
                    periodDetail.setCostShare(new BudgetDecimal((double)Float.parseFloat(costShareNode.getTextContent())));
                } else {
                    periodDetail.setCostShare(BudgetDecimal.ZERO);
                }
                periodDetail.computeTotal();
                continue;
            }
            Node budgetPeriodNode = XPathAPI.selectSingleNode((Node)budgetYear, (String)"BudgetPeriod");
            String budgetPeriod = null;
            if (budgetPeriodNode != null) {
                budgetPeriod = budgetPeriodNode.getTextContent();
            }
            LOG.debug((Object)("Unable to find matching period for uploaded period '" + budgetPeriod + "' -- " + startDateNode.getTextContent() + " - " + endDateNode.getTextContent()));
            errors.add(new String[]{"newSubAward.subAwardFile.periodNotFound", budgetPeriod, startDateNode.getTextContent(), endDateNode.getTextContent()});
        }
        return result;
    }

    protected BudgetSubAwardPeriodDetail findBudgetSubAwardPeriodDetail(Budget budget, BudgetSubAwards budgetSubAward, Date startDate, Date endDate) {
        BudgetPeriod matchingPeriod = null;
        BudgetSubAwardPeriodDetail matchingDetail = null;
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            if (startDate.getTime() != period.getStartDate().getTime() || endDate.getTime() != period.getEndDate().getTime()) continue;
            matchingPeriod = period;
            break;
        }
        if (matchingPeriod != null) {
            for (BudgetSubAwardPeriodDetail detail : budgetSubAward.getBudgetSubAwardPeriodDetails()) {
                if (!ObjectUtils.equals((Object)detail.getBudgetPeriod(), (Object)matchingPeriod.getBudgetPeriod())) continue;
                matchingDetail = detail;
                break;
            }
        }
        return matchingDetail;
    }

    protected BudgetSubAwards updateXML(byte[] xmlContents, Map fileMap, BudgetSubAwards budgetSubAwardBean, Budget budget) throws Exception {
        DocumentBuilderFactory domParserFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlContents);
        Document document = domParser.parse(byteArrayInputStream);
        byteArrayInputStream.close();
        String namespace = null;
        String formName = null;
        if (document != null) {
            Element element = document.getDocumentElement();
            NamedNodeMap map = element.getAttributes();
            String namespaceHolder = element.getNodeName().substring(0, element.getNodeName().indexOf(58));
            Node node = map.getNamedItem("xmlns:" + namespaceHolder);
            namespace = node.getNodeValue();
            FormMappingInfo formMappingInfo = new FormMappingLoader().getFormInfo(namespace);
            formName = formMappingInfo.getFormName();
            budgetSubAwardBean.setNamespace(namespace);
            budgetSubAwardBean.setFormName(formName);
        }
        String xpathEmptyNodes = "//*[not(node()) and local-name(.) != 'FileLocation' and local-name(.) != 'HashValue']";
        String xpathOtherPers = "//*[local-name(.)='ProjectRole' and local-name(../../.)='OtherPersonnel' and count(../NumberOfPersonnel)=0]";
        this.removeAllEmptyNodes(document, xpathEmptyNodes, 0);
        this.removeAllEmptyNodes(document, xpathOtherPers, 1);
        this.removeAllEmptyNodes(document, xpathEmptyNodes, 0);
        this.changeDataTypeForNumberOfOtherPersons(document);
        List fedNonFedSubAwardForms = this.getFedNonFedSubawardForms();
        NodeList budgetYearList = XPathAPI.selectNodeList((Node)document, (String)"//*[local-name(.) = 'BudgetYear']");
        for (int i = 0; i < budgetYearList.getLength(); ++i) {
            Element newBudgetYearElement;
            Node bgtYearNode = budgetYearList.item(i);
            String period = BudgetSubAwardServiceImpl.getValue((Node)XPathAPI.selectSingleNode((Node)bgtYearNode, (String)"BudgetPeriod"));
            if (fedNonFedSubAwardForms.contains(namespace)) {
                newBudgetYearElement = this.copyElementToName((Element)bgtYearNode, bgtYearNode.getNodeName());
                bgtYearNode.getParentNode().replaceChild(newBudgetYearElement, bgtYearNode);
                continue;
            }
            newBudgetYearElement = this.copyElementToName((Element)bgtYearNode, bgtYearNode.getNodeName() + period);
            bgtYearNode.getParentNode().replaceChild(newBudgetYearElement, bgtYearNode);
        }
        Node oldroot = document.removeChild(document.getDocumentElement());
        Node newroot = document.appendChild(document.createElement("Forms"));
        newroot.appendChild(oldroot);
        NodeList lstFileName = document.getElementsByTagName("att:FileName");
        NodeList lstFileLocation = document.getElementsByTagName("att:FileLocation");
        NodeList lstMimeType = document.getElementsByTagName("att:MimeType");
        NodeList lstHashValue = document.getElementsByTagName("glob:HashValue");
        if (lstFileName.getLength() != lstFileLocation.getLength() || lstFileLocation.getLength() != lstHashValue.getLength()) {
            // empty if block
        }
        ArrayList<BudgetSubAwardAttachment> attachmentList = new ArrayList<BudgetSubAwardAttachment>();
        for (int index = 0; index < lstFileName.getLength(); ++index) {
            Node fileNode = lstFileName.item(index);
            Node fileNameNode = fileNode.getFirstChild();
            String fileName = fileNameNode.getNodeValue();
            byte[] fileBytes = (byte[])fileMap.get(fileName);
            if (fileBytes == null) {
                throw new RuntimeException("FileName mismatch in XML and PDF extracted file");
            }
            String hashVal = GrantApplicationHash.computeAttachmentHash((byte[])fileBytes);
            Node hashNode = lstHashValue.item(index);
            NamedNodeMap hashNodeMap = hashNode.getAttributes();
            Text temp = document.createTextNode(hashVal);
            hashNode.appendChild(temp);
            hashNode = hashNodeMap.getNamedItem("glob:hashAlgorithm");
            hashNode.setNodeValue("SHA-1");
            fileNode = lstFileLocation.item(index);
            NamedNodeMap fileNodeMap = fileNode.getAttributes();
            fileNode = fileNodeMap.getNamedItem("att:href");
            String contentId = fileNode.getNodeValue();
            String encodedContentId = this.cleanContentId(contentId);
            fileNode.setNodeValue(encodedContentId);
            Node mimeTypeNode = lstMimeType.item(0);
            String contentType = mimeTypeNode.getFirstChild().getNodeValue();
            BudgetSubAwardAttachment budgetSubAwardAttachmentBean = new BudgetSubAwardAttachment();
            budgetSubAwardAttachmentBean.setAttachment(fileBytes);
            budgetSubAwardAttachmentBean.setContentId(encodedContentId);
            budgetSubAwardAttachmentBean.setContentType(contentType);
            budgetSubAwardAttachmentBean.setBudgetId(budgetSubAwardBean.getBudgetId());
            budgetSubAwardAttachmentBean.setSubAwardNumber(budgetSubAwardBean.getSubAwardNumber());
            attachmentList.add(budgetSubAwardAttachmentBean);
        }
        budgetSubAwardBean.setBudgetSubAwardAttachments(attachmentList);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bos);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        budgetSubAwardBean.setSubAwardXmlFileData(new String(bos.toByteArray()));
        bos.close();
        return budgetSubAwardBean;
    }

    protected String cleanContentId(String contentId) {
        return StringUtils.replaceChars((String)contentId, (String)" .%-_", (String)"");
    }

    public void populateBudgetSubAwardAttachments(Budget budget) {
        List subAwards = budget.getBudgetSubAwards();
        for (BudgetSubAwards budgetSubAwards : subAwards) {
            budgetSubAwards.refreshReferenceObject("budgetSubAwardAttachments");
            List attList = budgetSubAwards.getBudgetSubAwardAttachments();
            for (BudgetSubAwardAttachment budgetSubAwardAttachment : attList) {
            }
        }
    }

    protected void removeAllEmptyNodes(Document document, String xpath, int parentLevel) throws TransformerException {
        NodeList emptyElements = XPathAPI.selectNodeList((Node)document, (String)xpath);
        for (int i = emptyElements.getLength() - 1; i > -1; --i) {
            Node nodeToBeRemoved = emptyElements.item(i);
            int hierLevel = parentLevel;
            while (hierLevel-- > 0) {
                nodeToBeRemoved = nodeToBeRemoved.getParentNode();
            }
            nodeToBeRemoved.getParentNode().removeChild(nodeToBeRemoved);
        }
        NodeList moreEmptyElements = XPathAPI.selectNodeList((Node)document, (String)xpath);
        if (moreEmptyElements.getLength() > 0) {
            this.removeAllEmptyNodes(document, xpath, parentLevel);
        }
    }

    protected Element copyElementToName(Element element, String tagName) {
        int i;
        Element newElement = element.getOwnerDocument().createElement(tagName);
        NamedNodeMap attrs = element.getAttributes();
        for (i = 0; i < attrs.getLength(); ++i) {
            Node attribute = attrs.item(i);
            newElement.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            newElement.appendChild(element.getChildNodes().item(i).cloneNode(true));
        }
        return newElement;
    }

    protected HashValueDocument.HashValue getValue(byte[] fileBytes) throws Exception {
        return this.createHashValueType(GrantApplicationHash.computeAttachmentHash((byte[])fileBytes));
    }

    protected HashValueDocument.HashValue createHashValueType(String hashValueStr) throws Exception {
        HashValueDocument.HashValue hashValue = HashValueDocument.HashValue.Factory.newInstance();
        hashValue.setHashAlgorithm("SHA-1");
        hashValue.setStringValue(hashValueStr);
        return hashValue;
    }

    private void changeDataTypeForNumberOfOtherPersons(Document document) throws Exception {
        NodeList otherPesronsCountNodes = XPathAPI.selectNodeList((Node)document, (String)"//*[local-name(.)='OtherPersonnelTotalNumber']");
        for (int i = 0; i < otherPesronsCountNodes.getLength(); ++i) {
            Node countNode = otherPesronsCountNodes.item(i);
            String value = BudgetSubAwardServiceImpl.getValue((Node)countNode);
            if (value == null || value.length() <= 0 || value.indexOf(46) == -1) continue;
            int intVal = Double.valueOf(value).intValue();
            this.setValue(countNode, "" + intVal);
        }
    }

    private void setValue(Node node, String value) {
        Node child = null;
        for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            child.setNodeValue(value);
            break;
        }
    }

    private static String getValue(Node node) {
        String textValue = "";
        Node child = null;
        if (node != null) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                textValue = child.getNodeValue();
                break;
            }
        }
        return textValue.trim();
    }

    private List<String> getFedNonFedSubawardForms() {
        ArrayList<String> forms = new ArrayList<String>();
        forms.add("http://apply.grants.gov/forms/RR_FedNonFedBudget10-V1.1");
        return forms;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

