/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.service.impl;

import java.util.ArrayList;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.BudgetVersionRule;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetSubAwardService;
import org.kuali.kra.proposaldevelopment.budget.service.ProposalBudgetService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ProposalBudgetServiceImpl
implements ProposalBudgetService {
    private DocumentService documentService;
    private ParameterService parameterService;
    private BudgetService<DevelopmentProposal> budgetService;
    private BudgetCalculationService budgetCalculationService;
    private BudgetSubAwardService budgetSubAwardService;

    public BudgetDocument<DevelopmentProposal> getNewBudgetVersion(BudgetParentDocument<DevelopmentProposal> parentDocument, String documentDescription) throws WorkflowException {
        Integer budgetVersionNumber = parentDocument.getNextBudgetVersionNumber();
        BudgetDocument budgetDocument = (BudgetDocument)this.documentService.getNewDocument(BudgetDocument.class);
        budgetDocument.setParentDocument(parentDocument);
        budgetDocument.setParentDocumentKey(parentDocument.getDocumentNumber());
        budgetDocument.setParentDocumentTypeCode(parentDocument.getDocumentTypeCode());
        budgetDocument.getDocumentHeader().setDocumentDescription(documentDescription);
        Budget budget = budgetDocument.getBudget();
        budget.setBudgetVersionNumber(budgetVersionNumber);
        budget.setBudgetDocument(budgetDocument);
        BudgetParent budgetParent = parentDocument.getBudgetParent();
        budget.setStartDate(budgetParent.getRequestedStartDateInitial());
        budget.setEndDate(budgetParent.getRequestedEndDateInitial());
        budget.setOhRateTypeCode(this.parameterService.getParameterValueAsString(BudgetDocument.class, "defaultOverheadRateTypeCode"));
        budget.setOhRateClassCode(this.parameterService.getParameterValueAsString(BudgetDocument.class, "defaultOverheadRateClassCode"));
        budget.setUrRateClassCode(this.parameterService.getParameterValueAsString(BudgetDocument.class, "defaultUnderrecoveryRateClassCode"));
        budget.setModularBudgetFlag(this.parameterService.getParameterValueAsBoolean(BudgetDocument.class, "defaultModularFlag"));
        budget.setBudgetStatus(this.parameterService.getParameterValueAsString(BudgetDocument.class, budgetParent.getDefaultBudgetStatusParameter()));
        boolean success = new BudgetVersionRule().processAddBudgetVersion(new AddBudgetVersionEvent("document.parentDocument.budgetDocumentVersion", (Document)budgetDocument.getParentDocument(), budget));
        if (!success) {
            return null;
        }
        budget.setRateClassTypesReloaded(true);
        this.saveBudgetDocument(budgetDocument);
        budgetDocument = (BudgetDocument)this.documentService.getByDocumentHeaderId(budgetDocument.getDocumentNumber());
        parentDocument.refreshBudgetDocumentVersions();
        return budgetDocument;
    }

    public boolean isRateOverridden(BudgetPeriod budgetPeriod) {
        return false;
    }

    protected void saveBudgetDocument(BudgetDocument<DevelopmentProposal> budgetDocument) throws WorkflowException {
        this.documentService.saveDocument(budgetDocument);
        this.documentService.routeDocument(budgetDocument, "Route to Final", new ArrayList());
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetDocument<DevelopmentProposal> copyBudgetVersion(BudgetDocument<DevelopmentProposal> budgetDocument) throws WorkflowException {
        return this.copyBudgetVersion(budgetDocument, false);
    }

    public BudgetDocument<DevelopmentProposal> copyBudgetVersion(BudgetDocument<DevelopmentProposal> budgetDocument, boolean onlyOnePeriod) throws WorkflowException {
        return this.getBudgetService().copyBudgetVersion(budgetDocument, onlyOnePeriod);
    }

    public void setBudgetService(BudgetService<DevelopmentProposal> budgetService) {
        this.budgetService = budgetService;
    }

    public BudgetService<DevelopmentProposal> getBudgetService() {
        return this.budgetService;
    }

    public void recalculateBudget(Budget budget) {
        this.budgetCalculationService.calculateBudget(budget);
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void calculateBudgetOnSave(Budget budget) {
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            this.getBudgetSubAwardService().generateSubAwardLineItems(subAward, budget);
        }
        this.budgetCalculationService.calculateBudget(budget);
    }

    public boolean isRateOverridden(Budget budget) {
        return false;
    }

    public void removeBudgetSummaryPeriodCalcAmounts(BudgetPeriod budgetPeriod) {
    }

    public void populateSummaryCalcAmounts(Budget budget, BudgetPeriod budgetPeriod) {
    }

    public boolean validateAddingNewBudget(BudgetParentDocument<DevelopmentProposal> parentDocument) {
        return true;
    }

    public void recalculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.budgetCalculationService.calculateBudget(budget);
    }

    protected BudgetSubAwardService getBudgetSubAwardService() {
        return this.budgetSubAwardService;
    }

    public void setBudgetSubAwardService(BudgetSubAwardService budgetSubAwardService) {
        this.budgetSubAwardService = budgetSubAwardService;
    }
}

