/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.impl.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.ProposalStateService;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.kra.workflow.KraDocumentXMLMaterializer;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-PD")
@ParameterConstants.COMPONENT(component="Document")
public class ProposalDevelopmentDocument
extends BudgetParentDocument<DevelopmentProposal>
implements Copyable,
SessionDocument,
Permissionable,
KrmsRulesContext {
    private static Log LOG = LogFactory.getLog(ProposalDevelopmentDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "PRDV";
    private static final String KRA_EXTERNALIZABLE_IMAGES_URI_KEY = "kra.externalizable.images.url";
    private static final String RETURN_TO_PROPOSAL_ALT_TEXT = "return to proposal";
    private static final String RETURN_TO_PROPOSAL_METHOD_TO_CALL = "methodToCall.returnToProposal";
    private static final String HIERARCHY_CHILD_SPLITNODE_QUESTION = "isHierarchyChild";
    private static final long serialVersionUID = 2958631745964610527L;
    private List<DevelopmentProposal> developmentProposalList = new ArrayList();
    private List<BudgetDocumentVersion> budgetDocumentVersions;
    private transient Boolean allowsNoteAttachments;
    private boolean proposalDeleted;
    private String institutionalProposalNumber;
    private String saveXmlFolderName;
    private List<CustomAttributeDocValue> customDataList;

    public ProposalDevelopmentDocument() {
        DevelopmentProposal newProposal = new DevelopmentProposal();
        newProposal.setProposalDocument(this);
        this.developmentProposalList.add(newProposal);
        this.budgetDocumentVersions = new ArrayList();
        this.customDataList = new ArrayList();
    }

    public List<DevelopmentProposal> getDevelopmentProposalList() {
        return this.developmentProposalList;
    }

    public void setDevelopmentProposalList(List<DevelopmentProposal> proposalList) {
        this.developmentProposalList = proposalList;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        if (!this.developmentProposalList.isEmpty()) {
            return (DevelopmentProposal)this.developmentProposalList.get(0);
        }
        return new DevelopmentProposal();
    }

    public void setDevelopmentProposal(DevelopmentProposal proposal) {
        this.developmentProposalList.set(0, proposal);
    }

    public String getInstitutionalProposalNumber() {
        return this.institutionalProposalNumber;
    }

    public void setInstitutionalProposalNumber(String institutionalProposalNumber) {
        this.institutionalProposalNumber = institutionalProposalNumber;
    }

    public void initialize() {
        super.initialize();
        this.getDevelopmentProposal().initializeOwnedByUnitNumber();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange dto) {
        super.doRouteStatusChange(dto);
        String newStatus = dto.getNewRouteStatus();
        String oldStatus = dto.getOldRouteStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Route Status change for document %s from %s to %s", this.getDocumentNumber(), oldStatus, newStatus));
        }
        if (!this.isProposalDeleted()) {
            DevelopmentProposal bp = this.getDevelopmentProposal();
            ProposalHierarchyService hierarchyService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
            LOG.info((Object)String.format("Route status change for document %s - proposal number %s is moving from %s to %s", bp.getProposalDocument().getDocumentHeader().getDocumentNumber(), bp.getProposalNumber(), oldStatus, newStatus));
            if (bp.isParent()) {
                try {
                    hierarchyService.routeHierarchyChildren(this, dto);
                }
                catch (ProposalHierarchyException e) {
                    throw new RuntimeException("ProposalHierarchyException thrown while routing children.", e);
                }
            }
            if (!bp.isInHierarchy()) {
                try {
                    hierarchyService.calculateAndSetProposalAppDocStatus(this, dto);
                }
                catch (ProposalHierarchyException pe) {
                    throw new RuntimeException(String.format("ProposalHierarchyException thrown while updating app doc status for document %s", this.getDocumentNumber()));
                }
            }
            bp.setProposalStateTypeCode(((ProposalStateService)KraServiceLocator.getService(ProposalStateService.class)).getProposalStateTypeCode(this, true, false));
        }
    }

    public void doActionTaken(ActionTakenEvent event) {
        super.doActionTaken(event);
        ActionTaken actionTaken = event.getActionTaken();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Action taken on document %s: event code %s, action taken is %s", this.getDocumentNumber(), event.getDocumentEventCode(), actionTaken.getActionTaken().getCode()));
        }
        if (!this.isProposalDeleted()) {
            ProposalHierarchyService hService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
            KraDocumentRejectionService documentRejectionService = (KraDocumentRejectionService)KraServiceLocator.getService(KraDocumentRejectionService.class);
            if (StringUtils.equals((String)"A", (String)actionTaken.getActionTaken().getCode())) {
                try {
                    if (documentRejectionService.isDocumentOnInitialNode((Document)this)) {
                        DocumentRouteStatusChange dto = new DocumentRouteStatusChange(this.getDocumentHeader().getWorkflowDocument().getDocumentId(), this.getDocumentNumber(), "R", "R");
                        if (this.getDevelopmentProposal().isParent()) {
                            hService.routeHierarchyChildren(this, dto);
                            hService.calculateAndSetProposalAppDocStatus(this, dto);
                        }
                        if (!this.getDevelopmentProposal().isInHierarchy()) {
                            hService.calculateAndSetProposalAppDocStatus(this, dto);
                        }
                    }
                }
                catch (ProposalHierarchyException pe) {
                    throw new RuntimeException(String.format("ProposalHeierachyException encountered trying to re-submit rejected parent document:%s", this.getDocumentNumber()), pe);
                }
                catch (Exception we) {
                    throw new RuntimeException(String.format("Exception trying to re-submit rejected parent:%s", this.getDocumentNumber()), we);
                }
            }
            String pCode = this.getDevelopmentProposal().getProposalStateTypeCode();
            this.getDevelopmentProposal().setProposalStateTypeCode(((ProposalStateService)KraServiceLocator.getService(ProposalStateService.class)).getProposalStateTypeCode(this, false, documentRejectionService.isDocumentOnInitialNode((Document)this)));
            if (!StringUtils.equals((String)pCode, (String)this.getDevelopmentProposal().getProposalStateTypeCode())) {
                this.getDevelopmentProposal().refresh();
                ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).save((PersistableBusinessObject)this.getDevelopmentProposal());
            }
            if (this.getDevelopmentProposal().isChild() && StringUtils.equals((String)"X", (String)actionTaken.getActionTaken().getCode())) {
                try {
                    hService.removeFromHierarchy(this.getDevelopmentProposal());
                }
                catch (ProposalHierarchyException e) {
                    throw new RuntimeException(String.format("COULD NOT REMOVE CHILD:%s", this.getDevelopmentProposal().getProposalNumber()));
                }
            }
            if (this.isLastSubmitterApprovalAction(event.getActionTaken()) && this.shouldAutogenerateInstitutionalProposal()) {
                InstitutionalProposalService institutionalProposalService = (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
                String proposalNumber = institutionalProposalService.createInstitutionalProposal(this.getDevelopmentProposal(), this.getFinalBudgetForThisProposal());
                this.setInstitutionalProposalNumber(proposalNumber);
            }
        }
    }

    private boolean isLastSubmitterApprovalAction(ActionTaken actionTaken) {
        WorkflowDocumentActionsService workflowInfo = KewApiServiceLocator.getWorkflowDocumentActionsService();
        return actionTaken.getActionTaken().getCode().equals("A") && workflowInfo.isFinalApprover(actionTaken.getDocumentId(), actionTaken.getPrincipalId());
    }

    private boolean shouldAutogenerateInstitutionalProposal() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "proposaldevelopment.autogenerate.institutionalproposal");
    }

    protected ConfigurationService getKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    protected ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
    }

    public Budget getFinalBudgetForThisProposal() {
        BudgetDocumentVersion budgetDocumentVersion = this.getFinalBudgetVersion();
        if (budgetDocumentVersion != null) {
            return budgetDocumentVersion.getFinalBudget();
        }
        return null;
    }

    public String getFinalrateClassCode() {
        String retVal = "";
        Budget finalBudget = this.getFinalBudgetForThisProposal();
        if (finalBudget != null && finalBudget.getRateClass().getRateClassCode() != null) {
            retVal = finalBudget.getRateClass().getRateClassCode();
        }
        return retVal;
    }

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        KraDocumentXMLMaterializer xmlWrapper = (KraDocumentXMLMaterializer)super.wrapDocumentWithMetadataForXmlSerialization();
        xmlWrapper.setRolepersons(this.getAllRolePersons());
        return xmlWrapper;
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (!this.isProposalDeleted()) {
            this.getDevelopmentProposal().updateS2sOpportunity();
            ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).saveBudgetFinalVersionStatus(this);
            if (this.getBudgetDocumentVersions() != null) {
                this.updateDocumentDescriptions(this.getBudgetDocumentVersions());
            }
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        if (!this.isProposalDeleted()) {
            ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).loadBudgetStatus(this.getDevelopmentProposal());
            this.getDevelopmentProposal().updateProposalChangeHistory();
        }
    }

    public Boolean getAllowsNoteAttachments() {
        if (this.allowsNoteAttachments == null) {
            DataDictionary dataDictionary = KNSServiceLocator.getDataDictionaryService().getDataDictionary();
            DocumentEntry entry = dataDictionary.getDocumentEntry(this.getClass().getName());
            this.allowsNoteAttachments = entry.getAllowsNoteAttachments();
        }
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("Aggregator");
        roleNames.add("Budget Creator");
        roleNames.add("Narrative Writer");
        roleNames.add("Viewer");
        roleNames.add("approver");
        return roleNames;
    }

    public String getDocumentNumberForPermission() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    public String getDocumentKey() {
        return "proposal";
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.addAll(this.getDevelopmentProposal().buildListOfDeletionAwareLists());
        managedLists.add(this.developmentProposalList);
        return managedLists;
    }

    public void setBudgetDocumentVersions(List<BudgetDocumentVersion> budgetDocumentVersions) {
        this.budgetDocumentVersions = budgetDocumentVersions;
    }

    public List<BudgetDocumentVersion> getBudgetDocumentVersions() {
        return this.budgetDocumentVersions;
    }

    public Task getParentAuthZTask(String taskName) {
        return new ProposalTask(taskName, this);
    }

    public boolean isComplete() {
        return this.getDevelopmentProposal().isProposalComplete();
    }

    public void saveBudgetFinalVersionStatus(BudgetDocument budgetDocument) {
        ((ProposalStatusService)this.getService(ProposalStatusService.class)).saveBudgetFinalVersionStatus(this);
    }

    public void processAfterRetrieveForBudget(BudgetDocument budgetDocument) {
        ((ProposalStatusService)this.getService(ProposalStatusService.class)).loadBudgetStatusByProposalDocumentNumber(budgetDocument.getParentDocumentKey());
    }

    public String getTaskGroupName() {
        return "proposalBudget";
    }

    public ExtraButton configureReturnToParentTopButton() {
        ExtraButton returnToProposalButton = new ExtraButton();
        returnToProposalButton.setExtraButtonProperty(RETURN_TO_PROPOSAL_METHOD_TO_CALL);
        returnToProposalButton.setExtraButtonSource(this.buildExtraButtonSourceURI("tinybutton-retprop.gif"));
        returnToProposalButton.setExtraButtonAltText(RETURN_TO_PROPOSAL_ALT_TEXT);
        return returnToProposalButton;
    }

    private String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString(KRA_EXTERNALIZABLE_IMAGES_URI_KEY) + buttonFileName;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    public DevelopmentProposal getBudgetParent() {
        return this.getDevelopmentProposal();
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getDevelopmentProposal().getProposalNumber() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    public Permissionable getBudgetPermissionable() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean answerSplitNodeQuestion(String routeNodeName) throws Exception {
        LOG.debug((Object)("Processing answerSplitNodeQuestion:" + routeNodeName));
        if (StringUtils.equals((String)HIERARCHY_CHILD_SPLITNODE_QUESTION, (String)routeNodeName)) {
            return this.getDevelopmentProposal().isChild();
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    public String getNamespace() {
        return "KC-PD";
    }

    public String getLeadUnitNumber() {
        return this.getDevelopmentProposal().getOwnedByUnitNumber();
    }

    public String getDocumentRoleTypeCode() {
        return "KC-PD";
    }

    public String getProposalBudgetFlag() {
        return "true";
    }

    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && ("R".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode()) || "P".equals(docRouteStatus) || "F".equals(docRouteStatus))) {
            isComplete = true;
        }
        return isComplete;
    }

    public boolean isProposalDeleted() {
        return this.proposalDeleted;
    }

    public void setProposalDeleted(boolean proposalDeleted) {
        this.proposalDeleted = proposalDeleted;
    }

    public void refreshBudgetDocumentVersions() {
        this.refreshReferenceObject("budgetDocumentVersions");
    }

    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-PD");
        qualifiers.put("name", "KC Proposal Development Context");
    }

    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderServiceHelper fbService = (KcKrmsFactBuilderServiceHelper)KraServiceLocator.getService((String)"proposalDevelopmentFactBuilderService");
        fbService.addFacts(factsBuilder, (ResearchDocumentBase)this);
    }

    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    public void defaultDocumentDescription() {
        DevelopmentProposal proposal = this.getDevelopmentProposal();
        String desc = String.format("%s; Proposal No: %s; PI: %s; Sponsor: %s; Due Date: %s", proposal.getTitle() != null ? proposal.getTitle().substring(0, Math.min(proposal.getTitle().length(), 19)) : "null", proposal.getProposalNumber(), proposal.getPrincipalInvestigatorName(), proposal.getSponsorName(), proposal.getDeadlineDate() != null ? this.getDateTimeService().toDateString((Date)proposal.getDeadlineDate()) : "null");
        this.getDocumentHeader().setDocumentDescription(desc);
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getCustomDataList();
    }

    public List<CustomAttributeDocValue> getCustomDataList() {
        return this.customDataList;
    }

    public void setCustomDataList(List<CustomAttributeDocValue> customDataList) {
        this.customDataList = customDataList;
    }

    public String getSaveXmlFolderName() {
        return this.saveXmlFolderName;
    }

    public void setSaveXmlFolderName(String saveXmlFolderName) {
        this.saveXmlFolderName = saveXmlFolderName;
    }

    public boolean isDefaultDocumentDescription() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "HIDE_AND_DEFAULT_PROP_DEV_DOC_DESC");
    }

    public String getDocumentTitle() {
        if (this.isDefaultDocumentDescription()) {
            return this.getDocumentHeader().getDocumentDescription();
        }
        return super.getDocumentTitle();
    }
}

