/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class ProposalDevelopmentDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    Log LOG = LogFactory.getLog(ProposalDevelopmentDocumentAuthorizer.class);

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProposalDevelopmentDocument proposalDoc = (ProposalDevelopmentDocument)document;
        String proposalNbr = proposalDoc.getDevelopmentProposal().getProposalNumber();
        String userId = user.getPrincipalId();
        if (proposalNbr == null) {
            if (this.canCreateProposal(user)) {
                editModes.add("fullEntry");
                this.setPermissions(userId, proposalDoc, editModes);
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canEdit(document, user)) {
                editModes.add("fullEntry");
                this.setPermissions(userId, proposalDoc, editModes);
            } else if (this.canExecuteProposalTask(userId, proposalDoc, "viewProposal")) {
                editModes.add("viewOnly");
                this.setPermissions(userId, proposalDoc, editModes);
            } else {
                editModes.add("unviewable");
            }
            if (this.isBudgetComplete((BudgetParentDocument)proposalDoc)) {
                if (editModes.contains("addBudget")) {
                    editModes.add("modifyCompletedBudgets");
                }
                editModes.remove("modifyProposalBudget");
                editModes.remove("addBudget");
            }
        }
        return editModes;
    }

    private void setPermissions(String userId, ProposalDevelopmentDocument doc, Set<String> editModes) {
        if (editModes.contains("fullEntry")) {
            editModes.add("modifyProposal");
        }
        if (this.canExecuteTask(userId, doc, "addBudget")) {
            editModes.add("addBudget");
        }
        if (this.canExecuteTask(userId, doc, "openBudgets")) {
            editModes.add("openBudgets");
        }
        if (this.canExecuteTask(userId, doc, "modifyBudget")) {
            editModes.add("modifyProposalBudget");
        }
        if (this.canExecuteTask(userId, doc, "modifyProposalRoles")) {
            editModes.add("modifyPermissions");
        }
        if (this.canExecuteTask(userId, doc, "addNarrative")) {
            editModes.add("addNarratives");
        }
        if (this.canExecuteTask(userId, doc, "certify")) {
            editModes.add("certify");
        }
        if (this.canExecuteTask(userId, doc, "printProposal")) {
            editModes.add("printProposal");
        }
        if (this.canExecuteTask(userId, doc, "alterProposalData")) {
            editModes.add("alterProposalData");
        }
        if (this.canExecuteTask(userId, doc, "showAlterProposalData")) {
            editModes.add("showAlterProposalData");
        }
        if (this.canExecuteTask(userId, doc, "submitToSponsor")) {
            editModes.add("submitToSponsor");
        }
        if (this.canExecuteTask(userId, doc, "maintainProposalHierarchy")) {
            editModes.add("maintainProposalHierarchy");
        }
        if (this.canExecuteTask(userId, doc, "rejectProposal")) {
            editModes.add("rejectProposal");
        }
        this.setNarrativePermissions(userId, doc, editModes);
    }

    private void setNarrativePermissions(String userId, ProposalDevelopmentDocument doc, Set<String> editModes) {
        String prefix;
        List narratives = doc.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narratives) {
            prefix = "proposalAttachment." + narrative.getModuleNumber() + ".";
            if (narrative.getDownloadAttachment(userId)) {
                editModes.add(prefix + "download");
            }
            if (narrative.getReplaceAttachment(userId)) {
                editModes.add(prefix + "replace");
            }
            if (narrative.getDeleteAttachment(userId)) {
                editModes.add(prefix + "delete");
            }
            if (!narrative.getModifyNarrativeRights(userId)) continue;
            editModes.add(prefix + "modifyRights");
        }
        narratives = doc.getDevelopmentProposal().getInstituteAttachments();
        for (Narrative narrative : narratives) {
            prefix = "instituteAttachment." + narrative.getModuleNumber() + ".";
            if (narrative.getDownloadAttachment(userId)) {
                editModes.add(prefix + "download");
            }
            if (narrative.getReplaceAttachment(userId)) {
                editModes.add(prefix + "replace");
            }
            if (narrative.getDeleteAttachment(userId)) {
                editModes.add(prefix + "delete");
            }
            if (!narrative.getModifyNarrativeRights(userId)) continue;
            editModes.add(prefix + "modifyRights");
        }
        TaskAuthorizationService taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        int i = 0;
        boolean canReplace = taskAuthorizationService.isAuthorized(userId, (Task)new ProposalTask("replacePersonnelAttachmentAuthorizer", doc));
        for (ProposalPersonBiography ppb : doc.getDevelopmentProposal().getPropPersonBios()) {
            ppb.setPositionNumber(i);
            String prefix2 = "biographyAttachments." + ppb.getPositionNumber() + ".";
            if (canReplace) {
                editModes.add(prefix2 + "replace");
            }
            ++i;
        }
    }

    private boolean canExecuteTask(String userId, ProposalDevelopmentDocument doc, String taskName) {
        return this.canExecuteProposalTask(userId, doc, taskName);
    }

    private boolean canExecuteProposalTask(String userId, ProposalDevelopmentDocument doc, String taskName) {
        ProposalTask task = new ProposalTask(taskName, doc);
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, (Task)task);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateProposal(user);
    }

    public boolean canOpen(Document document, Person user) {
        ProposalDevelopmentDocument proposalDocument = (ProposalDevelopmentDocument)document;
        if (proposalDocument.getDevelopmentProposal().getProposalNumber() == null) {
            return this.canCreateProposal(user);
        }
        return this.canExecuteProposalTask(user.getPrincipalId(), proposalDocument, "viewProposal");
    }

    private boolean canCreateProposal(Person user) {
        ApplicationTask task = new ApplicationTask("createProposal");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), (Task)task);
    }

    public boolean canEdit(Document document, Person user) {
        ProposalDevelopmentDocument proposalDocument = (ProposalDevelopmentDocument)document;
        String proposalStateTypeCode = "";
        if (proposalDocument.getDevelopmentProposal().getProposalState() != null) {
            proposalStateTypeCode = proposalDocument.getDevelopmentProposal().getProposalState().getStateTypeCode();
        }
        if (proposalStateTypeCode.equalsIgnoreCase("10") || proposalStateTypeCode.equalsIgnoreCase("7")) {
            return false;
        }
        return this.canExecuteProposalTask(user.getPrincipalId(), (ProposalDevelopmentDocument)document, "modifyProposal");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCancel(Document document, Person user) {
        return this.canEdit(document, user) && super.canCancel(document, user);
    }

    public boolean canReload(Document document, Person user) {
        WorkflowDocument workflow = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document, user) && !workflow.isInitiated() || workflow.isCanceled();
    }

    public boolean canRoute(Document document, Person user) {
        return this.canExecuteProposalTask(user.getPrincipalId(), (ProposalDevelopmentDocument)document, "submitToWorkflow") && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canAnnotate(Document document, Person user) {
        return this.canRoute(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canDisapprove(Document document, Person user) {
        return super.canDisapprove(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canBlanketApprove(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return workflowDocument.isEnroute() && super.canBlanketApprove(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canAcknowledge(Document document, Person user) {
        return super.canAcknowledge(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "proposal.hierarchyChildAcknowledgeAction");
    }

    protected boolean isBudgetComplete(BudgetParentDocument parentDocument) {
        if (!parentDocument.isComplete()) {
            return false;
        }
        for (BudgetDocumentVersion budgetVersion : parentDocument.getBudgetDocumentVersions()) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            return true;
        }
        return false;
    }

    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.canExecuteProposalTask(user.getPrincipalId(), (ProposalDevelopmentDocument)document, "proposalAddNoteAttachment");
    }

    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String createdBySelfOnly, Person user) {
        boolean retVal = false;
        Boolean allowNotesDeletion = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "allowProposalDevelopmentNotesDeletion");
        if (allowNotesDeletion != null && allowNotesDeletion.booleanValue()) {
            retVal = super.canDeleteNoteAttachment(document, attachmentTypeCode, createdBySelfOnly, user);
        }
        return retVal;
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.canExecuteProposalTask(user.getPrincipalId(), (ProposalDevelopmentDocument)document, "viewProposal");
    }

    public boolean canFyi(Document document, Person user) {
        return super.canFyi(document, user) && this.canExecuteProposalTask(user.getPrincipalName(), (ProposalDevelopmentDocument)document, "hierarchyChildWorkflowAction");
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canRecall(Document document, Person user) {
        return this.canExecuteProposalTask(user.getPrincipalId(), (ProposalDevelopmentDocument)document, "recallProposal");
    }
}

