/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.document.authorizer.ProposalAuthorizer;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.rice.krad.document.Document;

public class AlterProposalDataAuthorizer
extends ProposalAuthorizer {
    Log LOG = LogFactory.getLog(AlterProposalDataAuthorizer.class);

    public boolean isAuthorized(String userId, ProposalTask task) {
        boolean ret;
        ProposalDevelopmentDocument doc = task.getDocument();
        boolean bl = ret = this.kraWorkflowService.isEnRoute((Document)doc) && doc.getDevelopmentProposal().getSubmitFlag() == false && this.hasProposalPermission(userId, doc, "Alter Proposal Data");
        if (doc.getDevelopmentProposal().isChild()) {
            ProposalHierarchyService hService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
            try {
                if (hService.getParentWorkflowDocument(doc).isEnroute()) {
                    ret = false;
                }
            }
            catch (ProposalHierarchyException e) {
                this.LOG.error((Object)String.format("Exception looking up parent of DevelopmentProposal %s, authorizer is going to deny edit access to this child.", doc.getDevelopmentProposal().getProposalNumber()), (Throwable)e);
                ret = false;
            }
        }
        return ret;
    }
}

