/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorizer;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.document.authorizer.ProposalAuthorizer;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreateIacucProtocolFromProposalAuthorizer
extends ProposalAuthorizer {
    public boolean isAuthorized(String userId, ProposalTask task) {
        DevelopmentProposal proposal = task.getDocument().getDevelopmentProposal();
        return this.canCreateProtocol() && this.hasProposalRequiredFields(proposal);
    }

    private boolean canCreateProtocol() {
        ApplicationTask task = new ApplicationTask("createIacucProtocol");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        boolean canCreateProtocol = taskAuthenticationService.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)task);
        return canCreateProtocol;
    }

    private boolean hasProposalRequiredFields(DevelopmentProposal proposal) {
        ProposalPerson person;
        boolean validProposalRequiredFields = true;
        if (StringUtils.isEmpty((String)proposal.getTitle())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((String)proposal.getOwnedByUnitNumber())) {
            validProposalRequiredFields = false;
        }
        if ((person = proposal.getPrincipalInvestigator()) == null || StringUtils.isEmpty((String)person.getPersonId())) {
            validProposalRequiredFields = false;
        }
        return validProposalRequiredFields;
    }
}

