/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorizer;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorization.TaskAuthorizerImpl;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.NarrativeRight;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.NarrativeTask;
import org.kuali.kra.service.KraAuthorizationService;

public abstract class NarrativeAuthorizer
extends TaskAuthorizerImpl {
    private KraAuthorizationService kraAuthorizationService;
    private boolean requiresWritableDoc = false;

    public boolean isAuthorized(String userId, Task task) {
        NarrativeTask narrativeTask = (NarrativeTask)task;
        if (this.isRequiresWritableDoc() && narrativeTask.getDocument().isViewOnly()) {
            return false;
        }
        return this.isAuthorized(userId, narrativeTask);
    }

    public abstract boolean isAuthorized(String var1, NarrativeTask var2);

    public final void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected final boolean hasProposalPermission(String userId, ProposalDevelopmentDocument doc, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, (Permissionable)doc, permissionName);
    }

    protected final boolean hasNarrativeRight(String userId, Narrative narrative, NarrativeRight narrativeRight) {
        List userRightsList = narrative.getNarrativeUserRights();
        for (NarrativeUserRights userRights : userRightsList) {
            if (!StringUtils.equals((String)userId, (String)userRights.getUserId()) || !StringUtils.equals((String)userRights.getAccessType(), (String)narrativeRight.getAccessType())) continue;
            return true;
        }
        return false;
    }

    public boolean isRequiresWritableDoc() {
        return this.requiresWritableDoc;
    }

    public void setRequiresWritableDoc(boolean requiresWritableDoc) {
        this.requiresWritableDoc = requiresWritableDoc;
    }
}

