/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.document.authorizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.document.authorizer.ProposalAuthorizer;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class ProposalHierarchyChildWorkflowActionAuthorizer
extends ProposalAuthorizer {
    private static final Log LOG = LogFactory.getLog(ProposalHierarchyChildWorkflowActionAuthorizer.class);

    public boolean isAuthorized(String username, ProposalTask task) {
        boolean authorized = true;
        ProposalDevelopmentDocument doc = task.getDocument();
        if (doc.getDevelopmentProposal().isChild()) {
            try {
                WorkflowDocument parentWDoc = ((ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class)).getParentWorkflowDocument(doc);
                if (task.getTaskName().equals("proposal.hierarchyChildAcknowledgeAction")) {
                    if (!parentWDoc.isAcknowledgeRequested() || parentWDoc.isInitiated()) {
                        authorized = false;
                    }
                } else if (task.getTaskName().equals("hierarchyChildWorkflowAction") && !parentWDoc.isInitiated()) {
                    authorized = false;
                }
            }
            catch (ProposalHierarchyException e) {
                LOG.error((Object)String.format("Could not find parent workflow document for proposal document number:%s, which claims to be a child. Returning false.", doc.getDocumentHeader().getDocumentNumber()), (Throwable)e);
                authorized = false;
            }
        }
        return authorized;
    }
}

