/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.personnel.HierarchyPersonnelSummary;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyErrorDto;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.bo.HierarchyProposalSummary;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.transaction.PlatformTransactionManager;

public class ProposalHierarcyActionHelper {
    private static final Log LOG = LogFactory.getLog(ProposalHierarcyActionHelper.class);
    private ProposalHierarchyService hierarchyService;
    private KraAuthorizationService authorizationService;

    public void syncAllHierarchy(ProposalDevelopmentDocument doc) {
        this.syncAllHierarchy(doc, false);
    }

    public void syncAllHierarchy(ProposalDevelopmentDocument doc, boolean allowEndDateChange) {
        if (this.validateHierarchyForSyncAll(doc.getDevelopmentProposal(), allowEndDateChange)) {
            try {
                this.getProposalHierarchyService().synchronizeAllChildren(doc);
                KNSGlobalVariables.getMessageList().add("message.hierarchy.sync.success", new String[0]);
            }
            catch (ProposalHierarchyException e) {
                this.doUnexpectedError(e, "newHierarchyProposal.x", true);
            }
        }
    }

    public void removeFromHierarchy(DevelopmentProposal childProposal) {
        if (!this.getProposalHierarchyService().validateRemovePermissions(childProposal, GlobalVariables.getUserSession().getPrincipalId())) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.authorization.violation", new String[0]);
        } else if (this.validateChildForRemoval(childProposal)) {
            try {
                this.getProposalHierarchyService().removeFromHierarchy(childProposal);
                KNSGlobalVariables.getMessageList().add("message.hierarchy.remove.success", new String[0]);
            }
            catch (ProposalHierarchyException e) {
                this.doUnexpectedError(e, "newHierarchyProposal.x", true);
            }
        }
    }

    public void syncToHierarchyParent(DevelopmentProposal childProposal) {
        this.syncToHierarchyParent(childProposal, false);
    }

    public void syncToHierarchyParent(DevelopmentProposal childProposal, boolean allowEndDateChange) {
        DevelopmentProposal hierarchy = this.getProposalHierarchyService().getDevelopmentProposal(childProposal.getHierarchyParentProposalNumber());
        if (this.validateChildForSync(childProposal, hierarchy, allowEndDateChange)) {
            try {
                this.getProposalHierarchyService().synchronizeChild(childProposal);
                KNSGlobalVariables.getMessageList().add("message.hierarchy.sync.success", new String[0]);
            }
            catch (ProposalHierarchyException e) {
                this.doUnexpectedError(e, "newHierarchyProposal.x", true);
            }
        }
    }

    public void syncBudgetToParent(ProposalDevelopmentBudgetExt budget, DevelopmentProposal childProposal, boolean allowEndDateChange) {
        DevelopmentProposal hierarchy = this.getProposalHierarchyService().getDevelopmentProposal(childProposal.getHierarchyParentProposalNumber());
        if (this.validateChildForSync(childProposal, hierarchy, allowEndDateChange)) {
            try {
                this.getProposalHierarchyService().synchronizeChildProposalBudget(budget, childProposal);
                KNSGlobalVariables.getMessageList().add("message.hierarchy.sync.success", new String[0]);
            }
            catch (ProposalHierarchyException e) {
                this.doUnexpectedError(e, "newHierarchyProposal.x", true);
            }
        }
    }

    public void createHierarchy(DevelopmentProposal initialChildProposal) {
        LOG.info((Object)String.format("createHierarchy called with Proposal $s", initialChildProposal.getProposalNumber()));
        if (this.validateChildCandidate(initialChildProposal)) {
            try {
                MessageMap messageMap = GlobalVariables.getMessageMap();
                String parentProposalNumber = this.getProposalHierarchyService().createHierarchy(initialChildProposal);
                if (GlobalVariables.getMessageMap() != messageMap) {
                    GlobalVariables.getMessageMap().merge(messageMap);
                }
                KNSGlobalVariables.getMessageList().add("message.hierarchy.create.success", new String[]{parentProposalNumber});
            }
            catch (ProposalHierarchyException e) {
                this.doUnexpectedError(e, "newHierarchyProposal.x", true);
            }
        }
        LOG.info((Object)String.format("createHierarchy completed", initialChildProposal.getProposalNumber()));
    }

    public void linkToHierarchy(DevelopmentProposal hierarchyProposal, DevelopmentProposal newChildProposal, String hierarchyBudgetTypeCode) {
        this.linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode, false);
    }

    public void linkToHierarchy(DevelopmentProposal hierarchyProposal, DevelopmentProposal newChildProposal, String hierarchyBudgetTypeCode, boolean allowEndDateChange) {
        if (!this.getAuthoriztionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), (Permissionable)hierarchyProposal.getProposalDocument(), "Maintain ProposalHierarchy") || !this.getAuthoriztionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), (Permissionable)newChildProposal.getProposalDocument(), "Maintain ProposalHierarchy")) {
            GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", "error.authorization.violation", new String[0]);
        } else if (this.validateParent(hierarchyProposal)) {
            boolean valid = true;
            if ((valid &= this.validateChildCandidate(newChildProposal)) && this.validateChildCandidateForHierarchy(hierarchyProposal, newChildProposal, allowEndDateChange)) {
                try {
                    MessageMap messageMap = GlobalVariables.getMessageMap();
                    this.getProposalHierarchyService().linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode);
                    if (GlobalVariables.getMessageMap() != messageMap) {
                        GlobalVariables.getMessageMap().merge(messageMap);
                    }
                    KNSGlobalVariables.getMessageList().add("message.hierarchy.link.success", new String[]{newChildProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()});
                }
                catch (ProposalHierarchyException e) {
                    this.doUnexpectedError(e, "newHierarchyProposal.x", true);
                }
            }
        }
    }

    public List<HierarchyPersonnelSummary> getHierarchyPersonnelSummaries(String parentProposalNumber) {
        List retval = null;
        try {
            retval = this.getProposalHierarchyService().getHierarchyPersonnelSummaries(parentProposalNumber);
        }
        catch (ProposalHierarchyException e) {
            this.doUnexpectedError(e, "newHierarchyProposal.x", false);
        }
        return retval;
    }

    public List<HierarchyProposalSummary> getHierarchyProposalSummaries(String proposalNumber) {
        List retval = null;
        try {
            retval = this.getProposalHierarchyService().getHierarchyProposalSummaries(proposalNumber);
        }
        catch (ProposalHierarchyException e) {
            this.doUnexpectedError(e, "newHierarchyProposal.x", false);
        }
        return retval;
    }

    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return this.getProposalHierarchyService().getDevelopmentProposal(proposalNumber);
    }

    public List<DevelopmentProposal> getChildProposals(String parentProposalNumber) {
        ArrayList<DevelopmentProposal> childProposals = new ArrayList<DevelopmentProposal>();
        try {
            childProposals.addAll(this.getProposalHierarchyService().getHierarchyChildren(parentProposalNumber));
        }
        catch (ProposalHierarchyException e) {
            this.doUnexpectedError(e, "newHierarchyProposal.x", false);
        }
        return childProposals;
    }

    private ProposalHierarchyService getProposalHierarchyService() {
        if (this.hierarchyService == null) {
            this.hierarchyService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.hierarchyService;
    }

    private KraAuthorizationService getAuthoriztionService() {
        if (this.authorizationService == null) {
            this.authorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        }
        return this.authorizationService;
    }

    private boolean validateParent(DevelopmentProposal proposal) {
        boolean valid = true;
        if (!proposal.isParent()) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposalNumber", "error.hierarchy.link.notParent", new String[0]);
            valid = false;
        } else if (this.hasCompleteBudget(proposal)) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposalNumber", "error.hierarchy.link.parentBudgetComplete", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateChildCandidate(DevelopmentProposal proposal) {
        boolean valid = true;
        proposal.getProposalDocument().refreshBudgetDocumentVersions();
        if (proposal.isInHierarchy()) {
            GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", "error.hierarchy.link.alreadyHierarchyMember", new String[0]);
            return false;
        }
        if (proposal.getProposalDocument().getBudgetDocumentVersions().isEmpty()) {
            GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", "error.hierarchy.link.noBudgetVersion", new String[0]);
            valid = false;
        } else if (!this.hasFinalBudget(proposal)) {
            GlobalVariables.getMessageMap().putWarning("newHierarchyChildProposalNumber", "warning.hierarchy.link.noFinalBudget", new String[]{proposal.getProposalNumber()});
        }
        if (proposal.getPrincipalInvestigator() == null) {
            GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", "error.hierarchy.link.noPrincipleInvestigator", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateChildCandidateForHierarchy(DevelopmentProposal hierarchy, DevelopmentProposal child, boolean allowEndDateChange) {
        boolean valid = true;
        if (!StringUtils.equalsIgnoreCase((String)hierarchy.getSponsorCode(), (String)child.getSponsorCode())) {
            GlobalVariables.getMessageMap().putWarning("newHierarchyChildProposalNumber", "warning.hierarchy.link.differentSponsor", new String[0]);
        }
        try {
            ProposalHierarchyErrorDto budgetError = this.getProposalHierarchyService().validateChildBudgetPeriods(hierarchy, child, allowEndDateChange);
            if (budgetError != null) {
                valid = false;
                GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", budgetError.getErrorKey(), budgetError.getErrorParameters());
            }
        }
        catch (ProposalHierarchyException e) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.unexpected", new String[]{e.getMessage()});
            valid = false;
        }
        return valid;
    }

    private boolean validateChildForRemoval(DevelopmentProposal child) {
        boolean valid = true;
        try {
            DevelopmentProposal hierarchy = this.getProposalHierarchyService().lookupParent(child);
            if (this.hasCompleteBudget(hierarchy)) {
                GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.remove.parentBudgetComplete", new String[0]);
                valid = false;
            }
        }
        catch (ProposalHierarchyException e) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.unexpected", new String[]{e.getMessage()});
            valid = false;
        }
        return valid;
    }

    private boolean hasFinalBudget(DevelopmentProposal proposal) {
        boolean retval = false;
        for (BudgetDocumentVersion version : proposal.getProposalDocument().getBudgetDocumentVersions()) {
            if (!version.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean hasCompleteBudget(DevelopmentProposal proposal) {
        String completeCode = ((ParameterService)KraServiceLocator.getService(ParameterService.class)).getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).loadBudgetStatus(proposal);
        return StringUtils.equalsIgnoreCase((String)proposal.getBudgetStatus(), (String)completeCode);
    }

    private void doUnexpectedError(ProposalHierarchyException e, String field, boolean rollback) {
        LOG.error((Object)String.format("Unexpected error in Proposal Hierarchy handling: %s", e.toString()), (Throwable)e);
        if (rollback) {
            PlatformTransactionManager txMgr = (PlatformTransactionManager)KraServiceLocator.getService((String)"transactionManager");
            txMgr.rollback(txMgr.getTransaction(null));
        }
        GlobalVariables.getMessageMap().putError(field, "error.hierarchy.unexpected", new String[]{e.toString()});
    }

    public boolean checkParentChildStatusMatch(ProposalDevelopmentDocument document) {
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        boolean match = true;
        try {
            if (proposal.isParent() && this.hasCompleteBudget(document) && !this.getProposalHierarchyService().allChildBudgetsAreComplete(proposal.getProposalNumber())) {
                match = false;
                GlobalVariables.getMessageMap().putError("document.budgetDocumentVersion[0].budgetVersionOverview.budgetStatus", "error.hierarchy.budget.childStatusesNotComplete", new String[0]);
            } else if (proposal.isChild() && !this.hasCompleteBudget(document) && this.hasCompleteBudget(this.getProposalHierarchyService().lookupParent(proposal))) {
                match = false;
            }
        }
        catch (ProposalHierarchyException e) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.unexpected", new String[]{e.getMessage()});
            match = false;
        }
        return match;
    }

    public boolean validateChildForSync(DevelopmentProposal child, DevelopmentProposal hierarchy, boolean allowEndDateChange) {
        boolean valid = true;
        if (child.getPrincipalInvestigator() == null) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.sync.noPrincipleInvestigator", new String[]{child.getProposalNumber()});
            valid = false;
        }
        try {
            ProposalHierarchyErrorDto budgetError = this.getProposalHierarchyService().validateChildBudgetPeriods(hierarchy, child, allowEndDateChange);
            if (budgetError != null) {
                valid = false;
                GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", budgetError.getErrorKey(), budgetError.getErrorParameters());
            }
        }
        catch (ProposalHierarchyException e) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.unexpected", new String[]{e.getMessage()});
            valid = false;
        }
        return valid;
    }

    public boolean validateHierarchyForSyncAll(DevelopmentProposal hierarchy, boolean allowEndDateChange) {
        boolean valid = true;
        try {
            for (DevelopmentProposal child : this.getProposalHierarchyService().getHierarchyChildren(hierarchy.getProposalNumber())) {
                valid &= this.validateChildForSync(child, hierarchy, allowEndDateChange);
            }
        }
        catch (ProposalHierarchyException e) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposal.x", "error.hierarchy.unexpected", new String[]{e.getMessage()});
            valid = false;
        }
        return valid;
    }

    private boolean hasCompleteBudget(ProposalDevelopmentDocument pdDoc) {
        boolean retval = false;
        String completeCode = ((ParameterService)KraServiceLocator.getService(ParameterService.class)).getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        for (BudgetDocumentVersion version : pdDoc.getBudgetDocumentVersions()) {
            if (version.getBudgetVersionOverview().getBudgetStatus() == null || !version.getBudgetVersionOverview().getBudgetStatus().equalsIgnoreCase(completeCode)) continue;
            retval = true;
            break;
        }
        return retval;
    }
}

