/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.hierarchy.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalBudgetStatus;
import org.kuali.kra.proposaldevelopment.hierarchy.dao.ProposalHierarchyDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.util.OjbCollectionAware;

public class ProposalHierarchyDaoOjb
extends PlatformAwareDaoBaseOjb
implements OjbCollectionAware,
ProposalHierarchyDao {
    public List<String> getHierarchyChildProposalNumbers(String proposalNumber) {
        ArrayList<String> retval = new ArrayList<String>();
        ReportQueryByCriteria query = this.createHierarchyChildProposalNumberQuery(proposalNumber);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] result = (Object[])iter.next();
            retval.add((String)result[0]);
        }
        return retval;
    }

    public List<ProposalBudgetStatus> getHierarchyChildProposalBudgetStatuses(String proposalNumber) {
        Criteria crit = new Criteria();
        crit.addIn("proposalNumber", (Collection)this.getHierarchyChildProposalNumbers(proposalNumber));
        QueryByCriteria statusQuery = new QueryByCriteria(ProposalBudgetStatus.class, crit);
        return new ArrayList<ProposalBudgetStatus>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)statusQuery));
    }

    private ReportQueryByCriteria createHierarchyChildProposalNumberQuery(String proposalNumber) {
        Criteria crit = new Criteria();
        crit.addEqualTo("hierarchyParentProposalNumber", (Object)proposalNumber);
        ReportQueryByCriteria query = new ReportQueryByCriteria(DevelopmentProposal.class, crit);
        query.addOrderByAscending("proposalNumber");
        query.setAttributes(new String[]{"proposalNumber"});
        return query;
    }
}

