/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.hierarchy.service.impl;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelBudgetService;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.HierarchyPersonnelSummary;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeStatus;
import org.kuali.kra.proposaldevelopment.bo.PropScienceKeyword;
import org.kuali.kra.proposaldevelopment.bo.ProposalBudgetStatus;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonExtendedAttributes;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardAttachment;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardFiles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyBudgetTypeConstants;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyStatusConstants;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyErrorDto;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.bo.HierarchyProposalSummary;
import org.kuali.kra.proposaldevelopment.hierarchy.dao.ProposalHierarchyDao;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.service.DeepCopyPostProcessor;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kns.service.SessionDocumentService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProposalHierarchyServiceImpl
implements ProposalHierarchyService {
    private static final Log LOG = LogFactory.getLog(ProposalHierarchyServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private KraAuthorizationService kraAuthorizationService;
    private ProposalHierarchyDao proposalHierarchyDao;
    private NarrativeService narrativeService;
    private BudgetService budgetService;
    private BudgetSummaryService budgetSummaryService;
    private ProposalPersonBiographyService propPersonBioService;
    private ParameterService parameterService;
    private IdentityService identityManagementService;
    private ConfigurationService configurationService;
    private KraDocumentRejectionService kraDocumentRejectionService;
    private List<ProposalPersonExtendedAttributes> proposalPersonExtendedAttributesToDelete;
    private SessionDocumentService sessionDocumentService;
    private WorkflowDocumentService workflowDocumentService;

    public void setIdentityManagementService(IdentityService identityManagerService) {
        this.identityManagementService = identityManagerService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setProposalHierarchyDao(ProposalHierarchyDao proposalHierarchyDao) {
        this.proposalHierarchyDao = proposalHierarchyDao;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setPropPersonBioService(ProposalPersonBiographyService propPersonBioService) {
        this.propPersonBioService = propPersonBioService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public String createHierarchy(DevelopmentProposal initialChild) throws ProposalHierarchyException {
        ProposalDevelopmentDocument newDoc;
        LOG.info((Object)String.format("***Create Hierarchy using Proposal #%s", initialChild.getProposalNumber()));
        if (initialChild.isInHierarchy()) {
            throw new ProposalHierarchyException("Cannot create hierarchy: proposal " + initialChild.getProposalNumber() + " is already a member of a hierarchy.");
        }
        try {
            WorkflowDocument workflowDocument = this.workflowDocumentService.createWorkflowDocument("ProposalDevelopmentDocument", GlobalVariables.getUserSession().getPerson());
            this.sessionDocumentService.addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDocument);
            DocumentHeader documentHeader = new DocumentHeader();
            documentHeader.setWorkflowDocument(workflowDocument);
            documentHeader.setDocumentNumber(workflowDocument.getDocumentId().toString());
            newDoc = new ProposalDevelopmentDocument();
            newDoc.setDocumentHeader(documentHeader);
            newDoc.setDocumentNumber(documentHeader.getDocumentNumber());
        }
        catch (WorkflowException x) {
            throw new ProposalHierarchyException("Error creating new document: " + (Object)((Object)x));
        }
        DevelopmentProposal hierarchy = newDoc.getDevelopmentProposal();
        this.copyInitialData(hierarchy, initialChild);
        hierarchy.setHierarchyStatus(HierarchyStatusConstants.Parent.code());
        String docDescription = initialChild.getProposalDocument().getDocumentHeader().getDocumentDescription();
        newDoc.getDocumentHeader().setDocumentDescription(docDescription);
        try {
            this.documentService.saveDocument((Document)newDoc);
            this.budgetService.addBudgetVersion((BudgetParentDocument)newDoc, "Hierarchy Budget");
        }
        catch (WorkflowException x) {
            throw new ProposalHierarchyException("Error saving new document: " + (Object)((Object)x));
        }
        LOG.info((Object)String.format("***New Hierarchy Parent (#%s) budget created", hierarchy.getProposalNumber()));
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addRole(userId, "Aggregator", (Permissionable)newDoc);
        this.initializeBudget(hierarchy, initialChild);
        this.prepareHierarchySync(hierarchy);
        this.linkChild(hierarchy, initialChild, HierarchyBudgetTypeConstants.SubBudget.code());
        this.setInitialPi(hierarchy, initialChild);
        this.copyInitialAttachments(initialChild, hierarchy);
        this.aggregateHierarchy(hierarchy);
        LOG.info((Object)String.format("***Initial Child (#%s) linked to Parent (#%s)", initialChild.getProposalNumber(), hierarchy.getProposalNumber()));
        this.finalizeHierarchySync(hierarchy);
        LOG.info((Object)String.format("***Hierarchy creation (#%s) complete", hierarchy.getProposalNumber()));
        return hierarchy.getProposalNumber();
    }

    public void linkToHierarchy(DevelopmentProposal hierarchyProposal, DevelopmentProposal newChildProposal, String hierarchyBudgetTypeCode) throws ProposalHierarchyException {
        LOG.info((Object)String.format("***Linking Child (#%s) linked to Parent (#%s)", newChildProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()));
        if (!hierarchyProposal.isParent()) {
            throw new ProposalHierarchyException("Proposal " + hierarchyProposal.getProposalNumber() + " is not a hierarchy parent");
        }
        if (newChildProposal.isInHierarchy()) {
            throw new ProposalHierarchyException("Proposal " + newChildProposal.getProposalNumber() + " is already a member of a hierarchy");
        }
        this.prepareHierarchySync(hierarchyProposal);
        this.linkChild(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode);
        this.finalizeHierarchySync(hierarchyProposal);
        LOG.info((Object)String.format("***Linking Child (#%s) linked to Parent (#%s) complete", newChildProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()));
    }

    public void removeFromHierarchy(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        String hierarchyProposalNumber = childProposal.getHierarchyParentProposalNumber();
        DevelopmentProposal hierarchyProposal = this.getHierarchy(hierarchyProposalNumber);
        BudgetDocument hierarchyBudgetDoc = this.getHierarchyBudget(hierarchyProposal);
        Budget hierarchyBudget = hierarchyBudgetDoc.getBudget();
        LOG.info((Object)String.format("***Removing Child (#%s) from Parent (#%s)", childProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()));
        List childProposalNumbers = this.proposalHierarchyDao.getHierarchyChildProposalNumbers(hierarchyProposalNumber);
        boolean isLast = childProposalNumbers.size() == 1 && StringUtils.equals((String)((String)childProposalNumbers.get(0)), (String)childProposal.getProposalNumber());
        childProposal.setHierarchyStatus(HierarchyStatusConstants.None.code());
        childProposal.setHierarchyParentProposalNumber(null);
        if (StringUtils.equalsIgnoreCase((String)hierarchyProposal.getHierarchyOriginatingChildProposalNumber(), (String)childProposal.getProposalNumber())) {
            hierarchyProposal.getPrincipalInvestigator().setHierarchyProposalNumber(null);
        }
        this.removeChildElements(hierarchyProposal, hierarchyBudget, childProposal.getProposalNumber());
        try {
            this.documentService.saveDocument((Document)hierarchyBudgetDoc);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        if (isLast) {
            try {
                LOG.info((Object)String.format("***Child (#%s) was last child, cancelling Parent (#%s)", childProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()));
                this.businessObjectService.save((PersistableBusinessObject)childProposal);
                Document doc = this.documentService.getByDocumentHeaderId(hierarchyProposal.getProposalDocument().getDocumentNumber());
                this.documentService.cancelDocument(doc, "Removed last child from Proposal Hierarchy");
            }
            catch (WorkflowException e) {
                throw new ProposalHierarchyException("Error cancelling empty parent proposal");
            }
        } else {
            String lowestProposalNumber = "";
            for (String proposalNumber : childProposalNumbers) {
                if (StringUtils.equals((String)proposalNumber, (String)childProposal.getProposalNumber())) continue;
                lowestProposalNumber = proposalNumber;
                break;
            }
            hierarchyProposal.setHierarchyOriginatingChildProposalNumber(lowestProposalNumber);
            this.businessObjectService.save((PersistableBusinessObject)childProposal);
            this.synchronizeAllChildren(hierarchyProposal);
        }
        LOG.info((Object)String.format("***Removing Child (#%s) from Parent (#%s) complete", childProposal.getProposalNumber(), hierarchyProposal.getProposalNumber()));
    }

    public void synchronizeAllChildren(ProposalDevelopmentDocument pdDoc) throws ProposalHierarchyException {
        this.prepareHierarchySync(pdDoc);
        this.synchronizeAll(pdDoc.getDevelopmentProposal());
        this.finalizeHierarchySync(pdDoc);
    }

    protected void synchronizeAllChildren(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        this.prepareHierarchySync(hierarchyProposal);
        this.synchronizeAll(hierarchyProposal);
        this.finalizeHierarchySync(hierarchyProposal);
    }

    protected void synchronizeAll(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        boolean changed = false;
        LOG.info((Object)String.format("***Synchronizing all Children of Parent (#%s)", hierarchyProposal.getProposalNumber()));
        if (!hierarchyProposal.isParent()) {
            throw new ProposalHierarchyException("Proposal " + hierarchyProposal.getProposalNumber() + " is not a hierarchy parent");
        }
        changed = this.synchronizeAllChildProposals(hierarchyProposal);
        if (changed) {
            this.aggregateHierarchy(hierarchyProposal);
        }
        LOG.info((Object)String.format("***Synchronizing all Children of Parent (#%s) complete", hierarchyProposal.getProposalNumber()));
    }

    public void synchronizeChild(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        DevelopmentProposal hierarchy = this.getHierarchy(childProposal.getHierarchyParentProposalNumber());
        LOG.info((Object)String.format("***Synchronizing Child (#%s) of Parent (#%s)", childProposal.getProposalNumber(), hierarchy.getProposalNumber()));
        this.prepareHierarchySync(hierarchy);
        boolean changed = this.synchronizeChildProposal(hierarchy, childProposal);
        if (changed) {
            this.aggregateHierarchy(hierarchy);
        }
        this.finalizeHierarchySync(hierarchy);
        LOG.info((Object)String.format("***Synchronizing Child (#%s) of Parent (#%s) complete", childProposal.getProposalNumber(), hierarchy.getProposalNumber()));
    }

    public void synchronizeChildProposalBudget(ProposalDevelopmentBudgetExt budget, DevelopmentProposal childProposal) throws ProposalHierarchyException {
        DevelopmentProposal hierarchy = this.getHierarchy(childProposal.getHierarchyParentProposalNumber());
        LOG.info((Object)String.format("***Synchronizing Child Budget (#%s) of Parent (#%s)", childProposal.getProposalNumber(), hierarchy.getProposalNumber()));
        this.prepareHierarchySync(hierarchy);
        boolean changed = this.synchronizeChildProposalBudget(hierarchy, budget, childProposal);
        if (changed) {
            this.aggregateHierarchy(hierarchy);
        }
        this.finalizeHierarchySync(hierarchy);
        LOG.info((Object)String.format("***Synchronizing Child Budget (#%s) of Parent (#%s) complete", childProposal.getProposalNumber(), hierarchy.getProposalNumber()));
    }

    public DevelopmentProposal lookupParent(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        return this.getHierarchy(childProposal.getHierarchyParentProposalNumber());
    }

    protected void linkChild(DevelopmentProposal hierarchyProposal, DevelopmentProposal newChildProposal, String hierarchyBudgetTypeCode) throws ProposalHierarchyException {
        newChildProposal.setHierarchyStatus(HierarchyStatusConstants.Child.code());
        newChildProposal.setHierarchyParentProposalNumber(hierarchyProposal.getProposalNumber());
        newChildProposal.setHierarchyBudgetType(hierarchyBudgetTypeCode);
        this.synchronizeChildProposal(hierarchyProposal, newChildProposal);
        this.aggregateHierarchy(hierarchyProposal);
    }

    protected void copyInitialData(DevelopmentProposal hierarchyProposal, DevelopmentProposal srcProposal) throws ProposalHierarchyException {
        hierarchyProposal.setHierarchyOriginatingChildProposalNumber(srcProposal.getProposalNumber());
        hierarchyProposal.setSponsor(srcProposal.getSponsor());
        hierarchyProposal.setSponsorCode(srcProposal.getSponsorCode());
        hierarchyProposal.setProposalTypeCode(srcProposal.getProposalTypeCode());
        hierarchyProposal.setRequestedStartDateInitial(srcProposal.getRequestedStartDateInitial());
        hierarchyProposal.setRequestedEndDateInitial(srcProposal.getRequestedEndDateInitial());
        hierarchyProposal.setOwnedByUnit(srcProposal.getOwnedByUnit());
        hierarchyProposal.setOwnedByUnitNumber(srcProposal.getOwnedByUnitNumber());
        hierarchyProposal.setActivityType(srcProposal.getActivityType());
        hierarchyProposal.setActivityTypeCode(srcProposal.getActivityTypeCode());
        hierarchyProposal.setTitle(srcProposal.getTitle());
        hierarchyProposal.setDeadlineDate(srcProposal.getDeadlineDate());
        hierarchyProposal.setDeadlineTime(srcProposal.getDeadlineTime());
        hierarchyProposal.setDeadlineType(srcProposal.getDeadlineType());
        hierarchyProposal.setAnticipatedAwardTypeCode(srcProposal.getAnticipatedAwardTypeCode());
        hierarchyProposal.setNoticeOfOpportunityCode(srcProposal.getNoticeOfOpportunityCode());
        hierarchyProposal.setCfdaNumber(srcProposal.getCfdaNumber());
        hierarchyProposal.setPrimeSponsorCode(srcProposal.getPrimeSponsorCode());
        hierarchyProposal.setNsfCode(srcProposal.getNsfCode());
        hierarchyProposal.setSponsorProposalNumber(srcProposal.getSponsorProposalNumber());
        hierarchyProposal.setAgencyDivisionCode(srcProposal.getAgencyDivisionCode());
        hierarchyProposal.setAgencyProgramCode(srcProposal.getAgencyProgramCode());
        hierarchyProposal.setSubcontracts(srcProposal.getSubcontracts());
        hierarchyProposal.setProgramAnnouncementNumber(srcProposal.getProgramAnnouncementNumber());
        hierarchyProposal.setProgramAnnouncementTitle(srcProposal.getProgramAnnouncementTitle());
        hierarchyProposal.getProposalSites().clear();
        for (ProposalSite site : srcProposal.getProposalSites()) {
            ProposalSite newSite = (ProposalSite)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)site);
            newSite.setProposalNumber(null);
            newSite.setVersionNumber(null);
            for (CongressionalDistrict cd : newSite.getCongressionalDistricts()) {
                cd.setProposalNumber(null);
                cd.setCongressionalDistrictId(null);
                cd.setVersionNumber(null);
            }
            hierarchyProposal.addProposalSite(newSite);
        }
        hierarchyProposal.setMailBy(srcProposal.getMailBy());
        hierarchyProposal.setMailType(srcProposal.getMailType());
        hierarchyProposal.setMailAccountNumber(srcProposal.getMailAccountNumber());
        hierarchyProposal.setNumberOfCopies(srcProposal.getNumberOfCopies());
        hierarchyProposal.setMailingAddressId(srcProposal.getMailingAddressId());
        hierarchyProposal.setMailDescription(srcProposal.getMailDescription());
    }

    protected boolean synchronizeAllChildProposals(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        boolean changed = false;
        for (DevelopmentProposal childProposal : this.getHierarchyChildren(hierarchyProposal.getProposalNumber())) {
            List oldKeywords = this.getOldKeywords(hierarchyProposal, childProposal);
            ProposalPerson principalInvestigator = hierarchyProposal.getPrincipalInvestigator();
            BudgetDocument hierarchyBudgetDocument = this.getHierarchyBudget(hierarchyProposal);
            Budget hierarchyBudget = hierarchyBudgetDocument.getBudget();
            BudgetDocument childBudgetDocument = this.getSyncableBudget(childProposal);
            ProposalDevelopmentBudgetExt childBudget = (ProposalDevelopmentBudgetExt)childBudgetDocument.getBudget();
            org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)hierarchyBudget);
            org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)childBudget);
            childProposal.setHierarchyLastSyncHashCode(Integer.valueOf(this.computeHierarchyHashCode(childProposal)));
            this.removeChildElements(hierarchyProposal, hierarchyBudget, childProposal.getProposalNumber());
            this.synchronizeKeywords(hierarchyProposal, childProposal, oldKeywords);
            this.synchronizeSpecialReviews(hierarchyProposal, childProposal);
            this.synchronizeNarratives(hierarchyProposal, childProposal);
            this.synchronizePersons(hierarchyProposal, childProposal, principalInvestigator);
            this.businessObjectService.save((PersistableBusinessObject)childProposal);
            this.synchronizeBudget(hierarchyProposal, childProposal, hierarchyBudget, childBudget, hierarchyBudgetDocument);
            changed = true;
        }
        return changed;
    }

    protected boolean synchronizeChildProposal(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) throws ProposalHierarchyException {
        List oldKeywords = this.getOldKeywords(hierarchyProposal, childProposal);
        ProposalPerson principalInvestigator = hierarchyProposal.getPrincipalInvestigator();
        BudgetDocument hierarchyBudgetDocument = this.getHierarchyBudget(hierarchyProposal);
        Budget hierarchyBudget = hierarchyBudgetDocument.getBudget();
        BudgetDocument childBudgetDocument = this.getSyncableBudget(childProposal);
        ProposalDevelopmentBudgetExt childBudget = (ProposalDevelopmentBudgetExt)childBudgetDocument.getBudget();
        org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)hierarchyBudget);
        org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)childBudget);
        childProposal.setHierarchyLastSyncHashCode(Integer.valueOf(this.computeHierarchyHashCode(childProposal)));
        this.removeChildElements(hierarchyProposal, hierarchyBudget, childProposal.getProposalNumber());
        try {
            this.documentService.saveDocument((Document)hierarchyBudgetDocument);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        this.synchronizeKeywords(hierarchyProposal, childProposal, oldKeywords);
        this.synchronizeSpecialReviews(hierarchyProposal, childProposal);
        this.synchronizeNarratives(hierarchyProposal, childProposal);
        this.synchronizePersonsAndAggregate(hierarchyProposal, childProposal, principalInvestigator);
        this.businessObjectService.save((PersistableBusinessObject)childProposal);
        this.synchronizeBudget(hierarchyProposal, childProposal, hierarchyBudget, childBudget, hierarchyBudgetDocument);
        return true;
    }

    protected boolean synchronizeChildProposalBudget(DevelopmentProposal hierarchyProposal, ProposalDevelopmentBudgetExt budget, DevelopmentProposal childProposal) throws ProposalHierarchyException {
        BudgetDocument hierarchyBudgetDocument = this.getHierarchyBudget(hierarchyProposal);
        Budget hierarchyBudget = hierarchyBudgetDocument.getBudget();
        BudgetDocument childBudgetDocument = this.getSyncableBudget(childProposal);
        if (!StringUtils.equals((String)childBudgetDocument.getDocumentNumber(), (String)budget.getDocumentNumber())) {
            budget = (ProposalDevelopmentBudgetExt)childBudgetDocument.getBudget();
        }
        org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)hierarchyBudget);
        org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)budget);
        this.removeChildBudgetElements(hierarchyProposal, hierarchyBudget, childProposal.getProposalNumber());
        try {
            this.getDocumentService().saveDocument((Document)hierarchyBudgetDocument);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        this.synchronizeBudget(hierarchyProposal, childProposal, hierarchyBudget, budget, hierarchyBudgetDocument);
        return true;
    }

    protected List<PropScienceKeyword> getOldKeywords(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        ArrayList<PropScienceKeyword> oldKeywords = new ArrayList<PropScienceKeyword>();
        for (PropScienceKeyword keyword : hierarchyProposal.getPropScienceKeywords()) {
            if (!StringUtils.equals((String)childProposal.getProposalNumber(), (String)keyword.getHierarchyProposalNumber())) continue;
            oldKeywords.add(keyword);
        }
        return oldKeywords;
    }

    protected void synchronizeKeywords(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, List<PropScienceKeyword> oldKeywords) {
        for (PropScienceKeyword keyword : childProposal.getPropScienceKeywords()) {
            PropScienceKeyword newKeyword = new PropScienceKeyword(hierarchyProposal.getProposalNumber(), keyword.getScienceKeyword());
            int index = oldKeywords.indexOf(newKeyword);
            if (index > -1) {
                newKeyword = oldKeywords.get(index);
            }
            newKeyword.setHierarchyProposalNumber(childProposal.getProposalNumber());
            hierarchyProposal.addPropScienceKeyword(newKeyword);
        }
    }

    protected void synchronizeSpecialReviews(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        for (ProposalSpecialReview review : childProposal.getPropSpecialReviews()) {
            ProposalSpecialReview newReview = (ProposalSpecialReview)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)review);
            newReview.setProposalSpecialReviewId(null);
            newReview.setProposalNumber(hierarchyProposal.getProposalNumber());
            newReview.setSpecialReviewNumber(hierarchyProposal.getProposalDocument().getDocumentNextValue("proposalDevelopment.proposalSpecialReview.specialReviewNumber"));
            newReview.setVersionNumber(null);
            newReview.setHierarchyProposalNumber(childProposal.getProposalNumber());
            hierarchyProposal.getPropSpecialReviews().add(newReview);
        }
    }

    protected void synchronizeNarratives(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) {
        String instituteNarrativeTypeGroup = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "instituteNarrativeTypeGroup");
        for (Narrative narrative : childProposal.getNarratives()) {
            if (StringUtils.equalsIgnoreCase((String)narrative.getNarrativeType().getAllowMultiple(), (String)"N") || StringUtils.equalsIgnoreCase((String)narrative.getNarrativeType().getNarrativeTypeGroup(), (String)instituteNarrativeTypeGroup)) continue;
            HashMap<String, String> primaryKey = new HashMap<String, String>();
            primaryKey.put("proposalNumber", narrative.getProposalNumber());
            primaryKey.put("moduleNumber", narrative.getModuleNumber() + "");
            NarrativeAttachment attachment = (NarrativeAttachment)this.businessObjectService.findByPrimaryKey(NarrativeAttachment.class, primaryKey);
            narrative.getNarrativeAttachmentList().clear();
            narrative.getNarrativeAttachmentList().add(attachment);
            Narrative newNarrative = (Narrative)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)narrative);
            newNarrative.setVersionNumber(null);
            newNarrative.setHierarchyProposalNumber(childProposal.getProposalNumber());
            this.narrativeService.addNarrative(hierarchyProposal.getProposalDocument(), newNarrative);
        }
    }

    protected void synchronizePersonsAndAggregate(DevelopmentProposal hierarchyProposal, DevelopmentProposal primaryChildProposal, ProposalPerson principalInvestigator) {
        this.synchronizePersons(hierarchyProposal, primaryChildProposal, principalInvestigator);
        for (DevelopmentProposal childProposal : this.getHierarchyChildren(hierarchyProposal.getProposalNumber())) {
            if (StringUtils.equals((String)primaryChildProposal.getProposalNumber(), (String)childProposal.getProposalNumber())) continue;
            this.synchronizePersons(hierarchyProposal, childProposal, principalInvestigator);
        }
    }

    protected void synchronizePersons(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, ProposalPerson principalInvestigator) {
        for (ProposalPerson person : childProposal.getProposalPersons()) {
            ProposalPerson firstInstance;
            int firstIndex = hierarchyProposal.getProposalPersons().indexOf(person);
            int lastIndex = hierarchyProposal.getProposalPersons().lastIndexOf(person);
            ProposalPerson proposalPerson = firstInstance = firstIndex == -1 ? null : (ProposalPerson)hierarchyProposal.getProposalPersons().get(firstIndex);
            if (firstIndex != -1 && (firstIndex != lastIndex || this.rolesAreSimilar(person, firstInstance))) continue;
            ProposalPerson newPerson = (ProposalPerson)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)person);
            newPerson.setProposalNumber(hierarchyProposal.getProposalNumber());
            newPerson.getProposalPersonYnqs().clear();
            newPerson.getCreditSplits().clear();
            for (ProposalPersonUnit unit : newPerson.getUnits()) {
                unit.getCreditSplits().clear();
            }
            newPerson.setProposalPersonNumber(null);
            newPerson.setVersionNumber(null);
            newPerson.setHierarchyProposalNumber(childProposal.getProposalNumber());
            if (StringUtils.equalsIgnoreCase((String)person.getProposalPersonRoleId(), (String)"PI")) {
                newPerson.setProposalPersonRoleId("COI");
            }
            if (newPerson.equals((Object)principalInvestigator) && (firstIndex == -1 || !firstInstance.isInvestigator())) {
                newPerson.setProposalPersonRoleId("PI");
            }
            if (person.getProposalPersonExtendedAttributes() != null) {
                ProposalPersonExtendedAttributes newPersonEA = (ProposalPersonExtendedAttributes)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)person.getProposalPersonExtendedAttributes());
                newPersonEA.setProposalNumber(hierarchyProposal.getProposalNumber());
                newPersonEA.setProposalPersonNumber(newPerson.getProposalPersonNumber());
                newPerson.setProposalPersonExtendedAttributes(newPersonEA);
            }
            hierarchyProposal.addProposalPerson(newPerson);
        }
    }

    protected void synchronizeBudget(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, Budget hierarchyBudget, ProposalDevelopmentBudgetExt childBudget, BudgetDocument hierarchyBudgetDocument) throws ProposalHierarchyException {
        LOG.info((Object)String.format("***Beginning Hierarchy Budget Sync for Parent %s and Child %s", hierarchyProposal.getProposalNumber(), childProposal.getProposalNumber()));
        this.synchronizeChildBudget(hierarchyBudget, (Budget)childBudget, childProposal.getProposalNumber(), childProposal.getHierarchyBudgetType(), StringUtils.equals((String)childProposal.getProposalNumber(), (String)hierarchyProposal.getHierarchyOriginatingChildProposalNumber()));
        if (hierarchyBudget.getEndDate().after(hierarchyProposal.getRequestedEndDateInitial())) {
            hierarchyProposal.setRequestedEndDateInitial(hierarchyBudget.getEndDate());
        }
        if (childProposal.getRequestedEndDateInitial().after(hierarchyProposal.getRequestedEndDateInitial())) {
            hierarchyProposal.setRequestedEndDateInitial(childProposal.getRequestedEndDateInitial());
        }
        try {
            this.documentService.saveDocument((Document)hierarchyBudgetDocument);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        LOG.info((Object)String.format("***Completed Hierarchy Budget Sync for Parent %s and Child %s", hierarchyProposal.getProposalNumber(), childProposal.getProposalNumber()));
        childBudget.setHierarchyLastSyncHashCode(Integer.valueOf(this.computeHierarchyHashCode((Budget)childBudget)));
        childProposal.setLastSyncedBudgetDocumentNumber(childBudget.getDocumentNumber());
        this.businessObjectService.save((PersistableBusinessObject)childBudget);
        this.businessObjectService.save((PersistableBusinessObject)childProposal);
    }

    protected void syncProposalPersons(DevelopmentProposal childProposal, DevelopmentProposal hierarchyProposal, ProposalPerson pi, List<ProposalPerson> removedPersons) {
        if (this.proposalPersonExtendedAttributesToDelete == null) {
            this.proposalPersonExtendedAttributesToDelete = new ArrayList();
        }
        for (ProposalPerson removedPerson : removedPersons) {
            List currentBiographies = hierarchyProposal.getPropPersonBios();
            ListIterator iter = currentBiographies.listIterator();
            while (iter.hasNext()) {
                ProposalPersonBiography bio = (ProposalPersonBiography)iter.next();
                if (!StringUtils.equalsIgnoreCase((String)bio.getPersonId(), (String)removedPerson.getPersonId()) || !removedPerson.getProposalPersonNumber().equals(bio.getProposalPersonNumber())) continue;
                iter.remove();
            }
            if (removedPerson.getProposalPersonExtendedAttributes() == null) continue;
            this.proposalPersonExtendedAttributesToDelete.add(removedPerson.getProposalPersonExtendedAttributes());
        }
    }

    protected void synchronizeChildBudget(Budget parentBudget, Budget childBudget, String childProposalNumber, String hierarchyBudgetTypeCode, boolean isOriginatingChildBudget) throws ProposalHierarchyException {
        try {
            if (isOriginatingChildBudget) {
                parentBudget.setUrRateClassCode(childBudget.getUrRateClassCode());
                parentBudget.setOhRateClassCode(childBudget.getOhRateClassCode());
            }
            HashMap<Integer, BudgetPerson> personMap = new HashMap<Integer, BudgetPerson>();
            for (BudgetPerson person : childBudget.getBudgetPersons()) {
                BudgetPerson newPerson = (BudgetPerson)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)person);
                newPerson.setPersonSequenceNumber(parentBudget.getBudgetDocument().getHackedDocumentNextValue("personSequenceNumber"));
                newPerson.setBudgetId(parentBudget.getBudgetId());
                newPerson.setHierarchyProposalNumber(childProposalNumber);
                newPerson.setVersionNumber(null);
                parentBudget.addBudgetPerson(newPerson);
                personMap.put(person.getPersonSequenceNumber(), newPerson);
            }
            for (BudgetSubAwards childSubAwards : childBudget.getBudgetSubAwards()) {
                childSubAwards.refreshReferenceObject("budgetSubAwardAttachments");
                childSubAwards.refreshReferenceObject("budgetSubAwardFiles");
                BudgetSubAwards newSubAwards = (BudgetSubAwards)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)childSubAwards);
                newSubAwards.setBudgetId(parentBudget.getBudgetId());
                newSubAwards.setBudgetVersionNumber(parentBudget.getBudgetVersionNumber());
                newSubAwards.setSubAwardNumber(Integer.valueOf(parentBudget.getBudgetDocument().getHackedDocumentNextValue("subAwardNumber") != null ? parentBudget.getBudgetDocument().getHackedDocumentNextValue("subAwardNumber") : 1));
                newSubAwards.setVersionNumber(null);
                newSubAwards.setHierarchyProposalNumber(childProposalNumber);
                for (BudgetSubAwardAttachment attachment : newSubAwards.getBudgetSubAwardAttachments()) {
                    attachment.setSubAwardNumber(newSubAwards.getSubAwardNumber());
                    attachment.setBudgetId(parentBudget.getBudgetId());
                    attachment.setBudgetSubawardAttachmentId(null);
                    attachment.setVersionNumber(null);
                }
                for (BudgetSubAwardFiles files : newSubAwards.getBudgetSubAwardFiles()) {
                    files.setSubAwardNumber(newSubAwards.getSubAwardNumber());
                    files.setBudgetId(parentBudget.getBudgetId());
                    files.setVersionNumber(null);
                }
                ArrayList<BudgetSubAwards> listToBeSaved = new ArrayList<BudgetSubAwards>();
                listToBeSaved.add(newSubAwards);
                listToBeSaved.addAll(newSubAwards.getBudgetSubAwardFiles());
                listToBeSaved.addAll(newSubAwards.getBudgetSubAwardAttachments());
                this.businessObjectService.save(listToBeSaved);
                parentBudget.getBudgetSubAwards().add(newSubAwards);
            }
            int parentStartPeriod = this.getCorrespondingParentPeriod(parentBudget, childBudget);
            if (parentStartPeriod == -1) {
                throw new ProposalHierarchyException("Cannot find a parent budget period that corresponds to the child period.");
            }
            List parentPeriods = parentBudget.getBudgetPeriods();
            List childPeriods = childBudget.getBudgetPeriods();
            Long budgetId = parentBudget.getBudgetId();
            for (BudgetCostShare costShare : childBudget.getBudgetCostShares()) {
                if (!StringUtils.isNotEmpty((String)costShare.getSourceAccount())) continue;
                BudgetCostShare newCostShare = (BudgetCostShare)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)costShare);
                newCostShare.setBudgetId(budgetId);
                newCostShare.setDocumentComponentId(parentBudget.getHackedDocumentNextValue(newCostShare.getDocumentComponentIdKey()));
                newCostShare.setObjectId(null);
                newCostShare.setVersionNumber(null);
                newCostShare.setHierarchyProposalNumber(childProposalNumber);
                newCostShare.setHiddenInHierarchy(true);
                this.businessObjectService.save((PersistableBusinessObject)newCostShare);
            }
            for (BudgetUnrecoveredFandA unrecoveredFandA : childBudget.getBudgetUnrecoveredFandAs()) {
                if (!StringUtils.isNotEmpty((String)unrecoveredFandA.getSourceAccount())) continue;
                BudgetUnrecoveredFandA newUnrecoveredFandA = (BudgetUnrecoveredFandA)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)unrecoveredFandA);
                newUnrecoveredFandA.setBudgetId(budgetId);
                newUnrecoveredFandA.setDocumentComponentId(parentBudget.getHackedDocumentNextValue(newUnrecoveredFandA.getDocumentComponentIdKey()));
                newUnrecoveredFandA.setObjectId(null);
                newUnrecoveredFandA.setVersionNumber(null);
                newUnrecoveredFandA.setHierarchyProposalNumber(childProposalNumber);
                newUnrecoveredFandA.setHiddenInHierarchy(true);
                this.businessObjectService.save((PersistableBusinessObject)newUnrecoveredFandA);
            }
            int i = 0;
            int j = parentStartPeriod;
            while (i < childPeriods.size()) {
                Integer lineItemNumber;
                BudgetLineItem parentLineItem;
                BudgetPeriod childPeriod = (BudgetPeriod)childPeriods.get(i);
                BudgetPeriod parentPeriod = this.findOrCreateMatchingPeriod(childPeriod, parentBudget);
                Long budgetPeriodId = parentPeriod.getBudgetPeriodId();
                Integer budgetPeriod = parentPeriod.getBudgetPeriod();
                if (StringUtils.equals((String)hierarchyBudgetTypeCode, (String)HierarchyBudgetTypeConstants.SubBudget.code())) {
                    for (BudgetLineItem childLineItem : childPeriod.getBudgetLineItems()) {
                        org.kuali.rice.krad.util.ObjectUtils.materializeUpdateableCollections((Object)childLineItem);
                        parentLineItem = (BudgetLineItem)((DeepCopyPostProcessor)KraServiceLocator.getService(DeepCopyPostProcessor.class)).processDeepCopyWithDeepCopyIgnore((Serializable)childLineItem);
                        lineItemNumber = parentBudget.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber");
                        parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                        parentLineItem.setBudgetLineItemId(null);
                        parentLineItem.setBudgetId(budgetId);
                        parentLineItem.setBudgetPeriodId(budgetPeriodId);
                        parentLineItem.setBudgetPeriod(budgetPeriod);
                        parentLineItem.setLineItemNumber(lineItemNumber);
                        parentLineItem.setVersionNumber(null);
                        parentLineItem.setObjectId(null);
                        for (BudgetLineItemCalculatedAmount calAmt : parentLineItem.getBudgetLineItemCalculatedAmounts()) {
                            calAmt.setBudgetLineItemCalculatedAmountId(null);
                            calAmt.setBudgetLineItemId(null);
                            calAmt.setBudgetId(budgetId);
                            calAmt.setBudgetPeriodId(budgetPeriodId);
                            calAmt.setBudgetPeriod(budgetPeriod);
                            calAmt.setLineItemNumber(lineItemNumber);
                            calAmt.setVersionNumber(null);
                            calAmt.setObjectId(null);
                        }
                        for (BudgetPersonnelDetails details : parentLineItem.getBudgetPersonnelDetailsList()) {
                            BudgetPerson budgetPerson = (BudgetPerson)personMap.get(details.getPersonSequenceNumber());
                            details.setBudgetPerson(budgetPerson);
                            details.setJobCode(budgetPerson.getJobCode());
                            details.setPersonId(budgetPerson.getPersonRolodexTbnId());
                            details.setPersonSequenceNumber(budgetPerson.getPersonSequenceNumber());
                            details.setPersonNumber(parentBudget.getBudgetDocument().getHackedDocumentNextValue("budget.budgetPersonnelDetails.personNumber"));
                            details.setBudgetPersonnelLineItemId(null);
                            details.setBudgetId(budgetId);
                            details.setBudgetPeriodId(budgetPeriodId);
                            details.setBudgetPeriod(budgetPeriod);
                            details.setLineItemNumber(lineItemNumber);
                            details.setVersionNumber(null);
                            details.setObjectId(null);
                            for (BudgetPersonnelCalculatedAmount calAmt : details.getBudgetPersonnelCalculatedAmounts()) {
                                calAmt.setBudgetPersonnelCalculatedAmountId(null);
                                calAmt.setBudgetLineItemId(null);
                                calAmt.setBudgetId(budgetId);
                                calAmt.setBudgetPeriodId(budgetPeriodId);
                                calAmt.setBudgetPeriod(budgetPeriod);
                                calAmt.setLineItemNumber(lineItemNumber);
                                calAmt.setVersionNumber(null);
                                calAmt.setObjectId(null);
                            }
                        }
                        parentPeriod.getBudgetLineItems().add(parentLineItem);
                    }
                } else {
                    CostElement costElement;
                    HashMap<String, String> primaryKeys;
                    String directCostElement = this.parameterService.getParameterValueAsString(BudgetDocument.class, "proposalHierarchySubProjectDirectCostElement");
                    String indirectCostElement = this.parameterService.getParameterValueAsString(BudgetDocument.class, "proposalHierarchySubProjectIndirectCostElement");
                    if (childPeriod.getTotalIndirectCost().isNonZero()) {
                        primaryKeys = new HashMap<String, String>();
                        primaryKeys.put("costElement", indirectCostElement);
                        costElement = (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, primaryKeys);
                        parentLineItem = parentBudget.getNewBudgetLineItem();
                        parentLineItem.setLineItemDescription(childProposalNumber);
                        parentLineItem.setStartDate(parentPeriod.getStartDate());
                        parentLineItem.setEndDate(parentPeriod.getEndDate());
                        parentLineItem.setBudgetId(budgetId);
                        parentLineItem.setBudgetPeriodId(budgetPeriodId);
                        parentLineItem.setBudgetPeriod(budgetPeriod);
                        parentLineItem.setVersionNumber(null);
                        lineItemNumber = parentBudget.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber");
                        parentLineItem.setLineItemNumber(lineItemNumber);
                        parentLineItem.setLineItemSequence(lineItemNumber);
                        parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                        parentLineItem.setLineItemCost(childPeriod.getTotalIndirectCost());
                        parentLineItem.setIndirectCost(childPeriod.getTotalIndirectCost());
                        parentLineItem.setCostElementBO(costElement);
                        parentLineItem.setCostElement(costElement.getCostElement());
                        parentLineItem.setBudgetCategoryCode(costElement.getBudgetCategoryCode());
                        parentLineItem.setOnOffCampusFlag(costElement.getOnOffCampusFlag());
                        parentLineItem.setApplyInRateFlag(Boolean.valueOf(true));
                        parentPeriod.getBudgetLineItems().add(parentLineItem);
                    }
                    if (childPeriod.getTotalDirectCost().isNonZero()) {
                        primaryKeys = new HashMap();
                        primaryKeys.put("costElement", directCostElement);
                        costElement = (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, primaryKeys);
                        parentLineItem = parentBudget.getNewBudgetLineItem();
                        parentLineItem.setLineItemDescription(childProposalNumber);
                        parentLineItem.setStartDate(parentPeriod.getStartDate());
                        parentLineItem.setEndDate(parentPeriod.getEndDate());
                        parentLineItem.setBudgetId(budgetId);
                        parentLineItem.setBudgetPeriodId(budgetPeriodId);
                        parentLineItem.setBudgetPeriod(budgetPeriod);
                        parentLineItem.setVersionNumber(null);
                        lineItemNumber = parentBudget.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber");
                        parentLineItem.setLineItemNumber(lineItemNumber);
                        parentLineItem.setLineItemSequence(lineItemNumber);
                        parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                        parentLineItem.setLineItemCost(childPeriod.getTotalDirectCost());
                        parentLineItem.setDirectCost(childPeriod.getTotalDirectCost());
                        parentLineItem.setCostElementBO(costElement);
                        parentLineItem.setCostElement(costElement.getCostElement());
                        parentLineItem.setBudgetCategoryCode(costElement.getBudgetCategoryCode());
                        parentLineItem.setOnOffCampusFlag(costElement.getOnOffCampusFlag());
                        parentLineItem.setApplyInRateFlag(Boolean.valueOf(true));
                        parentPeriod.getBudgetLineItems().add(parentLineItem);
                    }
                }
                ++i;
                ++j;
            }
            parentBudget.setStartDate(parentBudget.getBudgetPeriod(0).getStartDate());
            parentBudget.setEndDate(parentBudget.getBudgetPeriod(parentBudget.getBudgetPeriods().size() - 1).getEndDate());
        }
        catch (Exception e) {
            LOG.error((Object)"Problem copying line items to parent", (Throwable)e);
            throw new ProposalHierarchyException("Problem copying line items to parent", (Throwable)e);
        }
        this.budgetSummaryService.calculateBudget(parentBudget);
    }

    protected BudgetPeriod findOrCreateMatchingPeriod(BudgetPeriod childPeriod, Budget parentBudget) {
        int priorPeriodIndex = 0;
        int index = 0;
        for (BudgetPeriod period : parentBudget.getBudgetPeriods()) {
            if (period.getStartDate().equals(childPeriod.getStartDate()) && period.getEndDate().equals(childPeriod.getEndDate())) {
                return period;
            }
            if (period.getEndDate().before(childPeriod.getStartDate())) {
                priorPeriodIndex = index;
            }
            ++index;
        }
        BudgetPeriod result = new BudgetPeriod();
        result.setStartDate(childPeriod.getStartDate());
        result.setEndDate(childPeriod.getEndDate());
        result.setBudgetPeriod(Integer.valueOf(((BudgetPeriod)parentBudget.getBudgetPeriods().get(priorPeriodIndex)).getBudgetPeriod() + 1));
        result.setBudget(parentBudget);
        result.setBudgetId(parentBudget.getBudgetId());
        this.getBudgetSummaryService().addBudgetPeriod(parentBudget, result);
        return result;
    }

    protected void aggregateHierarchy(DevelopmentProposal hierarchy) throws ProposalHierarchyException {
        Integer keyHash;
        LOG.info((Object)String.format("***Aggregating Proposal Hierarchy #%s", hierarchy.getProposalNumber()));
        ArrayList<ProposalPersonBiography> biosToRemove = new ArrayList<ProposalPersonBiography>();
        for (ProposalPersonBiography bio : hierarchy.getPropPersonBios()) {
            this.loadBioContent(bio);
            String bioPersonId = bio.getPersonId();
            Integer bioRolodexId = bio.getRolodexId();
            boolean keep = false;
            for (ProposalPerson person : hierarchy.getProposalPersons()) {
                if ((bioPersonId == null || !bioPersonId.equals(person.getPersonId())) && (bioRolodexId == null || !bioRolodexId.equals(person.getRolodexId()))) continue;
                bio.setProposalPersonNumber(person.getProposalPersonNumber());
                for (ProposalPersonBiographyAttachment attachment : bio.getPersonnelAttachmentList()) {
                    attachment.setProposalPersonNumber(person.getProposalPersonNumber());
                }
                keep = true;
                break;
            }
            if (keep) continue;
            biosToRemove.add(bio);
        }
        if (!biosToRemove.isEmpty()) {
            hierarchy.getPropPersonBios().removeAll(biosToRemove);
        }
        BudgetDocument hierarchyBudgetDocument = this.getHierarchyBudget(hierarchy);
        Budget hierarchyBudget = hierarchyBudgetDocument.getBudget();
        hierarchyBudget.getBudgetCostShares().clear();
        hierarchyBudget.getBudgetUnrecoveredFandAs().clear();
        HashMap<String, Comparable<Boolean>> fieldValues = new HashMap<String, Comparable<Boolean>>();
        fieldValues.put("hiddenInHierarchy", Boolean.valueOf(true));
        fieldValues.put("budgetId", hierarchyBudget.getBudgetId());
        Collection hiddenCostShares = this.businessObjectService.findMatching(BudgetCostShare.class, fieldValues);
        Collection hiddenUnrecoveredFandAs = this.businessObjectService.findMatching(BudgetUnrecoveredFandA.class, fieldValues);
        HashMap<Integer, BudgetCostShare> newCostShares = new HashMap<Integer, BudgetCostShare>();
        HashMap<Integer, BudgetUnrecoveredFandA> newUnrecoveredFandAs = new HashMap<Integer, BudgetUnrecoveredFandA>();
        for (BudgetCostShare costShare : hiddenCostShares) {
            keyHash = Arrays.hashCode(new Object[]{costShare.getProjectPeriod(), costShare.getSourceAccount()});
            BudgetCostShare newCostShare = (BudgetCostShare)newCostShares.get(keyHash);
            if (newCostShare == null) {
                newCostShare = (BudgetCostShare)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)costShare);
                newCostShare.setDocumentComponentId(null);
                newCostShare.setObjectId(null);
                newCostShare.setVersionNumber(null);
                newCostShares.put(keyHash, newCostShare);
                continue;
            }
            newCostShare.setSharePercentage((BudgetDecimal)newCostShare.getSharePercentage().add((AbstractKualiDecimal)costShare.getSharePercentage()));
            if (newCostShare.getSharePercentage().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100.0))) {
                newCostShare.setSharePercentage(new BudgetDecimal(100.0));
            }
            newCostShare.setShareAmount((BudgetDecimal)newCostShare.getShareAmount().add((AbstractKualiDecimal)costShare.getShareAmount()));
        }
        for (BudgetUnrecoveredFandA unrecoveredFandA : hiddenUnrecoveredFandAs) {
            keyHash = Arrays.hashCode(new Object[]{unrecoveredFandA.getFiscalYear(), unrecoveredFandA.getSourceAccount(), unrecoveredFandA.getApplicableRate(), unrecoveredFandA.getOnCampusFlag()});
            BudgetUnrecoveredFandA newUnrecoveredFandA = (BudgetUnrecoveredFandA)newUnrecoveredFandAs.get(keyHash);
            if (newUnrecoveredFandA == null) {
                newUnrecoveredFandA = (BudgetUnrecoveredFandA)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)unrecoveredFandA);
                newUnrecoveredFandA.setBudgetId(hierarchyBudget.getBudgetId());
                newUnrecoveredFandA.setDocumentComponentId(null);
                newUnrecoveredFandA.setObjectId(null);
                newUnrecoveredFandA.setVersionNumber(null);
                newUnrecoveredFandAs.put(keyHash, newUnrecoveredFandA);
                continue;
            }
            newUnrecoveredFandA.setAmount((BudgetDecimal)newUnrecoveredFandA.getAmount().add((AbstractKualiDecimal)unrecoveredFandA.getAmount()));
        }
        for (BudgetCostShare costShare : newCostShares.values()) {
            costShare.setHiddenInHierarchy(false);
            costShare.setHierarchyProposalNumber(null);
            hierarchyBudget.add(costShare);
        }
        for (BudgetUnrecoveredFandA unrecoveredFandA : newUnrecoveredFandAs.values()) {
            unrecoveredFandA.setHiddenInHierarchy(false);
            unrecoveredFandA.setHierarchyProposalNumber(null);
            hierarchyBudget.add(unrecoveredFandA);
        }
        KualiForm oldForm = KNSGlobalVariables.getKualiForm();
        KNSGlobalVariables.setKualiForm(null);
        ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudget(hierarchyBudget);
        ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudgetSummaryTotals(hierarchyBudget);
        KNSGlobalVariables.setKualiForm((KualiForm)oldForm);
        try {
            this.documentService.saveDocument((Document)hierarchyBudgetDocument);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
    }

    protected DevelopmentProposal getHierarchy(String hierarchyProposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal hierarchy = this.getDevelopmentProposal(hierarchyProposalNumber);
        if (hierarchy == null || !hierarchy.isParent()) {
            throw new ProposalHierarchyException("Proposal " + hierarchyProposalNumber + " is not a hierarchy");
        }
        return hierarchy;
    }

    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("proposalNumber", proposalNumber);
        return (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, pk);
    }

    protected boolean isSynchronized(String childProposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal childProposal = this.getDevelopmentProposal(childProposalNumber);
        return this.isSynchronized(childProposal);
    }

    protected boolean isSynchronized(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        Integer hc1 = this.computeHierarchyHashCode(childProposal);
        Integer hc2 = childProposal.getHierarchyLastSyncHashCode();
        return ObjectUtils.equals((Object)hc1, (Object)hc2);
    }

    protected boolean isBudgetSynchronized(String childProposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal childProposal = this.getDevelopmentProposal(childProposalNumber);
        return this.isBudgetSynchronized(childProposal, (ProposalDevelopmentBudgetExt)this.getSyncableBudget(childProposal).getBudget());
    }

    protected boolean isBudgetSynchronized(DevelopmentProposal childProposal, ProposalDevelopmentBudgetExt childBudget) throws ProposalHierarchyException {
        if (StringUtils.equals((String)childProposal.getLastSyncedBudgetDocumentNumber(), (String)childBudget.getDocumentNumber())) {
            org.kuali.rice.krad.util.ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)childBudget);
            Integer hc1 = this.computeHierarchyHashCode((Budget)childBudget);
            Integer hc2 = childBudget.getHierarchyLastSyncHashCode();
            return ObjectUtils.equals((Object)hc1, (Object)hc2);
        }
        return false;
    }

    protected void setInitialPi(DevelopmentProposal hierarchy, DevelopmentProposal child) {
        int index;
        ProposalPerson pi = child.getPrincipalInvestigator();
        if (pi != null && (index = hierarchy.getProposalPersons().indexOf(pi)) > -1) {
            hierarchy.getProposalPerson(index).setProposalPersonRoleId("PI");
        }
    }

    protected List<BudgetDocument<DevelopmentProposal>> getHierarchyBudgets(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        ArrayList<BudgetDocument<DevelopmentProposal>> hierarchyBudgets = new ArrayList<BudgetDocument<DevelopmentProposal>>();
        try {
            for (BudgetDocumentVersion budgetDocumentVersion : hierarchyProposal.getProposalDocument().getBudgetDocumentVersions()) {
                String budgetDocumentNumber = budgetDocumentVersion.getBudgetVersionOverview().getDocumentNumber();
                hierarchyBudgets.add((BudgetDocument<DevelopmentProposal>)((BudgetDocument)this.documentService.getByDocumentHeaderId(budgetDocumentNumber)));
            }
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        return hierarchyBudgets;
    }

    protected BudgetDocument<DevelopmentProposal> getHierarchyBudget(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        String budgetDocumentNumber = ((BudgetDocumentVersion)hierarchyProposal.getProposalDocument().getBudgetDocumentVersions().get(0)).getBudgetVersionOverview().getDocumentNumber();
        BudgetDocument budgetDocument = null;
        try {
            budgetDocument = (BudgetDocument)this.documentService.getByDocumentHeaderId(budgetDocumentNumber);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        return budgetDocument;
    }

    public BudgetDocument<DevelopmentProposal> getSyncableBudget(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        String budgetDocumentNumber = null;
        for (BudgetDocumentVersion version : childProposal.getProposalDocument().getBudgetDocumentVersions()) {
            budgetDocumentNumber = version.getDocumentNumber();
            if (!version.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            break;
        }
        BudgetDocument budgetDocument = null;
        try {
            budgetDocument = (BudgetDocument)this.documentService.getByDocumentHeaderId(budgetDocumentNumber);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
        return budgetDocument;
    }

    protected void initializeBudget(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) throws ProposalHierarchyException {
        BudgetDocument parentBudgetDoc = this.getHierarchyBudget(hierarchyProposal);
        Budget parentBudget = parentBudgetDoc.getBudget();
        BudgetDocument childBudgetDocument = this.getSyncableBudget(childProposal);
        Budget childBudget = childBudgetDocument.getBudget();
        for (int i = 0; i < childBudget.getBudgetPeriods().size(); ++i) {
            BudgetPeriod parentPeriod = parentBudget.getBudgetPeriod(i);
            BudgetPeriod childPeriod = childBudget.getBudgetPeriod(i);
            parentPeriod.setStartDate(childPeriod.getStartDate());
            parentPeriod.setEndDate(childPeriod.getEndDate());
            parentPeriod.setBudgetPeriod(childPeriod.getBudgetPeriod());
        }
        parentBudget.setCostSharingAmount(new BudgetDecimal(0));
        parentBudget.setTotalCost(new BudgetDecimal(0));
        parentBudget.setTotalDirectCost(new BudgetDecimal(0));
        parentBudget.setTotalIndirectCost(new BudgetDecimal(0));
        parentBudget.setUnderrecoveryAmount(new BudgetDecimal(0));
        parentBudget.setOhRateClassCode(childBudget.getOhRateClassCode());
        parentBudget.setOhRateTypeCode(childBudget.getOhRateTypeCode());
        parentBudget.setUrRateClassCode(childBudget.getUrRateClassCode());
        try {
            this.documentService.saveDocument((Document)parentBudgetDoc);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
    }

    public ProposalHierarchyErrorDto validateChildBudgetPeriods(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, boolean allowEndDateChange) throws ProposalHierarchyException {
        BudgetDocument parentBudgetDoc = this.getHierarchyBudget(hierarchyProposal);
        Budget parentBudget = parentBudgetDoc.getBudget();
        BudgetDocument childBudgetDocument = this.getSyncableBudget(childProposal);
        Budget childBudget = childBudgetDocument.getBudget();
        ProposalHierarchyErrorDto retval = null;
        int correspondingStart = this.getCorrespondingParentPeriod(parentBudget, childBudget);
        if (correspondingStart == -1) {
            retval = new ProposalHierarchyErrorDto("error.hierarchy.budget.startDateInconsistent", new String[]{childProposal.getProposalNumber()});
        } else {
            int j;
            List parentPeriods = parentBudget.getBudgetPeriods();
            List childPeriods = childBudget.getBudgetPeriods();
            int i = correspondingStart;
            for (j = 0; i < parentPeriods.size() && j < childPeriods.size(); ++i, ++j) {
                BudgetPeriod parentPeriod = (BudgetPeriod)parentPeriods.get(i);
                BudgetPeriod childPeriod = (BudgetPeriod)childPeriods.get(j);
                if (parentPeriod.getStartDate().equals(childPeriod.getStartDate()) && parentPeriod.getEndDate().equals(childPeriod.getEndDate())) continue;
                retval = new ProposalHierarchyErrorDto("error.hierarchy.budget.periodDurationInconsistent", new String[]{childProposal.getProposalNumber()});
                break;
            }
            if (retval == null && !allowEndDateChange && (j < childPeriods.size() || childProposal.getRequestedEndDateInitial().after(hierarchyProposal.getRequestedEndDateInitial()))) {
                retval = new ProposalHierarchyErrorDto("question.hierarchy.extendDate.confirm", new String[]{childProposal.getProposalNumber()});
            }
        }
        return retval;
    }

    protected int getCorrespondingParentPeriod(Budget parentBudget, Budget childBudget) {
        int correspondingStart = -1;
        Date childStart = childBudget.getBudgetPeriod(0).getStartDate();
        Date parentStart = parentBudget.getBudgetPeriod(0).getStartDate();
        Date parentEnd = parentBudget.getBudgetPeriod(parentBudget.getBudgetPeriods().size() - 1).getEndDate();
        if (childStart.compareTo(parentStart) >= 0 && childStart.compareTo(parentEnd) < 0) {
            List parentPeriods = parentBudget.getBudgetPeriods();
            for (int i = 0; i < parentPeriods.size(); ++i) {
                if (!childStart.equals(((BudgetPeriod)parentPeriods.get(i)).getStartDate())) continue;
                correspondingStart = i;
                break;
            }
        }
        return correspondingStart;
    }

    protected void removeChildElements(DevelopmentProposal parentProposal, Budget parentBudget, String childProposalNumber) {
        if (this.proposalPersonExtendedAttributesToDelete == null) {
            this.proposalPersonExtendedAttributesToDelete = new ArrayList();
        }
        List persons = parentProposal.getProposalPersons();
        for (int i = persons.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((ProposalPerson)persons.get(i)).getHierarchyProposalNumber())) continue;
            if (((ProposalPerson)persons.get(i)).getProposalPersonExtendedAttributes() != null) {
                this.proposalPersonExtendedAttributesToDelete.add(((ProposalPerson)persons.get(i)).getProposalPersonExtendedAttributes());
            }
            persons.remove(i);
        }
        List keywords = parentProposal.getPropScienceKeywords();
        for (int i = keywords.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((PropScienceKeyword)keywords.get(i)).getHierarchyProposalNumber())) continue;
            keywords.remove(i);
        }
        List reviews = parentProposal.getPropSpecialReviews();
        for (int i = reviews.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((ProposalSpecialReview)reviews.get(i)).getHierarchyProposalNumber())) continue;
            reviews.remove(i);
        }
        List narratives = parentProposal.getNarratives();
        for (int i = narratives.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((Narrative)narratives.get(i)).getHierarchyProposalNumber())) continue;
            this.businessObjectService.delete((PersistableBusinessObject)narratives.remove(i));
        }
        this.removeChildBudgetElements(parentProposal, parentBudget, childProposalNumber);
    }

    protected void removeChildBudgetElements(DevelopmentProposal parentProposal, Budget parentBudget, String childProposalNumber) {
        List subAwards = parentBudget.getBudgetSubAwards();
        for (int i = subAwards.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((BudgetSubAwards)subAwards.get(i)).getHierarchyProposalNumber())) continue;
            subAwards.remove(i);
        }
        List projectIncomes = parentBudget.getBudgetProjectIncomes();
        for (int i = projectIncomes.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((BudgetProjectIncome)projectIncomes.get(i)).getHierarchyProposalNumber())) continue;
            projectIncomes.remove(i);
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyProposalNumber", childProposalNumber);
        this.businessObjectService.deleteMatching(BudgetCostShare.class, fieldValues);
        this.businessObjectService.deleteMatching(BudgetUnrecoveredFandA.class, fieldValues);
        BudgetPersonnelBudgetService budgetPersonnelBudgetService = (BudgetPersonnelBudgetService)KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
        List periods = parentBudget.getBudgetPeriods();
        BudgetPeriod period = null;
        BudgetLineItem lineItem = null;
        for (int i = periods.size() - 1; i >= 0; --i) {
            period = (BudgetPeriod)periods.get(i);
            List lineItems = period.getBudgetLineItems();
            for (int j = lineItems.size() - 1; j >= 0; --j) {
                lineItem = (BudgetLineItem)lineItems.get(j);
                if (!StringUtils.equals((String)childProposalNumber, (String)lineItem.getHierarchyProposalNumber())) continue;
                List personnelDetailsList = lineItem.getBudgetPersonnelDetailsList();
                for (int k = personnelDetailsList.size() - 1; k >= 0; --k) {
                    budgetPersonnelBudgetService.deleteBudgetPersonnelDetails(parentBudget, i, j, k);
                }
                lineItems.remove(j);
                parentBudget.setBudgetLineItemDeleted(true);
            }
            if (!lineItems.isEmpty() || periods.indexOf(period) != periods.size() - 1 || periods.indexOf(period) <= 0) continue;
            periods.remove(period);
        }
        parentBudget.setEndDate(((BudgetPeriod)periods.get(periods.size() - 1)).getEndDate());
        List budgetPersons = parentBudget.getBudgetPersons();
        for (int i = budgetPersons.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((String)childProposalNumber, (String)((BudgetPerson)budgetPersons.get(i)).getHierarchyProposalNumber())) continue;
            budgetPersonnelBudgetService.deleteBudgetPersonnelDetailsForPerson(parentBudget, (BudgetPerson)budgetPersons.get(i));
            budgetPersons.remove(i);
        }
    }

    protected void prepareHierarchySync(DevelopmentProposal hierarchyProposal) {
        this.prepareHierarchySync(hierarchyProposal.getProposalDocument());
    }

    protected void prepareHierarchySync(ProposalDevelopmentDocument pdDoc) {
        pdDoc.refreshReferenceObject("documentNextvalues");
    }

    protected void finalizeHierarchySync(ProposalDevelopmentDocument pdDoc) throws ProposalHierarchyException {
        pdDoc.refreshBudgetDocumentVersions();
        try {
            this.documentService.saveDocument((Document)pdDoc);
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException((Throwable)e);
        }
    }

    protected void finalizeHierarchySync(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        if (this.proposalPersonExtendedAttributesToDelete != null && !this.proposalPersonExtendedAttributesToDelete.isEmpty()) {
            this.businessObjectService.delete(this.proposalPersonExtendedAttributesToDelete);
            this.proposalPersonExtendedAttributesToDelete.clear();
        }
        this.businessObjectService.save(hierarchyProposal.getProposalDocument().getDocumentNextvalues());
        this.businessObjectService.save((PersistableBusinessObject)hierarchyProposal);
        for (ProposalPerson person : hierarchyProposal.getProposalPersons()) {
            if (person.getProposalPersonExtendedAttributes() == null) continue;
            this.businessObjectService.save((PersistableBusinessObject)person.getProposalPersonExtendedAttributes());
        }
    }

    protected void copyInitialAttachments(DevelopmentProposal srcProposal, DevelopmentProposal destProposal) {
        String instituteNarrativeTypeGroup = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "instituteNarrativeTypeGroup");
        ProposalPerson srcPerson = null;
        ProposalPerson destPerson = null;
        for (ProposalPersonBiography srcPropPersonBio : srcProposal.getPropPersonBios()) {
            for (ProposalPerson person : srcProposal.getProposalPersons()) {
                if (!person.getProposalPersonNumber().equals(srcPropPersonBio.getProposalPersonNumber())) continue;
                srcPerson = person;
                break;
            }
            for (ProposalPerson person : destProposal.getProposalPersons()) {
                if (!person.equals((Object)srcPerson)) continue;
                destPerson = person;
                break;
            }
            this.loadBioContent(srcPropPersonBio);
            ProposalPersonBiography destPropPersonBio = (ProposalPersonBiography)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)srcPropPersonBio);
            destPropPersonBio.setProposalPersonNumber(destPerson.getProposalPersonNumber());
            destPropPersonBio.setPersonId(destPerson.getPersonId());
            destPropPersonBio.setRolodexId(destPerson.getRolodexId());
            this.propPersonBioService.addProposalPersonBiography(destProposal.getProposalDocument(), destPropPersonBio);
        }
        for (Narrative srcNarrative : srcProposal.getNarratives()) {
            if (!StringUtils.equalsIgnoreCase((String)srcNarrative.getNarrativeType().getAllowMultiple(), (String)"N") || srcProposal.getInstituteAttachments().contains(srcNarrative) || StringUtils.equalsIgnoreCase((String)srcNarrative.getNarrativeType().getNarrativeTypeGroup(), (String)instituteNarrativeTypeGroup)) continue;
            this.loadAttachmentContent(srcNarrative);
            Narrative destNarrative = (Narrative)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)srcNarrative);
            destNarrative.setModuleStatusCode("I");
            this.narrativeService.addNarrative(destProposal.getProposalDocument(), destNarrative);
        }
    }

    protected void loadAttachmentContent(Narrative narrative) {
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put("proposalNumber", narrative.getProposalNumber());
        primaryKey.put("moduleNumber", narrative.getModuleNumber() + "");
        NarrativeAttachment attachment = (NarrativeAttachment)this.businessObjectService.findByPrimaryKey(NarrativeAttachment.class, primaryKey);
        narrative.getNarrativeAttachmentList().clear();
        narrative.getNarrativeAttachmentList().add(attachment);
    }

    protected void loadBioContent(ProposalPersonBiography bio) {
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put("proposalNumber", bio.getProposalNumber());
        primaryKey.put("biographyNumber", bio.getBiographyNumber() + "");
        primaryKey.put("proposalPersonNumber", bio.getProposalPersonNumber() + "");
        ProposalPersonBiographyAttachment attachment = (ProposalPersonBiographyAttachment)this.businessObjectService.findByPrimaryKey(ProposalPersonBiographyAttachment.class, primaryKey);
        bio.getPersonnelAttachmentList().clear();
        bio.getPersonnelAttachmentList().add(attachment);
    }

    public String getHierarchyChildRouteStatus(String oldStatus, String newStatus) {
        LOG.info((Object)String.format("Route status change %s:%s", oldStatus, newStatus));
        String retCd = null;
        if (StringUtils.equals((String)newStatus, (String)"R") && (StringUtils.equals((String)oldStatus, (String)"I") || StringUtils.equals((String)oldStatus, (String)"S") || StringUtils.equals((String)"R", (String)oldStatus))) {
            retCd = this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentEnroute", new String[0]);
        } else if (StringUtils.equals((String)newStatus, (String)"F")) {
            retCd = this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentFinal", new String[0]);
        } else if (StringUtils.equals((String)newStatus, (String)"D")) {
            retCd = this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentDisapprove", new String[0]);
        } else if (StringUtils.equals((String)newStatus, (String)"X")) {
            retCd = this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentCancel", new String[0]);
        } else {
            LOG.warn((Object)String.format("Do not know how to calculate hierarchy child status for %s to %s", oldStatus, newStatus));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Route status for children:%s", retCd));
        }
        return retCd;
    }

    protected int computeHierarchyHashCode(DevelopmentProposal proposal) {
        int prime = 31;
        int result = 1;
        for (ProposalPerson person : proposal.getProposalPersons()) {
            result = prime * result + person.hashCode();
        }
        for (Narrative narrative : proposal.getNarratives()) {
            result = prime * result + narrative.hierarchyHashCode();
        }
        for (PropScienceKeyword keyword : proposal.getPropScienceKeywords()) {
            result = prime * result + keyword.getScienceKeywordCode().hashCode();
        }
        for (ProposalSpecialReview review : proposal.getPropSpecialReviews()) {
            result = prime * result + review.hierarchyHashCode();
        }
        return result;
    }

    protected int computeHierarchyHashCode(Budget budget) {
        int prime = 31;
        int result = 1;
        ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudget(budget);
        ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudgetSummaryTotals(budget);
        result = prime * result + budget.getBudgetSummaryTotals().hashCode();
        return result;
    }

    public List<ProposalDevelopmentDocument> getChildProposalDevelopmentDocuments(String parentProposalNumber) throws ProposalHierarchyException {
        ArrayList<ProposalDevelopmentDocument> outList = new ArrayList<ProposalDevelopmentDocument>();
        for (DevelopmentProposal child : this.getHierarchyChildren(parentProposalNumber)) {
            try {
                outList.add((ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(child.getProposalDocument().getDocumentNumber()));
            }
            catch (WorkflowException e) {
                LOG.error((Object)String.format("Could not find document for child proposal number %s", parentProposalNumber, child.getProposalNumber()), (Throwable)e);
                throw new ProposalHierarchyException(String.format("Could not find document for child proposal number %s", parentProposalNumber, child.getProposalNumber()), (Throwable)e);
            }
        }
        return outList;
    }

    public List<DevelopmentProposal> getHierarchyChildren(String parentProposalNumber) {
        ArrayList<DevelopmentProposal> children = new ArrayList<DevelopmentProposal>();
        for (String childProposalNumber : this.proposalHierarchyDao.getHierarchyChildProposalNumbers(parentProposalNumber)) {
            children.add(this.getDevelopmentProposal(childProposalNumber));
        }
        return children;
    }

    public WorkflowDocument getParentWorkflowDocument(ProposalDevelopmentDocument child) throws ProposalHierarchyException {
        return this.getParentDocument(child).getDocumentHeader().getWorkflowDocument();
    }

    public ProposalDevelopmentDocument getParentDocument(ProposalDevelopmentDocument child) throws ProposalHierarchyException {
        try {
            DevelopmentProposal parentProposal = this.getHierarchy(child.getDevelopmentProposal().getHierarchyParentProposalNumber());
            String parentDocumentNumber = parentProposal.getProposalDocument().getDocumentNumber();
            return (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(parentDocumentNumber);
        }
        catch (WorkflowException e) {
            LOG.error((Object)"Workflow exception thrown getting hierarchy routing status.", (Throwable)e);
            throw new ProposalHierarchyException(String.format("Could not lookup hierarchy workflow status for child:%s", child.getDocumentHeader().getDocumentNumber()), (Throwable)e);
        }
    }

    protected void rejectProposal(ProposalDevelopmentDocument proposalDoc, String reason, String principalId, String appDocStatus) throws WorkflowException {
        this.kraDocumentRejectionService.reject((Document)proposalDoc, reason, principalId, appDocStatus);
    }

    protected void rejectProposalHierarchy(ProposalDevelopmentDocument hierarchyParent, String reason, String principalId) throws ProposalHierarchyException {
        try {
            this.rejectProposal(hierarchyParent, this.renderMessage("message.proposalDevelopment.workflow.annotation.rejected", new String[]{reason}), principalId, this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.rejected", new String[0]));
        }
        catch (WorkflowException e) {
            throw new ProposalHierarchyException(String.format("WorkflowException encountered rejecting proposal hierarchy parent %s", hierarchyParent.getDevelopmentProposal().getProposalNumber()), (Throwable)e);
        }
        for (ProposalDevelopmentDocument child : this.getChildProposalDevelopmentDocuments(hierarchyParent.getDevelopmentProposal().getProposalNumber())) {
            try {
                this.rejectProposal(child, this.renderMessage("message.proposalDevelopment.workflow.annotation.parentRejected", new String[]{reason}), this.identityManagementService.getPrincipalByPrincipalName("kr").getPrincipalId(), this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentRejected", new String[0]));
            }
            catch (WorkflowException e) {
                throw new ProposalHierarchyException(String.format("WorkflowException encountered rejecting child document %s", child.getDevelopmentProposal().getProposalNumber()), (Throwable)e);
            }
        }
    }

    public void rejectProposalDevelopmentDocument(String proposalNumber, String reason, String principalName, FormFile rejectFile) throws WorkflowException, ProposalHierarchyException, IOException {
        DevelopmentProposal pbo = this.getDevelopmentProposal(proposalNumber);
        ProposalDevelopmentDocument pDoc = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(pbo.getProposalDocument().getDocumentNumber());
        if (!pbo.isInHierarchy()) {
            this.rejectProposal(pDoc, this.renderMessage("message.proposalDevelopment.workflow.annotation.rejected", new String[]{reason}), principalName, this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.rejected", new String[0]));
        } else if (pbo.isParent()) {
            this.rejectProposalHierarchy(pDoc, reason, principalName);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot reject proposal %s it is a hierarchy child or ", proposalNumber));
        }
        if (rejectFile != null && rejectFile.getFileData().length > 0) {
            Narrative narrative = new Narrative();
            narrative.setFileName(rejectFile.getFileName());
            narrative.setComments(reason);
            narrative.setNarrativeFile(rejectFile);
            narrative.setNarrativeTypeCode(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "rejectNarrativeTypeCode"));
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("NARRATIVE_STATUS_CODE", "C");
            NarrativeStatus status = (NarrativeStatus)this.businessObjectService.findByPrimaryKey(NarrativeStatus.class, keys);
            narrative.setNarrativeStatus(status);
            narrative.setModuleStatusCode(status.getNarrativeStatusCode());
            narrative.setModuleTitle("Proposal rejection attachment.");
            narrative.setContactName(GlobalVariables.getUserSession().getPrincipalName());
            narrative.setPhoneNumber(GlobalVariables.getUserSession().getPerson().getPhoneNumber());
            narrative.setEmailAddress(GlobalVariables.getUserSession().getPerson().getEmailAddress());
            pDoc.getDevelopmentProposal().addInstituteAttachment(narrative);
            this.businessObjectService.save((PersistableBusinessObject)pDoc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String calculateChildRouteStatus(ProposalDevelopmentDocument hierarchy, DocumentRouteStatusChange dto) {
        String parentOldStatus = dto.getOldRouteStatus();
        String parentNewStatus = dto.getNewRouteStatus();
        String newChildStatusTarget = "";
        if (StringUtils.equals((String)parentOldStatus, (String)"I")) return newChildStatusTarget;
        if (StringUtils.equals((String)parentOldStatus, (String)"S")) {
            newChildStatusTarget = parentNewStatus;
            if (StringUtils.equals((String)parentNewStatus, (String)"R") || StringUtils.equals((String)parentNewStatus, (String)"X")) return newChildStatusTarget;
            throw new UnsupportedOperationException(String.format("Do not know how to handle children of hierarchy for route status chnage from %s to %s", parentOldStatus, parentNewStatus));
        }
        if (StringUtils.equals((String)parentOldStatus, (String)"R")) {
            if (StringUtils.equals((String)parentNewStatus, (String)"X")) return parentNewStatus;
            if (StringUtils.equals((String)parentNewStatus, (String)"D")) {
                return parentNewStatus;
            }
            if (StringUtils.equals((String)parentNewStatus, (String)"P")) return newChildStatusTarget;
            if (!StringUtils.equals((String)parentNewStatus, (String)"R")) throw new UnsupportedOperationException(String.format("Do not know how to handle children of hierarchy for route status chnage from %s to %s", parentOldStatus, parentNewStatus));
            return "R";
        }
        if (StringUtils.equals((String)parentOldStatus, (String)"P")) return newChildStatusTarget;
        if (!StringUtils.equals((String)parentOldStatus, (String)"P")) throw new UnsupportedOperationException(String.format("Do not know how to handle children of hierarchy for route status chnage from %s to %s", parentOldStatus, parentNewStatus));
        if (!StringUtils.equals((String)parentNewStatus, (String)"F")) throw new UnsupportedOperationException(String.format("Do not know how to handle children of hierarchy for route status chnage from %s to %s", parentOldStatus, parentNewStatus));
        return parentNewStatus;
    }

    public void routeHierarchyChildren(ProposalDevelopmentDocument proposalDevelopmentDocument, DocumentRouteStatusChange dto) throws ProposalHierarchyException {
        String childStatusTarget = this.calculateChildRouteStatus(proposalDevelopmentDocument, dto);
        ProposalDevelopmentDocument child = null;
        try {
            LOG.info(IdentityService.class);
            Iterator i$ = this.getChildProposalDevelopmentDocuments(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber()).iterator();
            while (i$.hasNext()) {
                WorkflowDocument workdoc;
                ProposalDevelopmentDocument c;
                child = c = (ProposalDevelopmentDocument)i$.next();
                if (StringUtils.equals((String)"", (String)childStatusTarget)) continue;
                if (StringUtils.equals((String)"R", (String)childStatusTarget)) {
                    workdoc = WorkflowDocumentFactory.loadDocument((String)child.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId(), (String)child.getDocumentHeader().getWorkflowDocument().getDocumentId());
                    workdoc.setApplicationDocumentStatus(this.getHierarchyChildRouteStatus(dto.getOldRouteStatus(), dto.getNewRouteStatus()));
                    if (!workdoc.isEnroute()) {
                        workdoc.route(this.renderMessage("message.proposalDevelopment.workflow.annotation.parentSubmitted", new String[0]));
                        continue;
                    }
                    workdoc.approve(this.renderMessage("message.proposalDevelopment.workflow.annotation.parentResubmitted", new String[0]));
                    workdoc.setApplicationDocumentStatus(this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentEnroute", new String[0]));
                    continue;
                }
                workdoc = WorkflowDocumentFactory.loadDocument((String)this.identityManagementService.getPrincipalByPrincipalName("kr").getPrincipalId(), (String)child.getDocumentHeader().getWorkflowDocument().getDocumentId());
                workdoc.setApplicationDocumentStatus(this.getHierarchyChildRouteStatus(dto.getOldRouteStatus(), dto.getNewRouteStatus()));
                if (StringUtils.equals((String)"X", (String)childStatusTarget)) {
                    workdoc.cancel(this.renderMessage("message.proposalDevelopment.workflow.annotation.parentCanceled", new String[0]));
                    workdoc.setApplicationDocumentStatus(this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentCancel", new String[0]));
                    continue;
                }
                if (StringUtils.equals((String)"F", (String)childStatusTarget)) {
                    workdoc.approve(this.renderMessage("message.proposalDevelopment.workflow.annotation.parentApproved", new String[0]));
                    workdoc.setApplicationDocumentStatus(this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentFinal", new String[0]));
                    continue;
                }
                if (StringUtils.equals((String)"D", (String)childStatusTarget)) {
                    workdoc.disapprove(this.renderMessage("message.proposalDevelopment.workflow.annotation.parentDisapproved", new String[0]));
                    workdoc.setApplicationDocumentStatus(this.renderMessage("message.proposalDevelopment.workflow.applicationStatus.parentDisapprove", new String[0]));
                    continue;
                }
                throw new UnsupportedOperationException(String.format("Do not know how to handle new child status of %s", childStatusTarget));
            }
        }
        catch (Exception we) {
            throw new ProposalHierarchyException(String.format("Exception encountrered while attempting to route child proposal %s ( document #%s ) of proposal hierarchy %s ( document #%s )", child.getDevelopmentProposal().getProposalNumber(), child.getDocumentNumber(), proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber(), proposalDevelopmentDocument.getDocumentNumber()), (Throwable)we);
        }
    }

    public void calculateAndSetProposalAppDocStatus(ProposalDevelopmentDocument doc, DocumentRouteStatusChange dto) throws ProposalHierarchyException {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        if (StringUtils.equals((String)dto.getNewRouteStatus(), (String)"R")) {
            this.updateAppDocStatus(doc, principalId, "message.proposalDevelopment.workflow.applicationStatus.enroute");
        } else if (StringUtils.equals((String)dto.getNewRouteStatus(), (String)"X")) {
            this.updateAppDocStatus(doc, principalId, "message.proposalDevelopment.workflow.applicationStatus.cancel");
        } else if (StringUtils.equals((String)dto.getNewRouteStatus(), (String)"D")) {
            this.updateAppDocStatus(doc, principalId, "message.proposalDevelopment.workflow.applicationStatus.disapprove");
        } else if (StringUtils.equals((String)dto.getNewRouteStatus(), (String)"F")) {
            this.updateAppDocStatus(doc, principalId, "message.proposalDevelopment.workflow.applicationStatus.final");
        } else if (StringUtils.equals((String)dto.getNewRouteStatus(), (String)"P")) {
            this.updateAppDocStatus(doc, principalId, "message.proposalDevelopment.workflow.applicationStatus.processed");
        }
    }

    public void updateAppDocStatus(ProposalDevelopmentDocument doc, String principalId, String newStatus) throws ProposalHierarchyException {
        try {
            WorkflowDocument wdoc = WorkflowDocumentFactory.loadDocument((String)principalId, (String)doc.getDocumentHeader().getWorkflowDocument().getDocumentId());
            wdoc.setApplicationDocumentStatus(this.renderMessage(newStatus, new String[0]));
        }
        catch (Exception e) {
            throw new ProposalHierarchyException(String.format("Exception encountrered while attempting to update App Doc Status of proposal %s ( document #%s )", doc.getDevelopmentProposal().getProposalNumber(), doc.getDocumentNumber()), (Throwable)e);
        }
    }

    public boolean allChildBudgetsAreComplete(String parentProposalNumber) {
        boolean retval = true;
        String completeCode = this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        for (ProposalBudgetStatus status : this.proposalHierarchyDao.getHierarchyChildProposalBudgetStatuses(parentProposalNumber)) {
            if (StringUtils.equalsIgnoreCase((String)completeCode, (String)status.getBudgetStatusCode())) continue;
            retval = false;
            break;
        }
        return retval;
    }

    protected boolean rolesAreSimilar(ProposalPerson person1, ProposalPerson person2) {
        boolean isInvestigator1 = StringUtils.equals((String)person1.getProposalPersonRoleId(), (String)"PI") || StringUtils.equals((String)person1.getProposalPersonRoleId(), (String)"COI");
        boolean isInvestigator2 = StringUtils.equals((String)person2.getProposalPersonRoleId(), (String)"PI") || StringUtils.equals((String)person2.getProposalPersonRoleId(), (String)"COI");
        return isInvestigator1 == isInvestigator2;
    }

    public List<HierarchyPersonnelSummary> getHierarchyPersonnelSummaries(String parentProposalNumber) throws ProposalHierarchyException {
        ArrayList<HierarchyPersonnelSummary> summaries = new ArrayList<HierarchyPersonnelSummary>();
        ArrayList proposalNumbers = new ArrayList();
        proposalNumbers.addAll(this.proposalHierarchyDao.getHierarchyChildProposalNumbers(parentProposalNumber));
        Collections.sort(proposalNumbers);
        for (String proposalNumber : proposalNumbers) {
            HierarchyPersonnelSummary summary = new HierarchyPersonnelSummary();
            DevelopmentProposal childProposal = this.getDevelopmentProposal(proposalNumber);
            ArrayList<Budget> hierarchyBudgets = new ArrayList<Budget>();
            for (BudgetDocument hierarchyBudgetDocument : this.getHierarchyBudgets(childProposal)) {
                hierarchyBudgets.add(hierarchyBudgetDocument.getBudget());
            }
            Collections.sort(hierarchyBudgets);
            summary.setProposalNumber(proposalNumber);
            summary.setHierarchyBudgets(hierarchyBudgets);
            summaries.add(summary);
        }
        return summaries;
    }

    public List<HierarchyProposalSummary> getHierarchyProposalSummaries(String proposalNumber) throws ProposalHierarchyException {
        DevelopmentProposal proposal = this.getDevelopmentProposal(proposalNumber);
        ArrayList<HierarchyProposalSummary> summaries = new ArrayList<HierarchyProposalSummary>();
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        if (proposal.isParent()) {
            proposalNumbers.add(proposalNumber);
        } else if (proposal.isChild()) {
            proposalNumbers.add(proposal.getHierarchyParentProposalNumber());
        } else {
            throw new ProposalHierarchyException("Proposal " + proposalNumber + " is not a member of a hierarchy.");
        }
        proposalNumbers.addAll(this.proposalHierarchyDao.getHierarchyChildProposalNumbers((String)proposalNumbers.get(0)));
        for (String number : proposalNumbers) {
            HierarchyProposalSummary summary = new HierarchyProposalSummary();
            summary.setProposalNumber(number);
            if (!StringUtils.equals((String)number, (String)((String)proposalNumbers.get(0)))) {
                summary = this.getProposalSummary(number);
            }
            summaries.add(summary);
        }
        return summaries;
    }

    public HierarchyProposalSummary getProposalSummary(String proposalNumber) throws ProposalHierarchyException {
        HierarchyProposalSummary summary = new HierarchyProposalSummary();
        summary.setProposalNumber(proposalNumber);
        DevelopmentProposal childProposal = this.getDevelopmentProposal(proposalNumber);
        summary.setSynced(Boolean.valueOf(this.isSynchronized(childProposal)));
        BudgetDocument budgetDoc = this.getSyncableBudget(childProposal);
        summary.setSyncableBudgetDocumentNumber(budgetDoc.getDocumentNumber());
        summary.setBudgetSynced(Boolean.valueOf(this.isBudgetSynchronized(childProposal, (ProposalDevelopmentBudgetExt)budgetDoc.getBudget())));
        return summary;
    }

    public boolean validateRemovePermissions(DevelopmentProposal childProposal, String principalId) {
        boolean valid = true;
        valid &= this.kraAuthorizationService.hasPermission(principalId, (Permissionable)childProposal.getProposalDocument(), "Maintain ProposalHierarchy");
        try {
            valid &= this.kraAuthorizationService.hasPermission(principalId, (Permissionable)this.getHierarchy(childProposal.getHierarchyParentProposalNumber()).getProposalDocument(), "Maintain ProposalHierarchy");
        }
        catch (ProposalHierarchyException e) {
            valid = false;
        }
        return valid;
    }

    protected String renderMessage(String key, String ... params) {
        String msg = this.configurationService.getPropertyValueAsString(key);
        for (int i = 0; i < params.length; ++i) {
            msg = StringUtils.replace((String)msg, (String)("{" + i + "}"), (String)params[i]);
        }
        return msg;
    }

    public KraDocumentRejectionService getKraDocumentRejectionService() {
        return this.kraDocumentRejectionService;
    }

    public void setKraDocumentRejectionService(KraDocumentRejectionService kraDocumentRejectionService) {
        this.kraDocumentRejectionService = kraDocumentRejectionService;
    }

    public void setSessionDocumentService(SessionDocumentService sessionDocumentService) {
        this.sessionDocumentService = sessionDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    protected ProposalHierarchyDao getProposalHierarchyDao() {
        return this.proposalHierarchyDao;
    }

    protected NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    protected BudgetService getBudgetService() {
        return this.budgetService;
    }

    protected ProposalPersonBiographyService getPropPersonBioService() {
        return this.propPersonBioService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    protected IdentityService getIdentityManagementService() {
        return this.identityManagementService;
    }

    protected ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    protected List<ProposalPersonExtendedAttributes> getProposalPersonExtendedAttributesToDelete() {
        return this.proposalPersonExtendedAttributesToDelete;
    }

    protected SessionDocumentService getSessionDocumentService() {
        return this.sessionDocumentService;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }
}

