/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.service.ProposalCountryService;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;

public class KCStateValuesFinder
extends KeyValuesBase {
    private String countryCode = "";

    public List<KeyValue> getKeyValues() {
        List baseCodes;
        ArrayList<Object> labels = new ArrayList<KeyValue>();
        if (StringUtils.isEmpty((String)this.countryCode)) {
            this.findCurrentPersonCountryCode();
            if (StringUtils.isEmpty((String)this.countryCode)) {
                labels.add((KeyValue)new ConcreteKeyValue("", ""));
                return labels;
            }
            baseCodes = LocationApiServiceLocator.getStateService().findAllStatesInCountry(this.countryCode);
        } else {
            baseCodes = LocationApiServiceLocator.getStateService().findAllStatesInCountry(this.countryCode);
        }
        ArrayList codes = new ArrayList(baseCodes);
        Collections.sort(codes, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ConcreteKeyValue> newLabels = new ArrayList<ConcreteKeyValue>();
        newLabels.add(new ConcreteKeyValue("", ""));
        for (State state : codes) {
            if (!state.isActive()) continue;
            newLabels.add(new ConcreteKeyValue(state.getCode(), state.getCountryCode() + " - " + state.getName()));
        }
        labels = newLabels;
        this.clearInternalCache();
        return labels;
    }

    public static List<KeyValue> getKeyValues(String countryCodePassedIn) {
        ArrayList<Object> labels = new ArrayList<KeyValue>();
        if (StringUtils.isNotEmpty((String)countryCodePassedIn)) {
            String determinedCountryCode;
            if (countryCodePassedIn.length() == 2) {
                determinedCountryCode = countryCodePassedIn;
            } else {
                ProposalCountryService proposalCountryService = (ProposalCountryService)KraServiceLocator.getService(ProposalCountryService.class);
                determinedCountryCode = proposalCountryService.convertAltCountryCodeToRealCountryCode(countryCodePassedIn);
            }
            List baseCodes = LocationApiServiceLocator.getStateService().findAllStatesInCountry(determinedCountryCode);
            ArrayList codes = new ArrayList(baseCodes);
            Collections.sort(codes, new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<ConcreteKeyValue> newLabels = new ArrayList<ConcreteKeyValue>();
            newLabels.add(new ConcreteKeyValue("", ""));
            for (State state : codes) {
                if (!state.isActive()) continue;
                newLabels.add(new ConcreteKeyValue(state.getCode(), state.getCountryCode() + " - " + state.getName()));
            }
            labels = newLabels;
        }
        return labels;
    }

    protected void findCurrentPersonCountryCode() {
        ProposalDevelopmentForm pdf = (ProposalDevelopmentForm)KNSGlobalVariables.getKualiForm();
        if (pdf != null) {
            String currentPersonCountryCode = pdf.getCurrentPersonCountryCode();
            if (StringUtils.isNotEmpty((String)currentPersonCountryCode)) {
                if (currentPersonCountryCode.length() == 2) {
                    this.countryCode = currentPersonCountryCode;
                } else {
                    ProposalCountryService proposalCountryService = (ProposalCountryService)KraServiceLocator.getService(ProposalCountryService.class);
                    this.countryCode = proposalCountryService.convertAltCountryCodeToRealCountryCode(currentPersonCountryCode);
                }
            } else {
                this.countryCode = "";
            }
        } else {
            this.countryCode = "";
        }
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void clearInternalCache() {
        super.clearInternalCache();
        this.countryCode = "";
    }
}

