/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.bo.ValidNarrForms;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class ProposalNarrativeTypeValuesFinder
extends PersistableBusinessObjectValuesFinder {
    private static final String NO = "N";
    private static final Log LOG = LogFactory.getLog(ProposalNarrativeTypeValuesFinder.class);
    private ParameterService parameterService;
    String proposalNarrativeTypeGroup = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposalNarrativeTypeGroup");

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public List<KeyValue> getKeyValues() {
        Collection allNarrativeTypes = this.loadAllNarrativeTypes();
        return this.getFilteredKeyValues(allNarrativeTypes);
    }

    public List<KeyValue> getFilteredKeyValues(Collection<NarrativeType> allNarrativeTypes) {
        Collection filteredCollection = this.filterCollection(allNarrativeTypes);
        return this.buildKeyValuesCollection(filteredCollection);
    }

    protected Collection<NarrativeType> filterCollection(Collection<NarrativeType> narrativeTypes) {
        ProposalDevelopmentDocument document = this.getDocumentFromForm();
        ArrayList<NarrativeType> forRemoval = new ArrayList<NarrativeType>();
        for (NarrativeType narrativeType : narrativeTypes) {
            for (Narrative narrative : document.getDevelopmentProposal().getNarratives()) {
                if (this.filterCondition(narrative.getNarrativeType(), narrativeType)) {
                    forRemoval.add(narrativeType);
                    continue;
                }
                LOG.debug((Object)("Not removing narrative type " + narrativeType.getDescription()));
            }
        }
        narrativeTypes.removeAll(forRemoval);
        return narrativeTypes;
    }

    private List<KeyValue> buildKeyValuesCollection(Collection<NarrativeType> narrativeTypes) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        KeyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        for (NarrativeType narrativeType : narrativeTypes) {
            String key = narrativeType.getNarrativeTypeCode();
            String label = narrativeType.getDescription();
            KeyValues.add((KeyValue)new ConcreteKeyValue(key, label));
        }
        return KeyValues;
    }

    protected Collection<NarrativeType> loadAllNarrativeTypes() {
        ProposalDevelopmentDocument document = this.getDocumentFromForm();
        DevelopmentProposal developmentProposal = document.getDevelopmentProposal();
        List<Object> validS2SFormNarratives = new ArrayList<NarrativeType>();
        if (this.isS2sCandidate(developmentProposal)) {
            this.populateValidFormNarratives(developmentProposal, validS2SFormNarratives);
            this.populateGenericValidNarrativeTypes(validS2SFormNarratives);
            this.populateValidNarrativeTypeFromParentProposal(developmentProposal, validS2SFormNarratives);
        } else {
            String proposalNarrativeTypeGroup = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposalNarrativeTypeGroup");
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("narrativeTypeGroup", proposalNarrativeTypeGroup);
            List validNarrativeForms = (List)this.getBusinessObjectService().findAll(ValidNarrForms.class);
            List allNarrativeTypes = (List)this.getBusinessObjectService().findMatching(this.getBusinessObjectClass(), queryMap);
            validS2SFormNarratives = this.removeValidNarrativeForms(allNarrativeTypes, validNarrativeForms);
        }
        return validS2SFormNarratives;
    }

    private List<NarrativeType> removeValidNarrativeForms(List<NarrativeType> narrativeTypes, List<ValidNarrForms> validNarrativeForms) {
        ArrayList<NarrativeType> filteredNarrativeTypes = new ArrayList<NarrativeType>();
        this.populateGenericValidNarrativeTypes(filteredNarrativeTypes);
        for (NarrativeType narrativeType : narrativeTypes) {
            boolean exists = false;
            for (ValidNarrForms validNarrForm : validNarrativeForms) {
                if (!validNarrForm.getNarrativeTypeCode().equals(narrativeType.getNarrativeTypeCode())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            filteredNarrativeTypes.add(narrativeType);
        }
        return filteredNarrativeTypes;
    }

    private boolean isS2sCandidate(DevelopmentProposal developmentProposal) {
        return !developmentProposal.getS2sOppForms().isEmpty();
    }

    private BusinessObjectService getBusinessObjectService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("proposalNumber", proposalNumber);
        return (DevelopmentProposal)this.getBusinessObjectService().findByPrimaryKey(DevelopmentProposal.class, pk);
    }

    private List<NarrativeType> populateValidFormNarratives(DevelopmentProposal developmentProposal, List<NarrativeType> validaNarrativeTypes) {
        List s2sOpportunityForms = developmentProposal.getS2sOppForms();
        for (S2sOppForms oppForms : s2sOpportunityForms) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("formName", oppForms.getFormName());
            List validNarrativeForms = (List)this.getBusinessObjectService().findMatching(ValidNarrForms.class, queryMap);
            for (ValidNarrForms validNarrForms : validNarrativeForms) {
                if (!this.isProposalGroup(validNarrForms) || this.isNarrativeAlreadyAdded(validaNarrativeTypes, validNarrForms.getNarrativeType()) || !validNarrForms.getNarrativeType().getSystemGenerated().equals(NO)) continue;
                validaNarrativeTypes.add(validNarrForms.getNarrativeType());
            }
        }
        return validaNarrativeTypes;
    }

    private boolean isNarrativeAlreadyAdded(List<NarrativeType> validaNarrativeTypes, NarrativeType validNarrativeType) {
        for (NarrativeType narrativeType : validaNarrativeTypes) {
            if (!narrativeType.getNarrativeTypeCode().equals(validNarrativeType.getNarrativeTypeCode())) continue;
            return true;
        }
        return false;
    }

    private boolean isProposalGroup(ValidNarrForms validNarrForms) {
        return this.proposalNarrativeTypeGroup.equals(validNarrForms.getNarrativeType().getNarrativeTypeGroup());
    }

    private void populateValidNarrativeTypeFromParentProposal(DevelopmentProposal developmentProposal, List<NarrativeType> validaNarrativeTypes) {
        if (developmentProposal.isInHierarchy()) {
            String hierarchyProposalNumber = developmentProposal.getHierarchyParentProposalNumber();
            DevelopmentProposal parentProposal = this.getDevelopmentProposal(hierarchyProposalNumber);
            this.populateValidFormNarratives(parentProposal, validaNarrativeTypes);
        }
    }

    private Map<String, String> populateGenericValidNarrativeTypes(List<NarrativeType> validaNarrativeTypes) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("formName", "ALL");
        List validNarrativeForms = (List)this.getBusinessObjectService().findMatching(ValidNarrForms.class, queryMap);
        for (ValidNarrForms validNarrForms : validNarrativeForms) {
            if (!this.isProposalGroup(validNarrForms)) continue;
            validaNarrativeTypes.add(validNarrForms.getNarrativeType());
        }
        return queryMap;
    }

    protected ProposalDevelopmentDocument getDocumentFromForm() {
        return ((ProposalDevelopmentForm)KNSGlobalVariables.getKualiForm()).getProposalDevelopmentDocument();
    }

    protected boolean filterCondition(NarrativeType documentNarrativeType, NarrativeType narrativeType) {
        return documentNarrativeType.getNarrativeTypeCode().equals(narrativeType.getNarrativeTypeCode()) && this.multiplesNotAllowed(narrativeType);
    }

    private boolean multiplesNotAllowed(NarrativeType narrativeType) {
        return narrativeType.getAllowMultiple().equals(NO);
    }
}

