/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.notification;

import java.util.List;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationRoleQualifierService;
import org.kuali.kra.util.EmailAttachment;

public class ProposalDevelopmentNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 7899968257291957401L;
    private DevelopmentProposal proposal;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;

    public ProposalDevelopmentNotificationContext(DevelopmentProposal developmentProposal, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.proposal = developmentProposal;
        this.documentNumber = developmentProposal.getProposalDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService((KcNotificationService)KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService((KcNotificationModuleRoleService)KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        ProposalDevelopmentNotificationRoleQualifierService roleQualifier = (ProposalDevelopmentNotificationRoleQualifierService)KraServiceLocator.getService(ProposalDevelopmentNotificationRoleQualifierService.class);
        roleQualifier.setDevelopmentProposal(developmentProposal);
        this.setNotificationRoleQualifierService((KcNotificationRoleQualifierService)roleQualifier);
    }

    public ProposalDevelopmentNotificationContext(DevelopmentProposal developmentProposal, String actionTypeCode, String contextName) {
        this(developmentProposal, actionTypeCode, contextName, (NotificationRenderer)KraServiceLocator.getService(ProposalDevelopmentNotificationRenderer.class));
        ((ProposalDevelopmentNotificationRenderer)this.getRenderer()).setDevelopmentProposal(developmentProposal);
    }

    public String getModuleCode() {
        return "3";
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getContextName() {
        return this.contextName;
    }

    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public DevelopmentProposal getProposal() {
        return this.proposal;
    }

    public void setProposal(DevelopmentProposal proposal) {
        this.proposal = proposal;
    }
}

