/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.notification;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalChangedData;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;

public class ProposalDevelopmentNotificationRenderer
extends NotificationRendererBase {
    private static final long serialVersionUID = 1143944858168503090L;
    private DevelopmentProposal developmentProposal;
    private ProposalChangedData proposalChangedData;
    private Narrative modifiedNarrative;
    private transient ProposalDevelopmentService proposalDevelopmentService;

    public ProposalDevelopmentNotificationRenderer() {
    }

    public ProposalDevelopmentNotificationRenderer(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
        Map result = super.getDefaultReplacementParameters();
        result.put("{PROPOSAL_NUMBER}", this.developmentProposal.getProposalNumber());
        result.put("{PROPOSAL_TITLE}", this.developmentProposal.getTitle());
        result.put("{SPONSOR_CODE}", this.developmentProposal.getSponsorCode());
        result.put("{SPONSOR_NAME}", this.developmentProposal.getSponsorName());
        result.put("{PROGRAM_ANNOUNCEMENT_NUMBER}", this.developmentProposal.getProgramAnnouncementNumber());
        result.put("{PROGRAM_ANNOUNCEMENT_TITLE}", this.developmentProposal.getProgramAnnouncementTitle());
        result.put("{CFDA_NUMBER}", this.developmentProposal.getCfdaNumber());
        if (this.developmentProposal.getDeadlineDate() != null) {
            result.put("{DEADLINE_DATE}", dateFormatter.format(this.developmentProposal.getDeadlineDate()));
        } else {
            result.put("{DEADLINE_DATE}", "");
        }
        result.put("{DEADLINE_DATE}", this.developmentProposal.getDeadlineTime());
        result.put("{PI_NAME}", this.developmentProposal.getPrincipalInvestigatorName());
        result.put("{LEAD_UNIT}", this.developmentProposal.getUnitNumber());
        result.put("{LEAD_UNIT_NAME}", this.developmentProposal.getUnit().getUnitName());
        result.put("{PRIME_SPONSOR_CODE}", this.developmentProposal.getPrimeSponsorCode());
        result.put("{PRIME_SPONSOR_NAME}", this.developmentProposal.getPrimeSponsor() != null ? this.developmentProposal.getPrimeSponsor().getSponsorName() : "");
        InstitutionalProposal instProp = this.getProposalDevelopmentService().getInstitutionalProposal(this.developmentProposal.getProposalNumber());
        result.put("{INSTITUTIONAL_PROPOSAL_NUMBER}", instProp != null ? instProp.getProposalNumber() : "");
        if (this.proposalChangedData != null) {
            result.put("{OVERRIDE_FIELD_NAME}", this.proposalChangedData.getEditableColumn().getColumnLabel());
            result.put("{OVERRIDE_FIELD_VALUE}", this.proposalChangedData.getDisplayValue());
        }
        if (this.modifiedNarrative != null) {
            result.put("{NARRATIVE_MODULE_NUM}", this.modifiedNarrative.getModuleNumber().toString());
            result.put("{NARRATIVE_TYPE}", this.modifiedNarrative.getNarrativeType().getDescription());
            result.put("{NARRATIVE_MODULE_DESCRIPTION}", this.modifiedNarrative.getModuleTitle() == null ? "" : this.modifiedNarrative.getModuleTitle());
        }
        return result;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    public ProposalChangedData getProposalChangedData() {
        return this.proposalChangedData;
    }

    public void setProposalChangedData(ProposalChangedData proposalChangedData) {
        this.proposalChangedData = proposalChangedData;
    }

    public Narrative getModifiedNarrative() {
        return this.modifiedNarrative;
    }

    public void setModifiedNarrative(Narrative modifiedNarrative) {
        this.modifiedNarrative = modifiedNarrative;
    }
}

