/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.print;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.kuali.kra.bo.SponsorFormTemplate;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.NIHResearchAndRelatedXmlStream;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.ProposalDevelopmentXmlStream;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalSponsorFormsPrint
extends AbstractPrint {
    private static final String LOCAL_PRINT_FORM_SPONSOR_CODE = "LOCAL_PRINT_FORM_SPONSOR_CODE";
    private BusinessObjectService businessObjectService;
    private NIHResearchAndRelatedXmlStream nihResearchAndRelatedXmlStream;
    private ProposalDevelopmentXmlStream proposalDevelopmentXmlStream;

    public Map<String, Source> getXSLTemplateWithBookmarks() {
        LinkedHashMap<String, Source> sourceMap = new LinkedHashMap<String, Source>();
        List printFormTemplates = (List)this.getReportParameters().get("Selected Templates");
        for (SponsorFormTemplate sponsorFormTemplate : printFormTemplates) {
            SponsorFormTemplate sponsorTemplate = (SponsorFormTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(SponsorFormTemplate.class, (Object)sponsorFormTemplate.getSponsorFormTemplateId());
            sourceMap.put(sponsorFormTemplate.getPageDescription(), new StreamSource(new ByteArrayInputStream(sponsorTemplate.getAttachmentContent())));
        }
        return sourceMap;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProposalDevelopmentXmlStream getProposalDevelopmentXmlStream() {
        return this.proposalDevelopmentXmlStream;
    }

    public void setProposalDevelopmentXmlStream(ProposalDevelopmentXmlStream proposalDevelopmentXmlStream) {
        this.proposalDevelopmentXmlStream = proposalDevelopmentXmlStream;
    }

    public Map<String, byte[]> renderXML() throws PrintingException {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getPrintableBusinessObject();
        if (developmentProposal.getSponsorCode().equals(this.getProposalParameterValue(LOCAL_PRINT_FORM_SPONSOR_CODE))) {
            this.setXmlStream((XmlStream)this.proposalDevelopmentXmlStream);
        } else {
            this.setXmlStream((XmlStream)this.nihResearchAndRelatedXmlStream);
        }
        return super.renderXML();
    }

    private String getProposalParameterValue(String param) {
        String value = null;
        try {
            value = PrintingUtils.getParameterValue((String)param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public NIHResearchAndRelatedXmlStream getNihResearchAndRelatedXmlStream() {
        return this.nihResearchAndRelatedXmlStream;
    }

    public void setNihResearchAndRelatedXmlStream(NIHResearchAndRelatedXmlStream nihResearchAndRelatedXmlStream) {
        this.nihResearchAndRelatedXmlStream = nihResearchAndRelatedXmlStream;
    }
}

