/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.xmlstream;

import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.ContactInfoType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.PostalAddressType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.AnimalSubjectDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ApplicantOrganizationType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.BudgetTotalsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreApplicantSubmissionQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreApplicationCategoryType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreBudgetTotalsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreFederalAgencyReceiptQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreFederalDebtDelinquencyQuestionsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreProjectDatesType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreStateIntergovernmentalReviewType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreStateReceiptQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreSubmissionCategoryType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.DescriptionBlockType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.EquipmentCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherAgencyQuestionsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ParticipantPatientCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ParticipantType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.PersonFullNameType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectRoleType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSiteType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSurveyDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.TravelCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.TravelType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryMap;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.budget.personnel.TbnPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.ProposalBaseStream;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AbstractResearchAndRelatedStream
extends ProposalBaseStream {
    private static final Log LOG = LogFactory.getLog(AbstractResearchAndRelatedStream.class);
    protected static final String EMPTY_STRING = " ";
    protected static final String REPORT_NAME = "Research and Related";
    protected static final String SPECIAL_REVIEW_CODE_2 = "2";
    protected static final String IACU_APPROVAL_PENDING_VALUE = "Pending";
    protected static final String BUDGET_JUSTIFICATION_IDENTIFIER = "budgetJust";
    private static final String CATEGORY_CODE_EQUIPMENT_RENTAL = "13";
    private static final String CATEGORY_CODE_EQUIPMENT = "20";
    private static final String CATEGORY_CODE_TRAVEL_FOREIGN = "23";
    private static final String CATEGORY_CODE_TRAVEL_DOMESTIC = "7";
    private static final String CATEGORY_CODE_PARTICIPANT_TRAVEL = "31";
    private static final String CATEGORY_CODE_PARTICIPANT_SUBSISTANCE = "36";
    private static final String CATEGORY_CODE_PARTICIPANT_STIPENDS = "32";
    private static final String CATEGORY_CODE_PARTICIPANT_OTHER = "2";
    private static final String CATEGORY_CODE_PARTICIPANT_TUITION = "35";
    private static final String CATEGORY_CODE_OUTPATIENT = "33";
    private static final String CATEGORY_CODE_INPATIENT = "9";
    protected static final String DEFAULT_VALUE_UNKNOWN = "Unknown";
    private static final String PROPOSALQUESTION_ID15 = "15";
    private static final String ANSWER_INDICATOR_VALUE = "Y";
    private static final String DEFAULT_ANSWER = "This question has not been answered";
    private static final String STEMCELL = "18";
    private static final String INTERNATIONAL_ACTIVITIES = "H1";
    private static final String PROPRIETARY_INFO = "G8";
    private static final String HISTORICAL_SITES = "G6";
    private static final String GENETICALLY_ENGINEERED = "G4";
    private static final String HAZARDOUS_MATERIALS = "G3";
    private static final String NSFSMALL_GRANT = "14";
    private static final String NSF_BEGINNING_INV = "12";
    private static final String LOBBYING_ACTIVITIES = "H4";
    private static final String ANSWER_PARAMETER = "answer";
    private static final String QUESTION_ID_PARAMETER = "questionId";
    private static final String ORGANIZATION_ID_PARAMETER = "organizationId";
    public static final String KEY_MAPPING_NAME = "mappingName";
    public static final String KEY_TARGET_CATEGORY_CODE = "targetCategoryCode";
    private static final String RATE_CLASS_TYPE_EMPLOYEE_BENEFITS = "E";
    private static final String RATE_CLASS_TYPE_VACATION = "V";
    private static final String RATE_TYPE_ADMINISTRATIVE_SALARIES = "2";
    private static final String RATE_TYPE_SUPPORT_STAFF_SALARIES = "3";
    private static final String PERIOD_TYPE_ACADEMIC_MONTHS = "2";
    private static final String PERIOD_TYPE_CALENDAR_MONTHS = "3";
    private static final String PERIOD_TYPE_SUMMER_MONTHS = "4";
    private static final String PERIOD_TYPE_CYCLE_MONTHS = "CY";
    private static final String TARGET_CATEGORY_CODE_EQUIPMENT_COST = "42";
    private static final String TARGET_CATEGORY_CODE_01 = "01";
    private static final String SENIOR_PERSONNEL_CATEGORY_CODE = "1";
    private static final String KEYPERSON_OTHER = "Other (Specify)";
    private static final String APPOINTMENT_TYPE_SUM_EMPLOYEE = "SUM EMPLOYEE";
    private static final String APPOINTMENT_TYPE_TMP_EMPLOYEE = "TMP EMPLOYEE";
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;
    private S2SUtilService s2SUtilService;

    protected AnimalSubjectDocument.AnimalSubject getAnimalSubject(DevelopmentProposal developmentProposal) {
        AnimalSubjectDocument.AnimalSubject animalSubject = AnimalSubjectDocument.AnimalSubject.Factory.newInstance();
        List specialReviewList = developmentProposal.getPropSpecialReviews();
        if (specialReviewList != null) {
            for (ProposalSpecialReview proposalSpecialReview : specialReviewList) {
                if (proposalSpecialReview.getSpecialReviewTypeCode() == null || !proposalSpecialReview.getSpecialReviewTypeCode().equals("2")) continue;
                animalSubject.setVertebrateAnimalsUsedQuestion(true);
                String animalWelfareAssurance = this.getAnimalWelfareAssuranceNumber(developmentProposal);
                if (animalWelfareAssurance != null) {
                    animalSubject.setAssuranceNumber(animalWelfareAssurance);
                }
                if (proposalSpecialReview.getApplicationDate() != null) {
                    animalSubject.setIACUCApprovalDate(this.getDateTimeService().getCalendar((Date)proposalSpecialReview.getApplicationDate()));
                    break;
                }
                animalSubject.setIACUCApprovalPending(IACU_APPROVAL_PENDING_VALUE);
                break;
            }
        }
        return animalSubject;
    }

    protected String getAnimalWelfareAssuranceNumber(DevelopmentProposal developmentProposal) {
        String animalWelfareAssurance = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getAnimalWelfareAssurance() != null) {
            animalWelfareAssurance = organization.getAnimalWelfareAssurance();
        }
        return animalWelfareAssurance;
    }

    protected Organization getOrganizationFromDevelopmentProposal(DevelopmentProposal developmentProposal) {
        Organization organization = null;
        ProposalSite proposalSite = developmentProposal.getApplicantOrganization();
        if (proposalSite != null) {
            organization = proposalSite.getOrganization();
        }
        return organization;
    }

    protected CoreSubmissionCategoryType getSubmissionCategoryForResearchCoverPage(String activityDescription, String creationStatusCode) {
        CoreSubmissionCategoryType coreSubmissionCategoryType = CoreSubmissionCategoryType.Factory.newInstance();
        coreSubmissionCategoryType.setProjectCategory(activityDescription == null ? EMPTY_STRING : activityDescription);
        coreSubmissionCategoryType.setSubmissionStatus(creationStatusCode == null ? EMPTY_STRING : creationStatusCode);
        return coreSubmissionCategoryType;
    }

    protected BudgetTotalsType getBudgetTotals(BudgetDecimal totalCost, BudgetDecimal costSharingAmount) {
        BudgetTotalsType budgetTotalType = BudgetTotalsType.Factory.newInstance();
        budgetTotalType.setFederalCost(totalCost.bigDecimalValue());
        budgetTotalType.setApplicantCost(costSharingAmount.bigDecimalValue());
        budgetTotalType.setStateCost(new BigDecimal(0));
        budgetTotalType.setLocalCost(new BigDecimal(0));
        budgetTotalType.setOtherCost(new BigDecimal(0));
        budgetTotalType.setProgramIncome(new BigDecimal(0));
        return budgetTotalType;
    }

    protected DescriptionBlockType getBudgetJustification(String proposalNumber) {
        DescriptionBlockType descBlockType = DescriptionBlockType.Factory.newInstance();
        descBlockType.setFileIdentifier(proposalNumber + BUDGET_JUSTIFICATION_IDENTIFIER);
        return descBlockType;
    }

    protected OtherDirectCostsDocument.OtherDirectCosts[] getOtherDirectCosts(DevelopmentProposal developmentProposal, List<BudgetLineItem> budgetLineItems) {
        ArrayList<OtherDirectCostsDocument.OtherDirectCosts> otherDirectCostList = new ArrayList<OtherDirectCostsDocument.OtherDirectCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryOther(budgetLineItem)) continue;
            OtherDirectCostsDocument.OtherDirectCosts otherDirectCost = OtherDirectCostsDocument.OtherDirectCosts.Factory.newInstance();
            otherDirectCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            otherDirectCost.setDescription(budgetLineItem.getLineItemDescription());
            otherDirectCost.setType(this.getOtherCategoryMapTypeDescription(developmentProposal, budgetLineItem));
            otherDirectCostList.add(otherDirectCost);
        }
        return otherDirectCostList.toArray(new OtherDirectCostsDocument.OtherDirectCosts[0]);
    }

    private String getOtherCategoryMapTypeDescription(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        BudgetCategoryMap budgetCategoryMap = this.getBudgetCategoryMap(developmentProposal, budgetLineItem);
        if (budgetCategoryMap != null) {
            return budgetCategoryMap.getDescription();
        }
        return "Other Direct Costs";
    }

    private String getCategoryMapTypeDescription(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        BudgetCategoryMap budgetCategoryMap = this.getBudgetCategoryMap(developmentProposal, budgetLineItem);
        if (budgetCategoryMap != null) {
            return budgetCategoryMap.getDescription();
        }
        if (budgetLineItem.getLineItemDescription() != null && !budgetLineItem.getLineItemDescription().equals("")) {
            return budgetLineItem.getLineItemDescription();
        }
        return budgetLineItem.getBudgetCategory().getDescription();
    }

    private BudgetCategoryMap getBudgetCategoryMap(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        boolean isNih = this.getSponsorService().isSponsorNihOsc((Sponsorable)developmentProposal) || this.getSponsorService().isSponsorNihMultiplePi((Sponsorable)developmentProposal);
        String mappingName = isNih ? "NIH_PRINTING" : "NSF_PRINTING";
        BudgetCategoryMap budgetCategoryMap = null;
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("budgetCategoryCode", budgetLineItem.getBudgetCategoryCode());
        categoryMap.put(KEY_MAPPING_NAME, mappingName);
        List budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        if (!budgetCategoryList.isEmpty()) {
            BudgetCategoryMapping budgetCategoryMapping = (BudgetCategoryMapping)budgetCategoryList.get(0);
            categoryMap = new HashMap();
            categoryMap.put(KEY_MAPPING_NAME, mappingName);
            categoryMap.put(KEY_TARGET_CATEGORY_CODE, budgetCategoryMapping.getTargetCategoryCode());
            List budgetCategoryMaps = (List)this.getBusinessObjectService().findMatching(BudgetCategoryMap.class, categoryMap);
            if (!budgetCategoryMaps.isEmpty()) {
                budgetCategoryMap = (BudgetCategoryMap)budgetCategoryMaps.get(0);
            }
        }
        return budgetCategoryMap;
    }

    private SponsorService getSponsorService() {
        return (SponsorService)KraServiceLocator.getService(SponsorService.class);
    }

    protected boolean isBudgetCategoryOther(BudgetLineItem budgetLineItem) {
        boolean isOther = true;
        if (this.isBudgetCategoryEquipment(budgetLineItem) || this.isBudgetCategoryTravel(budgetLineItem) || this.isBudgetCategoryParticipantPatient(budgetLineItem) || budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals("P") || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TUITION)) {
            isOther = false;
        }
        return isOther;
    }

    protected boolean isBudgetCategoryEquipment(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_EQUIPMENT_RENTAL) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_EQUIPMENT);
    }

    protected BigDecimal getTravelTotal(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal cost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryTravel(budgetLineItem)) continue;
            cost = (BudgetDecimal)cost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected boolean isBudgetCategoryTravel(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_TRAVEL_DOMESTIC) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_TRAVEL_FOREIGN);
    }

    protected boolean isBudgetCategoryParticipantPatient(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals("2") || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_STIPENDS) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_SUBSISTANCE) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TRAVEL) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_INPATIENT) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_OUTPATIENT) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TUITION);
    }

    protected EquipmentCostsDocument.EquipmentCosts[] getEquipmentCosts(List<BudgetLineItem> budgetLineItems) {
        ArrayList<EquipmentCostsDocument.EquipmentCosts> equipmentCostList = new ArrayList<EquipmentCostsDocument.EquipmentCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryEquipment(budgetLineItem)) continue;
            EquipmentCostsDocument.EquipmentCosts equipmentCost = EquipmentCostsDocument.EquipmentCosts.Factory.newInstance();
            equipmentCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            equipmentCost.setDescription(budgetLineItem.getLineItemDescription());
            equipmentCost.setEquipmentDescription(budgetLineItem.getBudgetCategory().getDescription());
            equipmentCostList.add(equipmentCost);
        }
        return equipmentCostList.toArray(new EquipmentCostsDocument.EquipmentCosts[0]);
    }

    protected OtherDirectType.Enum getOtherDirectType(String budgetCategoryDesc) {
        OtherDirectType.Enum otherDirectType = OtherDirectType.Enum.forString((String)budgetCategoryDesc);
        if (otherDirectType == null) {
            otherDirectType = OtherDirectType.OTHER;
        }
        return otherDirectType;
    }

    protected TravelType.Enum getTravelType(String budgetCategoryDesc) {
        TravelType.Enum travelType = TravelType.Enum.forString((String)budgetCategoryDesc);
        return travelType;
    }

    protected PersonFullNameType getContactPersonFullName(String lastName, String firstName, String middleName) {
        PersonFullNameType personFullNameType = PersonFullNameType.Factory.newInstance();
        personFullNameType.setLastName(lastName);
        personFullNameType.setFirstName(firstName);
        personFullNameType.setMiddleName(middleName);
        return personFullNameType;
    }

    protected ApplicantOrganizationType.OrganizationContactPerson getOrganizationContactPerson(Rolodex rolodex) {
        ApplicantOrganizationType.OrganizationContactPerson orgContactPerson = ApplicantOrganizationType.OrganizationContactPerson.Factory.newInstance();
        if (rolodex != null) {
            orgContactPerson.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
            orgContactPerson.setPositionTitle(rolodex.getTitle());
            orgContactPerson.setContactInformation(this.getPersonContactInformation(rolodex));
        } else {
            orgContactPerson.setName(this.getContactPersonFullName(DEFAULT_VALUE_UNKNOWN, DEFAULT_VALUE_UNKNOWN, DEFAULT_VALUE_UNKNOWN));
            orgContactPerson.setPositionTitle(DEFAULT_VALUE_UNKNOWN);
            orgContactPerson.setContactInformation(this.getOrganizationPersonContactInformationWithDefaultValues());
        }
        return orgContactPerson;
    }

    protected ContactInfoType getPersonContactInformation(Rolodex rolodex) {
        String officePhone;
        String faxNumber;
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        String emailAddress = rolodex.getEmailAddress();
        if (emailAddress != null) {
            contactInfoType.setEmail(emailAddress);
        }
        if ((faxNumber = rolodex.getFaxNumber()) != null) {
            contactInfoType.setFaxNumber(faxNumber);
        }
        if ((officePhone = rolodex.getPhoneNumber()) != null) {
            contactInfoType.setPhoneNumber(officePhone);
        }
        contactInfoType.setPostalAddress(this.getOrganizationAddress(rolodex));
        return contactInfoType;
    }

    protected ContactInfoType getOrganizationPersonContactInformationWithDefaultValues() {
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        contactInfoType.setEmail(DEFAULT_VALUE_UNKNOWN);
        contactInfoType.setFaxNumber(DEFAULT_VALUE_UNKNOWN);
        contactInfoType.setPhoneNumber(DEFAULT_VALUE_UNKNOWN);
        contactInfoType.setPostalAddress(this.getPostalAddressWithDefaultValues());
        return contactInfoType;
    }

    protected PostalAddressType getOrganizationAddress(Rolodex rolodex) {
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress(rolodex.getAddressLine1(), rolodex.getAddressLine2(), rolodex.getAddressLine3()));
        String city = rolodex.getCity();
        postalAddressType.setCity(city == null || city.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : city);
        postalAddressType.setState(rolodex.getState());
        String postalCode = rolodex.getPostalCode();
        postalAddressType.setPostalCode(postalCode == null || postalCode.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : postalCode);
        String county = rolodex.getCounty();
        postalAddressType.setCountry(county == null || county.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : county);
        return postalAddressType;
    }

    private PostalAddressType getPostalAddressWithDefaultValues() {
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress(DEFAULT_VALUE_UNKNOWN, DEFAULT_VALUE_UNKNOWN, DEFAULT_VALUE_UNKNOWN));
        postalAddressType.setCity(DEFAULT_VALUE_UNKNOWN);
        postalAddressType.setState(DEFAULT_VALUE_UNKNOWN);
        postalAddressType.setPostalCode(DEFAULT_VALUE_UNKNOWN);
        postalAddressType.setCountry(DEFAULT_VALUE_UNKNOWN);
        return postalAddressType;
    }

    private String[] getStreetAddress(String address1, String address2, String address3) {
        ArrayList<String> streetAddress = new ArrayList<String>();
        if (address1 != null) {
            streetAddress.add(address1);
        }
        if (address2 != null) {
            streetAddress.add(address2);
        }
        if (address3 != null) {
            streetAddress.add(address3);
        }
        return streetAddress.toArray(new String[0]);
    }

    protected OtherAgencyQuestionsType getOtherAgencyQuestionsForResearchCoverPage(DevelopmentProposal developmentProposal) {
        OtherAgencyQuestionsType otherAgencyQuestionsType = OtherAgencyQuestionsType.Factory.newInstance();
        otherAgencyQuestionsType.setOtherAgencyIndicator(false);
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (!proposalYnq.getQuestionId().equals(PROPOSALQUESTION_ID15) || proposalYnq.getAnswer() == null) continue;
            otherAgencyQuestionsType.setOtherAgencyIndicator(proposalYnq.getAnswer().equals(ANSWER_INDICATOR_VALUE));
            otherAgencyQuestionsType.setOtherAgencyNames(proposalYnq.getExplanation() == null ? EMPTY_STRING : proposalYnq.getExplanation());
        }
        return otherAgencyQuestionsType;
    }

    protected boolean getAnswerFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getAnswer().equals(ANSWER_INDICATOR_VALUE);
    }

    protected ProjectSurveyDocument.ProjectSurvey getProjectSurvey(DevelopmentProposal developmentProposal) {
        ProjectSurveyDocument.ProjectSurvey projectSurvey = ProjectSurveyDocument.ProjectSurvey.Factory.newInstance();
        List proposalYnqs = developmentProposal.getProposalYnqs();
        if (!proposalYnqs.isEmpty()) {
            for (ProposalYnq proposalYnq : proposalYnqs) {
                String explanation;
                boolean questionAnswered = false;
                String answer = proposalYnq.getAnswer();
                String questionId = proposalYnq.getQuestionId();
                String string = explanation = proposalYnq.getExplanation() == null ? EMPTY_STRING : proposalYnq.getExplanation();
                if (ANSWER_INDICATOR_VALUE.equals(answer)) {
                    questionAnswered = true;
                }
                this.setProjectSurvey(projectSurvey, questionAnswered, questionId, explanation);
            }
        } else {
            this.setDefaultValuesToProjectSurvey(projectSurvey);
        }
        if (this.getProposalYNQ(LOBBYING_ACTIVITIES) != null) {
            projectSurvey.setH4Question(true);
        }
        projectSurvey.setCBQuestion(false);
        projectSurvey.setCBText(DEFAULT_ANSWER);
        projectSurvey.setEnvExemptionQuestion(false);
        projectSurvey.setEnvExemptionCBText(DEFAULT_ANSWER);
        projectSurvey.setEnvImpactQuestion(false);
        projectSurvey.setEnvImpactText(DEFAULT_ANSWER);
        return projectSurvey;
    }

    private void setDefaultValuesToProjectSurvey(ProjectSurveyDocument.ProjectSurvey projectSurvey) {
        projectSurvey.setG3Question(false);
        projectSurvey.setG3Text(DEFAULT_ANSWER);
        projectSurvey.setG4Question(false);
        projectSurvey.setG4Text(DEFAULT_ANSWER);
        projectSurvey.setG6Question(false);
        projectSurvey.setG6Text(DEFAULT_ANSWER);
        projectSurvey.setG8Question(false);
        projectSurvey.setG8Text(DEFAULT_ANSWER);
        projectSurvey.setH1Question(false);
        projectSurvey.setH1Text(DEFAULT_ANSWER);
    }

    private void setProjectSurvey(ProjectSurveyDocument.ProjectSurvey projectSurvey, boolean questionAnswered, String questionId, String explanation) {
        if (questionId.equals(HAZARDOUS_MATERIALS)) {
            projectSurvey.setG3Question(questionAnswered);
            projectSurvey.setG3Text(explanation);
        } else if (questionId.equals(GENETICALLY_ENGINEERED)) {
            projectSurvey.setG4Question(questionAnswered);
            projectSurvey.setG4Text(explanation);
        } else if (questionId.equals(HISTORICAL_SITES)) {
            projectSurvey.setG6Question(questionAnswered);
            projectSurvey.setG6Text(explanation);
        } else if (questionId.equals(PROPRIETARY_INFO)) {
            projectSurvey.setG8Question(questionAnswered);
            projectSurvey.setG8Text(explanation);
        } else if (questionId.equals(INTERNATIONAL_ACTIVITIES)) {
            projectSurvey.setH1Question(questionAnswered);
            projectSurvey.setH1Text(explanation);
        } else if (questionId.equals(LOBBYING_ACTIVITIES)) {
            projectSurvey.setH4Question(questionAnswered);
        } else if (questionId.equals(NSFSMALL_GRANT)) {
            projectSurvey.setSmallGrantQuestion(questionAnswered);
        } else if (questionId.equals(NSF_BEGINNING_INV)) {
            projectSurvey.setNSFbeginningInvestQuestion(questionAnswered);
        } else if (questionId.equals(STEMCELL)) {
            projectSurvey.setStemCellQuestion(questionAnswered);
            projectSurvey.setStemCellText(explanation);
        }
    }

    private ProposalYnq getProposalYNQ(String questionId) {
        ProposalYnq proposalYnq = null;
        HashMap<String, String> proposalYnqMap = new HashMap<String, String>();
        proposalYnqMap.put(QUESTION_ID_PARAMETER, questionId);
        proposalYnqMap.put(ANSWER_PARAMETER, ANSWER_INDICATOR_VALUE);
        List proposalYnqs = (List)this.businessObjectService.findMatching(ProposalYnq.class, proposalYnqMap);
        if (proposalYnqs != null && !proposalYnqs.isEmpty()) {
            proposalYnq = (ProposalYnq)proposalYnqs.get(0);
        }
        return proposalYnq;
    }

    protected BigDecimal getSalaryWagesTotal(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal salaryAndWagesTotal = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                salaryAndWagesTotal = (BudgetDecimal)salaryAndWagesTotal.add((AbstractKualiDecimal)this.getSalaryWagesTotalForLineItem(budgetPersDetails));
            }
        }
        return salaryAndWagesTotal.bigDecimalValue();
    }

    private BudgetDecimal getSalaryWagesTotalForLineItem(BudgetPersonnelDetails budgetPersDetails) {
        BudgetDecimal salaryAndWages = BudgetDecimal.ZERO;
        salaryAndWages = (BudgetDecimal)salaryAndWages.add((AbstractKualiDecimal)budgetPersDetails.getSalaryRequested());
        salaryAndWages = (BudgetDecimal)salaryAndWages.add((AbstractKualiDecimal)this.getFringeCost(budgetPersDetails));
        return salaryAndWages;
    }

    protected BudgetDecimal getFringeCost(BudgetPersonnelDetails budgetPersDetails) {
        BudgetDecimal fringe = BudgetDecimal.ZERO;
        for (BudgetPersonnelRateAndBase budgetPersRateBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
            if (!this.isRateAndBaseOfRateClassTypeEB((AbstractBudgetRateAndBase)budgetPersRateBase) && !this.isRateAndBaseOfRateClassTypeVacation((AbstractBudgetRateAndBase)budgetPersRateBase)) continue;
            fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)budgetPersRateBase.getCalculatedCost());
        }
        return fringe;
    }

    protected BudgetDecimal getTotalSalaryRequested(BudgetPeriod budgetPeriod) {
        BudgetDecimal salary = BudgetDecimal.ZERO;
        List lineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            List persDetailsList = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : persDetailsList) {
                salary = (BudgetDecimal)salary.add((AbstractKualiDecimal)budgetPersonnelDetails.getSalaryRequested());
            }
        }
        return salary;
    }

    protected BudgetDecimal getTotalFringe(BudgetPeriod budgetPeriod) {
        BudgetDecimal fringe = BudgetDecimal.ZERO;
        List lineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            List persDetailsList = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : persDetailsList) {
                for (BudgetPersonnelRateAndBase budgetPersRateBase : budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList()) {
                    if (!this.isRateAndBaseOfRateClassTypeEBVacationOnLA(budgetPersRateBase)) continue;
                    fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)budgetPersRateBase.getCalculatedCost());
                }
            }
        }
        return fringe;
    }

    private boolean isRateAndBaseOfRateClassTypeEBVacationOnLA(BudgetPersonnelRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeEB : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType()) && !rateAndBase.getRateTypeCode().equals("3") || RateClassType.VACATION.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType()) && !rateAndBase.getRateTypeCode().equals("2");
    }

    private boolean isRateAndBaseOfRateClassTypeEB(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeEB : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType()) && !rateAndBase.getRateTypeCode().equals("3");
    }

    private boolean isRateAndBaseOfRateClassTypeVacation(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeVacation : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.VACATION.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType()) && !rateAndBase.getRateTypeCode().equals("2");
    }

    protected boolean isRateAndBaseOfRateClassTypeOverhead(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeOverhead : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.OVERHEAD.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType());
    }

    protected BigDecimal getParticipantPatientTotal(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal cost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryParticipantPatient(budgetLineItem)) continue;
            cost = (BudgetDecimal)cost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected BigDecimal getOtherDirectTotal(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal cost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryOther(budgetLineItem)) continue;
            cost = (BudgetDecimal)cost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected TravelCostsDocument.TravelCosts[] getTravelCosts(List<BudgetLineItem> budgetLineItems) {
        ArrayList<TravelCostsDocument.TravelCosts> travelCostList = new ArrayList<TravelCostsDocument.TravelCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryTravel(budgetLineItem)) continue;
            TravelCostsDocument.TravelCosts travelCost = TravelCostsDocument.TravelCosts.Factory.newInstance();
            if (CATEGORY_CODE_TRAVEL_FOREIGN.equals(budgetLineItem.getBudgetCategoryCode())) {
                travelCost.setType(TravelType.FOREIGN);
            } else {
                travelCost.setType(TravelType.DOMESTIC);
            }
            travelCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            travelCost.setDescription(budgetLineItem.getLineItemDescription());
            travelCostList.add(travelCost);
        }
        return travelCostList.toArray(new TravelCostsDocument.TravelCosts[0]);
    }

    protected ParticipantPatientCostsDocument.ParticipantPatientCosts[] getParticipantPatientCost(DevelopmentProposal developmentProposal, List<BudgetLineItem> budgetLineItems) {
        ArrayList<ParticipantPatientCostsDocument.ParticipantPatientCosts> participantPatientCostList = new ArrayList<ParticipantPatientCostsDocument.ParticipantPatientCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryParticipantPatient(budgetLineItem)) continue;
            ParticipantPatientCostsDocument.ParticipantPatientCosts participantPatientCost = ParticipantPatientCostsDocument.ParticipantPatientCosts.Factory.newInstance();
            participantPatientCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            participantPatientCost.setDescription(budgetLineItem.getLineItemDescription());
            participantPatientCost.setType(this.getParticipantPatientType(developmentProposal, budgetLineItem));
            participantPatientCostList.add(participantPatientCost);
        }
        return participantPatientCostList.toArray(new ParticipantPatientCostsDocument.ParticipantPatientCosts[0]);
    }

    private ParticipantType.Enum getParticipantPatientType(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        BudgetCategoryMap budgetCategoryMap = this.getBudgetCategoryMap(developmentProposal, budgetLineItem);
        ParticipantType.Enum participantType = null;
        participantType = budgetCategoryMap != null ? (budgetCategoryMap.getTargetCategoryCode().equals("41") ? ParticipantType.INPATIENT : (budgetCategoryMap.getTargetCategoryCode().equals("90") ? ParticipantType.OUTPATIENT : (budgetCategoryMap.getTargetCategoryCode().equals("79") ? ParticipantType.SUBSISTENCE : (budgetCategoryMap.getTargetCategoryCode().equals("77") ? ParticipantType.TRAVEL : (budgetCategoryMap.getTargetCategoryCode().equals("75") ? ParticipantType.STIPENDS : ParticipantType.OTHER))))) : ParticipantType.OTHER;
        return participantType;
    }

    protected BigDecimal getEquipmentTotal(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal cost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryEquipment(budgetLineItem)) continue;
            cost = (BudgetDecimal)cost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected List<OrganizationYnq> getOrganizationYNQ(String questionId) {
        Object organizationYnq = null;
        HashMap<String, String> organizationYnqMap = new HashMap<String, String>();
        organizationYnqMap.put(ORGANIZATION_ID_PARAMETER, questionId);
        List organizationYnqs = (List)this.businessObjectService.findMatching(OrganizationYnq.class, organizationYnqMap);
        return organizationYnqs;
    }

    protected ProjectRoleType.Enum getProjectRoleType(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        ProjectRoleType.Enum roleType = ProjectRoleType.Enum.forString((String)budgetPerson.getRole());
        if (this.isPI(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.PI_PD;
        } else if (this.isCoPI(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.CO_PI_PD;
        } else if (this.isKeyPerson(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.KEY_PERSON;
        } else if (roleType == null) {
            roleType = ProjectRoleType.OTHER;
        }
        return roleType;
    }

    private boolean isKeyPerson(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        List proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.isSamePerson(budgetPerson, proposalPerson)) continue;
            return true;
        }
        return false;
    }

    private boolean isCoPI(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        List proposalPersons = developmentProposal.getInvestigators();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.isSamePerson(budgetPerson, proposalPerson)) continue;
            return true;
        }
        return false;
    }

    private boolean isPI(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        ProposalPerson proposalPerson = developmentProposal.getPrincipalInvestigator();
        return this.isSamePerson(budgetPerson, proposalPerson);
    }

    private boolean isSamePerson(BudgetPerson budgetPerson, ProposalPerson proposalPerson) {
        if (proposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(budgetPerson.getPersonId())) {
            return true;
        }
        return proposalPerson.getRolodexId() != null && proposalPerson.getRolodexId().equals(budgetPerson.getRolodexId());
    }

    protected CoreApplicationCategoryType getApplicationCategoryForResearchCoverPage(String propTypeDesc) {
        CoreApplicationCategoryType coreApplicationCategoryType = CoreApplicationCategoryType.Factory.newInstance();
        coreApplicationCategoryType.setCategoryIdentifier(propTypeDesc == null ? EMPTY_STRING : propTypeDesc);
        return coreApplicationCategoryType;
    }

    protected void setApplicantSubmissionQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreApplicantSubmissionQualifiersType coreApplicantSubmissionQualifiersType) {
        coreApplicantSubmissionQualifiersType.setApplicationDate(this.getDateTimeService().getCalendar((Date)developmentProposal.getRequestedEndDateInitial()));
    }

    protected void setFederalAgencyReceiptQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreFederalAgencyReceiptQualifiersType coreFederalAgencyReceiptQualifiersType) {
        coreFederalAgencyReceiptQualifiersType.setAgencyName(developmentProposal.getSponsor().getAcronym());
        if (developmentProposal.getS2sOpportunity() != null && developmentProposal.getS2sOpportunity().getOpeningDate() != null) {
            coreFederalAgencyReceiptQualifiersType.setAgencyReceiptDate(this.getDateTimeService().getCalendar((Date)developmentProposal.getS2sOpportunity().getOpeningDate()));
        }
    }

    protected CoreStateReceiptQualifiersType setStateReceiptQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreStateReceiptQualifiersType coreStateReceiptQualifiersType) {
        if (developmentProposal.getDeadlineDate() != null) {
            coreStateReceiptQualifiersType.setStateReceiptDate(this.getDateTimeService().getCalendar((Date)developmentProposal.getDeadlineDate()));
        }
        return coreStateReceiptQualifiersType;
    }

    protected void setStateIntergovernmentalReviewForResearchCoverPage(DevelopmentProposal developmentProposal, CoreStateIntergovernmentalReviewType coreStateIntergovernmentalReviewType) {
        if (developmentProposal.getDeadlineDate() != null) {
            coreStateIntergovernmentalReviewType.setReviewAvailabilityDate(this.getDateTimeService().getCalendar((Date)developmentProposal.getDeadlineDate()));
        }
        coreStateIntergovernmentalReviewType.setSubjectToReviewQuestion(true);
    }

    protected CoreFederalDebtDelinquencyQuestionsType setFederalDebtDelinquencyQuestionForResearchCoverPage(DevelopmentProposal developmentProposal, CoreFederalDebtDelinquencyQuestionsType coreFederalDebtDelinquencyQuestionsType) {
        CoreFederalDebtDelinquencyQuestionsType ccoreFedDebtQuestionsType = CoreFederalDebtDelinquencyQuestionsType.Factory.newInstance();
        ccoreFedDebtQuestionsType.setApplicantDelinquentIndicator(false);
        return ccoreFedDebtQuestionsType;
    }

    protected CoreProjectDatesType getProjectDatesForResearchCoverPage(java.sql.Date startDate, java.sql.Date endDate) {
        CoreProjectDatesType coreProjectDatesType = CoreProjectDatesType.Factory.newInstance();
        coreProjectDatesType.setProjectStartDate(this.getDateTimeService().getCalendar((Date)startDate));
        coreProjectDatesType.setProjectEndDate(this.getDateTimeService().getCalendar((Date)endDate));
        return coreProjectDatesType;
    }

    protected CoreBudgetTotalsType getBudgetTotalsForResearchCoverPage(Budget budget) {
        CoreBudgetTotalsType coreBudgetTotalsType = CoreBudgetTotalsType.Factory.newInstance();
        if (budget != null && budget.getVersionNumber() > 0L) {
            if (!budget.getModularBudgetFlag().booleanValue()) {
                coreBudgetTotalsType.setApplicantCost(budget.getCostSharingAmount().bigDecimalValue());
                coreBudgetTotalsType.setFederalCost(budget.getTotalCost().bigDecimalValue());
                coreBudgetTotalsType.setOtherCost(budget.getTotalIndirectCost().bigDecimalValue());
            }
        } else {
            coreBudgetTotalsType.setApplicantCost(BigDecimal.ZERO);
            coreBudgetTotalsType.setFederalCost(BigDecimal.ZERO);
            coreBudgetTotalsType.setOtherCost(BigDecimal.ZERO);
        }
        coreBudgetTotalsType.setLocalCost(BigDecimal.ZERO);
        coreBudgetTotalsType.setProgramIncome(BigDecimal.ZERO);
        coreBudgetTotalsType.setStateCost(BigDecimal.ZERO);
        return coreBudgetTotalsType;
    }

    protected ProjectSiteType getProjectSiteForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProposalSite performingOrg = developmentProposal.getPerformingOrganization();
        ProjectSiteType projectSiteType = ProjectSiteType.Factory.newInstance();
        Organization organization = performingOrg.getOrganization();
        projectSiteType.setOrganizationName(organization.getOrganizationName());
        projectSiteType.setCongressionalDistrict(organization.getCongressionalDistrict());
        projectSiteType.setPostalAddress(this.getOrganizationAddress(organization.getRolodex()));
        return projectSiteType;
    }

    protected PostalAddressType getPostalAddress(ProposalPerson proposalPerson) {
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress(proposalPerson.getAddressLine1(), proposalPerson.getAddressLine2(), proposalPerson.getAddressLine3()));
        String city = proposalPerson.getCity();
        postalAddressType.setCity(city == null || city.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : city);
        postalAddressType.setState(proposalPerson.getState());
        String postalCode = proposalPerson.getPostalCode();
        postalAddressType.setPostalCode(postalCode == null || postalCode.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : postalCode);
        String country = proposalPerson.getCountryCode();
        postalAddressType.setCountry(country == null || country.trim().equals("") ? DEFAULT_VALUE_UNKNOWN : country);
        return postalAddressType;
    }

    protected ContactInfoType getPersonContactInformation(ProposalPerson proposalPerson) {
        String officePhone;
        String faxNumber;
        if (proposalPerson == null) {
            return null;
        }
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        String emailAddress = proposalPerson.getEmailAddress();
        if (emailAddress != null) {
            contactInfoType.setEmail(emailAddress);
        }
        if ((faxNumber = proposalPerson.getFaxNumber()) != null) {
            contactInfoType.setFaxNumber(faxNumber);
        }
        if ((officePhone = proposalPerson.getOfficePhone()) != null) {
            contactInfoType.setPhoneNumber(officePhone);
        }
        contactInfoType.setPostalAddress(this.getPostalAddress(proposalPerson));
        return contactInfoType;
    }

    protected void sortKeyPersonWithName(List<ProposalPerson> proposalPersonList) {
        Collections.sort(proposalPersonList, new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<KeyPersonInfo> getBudgetPersonsForCategoryMap(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, String categoryCode, String categoryMappingName) {
        boolean personAlreadyAdded = false;
        KeyPersonInfo keyPerson = null;
        ArrayList<KeyPersonInfo> keyPersons = new ArrayList<KeyPersonInfo>();
        List proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            keyPerson = this.getKeyPersonFromProposalPerson(proposalPerson);
            keyPersons.add(keyPerson);
        }
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_TARGET_CATEGORY_CODE, categoryCode);
        categoryMap.put(KEY_MAPPING_NAME, categoryMappingName);
        List budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            boolean lineItemIsSeniorPersonnel = false;
            for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                lineItemIsSeniorPersonnel = true;
                break;
            }
            if (!lineItemIsSeniorPersonnel) continue;
            for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                personAlreadyAdded = false;
                for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
                    if (!this.s2SUtilService.proposalPersonEqualsBudgetPerson(proposalPerson, budgetPersonnelDetails)) continue;
                    personAlreadyAdded = true;
                    break;
                }
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                if (personAlreadyAdded) continue;
                if (budgetPersonnelDetails.getBudgetPerson().getRolodexId() != null) {
                    keyPerson = this.getKeyPersonFromRolodex(budgetPersonnelDetails);
                    keyPersons.add(keyPerson);
                    continue;
                }
                if (StringUtils.isNotBlank((String)budgetPersonnelDetails.getBudgetPerson().getTbnId())) {
                    keyPerson = this.getKeyPersonFromTbnPerson(budgetPersonnelDetails);
                    keyPersons.add(keyPerson);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)budgetPersonnelDetails.getBudgetPerson().getPersonId())) continue;
                keyPerson = this.getKeyPersonFromKcPerson(budgetPersonnelDetails.getPersonId());
                keyPersons.add(keyPerson);
            }
        }
        Iterator i$ = keyPersons.iterator();
        while (i$.hasNext()) {
            KeyPersonInfo keyPersonInfo;
            KeyPersonInfo keyPersonComp = keyPersonInfo = (KeyPersonInfo)i$.next();
            CompensationInfo compensationInfo = new CompensationInfo();
            this.setCompensation(keyPersonComp, budgetPeriod, compensationInfo);
            keyPersonComp.setAcademicMonths(compensationInfo.getAcademicMonths());
            keyPersonComp.setCalendarMonths(compensationInfo.getCalendarMonths());
            keyPersonComp.setSummerMonths(compensationInfo.getSummerMonths());
            keyPersonComp.setBaseSalary(compensationInfo.getBaseSalary());
            keyPersonComp.setRequestedSalary(compensationInfo.getRequestedSalary());
            keyPersonComp.setFundsRequested(compensationInfo.getFundsRequested());
            keyPersonComp.setFringe(compensationInfo.getFringe());
            keyPersonComp.setCostSharingAmount(compensationInfo.getCostSharingAmount());
            keyPersonComp.setNonFundsRequested(compensationInfo.getNonFundsRequested());
            keyPersonComp.setFringeCostSharing(compensationInfo.getFringeCostSharing());
        }
        return keyPersons;
    }

    protected List<KeyPersonInfo> getBudgetPersonsForCategoryMap(DevelopmentProposal developmentProposal, Budget budget, String categoryCode, String categoryMappingName) {
        boolean personAlreadyAdded = false;
        KeyPersonInfo keyPerson = null;
        ArrayList<KeyPersonInfo> keyPersons = new ArrayList<KeyPersonInfo>();
        List proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            keyPerson = this.getKeyPersonFromProposalPerson(proposalPerson);
            keyPersons.add(keyPerson);
        }
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_TARGET_CATEGORY_CODE, categoryCode);
        categoryMap.put(KEY_MAPPING_NAME, categoryMappingName);
        List budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        List budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                boolean lineItemIsSeniorPersonnel = false;
                for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                    if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                    lineItemIsSeniorPersonnel = true;
                    break;
                }
                if (!lineItemIsSeniorPersonnel) continue;
                for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                    personAlreadyAdded = false;
                    for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
                        if (!this.s2SUtilService.proposalPersonEqualsBudgetPerson(proposalPerson, budgetPersonnelDetails)) continue;
                        personAlreadyAdded = true;
                    }
                    budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                    if (personAlreadyAdded) continue;
                    if (budgetPersonnelDetails.getBudgetPerson().getRolodexId() != null) {
                        keyPerson = this.getKeyPersonFromRolodex(budgetPersonnelDetails);
                        this.addToKeyPersonList(keyPerson, keyPersons);
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)budgetPersonnelDetails.getBudgetPerson().getTbnId())) {
                        keyPerson = this.getKeyPersonFromTbnPerson(budgetPersonnelDetails);
                        this.addToKeyPersonList(keyPerson, keyPersons);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)budgetPersonnelDetails.getBudgetPerson().getPersonId())) continue;
                    keyPerson = this.getKeyPersonFromKcPerson(budgetPersonnelDetails.getPersonId());
                    this.addToKeyPersonList(keyPerson, keyPersons);
                }
            }
        }
        for (KeyPersonInfo keyPersonComp : keyPersons) {
            CompensationInfo compensationInfo = this.getCompensation(keyPersonComp, budget);
            keyPersonComp.setAcademicMonths(compensationInfo.getAcademicMonths());
            keyPersonComp.setCalendarMonths(compensationInfo.getCalendarMonths());
            keyPersonComp.setSummerMonths(compensationInfo.getSummerMonths());
            keyPersonComp.setBaseSalary(compensationInfo.getBaseSalary());
            keyPersonComp.setRequestedSalary(compensationInfo.getRequestedSalary());
            keyPersonComp.setFundsRequested(compensationInfo.getFundsRequested());
            keyPersonComp.setFringe(compensationInfo.getFringe());
            keyPersonComp.setCostSharingAmount(compensationInfo.getCostSharingAmount());
            keyPersonComp.setNonFundsRequested(compensationInfo.getNonFundsRequested());
            keyPersonComp.setFringeCostSharing(compensationInfo.getFringeCostSharing());
        }
        return keyPersons;
    }

    private void addToKeyPersonList(KeyPersonInfo keyPerson, List<KeyPersonInfo> keyPersons) {
        if (!keyPersons.contains(keyPerson)) {
            keyPersons.add(keyPerson);
        }
    }

    private KeyPersonInfo getKeyPersonFromProposalPerson(ProposalPerson proposalPerson) {
        KeyPersonInfo keyPerson = null;
        if (proposalPerson.getRolodexId() != null) {
            proposalPerson.refreshReferenceObject("rolodex");
            Rolodex rolodexPerson = (Rolodex)this.getBusinessObjectService().findBySinglePrimaryKey(Rolodex.class, (Object)proposalPerson.getRolodexId());
            keyPerson = this.getKeyPeronInfo(rolodexPerson);
        } else if (StringUtils.isNotBlank((String)proposalPerson.getPersonId())) {
            keyPerson = this.getKeyPersonFromKcPerson(proposalPerson.getPersonId());
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromKcPerson(String personId) {
        KeyPersonInfo keyPerson = null;
        KcPerson kcPerson = null;
        try {
            kcPerson = this.kcPersonService.getKcPersonByPersonId(personId);
        }
        catch (Exception e) {
            LOG.error((Object)("Person not found " + e));
        }
        if (kcPerson != null) {
            keyPerson = new KeyPersonInfo();
            keyPerson.setPersonId(kcPerson.getPersonId());
            keyPerson.setFirstName(kcPerson.getFirstName() == null ? DEFAULT_VALUE_UNKNOWN : kcPerson.getFirstName());
            keyPerson.setLastName(kcPerson.getLastName() == null ? DEFAULT_VALUE_UNKNOWN : kcPerson.getLastName());
            keyPerson.setMiddleName(kcPerson.getMiddleName());
            keyPerson.setNonMITPersonFlag(false);
            keyPerson.setRole(KEYPERSON_OTHER);
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromTbnPerson(BudgetPersonnelDetails budgetPersonnelDetails) {
        KeyPersonInfo keyPerson = null;
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put("tbnId", budgetPersonnelDetails.getBudgetPerson().getTbnId());
        TbnPerson tbnPerson = (TbnPerson)this.businessObjectService.findByPrimaryKey(TbnPerson.class, searchMap);
        if (tbnPerson != null) {
            keyPerson = new KeyPersonInfo();
            keyPerson.setPersonId(tbnPerson.getJobCode());
            String[] tbnNames = tbnPerson.getPersonName().split(EMPTY_STRING);
            int nameIndex = 0;
            keyPerson.setPersonId(tbnPerson.getTbnId());
            keyPerson.setFirstName(tbnNames.length >= 1 ? tbnNames[nameIndex++] : DEFAULT_VALUE_UNKNOWN);
            keyPerson.setMiddleName(tbnNames.length >= 3 ? tbnNames[nameIndex++] : EMPTY_STRING);
            keyPerson.setLastName(tbnNames.length >= 2 ? tbnNames[nameIndex++] : DEFAULT_VALUE_UNKNOWN);
            keyPerson.setRole(tbnPerson.getPersonName());
            keyPerson.setNonMITPersonFlag(false);
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromRolodex(BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.getBudgetPerson().refreshReferenceObject("rolodex");
        Rolodex rolodexPerson = budgetPersonnelDetails.getBudgetPerson().getRolodex();
        KeyPersonInfo keyPerson = this.getKeyPeronInfo(rolodexPerson);
        return keyPerson;
    }

    private KeyPersonInfo getKeyPeronInfo(Rolodex rolodexPerson) {
        KeyPersonInfo keyPerson = new KeyPersonInfo();
        keyPerson.setRolodexId(rolodexPerson.getRolodexId());
        keyPerson.setFirstName(rolodexPerson.getFirstName() == null ? DEFAULT_VALUE_UNKNOWN : rolodexPerson.getFirstName());
        keyPerson.setLastName(rolodexPerson.getLastName() == null ? DEFAULT_VALUE_UNKNOWN : rolodexPerson.getLastName());
        keyPerson.setMiddleName(rolodexPerson.getMiddleName());
        keyPerson.setRole(StringUtils.isNotBlank((String)rolodexPerson.getTitle()) ? rolodexPerson.getTitle() : KEYPERSON_OTHER);
        keyPerson.setNonMITPersonFlag(true);
        return keyPerson;
    }

    protected List<BudgetCategoryMapping> getBudgetCategoryMappings(Map<String, String> conditionMap) {
        Collection budgetCategoryCollection = this.businessObjectService.findMatching(BudgetCategoryMapping.class, conditionMap);
        ArrayList<BudgetCategoryMapping> budgetCategoryMappings = new ArrayList<BudgetCategoryMapping>();
        if (budgetCategoryCollection != null) {
            budgetCategoryMappings.addAll(budgetCategoryCollection);
        }
        return budgetCategoryMappings;
    }

    private void setCompensation(KeyPersonInfo keyPerson, BudgetPeriod budgetPeriod, CompensationInfo compensationInfo) {
        this.setCompensationForPeriod(keyPerson, budgetPeriod, compensationInfo);
    }

    private CompensationInfo getCompensation(KeyPersonInfo keyPerson, Budget budget) {
        CompensationInfo compensationInfo = new CompensationInfo();
        List budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            this.setCompensationForPeriod(keyPerson, budgetPeriod, compensationInfo);
        }
        return compensationInfo;
    }

    private void setCompensationForPeriod(KeyPersonInfo keyPerson, BudgetPeriod budgetPeriod, CompensationInfo compensationInfo) {
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetails personDetails : lineItem.getBudgetPersonnelDetailsList()) {
                if (!this.s2SUtilService.keyPersonEqualsBudgetPerson(keyPerson, personDetails)) continue;
                BudgetDecimal numberOfMonths = this.s2SUtilService.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate());
                if (personDetails.getPeriodTypeCode().equals("2")) {
                    BudgetDecimal academicMonths = personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01));
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setAcademicMonths((BudgetDecimal)compensationInfo.getAcademicMonths().add((AbstractKualiDecimal)academicMonths));
                    }
                } else if (personDetails.getPeriodTypeCode().equals(PERIOD_TYPE_SUMMER_MONTHS)) {
                    BudgetDecimal summerMonths = personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01));
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setSummerMonths((BudgetDecimal)compensationInfo.getSummerMonths().add((AbstractKualiDecimal)summerMonths));
                    }
                } else {
                    BudgetDecimal calendarMonths = personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01));
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setCalendarMonths((BudgetDecimal)compensationInfo.getCalendarMonths().add((AbstractKualiDecimal)calendarMonths));
                    }
                }
                BudgetDecimal totalSal = personDetails.getSalaryRequested();
                if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                    compensationInfo.setRequestedSalary((BudgetDecimal)compensationInfo.getRequestedSalary().add((AbstractKualiDecimal)totalSal));
                }
                BudgetDecimal totalSalCostSharing = personDetails.getCostSharingAmount();
                compensationInfo.setCostSharingAmount((BudgetDecimal)compensationInfo.getCostSharingAmount().add((AbstractKualiDecimal)totalSalCostSharing));
                for (BudgetPersonnelCalculatedAmount personCalculatedAmt : personDetails.getBudgetPersonnelCalculatedAmounts()) {
                    personCalculatedAmt.refreshReferenceObject("rateClass");
                    if ((!personCalculatedAmt.getRateClass().getRateClassType().equals(RATE_CLASS_TYPE_EMPLOYEE_BENEFITS) || personCalculatedAmt.getRateTypeCode().equals("3")) && (!personCalculatedAmt.getRateClass().getRateClassType().equals(RATE_CLASS_TYPE_VACATION) || personCalculatedAmt.getRateTypeCode().equals("2"))) continue;
                    BudgetDecimal fringe = personCalculatedAmt.getCalculatedCost();
                    compensationInfo.setFringe((BudgetDecimal)compensationInfo.getFringe().add((AbstractKualiDecimal)fringe));
                    BudgetDecimal fringeCostSharing = personCalculatedAmt.getCalculatedCostSharing();
                    compensationInfo.setFringeCostSharing((BudgetDecimal)compensationInfo.getFringeCostSharing().add((AbstractKualiDecimal)fringeCostSharing));
                }
                BudgetPerson budgetPerson = personDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                compensationInfo.setBaseSalary(budgetPerson.getCalculationBase());
                String apptTypeCode = budgetPerson.getAppointmentType().getAppointmentTypeCode();
                if (apptTypeCode.equals(APPOINTMENT_TYPE_SUM_EMPLOYEE) || apptTypeCode.equals(APPOINTMENT_TYPE_TMP_EMPLOYEE)) continue;
                compensationInfo.setBaseSalary(budgetPerson.getCalculationBase());
            }
        }
        compensationInfo.setFundsRequested((BudgetDecimal)compensationInfo.getRequestedSalary().add((AbstractKualiDecimal)compensationInfo.getFringe()));
        compensationInfo.setNonFundsRequested((BudgetDecimal)compensationInfo.getCostSharingAmount().add((AbstractKualiDecimal)compensationInfo.getFringeCostSharing()));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public S2SUtilService getS2SUtilService() {
        return this.s2SUtilService;
    }

    public void setS2SUtilService(S2SUtilService utilService) {
        this.s2SUtilService = utilService;
    }
}

