/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.xmlstream;

import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.AssuranceType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.ContactInfoType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.PostalAddressType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.AbstractType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ApplicantOrganizationType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.AuthorizedOrganizationalRepresentativeType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.BudgetPeriodType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.BudgetSummaryType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.FundingOpportunityDetailsType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.HumanSubjectsType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.KeyPersonBiosketchType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.KeyPersonType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.NSFOtherPersonnelType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.NSFSeniorPersonnelType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.OrgAssurancesType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ProgramDirectorPrincipalInvestigatorDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ProjectDescriptionDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ResearchAndRelatedProjectDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.ResearchCoverPageDocument;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.SalariesAndWagesType;
import gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.SignatureType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.DescriptionBlockType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.KeyPersonType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OrgAssurancesType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.PersonFullNameType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectRoleType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSiteType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProposalPersonType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.AbstractResearchAndRelatedStream;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.NIHResearchAndRelatedXmlStream;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

/*
 * Exception performing whole class analysis ignored.
 */
public class NIHResearchAndRelatedXmlStream
extends AbstractResearchAndRelatedStream {
    private static final Log LOG = LogFactory.getLog(NIHResearchAndRelatedXmlStream.class);
    private static final String ORGANIZATION_QUESTION_ID_H5 = "H5";
    private static final String ORGANIZATION_QUESTION_ID_I8 = "I8";
    private static final String DEFAULT_VALUE_KEY_PERSON_FLAG_CODE = "true";
    private static final String KEY_PERSON_FLAG_DESCRIPTION_VALUE_COLLABORATOR = "Collaborator/Other";
    private static final String KEY_PERSON_FLAG_DESCRIPTION_VALUE_KEY_PERSON = "Key Person";
    private static final String KEY_PERSON_FLAG_CODE_VALUE_FALSE = "false";
    private static final String GENERAL_CERTIFICATION_QUESTION_ID = "H6";
    private static final String LOBBYING_QUESTION_ID = "H0";
    private static final String REFERENCES_BLOCK_TYPE = "references";
    private static final String EQUIPMENT_BLOCK_TYPE = "equipment";
    private static final String FACILITIES_BLOCK_TYPE = "facilities";
    private static final String PROJECT_SUMMARY_BLOCK_TYPE = "summary";
    private static final String SPECIAL_REVIEW_CODE_1 = "1";
    private static final String OTHER_PERSONNEL_CATEGORY_CODE = "30";
    private static final String APPROVAL_TYPE_EXEMPT = "4";
    protected static final String PROPOSAL_YNQ_QUESTION_16 = "16";
    private static final String ACADEMIC_PERIOD = "2";
    private static final String CALENDAR_PERIOD = "3";
    private static final String PROJECT_ROLE_PI = "PI";
    private static final String PROJECT_ROLE_COI = "COI";
    private static final String PROJECT_ROLE_KP = "KP";
    private static final Object PROPOSAL_YNQ_QUESTION_17 = "17";
    private static final int BUDGET_PERIOD_5 = 5;
    private static final String BUDGET_PERIOD_TYPE_4 = "4";
    private static final String BUDGET_PERIOD_TYPE_2 = "2";
    private static final String BUDGET_PERIOD_TYPE_3 = "3";
    protected ParameterService parameterService;
    private SponsorService sponsorService;
    private BudgetDecimal cumulativeCalendarMonthsFunded = BudgetDecimal.ZERO;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        Budget budget = this.getBudget(developmentProposal.getProposalDocument());
        ResearchAndRelatedProjectDocument researchAndRelatedProjectDocument = ResearchAndRelatedProjectDocument.Factory.newInstance();
        researchAndRelatedProjectDocument.setResearchAndRelatedProject(this.getResearchAndRelatedProject(developmentProposal, budget));
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        xmlObjectList.put("Research and Related", (XmlObject)researchAndRelatedProjectDocument);
        return xmlObjectList;
    }

    private ResearchAndRelatedProjectDocument.ResearchAndRelatedProject getResearchAndRelatedProject(DevelopmentProposal developmentProposal, Budget budget) {
        AwardAmountInfo amountInfo;
        ResearchAndRelatedProjectDocument.ResearchAndRelatedProject researchAndRelatedProject = ResearchAndRelatedProjectDocument.ResearchAndRelatedProject.Factory.newInstance();
        researchAndRelatedProject.setProjectDescription(this.getProjectDescription(developmentProposal));
        researchAndRelatedProject.setOrgAssurances((OrgAssurancesType)this.getOrgAssurances(developmentProposal));
        researchAndRelatedProject.setAbstractArray(this.getAbstractArray(developmentProposal));
        researchAndRelatedProject.setProposalPersonArray(this.getProposalPersonArray(developmentProposal, budget));
        researchAndRelatedProject.setKeyPersonArray(this.getKeyPersonArray(developmentProposal));
        researchAndRelatedProject.setNSFPreviousAwardNumber(this.getNSFPreviousAwardNumber(developmentProposal));
        researchAndRelatedProject.setNSFProjectDuration(this.getNSFProjectDuration(developmentProposal));
        researchAndRelatedProject.setNihInventions(this.getNihInventions(developmentProposal));
        Award award = null;
        if (developmentProposal.getCurrentAwardNumber() != null) {
            award = this.getAward(developmentProposal.getCurrentAwardNumber());
        }
        if (award != null && (amountInfo = this.getMaxAwardAmountInfo(award)) != null) {
            if (amountInfo.getCurrentFundEffectiveDate() != null) {
                Calendar totalProjectStartDate = Calendar.getInstance();
                totalProjectStartDate.setTime(amountInfo.getCurrentFundEffectiveDate());
                researchAndRelatedProject.setTotalProjectStartDt(totalProjectStartDate);
            }
            if (amountInfo.getFinalExpirationDate() != null) {
                Calendar totalProjectEndDate = Calendar.getInstance();
                totalProjectEndDate.setTime(amountInfo.getFinalExpirationDate());
                researchAndRelatedProject.setTotalProjectEndDt(totalProjectEndDate);
            }
        }
        this.setNIHDeatils(researchAndRelatedProject, developmentProposal);
        try {
            researchAndRelatedProject.setResearchCoverPage(this.getResearchCoverPage(developmentProposal, budget));
        }
        catch (ParseException e) {
            LOG.error((Object)"Unable to parse String date", (Throwable)e);
        }
        researchAndRelatedProject.setBudgetSummary(this.getBudgetSummary(budget, developmentProposal));
        return researchAndRelatedProject;
    }

    protected boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        String proposalTypeCodeRenewal = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        String proposalTypeCodeRevision = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        String proposalTypeCodeContinuation = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        return !StringUtils.isEmpty((String)proposalTypeCode) && (proposalTypeCode.equals(proposalTypeCodeRenewal) || proposalTypeCode.equals(proposalTypeCodeRevision) || proposalTypeCode.equals(proposalTypeCodeContinuation));
    }

    private void setNIHDeatils(ResearchAndRelatedProjectDocument.ResearchAndRelatedProject researchAndRelatedProject, DevelopmentProposal developmentProposal) {
        String sponsorAwardNumber;
        String currentAwardNumber;
        Award award;
        String federalIdComesFromAwardStr;
        String proposalTypeCode = developmentProposal.getProposalTypeCode();
        String federalId = this.getS2SUtilService().getFederalId(developmentProposal.getProposalDocument());
        researchAndRelatedProject.setNihPriorGrantNumber(federalId);
        if (this.isProposalTypeRenewalRevisionContinuation(proposalTypeCode) && "Y".equalsIgnoreCase(federalIdComesFromAwardStr = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "FEDERAL_ID_COMES_FROM_CURRENT_AWARD")) && (award = this.getAward(currentAwardNumber = developmentProposal.getCurrentAwardNumber())) != null && (sponsorAwardNumber = award.getSponsorAwardNumber()) != null && sponsorAwardNumber.length() > 5) {
            String activityCode = sponsorAwardNumber.substring(2, 5);
            String awardType = sponsorAwardNumber.substring(0, 1);
            researchAndRelatedProject.setNihActivityCode(activityCode);
            researchAndRelatedProject.setNihApplicationTypeCode(awardType);
        }
    }

    private InstitutionalProposal getMaxInstitutionalProposal(DevelopmentProposal developmentProposal) {
        String continuedFrom = developmentProposal.getContinuedFrom();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("proposalId", continuedFrom);
        List institutionalProposals = (List)this.getBusinessObjectService().findMatching(InstitutionalProposal.class, fieldValues);
        InstitutionalProposal institutionalProposal = null;
        Integer maxSequenceNumber = 0;
        for (InstitutionalProposal proposal : institutionalProposals) {
            if (maxSequenceNumber >= proposal.getSequenceNumber()) continue;
            maxSequenceNumber = proposal.getSequenceNumber();
            institutionalProposal = proposal;
        }
        return institutionalProposal;
    }

    private String getNihInventions(DevelopmentProposal developmentProposal) {
        String nihInventions = null;
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals("16")) continue;
            nihInventions = proposalYnq.getAnswer();
        }
        return nihInventions;
    }

    private BigInteger getNSFProjectDuration(DevelopmentProposal developmentProposal) {
        BigInteger projectDuration = null;
        if (developmentProposal.getRequestedEndDateInitial() != null && developmentProposal.getRequestedStartDateInitial() != null) {
            BigDecimal months = this.getMonthsBetweenDates((Date)developmentProposal.getRequestedStartDateInitial(), (Date)developmentProposal.getRequestedEndDateInitial());
            projectDuration = months.toBigInteger();
        }
        return projectDuration;
    }

    private BigDecimal getMonthsBetweenDates(Date pFrom, Date pTo) {
        BudgetDecimal projectDuration = null;
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTimeInMillis(pFrom.getTime());
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTimeInMillis(pTo.getTime());
        int yd = 12 * (calendarEnd.get(1) - calendarStart.get(1));
        int md = calendarEnd.get(2) - calendarStart.get(2);
        int dd = calendarEnd.get(5) - calendarStart.get(5);
        if (dd >= 15) {
            ++md;
        }
        int result = yd + md;
        projectDuration = new BudgetDecimal(result);
        return projectDuration.setScale(0).bigDecimalValue();
    }

    private String getNSFPreviousAwardNumber(DevelopmentProposal developmentProposal) {
        String currentAwardNumber = developmentProposal.getCurrentAwardNumber();
        Award award = this.getAward(currentAwardNumber);
        if (award != null) {
            return award.getSponsorAwardNumber();
        }
        return null;
    }

    private AbstractType[] getAbstractArray(DevelopmentProposal developmentProposal) {
        ArrayList<AbstractType> abstractTypeList = new ArrayList<AbstractType>();
        AbstractType abstractType = null;
        BigInteger abstractTypeCode = null;
        for (ProposalAbstract proposalAbstract : developmentProposal.getProposalAbstracts()) {
            if (proposalAbstract.getAbstractType() == null) continue;
            try {
                abstractType = AbstractType.Factory.newInstance();
                abstractType.setAbstractText(proposalAbstract.getAbstractDetails());
                abstractTypeCode = new BigInteger(proposalAbstract.getAbstractType().getAbstractTypeCode());
                abstractType.setAbstractTypeCode(abstractTypeCode);
                abstractType.setAbstractTypeDesc(proposalAbstract.getAbstractType().getDescription());
                abstractTypeList.add(abstractType);
            }
            catch (NumberFormatException e) {
                LOG.info((Object)("abstractTypeCode is Not a Number for proposal :" + developmentProposal.getProposalNumber()));
            }
        }
        return abstractTypeList.toArray(new AbstractType[0]);
    }

    private ProposalPersonType[] getProposalPersonArray(DevelopmentProposal developmentProposal, Budget budget) {
        ArrayList<ProposalPersonType> proposalPersonTypeList = new ArrayList<ProposalPersonType>();
        List proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            proposalPersonTypeList.add(this.getProposalPersonTypeWithValues(developmentProposal, proposalPerson, budget));
        }
        return proposalPersonTypeList.toArray(new ProposalPersonType[0]);
    }

    private ProposalPersonType getProposalPersonTypeWithValues(DevelopmentProposal developmentProposal, ProposalPerson proposalPerson, Budget budget) {
        ProposalPersonType proposalPersonType = ProposalPersonType.Factory.newInstance();
        String degree = this.getDegree(proposalPerson);
        proposalPersonType.setDegree(degree);
        proposalPersonType.setEmail(proposalPerson.getEmailAddress());
        proposalPersonType.setName(this.getProposalPersonFullNameType(proposalPerson));
        proposalPersonType.setPhone(proposalPerson.getPhoneNumber());
        if ("PI".equals(proposalPerson.getProposalPersonRoleId())) {
            proposalPersonType.setProjectRole(ProjectRoleType.PI_PD);
        } else if ("COI".equals(proposalPerson.getProposalPersonRoleId())) {
            proposalPersonType.setProjectRole(ProjectRoleType.CO_PI_PD);
        } else {
            proposalPersonType.setProjectRole(ProjectRoleType.KEY_PERSON);
        }
        proposalPersonType.setSSN(proposalPerson.getSocialSecurityNumber());
        if (proposalPerson.getDateOfBirth() != null) {
            proposalPersonType.setDOB(this.getDateTimeService().toDateString((Date)proposalPerson.getDateOfBirth()));
        }
        BudgetDecimal calendarMonths = BudgetDecimal.ZERO;
        BudgetDecimal academicMonths = BudgetDecimal.ZERO;
        BudgetDecimal summerMonths = BudgetDecimal.ZERO;
        if (budget != null) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                        if ((proposalPerson.getPersonId() == null || !proposalPerson.getPersonId().equals(budgetPersonnelDetails.getPersonId())) && (proposalPerson.getRolodexId() == null || !proposalPerson.getRolodexId().toString().equals(budgetPersonnelDetails.getPersonId()))) continue;
                        proposalPersonType.setPercentEffort(budgetPersonnelDetails.getPercentEffort().bigDecimalValue());
                        proposalPersonType.setRequestedCost(budgetPersonnelDetails.getSalaryRequested().bigDecimalValue());
                        if ("2".equals(budgetPersonnelDetails.getPeriodTypeCode())) {
                            academicMonths = (BudgetDecimal)academicMonths.add((AbstractKualiDecimal)budgetPersonnelDetails.getPercentEffort().multiply(new BudgetDecimal("0.01")).multiply(this.getNumberOfMonths((Date)budgetPersonnelDetails.getStartDate(), (Date)budgetPersonnelDetails.getEndDate())));
                            continue;
                        }
                        if ("3".equals(budgetPersonnelDetails.getPeriodTypeCode())) {
                            calendarMonths = (BudgetDecimal)calendarMonths.add((AbstractKualiDecimal)budgetPersonnelDetails.getPercentEffort().multiply(new BudgetDecimal("0.01")).multiply(this.getNumberOfMonths((Date)budgetPersonnelDetails.getStartDate(), (Date)budgetPersonnelDetails.getEndDate())));
                            continue;
                        }
                        summerMonths = (BudgetDecimal)summerMonths.add((AbstractKualiDecimal)budgetPersonnelDetails.getPercentEffort().multiply(new BudgetDecimal("0.01")).multiply(this.getNumberOfMonths((Date)budgetPersonnelDetails.getStartDate(), (Date)budgetPersonnelDetails.getEndDate())));
                    }
                }
            }
        }
        proposalPersonType.setAcademicFundingMonths(academicMonths.bigDecimalValue().setScale(2));
        proposalPersonType.setSummerFundingMonths(summerMonths.bigDecimalValue().setScale(2));
        proposalPersonType.setFundingMonths(calendarMonths.bigDecimalValue().setScale(2, RoundingMode.HALF_UP));
        return proposalPersonType;
    }

    private String getDegree(ProposalPerson proposalPerson) {
        List proposalPersonDegress = proposalPerson.getProposalPersonDegrees();
        String degree = null;
        for (ProposalPersonDegree proposalPersonDegree : proposalPersonDegress) {
            degree = degree == null ? proposalPersonDegree.getDegree() : degree + "," + proposalPersonDegree.getDegree();
        }
        return degree;
    }

    private BudgetDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        BudgetDecimal monthCount = BudgetDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return BudgetDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BudgetDecimal startMonthFraction = new BudgetDecimal(++startMonthDays).divide(new BudgetDecimal(startMonthMaxDays));
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BudgetDecimal endMonthFraction = new BudgetDecimal(endMonthDays).divide(new BudgetDecimal(endMonthMaxDays));
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)monthCount.add((AbstractKualiDecimal)new BudgetDecimal(--fullMonthCount))).add((AbstractKualiDecimal)startMonthFraction)).add((AbstractKualiDecimal)endMonthFraction);
        return monthCount;
    }

    private PersonFullNameType getProposalPersonFullNameType(ProposalPerson proposalPerson) {
        PersonFullNameType personFullNameType = PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName(proposalPerson.getFirstName());
        personFullNameType.setLastName(proposalPerson.getLastName());
        personFullNameType.setMiddleName(proposalPerson.getMiddleName());
        return personFullNameType;
    }

    private KeyPersonType[] getKeyPersonArray(DevelopmentProposal developmentProposal) {
        ArrayList<ProposalPerson> propKeyPersons = new ArrayList<ProposalPerson>();
        ArrayList<ProposalPerson> propInvestigators = new ArrayList<ProposalPerson>();
        ArrayList<ProposalPerson> propPIs = new ArrayList<ProposalPerson>();
        for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
            if ("PI".equals(proposalPerson.getProposalPersonRoleId())) {
                propPIs.add(proposalPerson);
                continue;
            }
            if ("KP".equals(proposalPerson.getProposalPersonRoleId())) {
                propKeyPersons.add(proposalPerson);
                continue;
            }
            propInvestigators.add(proposalPerson);
        }
        this.sortKeyPersonWithName(propPIs);
        this.sortKeyPersonWithName(propKeyPersons);
        this.sortKeyPersonWithName(propInvestigators);
        List keyPersonPIList = this.getKeyPersonForPropInvestigator(developmentProposal, propPIs, true);
        List keyPersonInvestigatorList = this.getKeyPersonForPropInvestigator(developmentProposal, propInvestigators, false);
        List keyPersonKeyPersonList = this.getKeyPersonForPropKeyPerson(developmentProposal, propKeyPersons);
        ArrayList allKeyPersonList = new ArrayList();
        allKeyPersonList.addAll(keyPersonPIList);
        allKeyPersonList.addAll(keyPersonInvestigatorList);
        allKeyPersonList.addAll(keyPersonKeyPersonList);
        return allKeyPersonList.toArray(new KeyPersonType[0]);
    }

    private List<KeyPersonType> getKeyPersonForPropKeyPerson(DevelopmentProposal developmentProposal, List<ProposalPerson> proposalKeyPersons) {
        ArrayList<KeyPersonType> keyPersonlist = new ArrayList<KeyPersonType>();
        for (ProposalPerson proposalPerson : proposalKeyPersons) {
            KeyPersonType keyPersonType = KeyPersonType.Factory.newInstance();
            PersonFullNameType personFullNameType = this.getPersonFullName(proposalPerson);
            keyPersonType.setName(personFullNameType);
            ContactInfoType contactInfoType = this.getContactInfoType(proposalPerson);
            keyPersonType.setContactInformation(contactInfoType);
            KeyPersonType.KeyPersonFlag keyPersonFlag = this.getKeyPersonFlag(proposalPerson);
            keyPersonType.setKeyPersonFlag(keyPersonFlag);
            keyPersonType.setSocialSecurityNumber(proposalPerson.getSocialSecurityNumber());
            String unitName = this.getUnitName(proposalPerson);
            if (unitName != null) {
                keyPersonType.setOrganizationDepartment(unitName);
            }
            Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
            keyPersonType.setOrganizationName(organization.getOrganizationName());
            if (proposalPerson.getPrimaryTitle() != null) {
                keyPersonType.setPositionTitle(proposalPerson.getPrimaryTitle());
            }
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            this.setDegree(proposalPerson, keyPersonType);
            if (proposalPerson.getEraCommonsUserName() == null) {
                keyPersonType.setAccountIdentifier("Unknown");
            } else {
                keyPersonType.setAccountIdentifier(proposalPerson.getEraCommonsUserName());
            }
            keyPersonlist.add(keyPersonType);
        }
        return keyPersonlist;
    }

    private void setBiographicalSketch(ProposalPerson proposalPerson, KeyPersonType keyPersonType) {
        KeyPersonBiosketchType keyPersonBioSketch = keyPersonType.addNewNIHBiographicalSketch();
        keyPersonBioSketch.setResearchSupportFileIdentifier("researchfilename");
        keyPersonBioSketch.setPositionsHonorsCitationsFileIdentifier("honorsfilename");
    }

    private void setDegree(ProposalPerson proposalPerson, KeyPersonType keyPersonType) {
        List proposalPersonDegrees = proposalPerson.getProposalPersonDegrees();
        for (ProposalPersonDegree proposalPersonDegree : proposalPersonDegrees) {
            keyPersonType.addDegree(proposalPersonDegree.getDegree());
        }
    }

    private String getMajorSubDivision(String leadUnit) {
        UnitService unitService = (UnitService)KraServiceLocator.getService(UnitService.class);
        List units = unitService.getAllSubUnits("000001");
        for (Unit unit : units) {
            if (!unit.getUnitNumber().equals(leadUnit)) continue;
            return unit.getParentUnitNumber();
        }
        return leadUnit;
    }

    private String getLeadUnit(DevelopmentProposal developmentProposal) {
        return developmentProposal.getOwnedByUnit().getUnitNumber();
    }

    private List<KeyPersonType> getKeyPersonForPropInvestigator(DevelopmentProposal developmentProposal, List<ProposalPerson> proposalPersonList, boolean piFlag) {
        ArrayList<KeyPersonType> keyPersonTypeList = new ArrayList<KeyPersonType>();
        for (ProposalPerson proposalPerson : proposalPersonList) {
            KeyPersonType keyPersonType = KeyPersonType.Factory.newInstance();
            PersonFullNameType personFullNameType = this.getPersonFullName(proposalPerson);
            keyPersonType.setName(personFullNameType);
            ContactInfoType contactInfoType = this.getContactInfoType(proposalPerson);
            keyPersonType.setContactInformation(contactInfoType);
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            KeyPersonType.KeyPersonFlag keyPersonFlag = this.getKeyPersonFlag(proposalPerson);
            if (piFlag) {
                keyPersonFlag.setKeyPersonFlagDesc("PI");
            }
            keyPersonType.setKeyPersonFlag(keyPersonFlag);
            keyPersonType.setSocialSecurityNumber(proposalPerson.getSocialSecurityNumber());
            String unitName = this.getUnitName(proposalPerson);
            if (unitName != null) {
                keyPersonType.setOrganizationDepartment(unitName);
            }
            Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
            keyPersonType.setOrganizationName(organization.getOrganizationName());
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            if (proposalPerson.getPrimaryTitle() != null) {
                keyPersonType.setPositionTitle(proposalPerson.getPrimaryTitle());
            }
            this.setBiographicalSketch(proposalPerson, keyPersonType);
            keyPersonType.setOrganizationDivision(this.getMajorSubDivision(this.getLeadUnit(developmentProposal)));
            this.setDegree(proposalPerson, keyPersonType);
            if (proposalPerson.getEraCommonsUserName() == null) {
                keyPersonType.setAccountIdentifier("Unknown");
            } else {
                keyPersonType.setAccountIdentifier(proposalPerson.getEraCommonsUserName());
            }
            keyPersonTypeList.add(keyPersonType);
        }
        return keyPersonTypeList;
    }

    private BudgetSummaryType getBudgetSummary(Budget budget, DevelopmentProposal developmentProposal) {
        BudgetSummaryType budgetSummaryType = BudgetSummaryType.Factory.newInstance();
        if (budget != null) {
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod(0);
            budgetSummaryType.setInitialBudgetTotals(this.getBudgetTotals(budgetPeriod.getTotalCost(), budgetPeriod.getCostSharingAmount()));
            budgetSummaryType.setAllBudgetTotals(this.getBudgetTotals(budget.getTotalCost(), budget.getCostSharingAmount()));
            budgetSummaryType.setBudgetIndirectCostsTotal(budget.getTotalIndirectCost().bigDecimalValue());
            budgetSummaryType.setBudgetPeriodArray(this.getBudgetPeriodArray(developmentProposal, budget.getBudgetPeriods()));
            budgetSummaryType.setBudgetJustification(this.getBudgetJustification(developmentProposal.getProposalNumber()));
            this.setAllNSFSeniorPersonnels(developmentProposal, budget, budgetSummaryType);
            budgetSummaryType.setModularBudgetQuestion(budget.getModularBudgetFlag().booleanValue());
            budgetSummaryType.setBudgetCostsTotal(budget.getTotalCost().bigDecimalValue());
            budgetSummaryType.setBudgetDirectCostsTotal(budget.getTotalDirectCost().bigDecimalValue());
        }
        return budgetSummaryType;
    }

    private void setAllNSFSeniorPersonnels(DevelopmentProposal developmentProposal, Budget budget, BudgetSummaryType budgetSummaryType) {
        List nsfSeniorPersons = this.getBudgetPersonsForCategoryMap(developmentProposal, budget, "01", "NSF_PRINTING");
        int rowNumber = 0;
        BudgetDecimal totalFringe = BudgetDecimal.ZERO;
        BudgetDecimal totalSalary = BudgetDecimal.ZERO;
        for (KeyPersonInfo keyPersonInfo : nsfSeniorPersons) {
            NSFSeniorPersonnelType nsfSeniorPersonnel = budgetSummaryType.addNewNSFSeniorPersonnel();
            this.setNSFSeniorPersonnel(keyPersonInfo, nsfSeniorPersonnel, rowNumber++);
            totalFringe = (BudgetDecimal)totalFringe.add((AbstractKualiDecimal)keyPersonInfo.getFringe());
            totalSalary = (BudgetDecimal)totalSalary.add((AbstractKualiDecimal)keyPersonInfo.getRequestedSalary());
        }
        budgetSummaryType.setTotalFringe(totalFringe.bigDecimalValue());
        budgetSummaryType.setTotalSalariesAndWages(totalSalary.bigDecimalValue());
        budgetSummaryType.setTotalSalariesWagesAndFringe(((BudgetDecimal)totalSalary.add((AbstractKualiDecimal)totalFringe)).bigDecimalValue());
        budgetSummaryType.setIndirectCostRateDetails(this.getIndirectCostDetails(developmentProposal));
    }

    private BudgetSummaryType.IndirectCostRateDetails getIndirectCostDetails(DevelopmentProposal developmentProposal) {
        BudgetSummaryType.IndirectCostRateDetails indirectCost = BudgetSummaryType.IndirectCostRateDetails.Factory.newInstance();
        String dhhsAgreementFlag = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "DHHS_AGREEMENT");
        Organization orgBean = developmentProposal.getApplicantOrganization().getOrganization();
        try {
            if (dhhsAgreementFlag.equals("0")) {
                BudgetSummaryType.IndirectCostRateDetails.NoDHHSAgreement noAgreement = BudgetSummaryType.IndirectCostRateDetails.NoDHHSAgreement.Factory.newInstance();
                noAgreement.setAgencyName(this.getS2SUtilService().getCognizantFedAgency(developmentProposal));
                if (orgBean.getIndirectCostRateAgreement() == null) {
                    noAgreement.setAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate("1900-01-01")));
                } else {
                    noAgreement.setAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate(orgBean.getIndirectCostRateAgreement())));
                }
                indirectCost.setNoDHHSAgreement(noAgreement);
            } else if (orgBean.getIndirectCostRateAgreement() != null) {
                indirectCost.setDHHSAgreementDate(this.getDateTimeService().getCalendar(this.getDateTimeService().convertToDate(orgBean.getIndirectCostRateAgreement())));
            } else {
                indirectCost.setDHHSAgreementNegotiationOffice(this.getS2SUtilService().getCognizantFedAgency(developmentProposal));
            }
        }
        catch (ParseException e) {
            LOG.error((Object)e);
        }
        return indirectCost;
    }

    private int setNSFSeniorPersonnels(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod BudgetPeriodType2) {
        List nsfSeniorPersons = this.getBudgetPersonsForCategoryMap(developmentProposal, budgetPeriod, "01", "NSF_PRINTING");
        int rowNumber = 0;
        int period = budgetPeriod.getBudgetPeriod();
        for (KeyPersonInfo keyPersonInfo : nsfSeniorPersons) {
            this.setNSFSeniorPersonnel(keyPersonInfo, BudgetPeriodType2.addNewNSFSeniorPersonnel(), rowNumber++, period);
        }
        return rowNumber;
    }

    public void setNSFSeniorPersonnel(KeyPersonInfo seniorPersonnelBean, NSFSeniorPersonnelType nsfSeniorPersonnelType, int rowNumber, int period) {
        if (period <= 5) {
            this.cumulativeCalendarMonthsFunded = (BudgetDecimal)this.cumulativeCalendarMonthsFunded.add((AbstractKualiDecimal)seniorPersonnelBean.getCalendarMonths());
        }
        nsfSeniorPersonnelType.setFullName(this.getFullName(seniorPersonnelBean));
        nsfSeniorPersonnelType.setTitle(seniorPersonnelBean.getRole());
        nsfSeniorPersonnelType.setAcademicMonthsFunded(seniorPersonnelBean.getAcademicMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setCalendarMonthsFunded(seniorPersonnelBean.getCalendarMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setSummerMonthsFunded(seniorPersonnelBean.getSummerMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setFundsRequested(seniorPersonnelBean.getRequestedSalary().bigDecimalValue());
        nsfSeniorPersonnelType.setPersonID(seniorPersonnelBean.getPersonId());
        nsfSeniorPersonnelType.setRownumber(BigInteger.valueOf(rowNumber));
    }

    public void setNSFSeniorPersonnel(KeyPersonInfo seniorPersonnelBean, NSFSeniorPersonnelType nsfSeniorPersonnelType, int rowNumber) {
        nsfSeniorPersonnelType.setFullName(this.getFullName(seniorPersonnelBean));
        nsfSeniorPersonnelType.setTitle(seniorPersonnelBean.getRole());
        nsfSeniorPersonnelType.setAcademicMonthsFunded(seniorPersonnelBean.getAcademicMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setCalendarMonthsFunded(seniorPersonnelBean.getCalendarMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setSummerMonthsFunded(seniorPersonnelBean.getSummerMonths().bigDecimalValue());
        nsfSeniorPersonnelType.setFundsRequested(seniorPersonnelBean.getRequestedSalary().bigDecimalValue());
        nsfSeniorPersonnelType.setPersonID(seniorPersonnelBean.getPersonId());
        nsfSeniorPersonnelType.setRownumber(BigInteger.valueOf(rowNumber));
        this.cumulativeCalendarMonthsFunded = BudgetDecimal.ZERO;
    }

    private String getFullName(KeyPersonInfo seniorPersonnelBean) {
        return seniorPersonnelBean.getLastName() + ", " + seniorPersonnelBean.getFirstName();
    }

    private BudgetSummaryType.BudgetPeriod[] getBudgetPeriodArray(DevelopmentProposal developmentProposal, List<BudgetPeriod> budgetPeriodList) {
        ArrayList<BudgetSummaryType.BudgetPeriod> budgetPeriods = new ArrayList<BudgetSummaryType.BudgetPeriod>();
        for (BudgetPeriod budgetPeriod : budgetPeriodList) {
            Budget budget = budgetPeriod.getBudget();
            if (budgetPeriod.getBudgetPeriod() == null) continue;
            List budgetLineItems = budgetPeriod.getBudgetLineItems();
            BudgetSummaryType.BudgetPeriod budgetPeriodType = BudgetSummaryType.BudgetPeriod.Factory.newInstance();
            budgetPeriodType.setBudgetPeriodID(BigInteger.valueOf(budgetPeriod.getBudgetPeriod().intValue()));
            budgetPeriodType.setStartDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getStartDate()));
            budgetPeriodType.setEndDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getEndDate()));
            budgetPeriodType.setFee(new BigDecimal(0));
            this.setSalaryAndWages(developmentProposal, budget, budgetPeriod, budgetPeriodType);
            budgetPeriodType.setEquipmentTotal(this.getEquipmentTotal(budgetLineItems));
            budgetPeriodType.setEquipmentCostsArray(this.getEquipmentCosts(budgetLineItems));
            budgetPeriodType.setOtherDirectCostsArray(this.getOtherDirectCosts(developmentProposal, budgetLineItems));
            this.setNonPersonnelLACost(budgetLineItems, budgetPeriodType);
            budgetPeriodType.setOtherDirectTotal(this.getOtherDirectTotal(budgetLineItems));
            budgetPeriodType.setTravelCostsArray(this.getTravelCosts(budgetLineItems));
            budgetPeriodType.setTravelTotal(this.getTravelTotal(budgetLineItems));
            budgetPeriodType.setParticipantPatientCostsArray(this.getParticipantPatientCost(developmentProposal, budgetLineItems));
            budgetPeriodType.setParticipantPatientTotal(this.getParticipantPatientTotal(budgetLineItems));
            budgetPeriodType.setNumberOfParticipants(BigInteger.valueOf(budgetPeriod.getNumberOfParticipants() == null ? 0L : (long)budgetPeriod.getNumberOfParticipants().intValue()));
            budgetPeriodType.setPeriodDirectCostsTotal(budgetPeriod.getTotalDirectCost().bigDecimalValue());
            budgetPeriodType.setIndirectCostsTotal(budgetPeriod.getTotalIndirectCost().bigDecimalValue());
            this.setIndirectCostDetails(budgetPeriod, budgetPeriodType);
            budgetPeriodType.setPeriodCostsTotal(budgetPeriod.getTotalCost().bigDecimalValue());
            budgetPeriodType.setProgramIncome(new BigDecimal(0));
            budgetPeriodType.setConsortiumCosts(this.getConsortiumCosts(developmentProposal, budgetPeriod));
            int count = this.setNSFSeniorPersonnels(developmentProposal, budgetPeriod, budgetPeriodType);
            budgetPeriodType.setNSFTotalSeniorPersonnel(BigInteger.valueOf(count));
            this.setNSFOtherPersonnels(developmentProposal, budgetPeriod, budgetPeriodType);
            this.setSalarySubTotals(budgetPeriod, budgetPeriodType);
            this.setProgramIncome(budgetPeriod, (BudgetPeriodType)budgetPeriodType);
            budgetPeriods.add(budgetPeriodType);
        }
        return budgetPeriods.toArray(new BudgetSummaryType.BudgetPeriod[0]);
    }

    private void setIndirectCostDetails(BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        Budget budget = budgetPeriod.getBudget();
        HashMap<String, IndirectCostDetailsBean> ohAmountsMap = new HashMap<String, IndirectCostDetailsBean>();
        if (budget.getModularBudgetFlag().booleanValue()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            List budgetModularIdcs = budgetModular.getBudgetModularIdcs();
            for (BudgetModularIdc budgetModularIdc : budgetModularIdcs) {
                IndirectCostDetailsBean indcost;
                String key = budgetModularIdc.getDescription() + budgetModularIdc.getIdcRate();
                if (ohAmountsMap.get(key) == null) {
                    indcost = new IndirectCostDetailsBean(this);
                    IndirectCostDetailsBean.access$002((IndirectCostDetailsBean)indcost, (BudgetDecimal)budgetModularIdc.getIdcRate());
                    IndirectCostDetailsBean.access$102((IndirectCostDetailsBean)indcost, (BudgetDecimal)budgetModularIdc.getIdcBase());
                    IndirectCostDetailsBean.access$202((IndirectCostDetailsBean)indcost, (BudgetDecimal)budgetModularIdc.getFundsRequested());
                    IndirectCostDetailsBean.access$302((IndirectCostDetailsBean)indcost, (String)budgetModularIdc.getDescription());
                    ohAmountsMap.put(key, indcost);
                    continue;
                }
                indcost = (IndirectCostDetailsBean)ohAmountsMap.get(key);
                IndirectCostDetailsBean.access$002((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)IndirectCostDetailsBean.access$000((IndirectCostDetailsBean)indcost).add((AbstractKualiDecimal)budgetModularIdc.getIdcRate())));
                IndirectCostDetailsBean.access$102((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)IndirectCostDetailsBean.access$100((IndirectCostDetailsBean)indcost).add((AbstractKualiDecimal)budgetModularIdc.getIdcBase())));
                IndirectCostDetailsBean.access$202((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)IndirectCostDetailsBean.access$200((IndirectCostDetailsBean)indcost).add((AbstractKualiDecimal)budgetModularIdc.getFundsRequested())));
                IndirectCostDetailsBean.access$302((IndirectCostDetailsBean)indcost, (String)budgetModularIdc.getDescription());
            }
        } else {
            List budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                List budgetRateAndBases = budgetLineItem.getBudgetRateAndBaseList();
                for (BudgetRateAndBase budgetRateAndBase : budgetRateAndBases) {
                    IndirectCostDetailsBean indcost;
                    String key = budgetRateAndBase.getRateClassCode() + budgetRateAndBase.getRateTypeCode();
                    if (!budgetRateAndBase.getRateClass().getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    if (ohAmountsMap.get(key) == null) {
                        indcost = new IndirectCostDetailsBean(this);
                        IndirectCostDetailsBean.access$002((IndirectCostDetailsBean)indcost, (BudgetDecimal)budgetRateAndBase.getAppliedRate());
                        IndirectCostDetailsBean.access$102((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)budgetRateAndBase.getBaseCost().add((AbstractKualiDecimal)budgetRateAndBase.getBaseCostSharing())));
                        IndirectCostDetailsBean.access$202((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)budgetRateAndBase.getCalculatedCost().add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCostSharing())));
                        IndirectCostDetailsBean.access$302((IndirectCostDetailsBean)indcost, (String)budgetRateAndBase.getRateClass().getRateClassTypeDescription());
                        ohAmountsMap.put(key, indcost);
                        continue;
                    }
                    indcost = (IndirectCostDetailsBean)ohAmountsMap.get(key);
                    IndirectCostDetailsBean.access$102((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)IndirectCostDetailsBean.access$100((IndirectCostDetailsBean)indcost).add((AbstractKualiDecimal)budgetRateAndBase.getBaseCost())).add((AbstractKualiDecimal)budgetRateAndBase.getBaseCostSharing())));
                    IndirectCostDetailsBean.access$202((IndirectCostDetailsBean)indcost, (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)IndirectCostDetailsBean.access$200((IndirectCostDetailsBean)indcost).add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCost())).add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCostSharing())));
                }
            }
        }
        for (String key : ohAmountsMap.keySet()) {
            IndirectCostDetailsBean indirectCostDetailBean = (IndirectCostDetailsBean)ohAmountsMap.get(key);
            BudgetSummaryType.BudgetPeriod.IndirectCostDetails indDetailsType = budgetPeriodType.addNewIndirectCostDetails();
            indDetailsType.setCostType(IndirectCostDetailsBean.access$300((IndirectCostDetailsBean)indirectCostDetailBean) == null ? "UNKNOWN" : IndirectCostDetailsBean.access$300((IndirectCostDetailsBean)indirectCostDetailBean));
            indDetailsType.setBaseAmount(IndirectCostDetailsBean.access$100((IndirectCostDetailsBean)indirectCostDetailBean).bigDecimalValue());
            indDetailsType.setRate(IndirectCostDetailsBean.access$000((IndirectCostDetailsBean)indirectCostDetailBean).bigDecimalValue());
            indDetailsType.setFundsRequested(IndirectCostDetailsBean.access$200((IndirectCostDetailsBean)indirectCostDetailBean).bigDecimalValue());
        }
    }

    private void setProgramIncome(BudgetPeriod budgetPeriod, BudgetPeriodType budgetPeriodType) {
        Budget budget = budgetPeriod.getBudget();
        List programIncomes = budget.getBudgetProjectIncomes();
        KualiDecimal totalProgIncome = KualiDecimal.ZERO;
        for (BudgetProjectIncome budgetProjectIncome : programIncomes) {
            if (!budgetProjectIncome.getBudgetPeriodNumber().equals(budgetPeriod.getBudgetPeriod())) continue;
            BudgetPeriodType.ProgramIncomeDetails progIncDetailsType = budgetPeriodType.addNewProgramIncomeDetails();
            progIncDetailsType.setAnticipatedAmount(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            totalProgIncome = (KualiDecimal)totalProgIncome.add((AbstractKualiDecimal)budgetProjectIncome.getProjectIncome());
            progIncDetailsType.setSources(budgetProjectIncome.getDescription());
        }
        budgetPeriodType.setProgramIncome(totalProgIncome.bigDecimalValue());
    }

    private BudgetSummaryType.BudgetPeriod.ConsortiumCosts getConsortiumCosts(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod) {
        ProposalDevelopmentBudgetExt budget = (ProposalDevelopmentBudgetExt)budgetPeriod.getBudget();
        BudgetDecimal consortiumDirectCost = BudgetDecimal.ZERO;
        BudgetDecimal consortiumIndirectCosts = BudgetDecimal.ZERO;
        BudgetSummaryType.BudgetPeriod.ConsortiumCosts consortiumCost = BudgetSummaryType.BudgetPeriod.ConsortiumCosts.Factory.newInstance();
        if (budget.getModularBudgetFlag().booleanValue()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            consortiumDirectCost = budgetModular.getConsortiumFna();
        } else {
            boolean isNih = this.sponsorService.isSponsorNihOsc((Sponsorable)developmentProposal) || this.sponsorService.isSponsorNihMultiplePi((Sponsorable)developmentProposal);
            String mappingName = isNih ? "NIH_PRINTING" : "NSF_PRINTING";
            String fnaGt25KParamValue = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_GT_25K");
            String fnaLt25KParamValue = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "SUBCONTRACTOR_F_AND_A_LT_25K");
            String fnaBroadParamValue = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "BROAD_F_AND_A");
            HashMap<String, String> categoryMap = new HashMap<String, String>();
            categoryMap.put("targetCategoryCode", "04");
            categoryMap.put("mappingName", mappingName);
            List budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                    if (categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) {
                        consortiumDirectCost = (BudgetDecimal)consortiumDirectCost.add((AbstractKualiDecimal)lineItem.getLineItemCost());
                    }
                    if (!lineItem.getCostElement().equals(fnaGt25KParamValue) && !lineItem.getCostElement().equals(fnaLt25KParamValue) && !lineItem.getCostElement().equals(fnaBroadParamValue)) continue;
                    consortiumIndirectCosts = (BudgetDecimal)consortiumIndirectCosts.add((AbstractKualiDecimal)lineItem.getLineItemCost());
                }
            }
        }
        consortiumCost.setDirectCosts(((BudgetDecimal)consortiumDirectCost.subtract((AbstractKualiDecimal)consortiumIndirectCosts)).bigDecimalValue());
        consortiumCost.setIndirectCosts(consortiumIndirectCosts.bigDecimalValue());
        return consortiumCost;
    }

    private void setNonPersonnelLACost(List<BudgetLineItem> budgetLineItems, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            List calcAmounts = budgetLineItem.getBudgetCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calcAmounts) {
                budgetLineItemCalculatedAmount.refreshNonUpdateableReferences();
                if (!budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals(RateClassType.LAB_ALLOCATION.getRateClassType())) continue;
                amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        if (amount.isGreaterThan((AbstractKualiDecimal)BudgetDecimal.ZERO)) {
            OtherDirectCostsDocument.OtherDirectCosts otherDirectCost = budgetPeriodType.addNewOtherDirectCosts();
            otherDirectCost.setCost(amount.bigDecimalValue());
            otherDirectCost.setDescription("LA M&S and Utilities");
            otherDirectCost.setType("Other Direct Costs");
        }
    }

    private void setSalarySubTotals(BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        BudgetSummaryType.BudgetPeriod.SalarySubtotals salSubTotals = budgetPeriodType.addNewSalarySubtotals();
        salSubTotals.setFringeBenefits(this.getTotalFringe(budgetPeriod).bigDecimalValue());
        salSubTotals.setSalaryRequested(this.getTotalSalaryRequested(budgetPeriod).bigDecimalValue());
        budgetPeriodType.setSalarySubtotals(salSubTotals);
    }

    private void setNSFOtherPersonnels(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        NSFOtherPersonnelType otherPersonnelType = budgetPeriodType.addNewNSFOtherPersonnel();
        boolean isNih = this.sponsorService.isSponsorNihOsc((Sponsorable)developmentProposal) || this.sponsorService.isSponsorNihMultiplePi((Sponsorable)developmentProposal);
        String mappingName = isNih ? "NIH_PRINTING" : "NSF_PRINTING";
        OtherPersonInfo otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-Secretarial");
        otherPersonnelType.setClericalCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setClericalFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-Graduates");
        otherPersonnelType.setGradCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setGradFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-Other Profs");
        otherPersonnelType.setOtherProfCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setOtherProfFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-Undergrads");
        otherPersonnelType.setUnderGradCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setUnderGradFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-Other");
        otherPersonnelType.setOtherCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setOtherFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonInfo = this.getOtherPersonInfo(developmentProposal, budgetPeriod, mappingName, "01-PostDocs");
        otherPersonnelType.setPostDocCount(BigInteger.valueOf(otherPersonInfo.getCount()));
        otherPersonnelType.setPostDocFunds(otherPersonInfo.getFund().bigDecimalValue());
        otherPersonnelType.setOtherLAFunds(this.getOtherLAFunds(budgetPeriod));
    }

    private BigDecimal getOtherLAFunds(BudgetPeriod budgetPeriod) {
        BudgetDecimal laAmount = BudgetDecimal.ZERO;
        List budgetLineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!budgetLineItem.getBudgetCategoryCode().equals("30")) continue;
            List calcAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calcAmounts) {
                budgetLineItemCalculatedAmount.refreshNonUpdateableReferences();
                if (!RateClassType.LA_SALARIES.getRateClassType().equals(budgetLineItemCalculatedAmount.getRateClass().getRateClassType())) continue;
                laAmount = (BudgetDecimal)laAmount.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        return laAmount.bigDecimalValue();
    }

    private OtherPersonInfo getOtherPersonInfo(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, String categoryMappingName, String categoryCode) {
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("targetCategoryCode", categoryCode);
        categoryMap.put("mappingName", categoryMappingName);
        List budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        OtherPersonInfo otherPersonInfo = new OtherPersonInfo(this);
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            Integer quantity = 0;
            boolean lineItemMatchesCategory = false;
            for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                lineItemMatchesCategory = true;
                break;
            }
            if (!lineItemMatchesCategory) continue;
            List budgetPersonnelDetailsList = lineItem.getBudgetPersonnelDetailsList();
            if (budgetPersonnelDetailsList.size() > 0) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetailsList) {
                    if (this.isPersonExistsInProposal(developmentProposal, budgetPersonnelDetails)) continue;
                    otherPersonInfo.setFund((BudgetDecimal)otherPersonInfo.getFund().add((AbstractKualiDecimal)budgetPersonnelDetails.getSalaryRequested()));
                    if (budgetPersonnelDetails.getQuantity() != null) {
                        quantity = budgetPersonnelDetails.getQuantity();
                    }
                    otherPersonInfo.setCount(otherPersonInfo.getCount() + quantity);
                }
                continue;
            }
            otherPersonInfo.setFund((BudgetDecimal)otherPersonInfo.getFund().add((AbstractKualiDecimal)lineItem.getLineItemCost()));
            otherPersonInfo.setCount(otherPersonInfo.getCount() + lineItem.getQuantity());
        }
        return otherPersonInfo;
    }

    private boolean isPersonExistsInProposal(DevelopmentProposal developmentProposal, BudgetPersonnelDetails budgetPersonnelDetails) {
        List proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.getS2SUtilService().proposalPersonEqualsBudgetPerson(proposalPerson, budgetPersonnelDetails)) continue;
            return true;
        }
        return false;
    }

    private void setSalaryAndWages(DevelopmentProposal developmentProposal, Budget budget, BudgetPeriod budgetPeriod, BudgetSummaryType.BudgetPeriod budgetPeriodType) {
        ArrayList<SalariesAndWagesType> salariesAndWagesTypeList = new ArrayList<SalariesAndWagesType>();
        List budgetLineItems = budgetPeriod.getBudgetLineItems();
        BudgetDecimal totalSalary = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                budgetPersDetails.refreshReferenceObject("budgetPerson");
                BudgetPerson budgetPerson = budgetPersDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                SalariesAndWagesType salariesAndWagesType = this.getSalariesAndWagesType(developmentProposal, budget, budgetPersDetails, budgetPerson);
                totalSalary = (BudgetDecimal)totalSalary.add((AbstractKualiDecimal)new BudgetDecimal(salariesAndWagesType.getSalaryAndFringeTotal()));
                salariesAndWagesTypeList.add(salariesAndWagesType);
            }
        }
        SalariesAndWagesType laSalariesAndWagesType = this.getLAAmmountsAsSalaryRecord(developmentProposal, budget, budgetPeriod);
        if (laSalariesAndWagesType != null) {
            totalSalary = (BudgetDecimal)totalSalary.add((AbstractKualiDecimal)new BudgetDecimal(laSalariesAndWagesType.getSalaryAndFringeTotal()));
            salariesAndWagesTypeList.add(laSalariesAndWagesType);
        }
        budgetPeriodType.setSalariesWagesTotal(totalSalary.bigDecimalValue());
        budgetPeriodType.setSalariesAndWagesArray(salariesAndWagesTypeList.toArray(new SalariesAndWagesType[0]));
    }

    private SalariesAndWagesType getLAAmmountsAsSalaryRecord(DevelopmentProposal developmentProposal, Budget budget, BudgetPeriod budgetPeriod) {
        List budgetLineItems = budgetPeriod.getBudgetLineItems();
        BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
        BudgetDecimal fringe = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            List budgetLineItemCalcAmounts = budgetLineItem.getBudgetCalculatedAmounts();
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItemCalcAmounts) {
                if (budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                    salaryRequested = (BudgetDecimal)salaryRequested.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
                }
                if ((!budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType()) || !budgetLineItemCalculatedAmount.getRateTypeCode().equals("3")) && (!budgetLineItemCalculatedAmount.getRateClass().getRateClassType().equals(RateClassType.VACATION.getRateClassType()) || !budgetLineItemCalculatedAmount.getRateTypeCode().equals("2"))) continue;
                fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
            }
        }
        if (salaryRequested.isZero()) {
            return null;
        }
        SalariesAndWagesType salariesAndWagesType = SalariesAndWagesType.Factory.newInstance();
        salariesAndWagesType.setName(this.getContactPersonFullName("Lab Allocation", "", ""));
        salariesAndWagesType.setRequestedCost(salaryRequested.bigDecimalValue());
        salariesAndWagesType.setFringeCost(fringe.bigDecimalValue());
        salariesAndWagesType.setSalaryAndFringeTotal(((BudgetDecimal)salaryRequested.add((AbstractKualiDecimal)fringe)).bigDecimalValue());
        return salariesAndWagesType;
    }

    private SalariesAndWagesType getSalariesAndWagesType(DevelopmentProposal developmentProposal, Budget budget, BudgetPersonnelDetails budgetPersDetails, BudgetPerson budgetPerson) {
        SalariesAndWagesType salariesAndWagesType;
        block2: {
            salariesAndWagesType = SalariesAndWagesType.Factory.newInstance();
            salariesAndWagesType.setAppointmentType(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode());
            salariesAndWagesType.setAppointmentMonths(new BigDecimal(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode()));
            salariesAndWagesType.setSummerFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "4").bigDecimalValue());
            salariesAndWagesType.setAcademicFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "2").bigDecimalValue());
            salariesAndWagesType.setFundingMonths(this.calculateFundingMonths(developmentProposal, budgetPersDetails, "3").bigDecimalValue());
            try {
                KcPerson person = budgetPerson.getPerson();
                salariesAndWagesType.setName(this.getContactPersonFullName(person.getLastName(), person.getFirstName(), person.getMiddleName()));
            }
            catch (IllegalArgumentException ie) {
                Rolodex rolodex = budgetPerson.getRolodex();
                if (rolodex == null) break block2;
                salariesAndWagesType.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
            }
        }
        salariesAndWagesType.setProjectRole(this.getProjectRoleType(developmentProposal, budgetPerson));
        salariesAndWagesType.setProjectRoleDescription(budgetPerson.getRole());
        salariesAndWagesType.setSalariesTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        BigDecimal fringe = this.getFringeCost(budgetPersDetails).bigDecimalValue();
        salariesAndWagesType.setFringeCost(fringe);
        salariesAndWagesType.setRequestedCost(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        salariesAndWagesType.setBaseSalary(budgetPerson.getCalculationBase().bigDecimalValue());
        salariesAndWagesType.setSalaryAndFringeTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue().add(fringe));
        return salariesAndWagesType;
    }

    private ResearchCoverPageDocument.ResearchCoverPage getResearchCoverPage(DevelopmentProposal developmentProposal, Budget budget) throws ParseException {
        ResearchCoverPageDocument.ResearchCoverPage researchCoverPage = ResearchCoverPageDocument.ResearchCoverPage.Factory.newInstance();
        developmentProposal.refreshNonUpdateableReferences();
        researchCoverPage.setSubmissionCategory(this.getSubmissionCategoryForResearchCoverPage(developmentProposal.getActivityType().getDescription(), developmentProposal.getProposalStateTypeCode()));
        researchCoverPage.setApplicationCategory(this.getApplicationCategoryForResearchCoverPage(developmentProposal.getProposalType().getDescription()));
        this.setApplicantSubmissionQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewApplicantSubmissionQualifiers());
        this.setFederalAgencyReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalAgencyReceiptQualifiers());
        this.setStateReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateReceiptQualifiers());
        this.setStateIntergovernmentalReviewForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateIntergovernmentalReview());
        this.setFederalDebtDelinquencyQuestionForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalDebtDelinquencyQuestions());
        researchCoverPage.setProjectDates(this.getProjectDatesForResearchCoverPage(developmentProposal.getRequestedStartDateInitial(), developmentProposal.getRequestedEndDateInitial()));
        researchCoverPage.setBudgetTotals(this.getBudgetTotalsForResearchCoverPage(budget));
        researchCoverPage.setProjectTitle(developmentProposal.getTitle() == null ? "Unknown" : developmentProposal.getTitle());
        researchCoverPage.setOtherAgencyQuestions(this.getOtherAgencyQuestionsForResearchCoverPage(developmentProposal));
        researchCoverPage.setApplicantOrganization(this.getApplicantOrganizationForResearchCoverPage(developmentProposal));
        researchCoverPage.setPrimaryProjectSite(this.getProjectSiteForResearchCoverPage(developmentProposal));
        researchCoverPage.setProgramDirectorPrincipalInvestigator(this.getProgramDirectorPrincipalInvestigatorForResearchCoverPage(developmentProposal));
        researchCoverPage.setFundingOpportunityDetails(this.getFundingOpportunityDetailsForResearchCoverPage(developmentProposal));
        researchCoverPage.setAuthorizedOrganizationalRepresentative(this.getAuthorizedOrganizationalRepresentative(developmentProposal));
        this.setAlternateProjectSites(developmentProposal, researchCoverPage);
        return researchCoverPage;
    }

    private void setAlternateProjectSites(DevelopmentProposal developmentProposal, ResearchCoverPageDocument.ResearchCoverPage researchCoverPage) {
        List otherOrganizations = developmentProposal.getOtherOrganizations();
        this.setPerformanceSites(researchCoverPage, otherOrganizations);
        List proposalSites = developmentProposal.getPerformanceSites();
        this.setPerformanceSites(researchCoverPage, proposalSites);
    }

    private void setPerformanceSites(ResearchCoverPageDocument.ResearchCoverPage researchCoverPage, List<ProposalSite> proposalSites) {
        for (ProposalSite proposalSite : proposalSites) {
            ProjectSiteType projectSiteType = researchCoverPage.addNewAlternateProjectSites();
            Rolodex rolodexBean = proposalSite.getRolodex();
            if (rolodexBean == null) {
                rolodexBean = proposalSite.getOrganization().getRolodex();
            }
            projectSiteType.setOrganizationName(rolodexBean.getOrganization());
            this.setPostalAddressInfo(rolodexBean, projectSiteType);
            List congressionalDistricts = proposalSite.getCongressionalDistricts();
            String congrDistName = null;
            for (CongressionalDistrict congressionalDistrict : congressionalDistricts) {
                congrDistName = congrDistName == null ? congressionalDistrict.getCongressionalDistrict() : congrDistName + "," + congressionalDistrict.getCongressionalDistrict();
            }
            projectSiteType.setCongressionalDistrict(congrDistName);
        }
    }

    private void setPostalAddressInfo(Rolodex rolodexBean, ProjectSiteType projectSiteType) {
        PostalAddressType postalAddressType = projectSiteType.addNewPostalAddress();
        postalAddressType.setCity(rolodexBean.getCity() == null || rolodexBean.getCity().trim().equals("") ? "Unknown" : rolodexBean.getCity());
        postalAddressType.setPostalCode(rolodexBean.getPostalCode() == null || rolodexBean.getPostalCode().trim().equals("") ? "Unknown" : rolodexBean.getPostalCode());
        postalAddressType.setCountry(rolodexBean.getCountryCode() == null || rolodexBean.getCountryCode().trim().equals("") ? "Unknown" : rolodexBean.getCountryCode());
        if (rolodexBean.getState() != null) {
            postalAddressType.setState(rolodexBean.getState());
        }
        if (rolodexBean.getAddressLine1() != null) {
            XmlToken street = postalAddressType.addNewStreet();
            street.setStringValue(rolodexBean.getAddressLine1());
        }
        if (rolodexBean.getAddressLine2() != null) {
            XmlToken street2 = postalAddressType.addNewStreet();
            street2.setStringValue(rolodexBean.getAddressLine2());
        }
        if (rolodexBean.getAddressLine3() != null) {
            XmlToken street3 = postalAddressType.addNewStreet();
            street3.setStringValue(rolodexBean.getAddressLine3());
        }
    }

    private AuthorizedOrganizationalRepresentativeType getAuthorizedOrganizationalRepresentative(DevelopmentProposal developmentProposal) {
        Organization authorisedOrg = this.getAuthorisedOrganization(developmentProposal);
        Rolodex rolodex = authorisedOrg.getRolodex();
        AuthorizedOrganizationalRepresentativeType authOrgRepType = AuthorizedOrganizationalRepresentativeType.Factory.newInstance();
        if (authorisedOrg != null) {
            authOrgRepType.setPositionTitle(rolodex.getTitle());
            authOrgRepType.setContactInformation(this.getPersonContactInformation(rolodex));
            authOrgRepType.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
        } else {
            authOrgRepType.setName(this.getContactPersonFullName("Unknown", "Unknown", "Unknown"));
            authOrgRepType.setPositionTitle("Unknown");
            authOrgRepType.setContactInformation(this.getOrganizationPersonContactInformationWithDefaultValues());
        }
        return authOrgRepType;
    }

    private Organization getAuthorisedOrganization(DevelopmentProposal developmentProposal) {
        Organization authorisedOrg = null;
        for (ProposalSite proposalSite : developmentProposal.getProposalSites()) {
            if (proposalSite.getLocationTypeCode() != 1) continue;
            authorisedOrg = proposalSite.getOrganization();
        }
        return authorisedOrg;
    }

    private FundingOpportunityDetailsType getFundingOpportunityDetailsForResearchCoverPage(DevelopmentProposal developmentProposal) {
        FundingOpportunityDetailsType fundingOpportunityType = FundingOpportunityDetailsType.Factory.newInstance();
        String programAnnouncementNumber = developmentProposal.getProgramAnnouncementNumber();
        String programAnnouncementTitle = developmentProposal.getProgramAnnouncementTitle();
        fundingOpportunityType.setFundingOpportunityNumber(programAnnouncementNumber == null ? " " : programAnnouncementNumber);
        fundingOpportunityType.setFundingOpportunityTitle(programAnnouncementTitle == null ? " " : programAnnouncementTitle);
        fundingOpportunityType.setFundingOpportunityResponseCode(developmentProposal.getS2sOpportunity() != null);
        return fundingOpportunityType;
    }

    private ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator getProgramDirectorPrincipalInvestigatorForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator principalInvestigatorType = ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator.Factory.newInstance();
        ProposalPerson principalInvestigator = PrintingUtils.getPrincipalInvestigator((List)developmentProposal.getProposalPersons());
        if (principalInvestigator != null) {
            principalInvestigatorType.setContactInformation(this.getPersonContactInformation(principalInvestigator));
            principalInvestigatorType.setName(this.getContactPersonFullName(principalInvestigator.getLastName(), principalInvestigator.getFirstName(), principalInvestigator.getMiddleName()));
            if (principalInvestigator.getEraCommonsUserName() == null) {
                principalInvestigatorType.setAccountIdentifier("Unknown");
            } else {
                principalInvestigatorType.setAccountIdentifier(principalInvestigator.getEraCommonsUserName());
            }
            principalInvestigatorType.setNewInvestigatorQuestion(this.getNewInvestQuestion(developmentProposal));
            this.setDegree(principalInvestigator, principalInvestigatorType);
            SignatureType signatureType = principalInvestigatorType.addNewDirectorInvestigatorSignature();
            signatureType.setSignatureAuthentication("unknown");
            signatureType.setSignatureDate(this.getDateTimeService().getCurrentCalendar());
        }
        return principalInvestigatorType;
    }

    private void setDegree(ProposalPerson principalInvestigator, ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator principalInvestigatorType) {
        List proposalPersonDegrees = principalInvestigator.getProposalPersonDegrees();
        for (ProposalPersonDegree proposalPersonDegree : proposalPersonDegrees) {
            principalInvestigatorType.addDegree(proposalPersonDegree.getDegree());
        }
    }

    private boolean getNewInvestQuestion(DevelopmentProposal developmentProposal) {
        List vecYNQQuestions = developmentProposal.getProposalYnqs();
        for (ProposalYnq proposalYnq : vecYNQQuestions) {
            if (!proposalYnq.getQuestionId().equals("13") || proposalYnq.getAnswer() == null || !proposalYnq.getAnswer().equals("Y")) continue;
            return true;
        }
        return false;
    }

    private ApplicantOrganizationType getApplicantOrganizationForResearchCoverPage(DevelopmentProposal developmentProposal) {
        Organization organization = developmentProposal.getApplicantOrganization().getOrganization();
        OrganizationType organizationType = organization.getOrganizationType(0);
        ApplicantOrganizationType applicantOrganizationType = ApplicantOrganizationType.Factory.newInstance();
        applicantOrganizationType.setOrganizationName(organization.getOrganizationName() == null ? "Unknown" : organization.getOrganizationName());
        applicantOrganizationType.setOrganizationDUNS(organization.getDunsNumber() == null ? "Unknown" : organization.getDunsNumber());
        applicantOrganizationType.setOrganizationEIN(organization.getFedralEmployerId() == null ? "Unknown" : "1" + organization.getFedralEmployerId() + "A1");
        if (organization.getPhsAccount() != null) {
            applicantOrganizationType.setPHSAccountID(organization.getPhsAccount());
        }
        applicantOrganizationType.setOrganizationCategoryCode(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeCode().toString());
        applicantOrganizationType.setOrganizationCategoryDescription(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeList().getDescription());
        applicantOrganizationType.setOrganizationCongressionalDistrict(organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict());
        applicantOrganizationType.setOrganizationAddress(this.getOrganizationAddress(organization.getRolodex()));
        applicantOrganizationType.setOrganizationContactPerson(this.getOrganizationContactPerson(developmentProposal.getApplicantOrganization().getRolodex()));
        String cageNumber = organization.getCageNumber();
        if (cageNumber != null) {
            applicantOrganizationType.setCageNumber(cageNumber);
        }
        ApplicantOrganizationType.OrganizationClassification orgClassification = applicantOrganizationType.addNewOrganizationClassification();
        List organizationTypes = organization.getOrganizationTypes();
        if (!organizationTypes.isEmpty()) {
            orgClassification.setCategoryCode(((OrganizationType)organizationTypes.get(0)).getOrganizationTypeCode().toString());
            orgClassification.setSubCategoryCode(((OrganizationType)organizationTypes.get(0)).getOrganizationTypeList().getDescription());
        }
        return applicantOrganizationType;
    }

    private String getUnitName(ProposalPerson proposalPerson) {
        String unitName = null;
        for (ProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            if (!proposalPersonUnit.isLeadUnit()) continue;
            Unit unit = proposalPersonUnit.getUnit();
            if (unit == null || unit.getUnitName() == null) break;
            unitName = unit.getUnitName();
            break;
        }
        return unitName;
    }

    private KeyPersonType.KeyPersonFlag getKeyPersonFlag(ProposalPerson proposalPerson) {
        KeyPersonType.KeyPersonFlag keyPersonFlag = KeyPersonType.KeyPersonFlag.Factory.newInstance();
        keyPersonFlag.setKeyPersonFlagCode("true");
        keyPersonFlag.setKeyPersonFlagDesc("Key Person");
        return keyPersonFlag;
    }

    private ContactInfoType getContactInfoType(ProposalPerson proposalPerson) {
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        contactInfoType.setEmail(proposalPerson.getEmailAddress());
        contactInfoType.setFaxNumber(proposalPerson.getFaxNumber());
        contactInfoType.setPhoneNumber(proposalPerson.getPhoneNumber());
        PostalAddressType postalAddressType = this.getPostalAddressType(proposalPerson);
        contactInfoType.setPostalAddress(postalAddressType);
        return contactInfoType;
    }

    private PostalAddressType getPostalAddressType(ProposalPerson proposalPerson) {
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setCity(proposalPerson.getCity());
        postalAddressType.setCountry(proposalPerson.getCounty());
        postalAddressType.setPostalCode(proposalPerson.getPostalCode());
        postalAddressType.setState(proposalPerson.getState());
        return postalAddressType;
    }

    private PersonFullNameType getPersonFullName(ProposalPerson proposalPerson) {
        PersonFullNameType personFullNameType = PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName(proposalPerson.getFirstName());
        personFullNameType.setLastName(proposalPerson.getLastName());
        personFullNameType.setMiddleName(proposalPerson.getMiddleName());
        return personFullNameType;
    }

    private gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.OrgAssurancesType getOrgAssurances(DevelopmentProposal developmentProposal) {
        gov.nih.era.projectmgmt.sbir.cgap.nihspecificNamespace.OrgAssurancesType orgAssurancesType = OrgAssurancesType.Factory.newInstance();
        List organizationYnqs = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getOrganizationId() != null) {
            organizationYnqs = this.getOrganizationYNQ(organization.getOrganizationId());
        }
        if (organizationYnqs != null) {
            for (OrganizationYnq organizationYnq : organizationYnqs) {
                if (organizationYnq.getQuestionId().equals("H0")) {
                    orgAssurancesType.setLobbyingQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
                }
                if (!organizationYnq.getQuestionId().equals("H6")) continue;
                orgAssurancesType.setGeneralCertificationQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
            }
            orgAssurancesType.setDebarmentAndSuspension(this.getAssuranceType(organizationYnqs, "I8"));
            orgAssurancesType.setDrugFreeWorkplace(this.getAssuranceType(organizationYnqs, "H5"));
        }
        return orgAssurancesType;
    }

    private AssuranceType getAssuranceType(List<OrganizationYnq> organizationYnqs, String questionId) {
        AssuranceType assuranceType = AssuranceType.Factory.newInstance();
        for (OrganizationYnq organizationYnq : organizationYnqs) {
            if (!organizationYnq.getQuestionId().equals(questionId)) continue;
            assuranceType.setYesNoAnswer(this.getAnswerFromOrganizationYnq(organizationYnq));
            assuranceType.setExplanation(this.getExplanationFromOrganizationYnq(organizationYnq));
        }
        return assuranceType;
    }

    private String getExplanationFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getExplanation() == null ? " " : organizationYnq.getExplanation();
    }

    private ProjectDescriptionDocument.ProjectDescription getProjectDescription(DevelopmentProposal developmentProposal) {
        ProjectDescriptionDocument.ProjectDescription projectDescription = ProjectDescriptionDocument.ProjectDescription.Factory.newInstance();
        projectDescription.setHumanSubject(this.getHumanSubjectsType(developmentProposal));
        projectDescription.setAnimalSubject(this.getAnimalSubject(developmentProposal));
        projectDescription.setProjectSurvey(this.getProjectSurvey(developmentProposal));
        projectDescription.setProjectSummary(this.getDescriptionBlockType(developmentProposal, "summary", true));
        projectDescription.setFacilitiesDescription(this.getDescriptionBlockType(developmentProposal, "facilities", false));
        projectDescription.setEquipmentDescription(this.getDescriptionBlockType(developmentProposal, "equipment", false));
        projectDescription.setReferences(this.getDescriptionBlockType(developmentProposal, "references", true));
        return projectDescription;
    }

    private DescriptionBlockType getDescriptionBlockType(DevelopmentProposal developmentProposal, String blockType, boolean isFile) {
        DescriptionBlockType descriptionBlockType = DescriptionBlockType.Factory.newInstance();
        if (isFile) {
            descriptionBlockType.setFileIdentifier(developmentProposal.getProposalNumber() + blockType);
        } else {
            descriptionBlockType.setText(blockType);
        }
        return descriptionBlockType;
    }

    private HumanSubjectsType getHumanSubjectsType(DevelopmentProposal developmentProposal) {
        HumanSubjectsType humanSubjectsType = HumanSubjectsType.Factory.newInstance();
        String[] exemptionNumber = new String[6];
        List specialReviewList = developmentProposal.getPropSpecialReviews();
        int arrayIndex = 0;
        if (specialReviewList != null) {
            for (ProposalSpecialReview proposalSpecialReview : specialReviewList) {
                String comments;
                boolean humanSubjectsUsedQuestion = this.getHumanSubjectsUsedQuestion(proposalSpecialReview);
                humanSubjectsType.setHumanSubjectsUsedQuestion(humanSubjectsUsedQuestion);
                if (!proposalSpecialReview.getApprovalTypeCode().equals("4") && proposalSpecialReview.getApprovalDate() != null) {
                    humanSubjectsType.setIRBApprovalDate(this.getDateTimeService().getCalendar((Date)proposalSpecialReview.getApprovalDate()));
                    break;
                }
                exemptionNumber[arrayIndex] = comments = this.getSpecialReviewComments(proposalSpecialReview);
                ++arrayIndex;
            }
        }
        this.setEXemptionNumber(developmentProposal, humanSubjectsType, exemptionNumber);
        this.setPhase3ClinicalTrialQuestion(developmentProposal, humanSubjectsType);
        return humanSubjectsType;
    }

    private void setPhase3ClinicalTrialQuestion(DevelopmentProposal developmentProposal, HumanSubjectsType humanSubjectsType) {
        humanSubjectsType.setPhase3ClinicalTrialQuestion(false);
        String strAnswer = this.getClinicalTrialQuestion(developmentProposal);
        if (strAnswer != null) {
            humanSubjectsType.setPhase3ClinicalTrialQuestion(strAnswer.equals("Y"));
        }
    }

    private String getClinicalTrialQuestion(DevelopmentProposal developmentProposal) {
        String clinicalAnswer = "N";
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals(PROPOSAL_YNQ_QUESTION_17)) continue;
            clinicalAnswer = proposalYnq.getAnswer();
        }
        return clinicalAnswer == null ? "N" : clinicalAnswer;
    }

    private boolean getHumanSubjectsUsedQuestion(ProposalSpecialReview proposalSpecialReview) {
        boolean humanSubjectsUsedQuestion = false;
        if (proposalSpecialReview.getSpecialReviewTypeCode() != null && proposalSpecialReview.getSpecialReviewTypeCode().equals("1")) {
            humanSubjectsUsedQuestion = true;
        }
        return humanSubjectsUsedQuestion;
    }

    private void setEXemptionNumber(DevelopmentProposal developmentProposal, HumanSubjectsType humanSubjectsType, String[] exemptionNumber) {
        if (humanSubjectsType.getHumanSubjectsUsedQuestion()) {
            String humanSubAssurance = this.getHumanAssuranceNumber(developmentProposal);
            if (humanSubAssurance != null) {
                humanSubjectsType.setAssuranceNumber(humanSubAssurance);
            }
        } else {
            humanSubjectsType.setExemptionNumberArray(exemptionNumber);
        }
    }

    private String getSpecialReviewComments(ProposalSpecialReview proposalSpecialReview) {
        String comments = null;
        comments = proposalSpecialReview.getComments() == null ? "Unknown" : proposalSpecialReview.getComments();
        return comments;
    }

    private String getHumanAssuranceNumber(DevelopmentProposal developmentProposal) {
        String humanSubAssurance = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getHumanSubAssurance() != null) {
            humanSubAssurance = organization.getHumanSubAssurance();
        }
        return humanSubAssurance;
    }

    private BudgetDecimal calculateFundingMonths(DevelopmentProposal developmentProposal, BudgetPersonnelDetails budgetPersonnelDetails, String budgetPeriodType) {
        BudgetDecimal fundingMonths = BudgetDecimal.ZERO;
        if (this.isPersonExistsInProposal(developmentProposal, budgetPersonnelDetails) && budgetPeriodType.equals(budgetPersonnelDetails.getPeriodTypeCode()) && budgetPersonnelDetails != null) {
            BigDecimal totalMonths = this.getMonthsBetweenDates((Date)budgetPersonnelDetails.getStartDate(), (Date)budgetPersonnelDetails.getEndDate());
            fundingMonths = budgetPersonnelDetails.getPercentEffort().multiply(new BudgetDecimal(totalMonths));
            fundingMonths = fundingMonths.divide(new BudgetDecimal(100));
        }
        return fundingMonths.setScale(0);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public SponsorService getSponsorService() {
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

