/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.printing.xmlstream;

import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.AssuranceType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.ContactInfoType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.PostalAddressType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ApplicantOrganizationType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.AuthorizedOrganizationalRepresentativeType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.BudgetPeriodType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.BudgetSummaryType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.DescriptionBlockType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.FundingOpportunityDetailsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.HumanSubjectsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.KeyPersonType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OrgAssurancesType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ParticipantType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.PersonFullNameType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProgramDirectorPrincipalInvestigatorDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectDescriptionDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ResearchAndRelatedProjectDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ResearchCoverPageDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.SalariesAndWagesType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.printing.xmlstream.AbstractResearchAndRelatedStream;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class ResearchAndRelatedXmlStream
extends AbstractResearchAndRelatedStream {
    private static final Log LOG = LogFactory.getLog(ResearchAndRelatedXmlStream.class);
    private static final String ORGANIZATION_QUESTION_ID_H5 = "H5";
    private static final String ORGANIZATION_QUESTION_ID_I8 = "I8";
    private static final String DEFAULT_VALUE_FOR_SSN = "XXXXXXXXX";
    private static final String DEFAULT_VALUE_FOR_KEY_PERSON_FLAG_DESCRIPTION = "PI";
    private static final String DEFAULT_VALUE_KEY_PERSON_FLAG_CODE = "true";
    private static final String KEY_PERSON_FLAG_DESCRIPTION_VALUE_COLLABORATOR = "Collaborator/Other";
    private static final String KEY_PERSON_FLAG_DESCRIPTION_VALUE_KEY_PERSON = "Key Person";
    private static final String KEY_PERSON_FLAG_CODE_VALUE_FALSE = "false";
    private static final String GENERAL_CERTIFICATION_QUESTION_ID = "H6";
    private static final String LOBBYING_QUESTION_ID = "H0";
    private static final String REFERENCES_BLOCK_TYPE = "references";
    private static final String EQUIPMENT_BLOCK_TYPE = "equipment";
    private static final String FACILITIES_BLOCK_TYPE = "facilities";
    private static final String PROJECT_SUMMARY_BLOCK_TYPE = "summary";
    private static final String SPECIAL_REVIEW_CODE_1 = "1";
    private static final String APPROVAL_TYPE_EXEMPT = "4";

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        Budget budget = this.getBudget(developmentProposal.getProposalDocument());
        ResearchAndRelatedProjectDocument researchAndRelatedProjectDocument = ResearchAndRelatedProjectDocument.Factory.newInstance();
        researchAndRelatedProjectDocument.setResearchAndRelatedProject(this.getResearchAndRelatedProject(developmentProposal, budget));
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        xmlObjectList.put("Research and Related", (XmlObject)researchAndRelatedProjectDocument);
        return xmlObjectList;
    }

    private ResearchAndRelatedProjectDocument.ResearchAndRelatedProject getResearchAndRelatedProject(DevelopmentProposal developmentProposal, Budget budget) {
        ResearchAndRelatedProjectDocument.ResearchAndRelatedProject researchAndRelatedProject = ResearchAndRelatedProjectDocument.ResearchAndRelatedProject.Factory.newInstance();
        researchAndRelatedProject.setProjectDescription(this.getProjectDescription(developmentProposal));
        researchAndRelatedProject.setOrgAssurances(this.getOrgAssurances(developmentProposal));
        researchAndRelatedProject.setKeyPerson(this.getKeyPersonType(developmentProposal));
        researchAndRelatedProject.setResearchCoverPage(this.getResearchCoverPage(developmentProposal, budget));
        researchAndRelatedProject.setBudgetSummary(this.getBudgetSummary(developmentProposal, budget));
        return researchAndRelatedProject;
    }

    private BudgetSummaryType getBudgetSummary(DevelopmentProposal developmentProposal, Budget budget) {
        BudgetSummaryType budgetSummaryType = BudgetSummaryType.Factory.newInstance();
        if (budget != null) {
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod(1);
            budgetSummaryType.setInitialBudgetTotals(this.getBudgetTotals(budgetPeriod.getTotalCost(), budgetPeriod.getCostSharingAmount()));
            budgetSummaryType.setAllBudgetTotals(this.getBudgetTotals(budget.getTotalCost(), budget.getCostSharingAmount()));
            budgetSummaryType.setBudgetPeriodArray(this.getBudgetPeriodArray(developmentProposal, budget.getBudgetPeriods()));
            budgetSummaryType.setBudgetJustification(this.getBudgetJustification(developmentProposal.getProposalNumber()));
            budgetSummaryType.setBudgetDirectCostsTotal(budget.getTotalDirectCost().bigDecimalValue());
            budgetSummaryType.setBudgetIndirectCostsTotal(budget.getTotalIndirectCost().bigDecimalValue());
            budgetSummaryType.setBudgetCostsTotal(budget.getTotalCost().bigDecimalValue());
        }
        return budgetSummaryType;
    }

    private BudgetPeriodType[] getBudgetPeriodArray(DevelopmentProposal developmentProposal, List<BudgetPeriod> budgetPeriodList) {
        ArrayList<BudgetPeriodType> budgetPeriodTypeList = new ArrayList<BudgetPeriodType>();
        for (BudgetPeriod budgetPeriod : budgetPeriodList) {
            if (budgetPeriod.getBudgetPeriod() == null) continue;
            List budgetLineItems = budgetPeriod.getBudgetLineItems();
            BudgetPeriodType budgetPeriodType = BudgetPeriodType.Factory.newInstance();
            budgetPeriodType.setBudgetPeriodID(new BigInteger(String.valueOf(budgetPeriod.getBudgetPeriod())));
            budgetPeriodType.setStartDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getStartDate()));
            budgetPeriodType.setEndDate(this.getDateTimeService().getCalendar((Date)budgetPeriod.getEndDate()));
            budgetPeriodType.setFee(new BigDecimal(0));
            budgetPeriodType.setSalariesWagesTotal(this.getSalaryWagesTotal(budgetLineItems));
            budgetPeriodType.setSalariesAndWagesArray(this.getSalaryAndWages(developmentProposal, budgetLineItems));
            budgetPeriodType.setEquipmentTotal(this.getEquipmentTotal(budgetLineItems));
            budgetPeriodType.setEquipmentCostsArray(this.getEquipmentCosts(budgetLineItems));
            budgetPeriodType.setOtherDirectCostsArray(this.getOtherDirectCosts(developmentProposal, budgetLineItems));
            budgetPeriodType.setOtherDirectTotal(this.getOtherDirectTotal(budgetLineItems));
            budgetPeriodType.setTravelCostsArray(this.getTravelCosts(budgetLineItems));
            budgetPeriodType.setTravelTotal(this.getTravelTotal(budgetLineItems));
            budgetPeriodType.setParticipantPatientCostsArray(this.getParticipantPatientCost(developmentProposal, budgetLineItems));
            budgetPeriodType.setParticipantPatientTotal(this.getParticipantPatientTotal(budgetLineItems));
            budgetPeriodType.setPeriodDirectCostsTotal(budgetPeriod.getTotalDirectCost().bigDecimalValue());
            budgetPeriodType.setIndirectCostsTotal(budgetPeriod.getTotalIndirectCost().bigDecimalValue());
            budgetPeriodType.setPeriodCostsTotal(budgetPeriod.getTotalCost().bigDecimalValue());
            budgetPeriodType.setProgramIncome(new BigDecimal(0));
            budgetPeriodTypeList.add(budgetPeriodType);
        }
        return budgetPeriodTypeList.toArray(new BudgetPeriodType[0]);
    }

    private BudgetDecimal getSalaryWagesTotalForLineItem(BudgetPersonnelDetails budgetPersDetails) {
        BudgetDecimal salaryAndWages = BudgetDecimal.ZERO;
        salaryAndWages = (BudgetDecimal)salaryAndWages.add((AbstractKualiDecimal)budgetPersDetails.getSalaryRequested());
        salaryAndWages = (BudgetDecimal)salaryAndWages.add((AbstractKualiDecimal)this.getFringeCost(budgetPersDetails));
        return salaryAndWages;
    }

    protected boolean isRateAndBaseOfRateClassTypeOverhead(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeOverhead : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.OVERHEAD.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType());
    }

    private boolean isRateAndBaseOfRateClassTypeEB(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeEB : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType());
    }

    private boolean isRateAndBaseOfRateClassTypeVacation(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug((Object)"isRateAndBaseOfRateClassTypeVacation : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.VACATION.getRateClassType().equals(rateAndBase.getRateClass().getRateClassType());
    }

    private ParticipantType.Enum getParticipantPatientType(String budgetCatgoryDesc) {
        ParticipantType.Enum participantType = ParticipantType.Enum.forString((String)budgetCatgoryDesc);
        if (participantType == null) {
            participantType = ParticipantType.OTHER;
        }
        return participantType;
    }

    protected OtherDirectType.Enum getOtherDirectType(String budgetCategoryDesc) {
        OtherDirectType.Enum otherDirectType = OtherDirectType.Enum.forString((String)budgetCategoryDesc);
        if (otherDirectType == null) {
            otherDirectType = OtherDirectType.OTHER;
        }
        return otherDirectType;
    }

    private SalariesAndWagesType[] getSalaryAndWages(DevelopmentProposal developmentProposal, List<BudgetLineItem> budgetLineItems) {
        ArrayList<SalariesAndWagesType> salariesAndWagesTypeList = new ArrayList<SalariesAndWagesType>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                budgetPersDetails.refreshNonUpdateableReferences();
                BudgetPerson budgetPerson = budgetPersDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                SalariesAndWagesType salariesAndWagesType = this.getSalariesAndWagesType(developmentProposal, budgetPersDetails, budgetPerson);
                salariesAndWagesTypeList.add(salariesAndWagesType);
            }
        }
        return salariesAndWagesTypeList.toArray(new SalariesAndWagesType[0]);
    }

    private SalariesAndWagesType getSalariesAndWagesType(DevelopmentProposal deveopmentProposal, BudgetPersonnelDetails budgetPersDetails, BudgetPerson budgetPerson) {
        SalariesAndWagesType salariesAndWagesType = SalariesAndWagesType.Factory.newInstance();
        salariesAndWagesType.setAppointmentType(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode());
        salariesAndWagesType.setAppointmentMonths(new BigDecimal(budgetPerson.getAppointmentTypeCode() == null ? "" : budgetPerson.getAppointmentTypeCode()));
        salariesAndWagesType.setSummerFundingMonths(BigDecimal.ZERO);
        salariesAndWagesType.setAcademicFundingMonths(new BigDecimal(0.0));
        salariesAndWagesType.setFundingMonths(new BigDecimal(0.0));
        KcPerson person = budgetPerson.getPerson();
        salariesAndWagesType.setName(this.getContactPersonFullName(person.getLastName(), person.getFirstName(), person.getMiddleName()));
        salariesAndWagesType.setProjectRole(this.getProjectRoleType(deveopmentProposal, budgetPerson));
        salariesAndWagesType.setProjectRoleDescription(budgetPerson.getRole());
        salariesAndWagesType.setSalariesTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        BigDecimal fringe = this.getFringeCost(budgetPersDetails).bigDecimalValue();
        salariesAndWagesType.setFringeCost(fringe);
        salariesAndWagesType.setRequestedCost(budgetPersDetails.getSalaryRequested().bigDecimalValue());
        salariesAndWagesType.setBaseSalary(budgetPerson.getCalculationBase().bigDecimalValue());
        salariesAndWagesType.setSalaryAndFringeTotal(budgetPersDetails.getSalaryRequested().bigDecimalValue().add(fringe));
        return salariesAndWagesType;
    }

    private ResearchCoverPageDocument.ResearchCoverPage getResearchCoverPage(DevelopmentProposal developmentProposal, Budget budget) {
        developmentProposal.refreshNonUpdateableReferences();
        ResearchCoverPageDocument.ResearchCoverPage researchCoverPage = ResearchCoverPageDocument.ResearchCoverPage.Factory.newInstance();
        researchCoverPage.setSubmissionCategory(this.getSubmissionCategoryForResearchCoverPage(developmentProposal.getActivityType().getDescription(), developmentProposal.getProposalStateTypeCode()));
        researchCoverPage.setApplicationCategory(this.getApplicationCategoryForResearchCoverPage(developmentProposal.getProposalType().getDescription()));
        this.setApplicantSubmissionQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewApplicantSubmissionQualifiers());
        this.setFederalAgencyReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalAgencyReceiptQualifiers());
        this.setStateReceiptQualifiersForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateReceiptQualifiers());
        this.setStateIntergovernmentalReviewForResearchCoverPage(developmentProposal, researchCoverPage.addNewStateIntergovernmentalReview());
        this.setFederalDebtDelinquencyQuestionForResearchCoverPage(developmentProposal, researchCoverPage.addNewFederalDebtDelinquencyQuestions());
        researchCoverPage.setProjectDates(this.getProjectDatesForResearchCoverPage(developmentProposal.getRequestedStartDateInitial(), developmentProposal.getRequestedEndDateInitial()));
        researchCoverPage.setBudgetTotals(this.getBudgetTotalsForResearchCoverPage(budget));
        researchCoverPage.setProjectTitle(developmentProposal.getTitle() == null ? "Unknown" : developmentProposal.getTitle());
        researchCoverPage.setOtherAgencyQuestions(this.getOtherAgencyQuestionsForResearchCoverPage(developmentProposal));
        researchCoverPage.setApplicantOrganization(this.getApplicantOrganizationForResearchCoverPage(developmentProposal));
        researchCoverPage.setPrimaryProjectSite(this.getProjectSiteForResearchCoverPage(developmentProposal));
        researchCoverPage.setProgramDirectorPrincipalInvestigator(this.getProgramDirectorPrincipalInvestigatorForResearchCoverPage(developmentProposal));
        researchCoverPage.setFundingOpportunityDetails(this.getFundingOpportunityDetailsForResearchCoverPage(developmentProposal));
        researchCoverPage.setAuthorizedOrganizationalRepresentative(this.getAuthorizedOrganizationalRepresentative(developmentProposal));
        return researchCoverPage;
    }

    private AuthorizedOrganizationalRepresentativeType getAuthorizedOrganizationalRepresentative(DevelopmentProposal developmentProposal) {
        Organization authorisedOrg = this.getAuthorisedOrganization(developmentProposal);
        Rolodex rolodex = authorisedOrg.getRolodex();
        AuthorizedOrganizationalRepresentativeType authOrgRepType = AuthorizedOrganizationalRepresentativeType.Factory.newInstance();
        if (authorisedOrg != null) {
            authOrgRepType.setPositionTitle(rolodex.getTitle());
            authOrgRepType.setContactInformation(this.getPersonContactInformation(rolodex));
            authOrgRepType.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
        } else {
            authOrgRepType.setName(this.getContactPersonFullName("Unknown", "Unknown", "Unknown"));
            authOrgRepType.setPositionTitle("Unknown");
            authOrgRepType.setContactInformation(this.getOrganizationPersonContactInformationWithDefaultValues());
        }
        return authOrgRepType;
    }

    private Organization getAuthorisedOrganization(DevelopmentProposal developmentProposal) {
        Organization authorisedOrg = null;
        for (ProposalSite proposalSite : developmentProposal.getProposalSites()) {
            if (proposalSite.getLocationTypeCode() != 1) continue;
            authorisedOrg = proposalSite.getOrganization();
        }
        return authorisedOrg;
    }

    private FundingOpportunityDetailsType getFundingOpportunityDetailsForResearchCoverPage(DevelopmentProposal developmentProposal) {
        FundingOpportunityDetailsType fundingOpportunityType = FundingOpportunityDetailsType.Factory.newInstance();
        String programAnnouncementNumber = developmentProposal.getProgramAnnouncementNumber();
        String programAnnouncementTitle = developmentProposal.getProgramAnnouncementTitle();
        fundingOpportunityType.setFundingOpportunityNumber(programAnnouncementNumber == null ? " " : programAnnouncementNumber);
        fundingOpportunityType.setFundingOpportunityTitle(programAnnouncementTitle == null ? " " : programAnnouncementTitle);
        return fundingOpportunityType;
    }

    private ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator getProgramDirectorPrincipalInvestigatorForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator principalInvestigatorType = ProgramDirectorPrincipalInvestigatorDocument.ProgramDirectorPrincipalInvestigator.Factory.newInstance();
        ProposalPerson principalInvestigator = PrintingUtils.getPrincipalInvestigator((List)developmentProposal.getProposalPersons());
        principalInvestigatorType.setContactInformation(this.getPersonContactInformation(principalInvestigator));
        principalInvestigatorType.setName(this.getContactPersonFullName(principalInvestigator.getLastName(), principalInvestigator.getFirstName(), principalInvestigator.getMiddleName()));
        return principalInvestigatorType;
    }

    private ApplicantOrganizationType getApplicantOrganizationForResearchCoverPage(DevelopmentProposal developmentProposal) {
        Organization organization = developmentProposal.getApplicantOrganization().getOrganization();
        OrganizationType organizationType = organization.getOrganizationType(0);
        ApplicantOrganizationType applicantOrganizationType = ApplicantOrganizationType.Factory.newInstance();
        applicantOrganizationType.setOrganizationName(organization.getOrganizationName() == null ? "Unknown" : organization.getOrganizationName());
        applicantOrganizationType.setOrganizationDUNS(organization.getDunsNumber() == null ? "Unknown" : organization.getDunsNumber());
        applicantOrganizationType.setOrganizationEIN(organization.getFedralEmployerId() == null ? "Unknown" : organization.getFedralEmployerId());
        if (organization.getPhsAccount() != null) {
            applicantOrganizationType.setPHSAccountID(organization.getPhsAccount());
        }
        applicantOrganizationType.setOrganizationCategoryCode(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeCode().toString());
        applicantOrganizationType.setOrganizationCategoryDescription(organizationType == null ? "Unknown" : organizationType.getOrganizationTypeList().getDescription());
        applicantOrganizationType.setOrganizationCongressionalDistrict(organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict());
        applicantOrganizationType.setOrganizationAddress(this.getOrganizationAddress(organization.getRolodex()));
        applicantOrganizationType.setOrganizationContactPerson(this.getOrganizationContactPerson(developmentProposal.getApplicantOrganization().getRolodex()));
        String cageNumber = organization.getCageNumber();
        if (cageNumber != null) {
            applicantOrganizationType.setCageNumber(cageNumber);
        }
        return applicantOrganizationType;
    }

    private KeyPersonType getKeyPersonType(DevelopmentProposal developmentProposal) {
        KeyPersonType keyPersonType = null;
        List proposalPersons = developmentProposal.getProposalPersons();
        boolean investigatorFound = false;
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!proposalPerson.isInvestigator()) continue;
            keyPersonType = this.getKeyPersonTypeWithValues(developmentProposal, proposalPerson);
            investigatorFound = true;
            break;
        }
        if (!investigatorFound) {
            keyPersonType = this.getkeyPersonTypeWithDefaultValues();
        }
        return keyPersonType;
    }

    private KeyPersonType getKeyPersonTypeWithValues(DevelopmentProposal developmentProposal, ProposalPerson proposalPerson) {
        KeyPersonType keyPersonType = KeyPersonType.Factory.newInstance();
        PersonFullNameType personFullNameType = this.getPersonFullName(proposalPerson);
        keyPersonType.setName(personFullNameType);
        ContactInfoType contactInfoType = this.getContactInfoType(proposalPerson);
        keyPersonType.setContactInformation(contactInfoType);
        KeyPersonType.KeyPersonFlag keyPersonFlag = this.getKeyPersonFlag(proposalPerson);
        keyPersonType.setKeyPersonFlag(keyPersonFlag);
        keyPersonType.setSocialSecurityNumber(proposalPerson.getSocialSecurityNumber());
        String unitName = this.getUnitName(proposalPerson);
        if (unitName != null) {
            keyPersonType.setOrganizationDepartment(unitName);
        }
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        keyPersonType.setOrganizationName(organization.getOrganizationName());
        if (proposalPerson.getPrimaryTitle() != null) {
            keyPersonType.setPositionTitle(proposalPerson.getPrimaryTitle());
        }
        return keyPersonType;
    }

    private KeyPersonType getkeyPersonTypeWithDefaultValues() {
        KeyPersonType keyPersonType = KeyPersonType.Factory.newInstance();
        keyPersonType.setAuthenticationCredential("Unknown");
        keyPersonType.setBiographicalSketch("Unknown");
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setCity("Unknown");
        postalAddressType.setPostalCode("Unknown");
        postalAddressType.setCountry("Unknown");
        contactInfoType.setPostalAddress(postalAddressType);
        keyPersonType.setContactInformation(contactInfoType);
        KeyPersonType.KeyPersonFlag flag = KeyPersonType.KeyPersonFlag.Factory.newInstance();
        flag.setKeyPersonFlagCode(DEFAULT_VALUE_KEY_PERSON_FLAG_CODE);
        flag.setKeyPersonFlagDesc(DEFAULT_VALUE_FOR_KEY_PERSON_FLAG_DESCRIPTION);
        keyPersonType.setKeyPersonFlag(flag);
        PersonFullNameType personFullNameType = PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName("Unknown");
        personFullNameType.setLastName("Unknown");
        keyPersonType.setName(personFullNameType);
        keyPersonType.setOrganizationDepartment("Unknown");
        keyPersonType.setOrganizationDivision("Unknown");
        keyPersonType.setOrganizationName("Unknown");
        keyPersonType.setPositionTitle("Unknown");
        keyPersonType.setSocialSecurityNumber(DEFAULT_VALUE_FOR_SSN);
        return keyPersonType;
    }

    private String getUnitName(ProposalPerson proposalPerson) {
        String unitName = null;
        for (ProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            if (!proposalPersonUnit.isLeadUnit()) continue;
            Unit unit = proposalPersonUnit.getUnit();
            if (unit == null || unit.getUnitName() == null) break;
            unitName = unit.getUnitName();
            break;
        }
        return unitName;
    }

    private KeyPersonType.KeyPersonFlag getKeyPersonFlag(ProposalPerson proposalPerson) {
        KeyPersonType.KeyPersonFlag keyPersonFlag = KeyPersonType.KeyPersonFlag.Factory.newInstance();
        if (proposalPerson.getPercentageEffort() != null && proposalPerson.getPercentageEffort().intValue() != 999) {
            keyPersonFlag.setKeyPersonFlagCode(DEFAULT_VALUE_KEY_PERSON_FLAG_CODE);
            keyPersonFlag.setKeyPersonFlagDesc(KEY_PERSON_FLAG_DESCRIPTION_VALUE_KEY_PERSON);
        } else {
            keyPersonFlag.setKeyPersonFlagCode(KEY_PERSON_FLAG_CODE_VALUE_FALSE);
            keyPersonFlag.setKeyPersonFlagDesc(KEY_PERSON_FLAG_DESCRIPTION_VALUE_COLLABORATOR);
        }
        return keyPersonFlag;
    }

    private ContactInfoType getContactInfoType(ProposalPerson proposalPerson) {
        ContactInfoType contactInfoType = ContactInfoType.Factory.newInstance();
        contactInfoType.setEmail(proposalPerson.getEmailAddress());
        contactInfoType.setFaxNumber(proposalPerson.getFaxNumber());
        contactInfoType.setPhoneNumber(proposalPerson.getPhoneNumber());
        PostalAddressType postalAddressType = this.getPostalAddressType(proposalPerson);
        contactInfoType.setPostalAddress(postalAddressType);
        return contactInfoType;
    }

    private PostalAddressType getPostalAddressType(ProposalPerson proposalPerson) {
        PostalAddressType postalAddressType = PostalAddressType.Factory.newInstance();
        postalAddressType.setCity(proposalPerson.getCity());
        postalAddressType.setCountry(proposalPerson.getCounty());
        postalAddressType.setPostalCode(proposalPerson.getPostalCode());
        postalAddressType.setState(proposalPerson.getState());
        return postalAddressType;
    }

    private PersonFullNameType getPersonFullName(ProposalPerson proposalPerson) {
        PersonFullNameType personFullNameType = PersonFullNameType.Factory.newInstance();
        personFullNameType.setFirstName(proposalPerson.getFirstName());
        personFullNameType.setLastName(proposalPerson.getLastName());
        personFullNameType.setMiddleName(proposalPerson.getMiddleName());
        return personFullNameType;
    }

    private OrgAssurancesType getOrgAssurances(DevelopmentProposal developmentProposal) {
        OrgAssurancesType orgAssurancesType = OrgAssurancesType.Factory.newInstance();
        List organizationYnqs = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getOrganizationId() != null) {
            organizationYnqs = this.getOrganizationYNQ(organization.getOrganizationId());
        }
        if (organizationYnqs != null) {
            for (OrganizationYnq organizationYnq : organizationYnqs) {
                if (organizationYnq.getQuestionId().equals(LOBBYING_QUESTION_ID)) {
                    orgAssurancesType.setLobbyingQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
                }
                if (!organizationYnq.getQuestionId().equals(GENERAL_CERTIFICATION_QUESTION_ID)) continue;
                orgAssurancesType.setGeneralCertificationQuestion(this.getAnswerFromOrganizationYnq(organizationYnq));
            }
            orgAssurancesType.setDebarmentAndSuspension(this.getAssuranceType(organizationYnqs, ORGANIZATION_QUESTION_ID_I8));
            orgAssurancesType.setDrugFreeWorkplace(this.getAssuranceType(organizationYnqs, ORGANIZATION_QUESTION_ID_H5));
        }
        return orgAssurancesType;
    }

    private AssuranceType getAssuranceType(List<OrganizationYnq> organizationYnqs, String questionId) {
        AssuranceType assuranceType = AssuranceType.Factory.newInstance();
        for (OrganizationYnq organizationYnq : organizationYnqs) {
            if (!organizationYnq.getQuestionId().equals(questionId)) continue;
            assuranceType.setYesNoAnswer(this.getAnswerFromOrganizationYnq(organizationYnq));
            assuranceType.setExplanation(this.getExplanationFromOrganizationYnq(organizationYnq));
        }
        return assuranceType;
    }

    private String getExplanationFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getExplanation() == null ? " " : organizationYnq.getExplanation();
    }

    private ProjectDescriptionDocument.ProjectDescription getProjectDescription(DevelopmentProposal developmentProposal) {
        ProjectDescriptionDocument.ProjectDescription projectDescription = ProjectDescriptionDocument.ProjectDescription.Factory.newInstance();
        projectDescription.setHumanSubject(this.getHumanSubjectsType(developmentProposal));
        projectDescription.setAnimalSubject(this.getAnimalSubject(developmentProposal));
        projectDescription.setProjectSurvey(this.getProjectSurvey(developmentProposal));
        projectDescription.setProjectSummary(this.getDescriptionBlockType(developmentProposal, PROJECT_SUMMARY_BLOCK_TYPE, true));
        projectDescription.setFacilitiesDescription(this.getDescriptionBlockType(developmentProposal, FACILITIES_BLOCK_TYPE, false));
        projectDescription.setEquipmentDescription(this.getDescriptionBlockType(developmentProposal, EQUIPMENT_BLOCK_TYPE, false));
        projectDescription.setReferences(this.getDescriptionBlockType(developmentProposal, REFERENCES_BLOCK_TYPE, true));
        return projectDescription;
    }

    private DescriptionBlockType getDescriptionBlockType(DevelopmentProposal developmentProposal, String blockType, boolean isFile) {
        DescriptionBlockType descriptionBlockType = DescriptionBlockType.Factory.newInstance();
        if (isFile) {
            descriptionBlockType.setFileIdentifier(developmentProposal.getProposalNumber() + blockType);
        } else {
            descriptionBlockType.setText(blockType);
        }
        return descriptionBlockType;
    }

    private HumanSubjectsType getHumanSubjectsType(DevelopmentProposal developmentProposal) {
        HumanSubjectsType humanSubjectsType = HumanSubjectsType.Factory.newInstance();
        String[] exemptionNumber = new String[6];
        List specialReviewList = developmentProposal.getPropSpecialReviews();
        int arrayIndex = 0;
        if (specialReviewList != null) {
            for (ProposalSpecialReview proposalSpecialReview : specialReviewList) {
                String comments;
                boolean humanSubjectsUsedQuestion = this.getHumanSubjectsUsedQuestion(proposalSpecialReview);
                humanSubjectsType.setHumanSubjectsUsedQuestion(humanSubjectsUsedQuestion);
                if (!proposalSpecialReview.getApprovalTypeCode().equals(APPROVAL_TYPE_EXEMPT) && proposalSpecialReview.getApprovalDate() != null) {
                    humanSubjectsType.setIRBApprovalDate(this.getDateTimeService().getCalendar((Date)proposalSpecialReview.getApprovalDate()));
                    break;
                }
                exemptionNumber[arrayIndex] = comments = this.getSpecialReviewComments(proposalSpecialReview);
                ++arrayIndex;
            }
        }
        this.setEXemptionNumber(developmentProposal, humanSubjectsType, exemptionNumber);
        return humanSubjectsType;
    }

    private boolean getHumanSubjectsUsedQuestion(ProposalSpecialReview proposalSpecialReview) {
        boolean humanSubjectsUsedQuestion = false;
        if (proposalSpecialReview.getSpecialReviewTypeCode() != null && proposalSpecialReview.getSpecialReviewTypeCode().equals(SPECIAL_REVIEW_CODE_1)) {
            humanSubjectsUsedQuestion = true;
        }
        return humanSubjectsUsedQuestion;
    }

    private void setEXemptionNumber(DevelopmentProposal developmentProposal, HumanSubjectsType humanSubjectsType, String[] exemptionNumber) {
        if (humanSubjectsType.getHumanSubjectsUsedQuestion()) {
            String humanSubAssurance = this.getHumanAssuranceNumber(developmentProposal);
            if (humanSubAssurance != null) {
                humanSubjectsType.setAssuranceNumber(humanSubAssurance);
            }
        } else {
            humanSubjectsType.setExemptionNumberArray(exemptionNumber);
        }
    }

    private String getSpecialReviewComments(ProposalSpecialReview proposalSpecialReview) {
        String comments = null;
        comments = proposalSpecialReview.getComments() == null ? "Unknown" : proposalSpecialReview.getComments();
        return comments;
    }

    private String getHumanAssuranceNumber(DevelopmentProposal developmentProposal) {
        String humanSubAssurance = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getHumanSubAssurance() != null) {
            humanSubAssurance = organization.getHumanSubAssurance();
        }
        return humanSubAssurance;
    }
}

