/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.questionnaire;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.document.authorization.ProposalTask;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;

public class ProposalPersonQuestionnaireHelper
extends QuestionnaireHelperBase {
    private static final long serialVersionUID = -5090730280279711495L;
    private static final Log LOG = LogFactory.getLog(ProposalPersonQuestionnaireHelper.class);
    private ProposalPerson proposalPerson;
    private ProposalDevelopmentForm proposalDevelopmentForm;
    private QuestionnaireService questionnaireService;

    public ProposalPersonQuestionnaireHelper(ProposalDevelopmentForm form, ProposalPerson proposalPerson) {
        this.proposalDevelopmentForm = form;
        this.setProposalPerson(proposalPerson);
        this.populateAnswers();
    }

    public ProposalPerson getProposalPerson() {
        return this.proposalPerson;
    }

    public void setProposalPerson(ProposalPerson proposalPerson) {
        this.proposalPerson = proposalPerson;
    }

    public ModuleQuestionnaireBean getModuleQnBean() {
        ProposalDevelopmentDocument propDevDoc = this.getProposalDevelopmentDocument();
        ProposalPersonModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalPersonModuleQuestionnaireBean(propDevDoc.getDevelopmentProposal(), this.getProposalPerson());
        return moduleQuestionnaireBean;
    }

    public void prepareView() {
        this.initializePermissions(this.getProposalDevelopmentDocument());
    }

    private void initializePermissions(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalTask task = new ProposalTask("certify", proposalDevelopmentDocument);
        this.setAnswerQuestionnaire(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task));
    }

    public String getModuleCode() {
        return "3";
    }

    protected ProposalDevelopmentDocument getProposalDevelopmentDocument() {
        ProposalDevelopmentDocument document = this.proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (document == null || document.getDevelopmentProposal() == null) {
            throw new IllegalArgumentException("invalid (null) ProposalDevelopmentDocument in ProposalDevelopmentForm");
        }
        return document;
    }

    public ProposalDevelopmentForm getProposalDevelopmentForm() {
        return this.proposalDevelopmentForm;
    }

    public void setProposalDevelopmentForm(ProposalDevelopmentForm proposalDevelopmentForm) {
        this.proposalDevelopmentForm = proposalDevelopmentForm;
    }

    public String getNamespaceCd() {
        return "KC-PD";
    }

    public void populateAnswers() {
        super.populateAnswers();
        if (this.getAnswerHeaders().size() > 1) {
            AnswerHeader mostCurrentHeader = (AnswerHeader)this.getAnswerHeaders().get(0);
            for (AnswerHeader header : this.getAnswerHeaders()) {
                if (!this.getQuestionnaireService().isCurrentQuestionnaire(header.getQuestionnaire()) || !header.getQuestionnaire().hasUsageFor(this.getModuleCode(), "3")) continue;
                mostCurrentHeader = header;
            }
            this.getAnswerHeaders().remove(mostCurrentHeader);
            this.getAnswerHeaders().add(0, mostCurrentHeader);
        }
    }

    protected QuestionnaireService getQuestionnaireService() {
        if (this.questionnaireService == null) {
            this.questionnaireService = (QuestionnaireService)KraServiceLocator.getService(QuestionnaireService.class);
        }
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }
}

