/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rule.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.NarrativeEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class NarrativeEventBase
extends KraDocumentEventBase
implements NarrativeEvent {
    private static final Log LOG = LogFactory.getLog(NarrativeEventBase.class);
    private Narrative narrative;
    private List<Narrative> narratives;

    protected NarrativeEventBase(String description, String errorPathPrefix, ProposalDevelopmentDocument document, Narrative narrative) {
        super(description, errorPathPrefix, (Document)document);
        if (narrative != null) {
            this.narrative = (Narrative)ObjectUtils.deepCopy((Serializable)narrative);
            if (narrative.getNarrativeFile() != null) {
                this.narrative.setFileName(narrative.getNarrativeFile().getFileName());
            }
        }
        this.narratives = new ArrayList();
        List narativeListToBeSaved = document.getDevelopmentProposal().getNarratives();
        for (Narrative narrativeToBeSaved : narativeListToBeSaved) {
            this.narratives.add((Narrative)ObjectUtils.deepCopy((Serializable)narrativeToBeSaved));
        }
        this.logEvent();
    }

    protected NarrativeEventBase(String description, String errorPathPrefix, ProposalDevelopmentDocument document) {
        super(description, errorPathPrefix, (Document)document);
        this.narratives = new ArrayList();
        List narativeListToBeSaved = document.getDevelopmentProposal().getNarratives();
        for (Narrative narrativeToBeSaved : narativeListToBeSaved) {
            this.narratives.add((Narrative)ObjectUtils.deepCopy((Serializable)narrativeToBeSaved));
        }
    }

    public Narrative getNarrative() {
        return this.narrative;
    }

    public List<Narrative> getNarratives() {
        return this.narratives;
    }

    protected void logEvent() {
        LOG.debug((Object)this.getDescription());
    }
}

