/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rule.event;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.PersonnelAttachmentEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class PersonnelAttachmentEventBase
extends KraDocumentEventBase
implements PersonnelAttachmentEvent {
    private static final Log LOG = LogFactory.getLog(PersonnelAttachmentEventBase.class);
    private ProposalPersonBiography proposalPersonBiography;

    protected PersonnelAttachmentEventBase(String description, String errorPathPrefix, ProposalDevelopmentDocument document, ProposalPersonBiography proposalPersonBiography) {
        super(description, errorPathPrefix, (Document)document);
        if (proposalPersonBiography != null) {
            this.proposalPersonBiography = (ProposalPersonBiography)ObjectUtils.deepCopy((Serializable)proposalPersonBiography);
            if (proposalPersonBiography.getPersonnelAttachmentFile() != null) {
                this.proposalPersonBiography.setFileName(proposalPersonBiography.getPersonnelAttachmentFile().getFileName());
                this.proposalPersonBiography.setContentType(proposalPersonBiography.getPersonnelAttachmentFile().getContentType());
            }
        } else {
            this.proposalPersonBiography = new ProposalPersonBiography();
        }
        this.logEvent();
    }

    public ProposalPersonBiography getProposalPersonBiography() {
        return this.proposalPersonBiography;
    }

    public void validate() {
        super.validate();
        if (this.getProposalPersonBiography() == null) {
            throw new IllegalArgumentException("invalid (null) proposal person biography");
        }
    }

    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getProposalPersonBiography() == null) {
            logMessage.append("null proposalPersonBiography");
        } else {
            logMessage.append(this.getProposalPersonBiography().toString());
        }
        LOG.debug((Object)logMessage);
    }
}

