/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetChangedData;
import org.kuali.kra.proposaldevelopment.rule.BudgetDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rule.event.BudgetDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalBudgetDataOverrideRule
extends ResearchDocumentRuleBase
implements BudgetDataOverrideRule {
    private static final Log LOG = LogFactory.getLog(ProposalBudgetDataOverrideRule.class);
    private static Map<String, String> validationClasses = new HashMap();
    private static final String DATE = "DATE";

    public boolean processBudgetDataOverrideRules(BudgetDataOverrideEvent budgetDataOverrideEvent) {
        BudgetChangedData budgetOverriddenData = budgetDataOverrideEvent.getBudgetChangedData();
        boolean valid = true;
        DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        String overriddenValue = budgetOverriddenData.getChangedValue();
        KraPersistenceStructureService kraPersistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        Map columnToAttributesMap = kraPersistenceStructureService.getDBColumnToObjectAttributeMap(BudgetVersionOverview.class);
        String overriddenName = dataDictionaryService.getAttributeErrorLabel(Budget.class, (String)columnToAttributesMap.get(budgetOverriddenData.getColumnName()));
        Boolean isRequiredField = dataDictionaryService.isAttributeRequired(Budget.class, (String)columnToAttributesMap.get(budgetOverriddenData.getColumnName()));
        if (StringUtils.isEmpty((String)budgetOverriddenData.getColumnName())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.columnName", "error.alterproposaldata.nofieldtoedit", new String[0]);
        }
        if (budgetOverriddenData != null && StringUtils.isNotEmpty((String)budgetOverriddenData.getChangedValue())) {
            valid &= this.validateAttributeFormat(budgetOverriddenData, dataDictionaryService);
        }
        if (isRequiredField.booleanValue() && StringUtils.isEmpty((String)overriddenValue)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.required", new String[]{overriddenName});
        }
        if (budgetOverriddenData != null && StringUtils.isNotEmpty((String)budgetOverriddenData.getComments())) {
            int commentsMaxLength = dataDictionaryService.getAttributeMaxLength(BudgetChangedData.class, "comments");
            String commentsLabel = dataDictionaryService.getAttributeLabel(BudgetChangedData.class, "comments");
            if (commentsMaxLength < budgetOverriddenData.getComments().length()) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.comments", "error.maxLength", new String[]{commentsLabel, commentsMaxLength + ""});
                return false;
            }
        }
        return valid;
    }

    private boolean validateAttributeFormat(BudgetChangedData budgetOverriddenData, DataDictionaryService dataDictionaryService) {
        String currentValueStr;
        Object currentValue;
        Pattern validationExpression;
        ProposalDevelopmentService proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        DateTimeService dateTimeService = CoreApiServiceLocator.getDateTimeService();
        String overriddenValue = budgetOverriddenData.getChangedValue();
        String changedValueLabel = dataDictionaryService.getAttributeLabel(BudgetChangedData.class, "changedValue");
        String dataType = null;
        Integer maxLength = -1;
        if (budgetOverriddenData.getEditableColumn() != null) {
            dataType = budgetOverriddenData.getEditableColumn().getDataType();
            maxLength = budgetOverriddenData.getEditableColumn().getDataLength();
        }
        ValidationPattern validationPattern = null;
        if (DATE.equalsIgnoreCase(dataType)) {
            try {
                dateTimeService.convertToDate(overriddenValue);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        String validationClassName = (String)validationClasses.get(dataType);
        if (StringUtils.isNotEmpty((String)validationClassName)) {
            try {
                validationPattern = (ValidationPattern)Class.forName((String)validationClasses.get(dataType)).newInstance();
                if (dataType.equalsIgnoreCase("STRING")) {
                    ((AnyCharacterValidationPattern)validationPattern).setAllowWhitespace(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in instantiating a ValidationPatternClass for Budget Data Overriding", e);
            }
        }
        if (validationPattern != null && (validationExpression = validationPattern.getRegexPattern()) != null && !validationExpression.pattern().equals(".*") && !validationExpression.matcher(overriddenValue).matches()) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
            return false;
        }
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> documentMap = new HashMap<String, String>();
        documentMap.put("proposalNumber", budgetOverriddenData.getProposalNumber());
        DevelopmentProposal developmentProposal = (DevelopmentProposal)boService.findByPrimaryKey(DevelopmentProposal.class, documentMap);
        HashMap<String, String> budgetMap = new HashMap<String, String>();
        budgetMap.put("parentDocumentKey", developmentProposal.getProposalDocument().getDocumentNumber());
        BudgetDocument budgetDocument = null;
        Collection budgetDocuments = boService.findMatching(BudgetDocument.class, budgetMap);
        for (BudgetDocument document : budgetDocuments) {
            if (!document.getBudget().getFinalVersionFlag().booleanValue()) continue;
            budgetDocument = document;
            break;
        }
        if ((currentValue = proposalDevelopmentService.getBudgetFieldValueFromDBColumnName(budgetDocument.getDocumentNumber(), budgetOverriddenData.getColumnName())) instanceof BudgetDecimal) {
            try {
                Double overriddenValueToInt = Double.parseDouble(overriddenValue);
            }
            catch (Exception e) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidNumber", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        if (maxLength != null && maxLength < overriddenValue.length() && !(currentValue instanceof Boolean)) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.maxLength", new String[]{changedValueLabel, maxLength.toString()});
            return false;
        }
        String string = currentValueStr = currentValue != null ? currentValue.toString() : "";
        if (DATE.equalsIgnoreCase(budgetOverriddenData.getEditableColumn().getDataType()) && currentValue != null) {
            currentValueStr = dateTimeService.toString((Date)currentValue, "MM/dd/yyyy");
        }
        if (StringUtils.isNotEmpty((String)currentValueStr) && currentValueStr.equalsIgnoreCase(overriddenValue) && !(currentValue instanceof Boolean)) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.budgetData.override.samevalue", new String[]{budgetOverriddenData.getEditableColumn().getColumnLabel(), budgetOverriddenData.getDisplayValue() != null ? budgetOverriddenData.getDisplayValue() : overriddenValue});
            return false;
        }
        return true;
    }

    static {
        validationClasses.put("STRING", "org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern");
        validationClasses.put("NUMBER", "org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern");
    }
}

