/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rule.event.DeleteProposalCongressionalDistrictEvent;
import org.kuali.kra.proposaldevelopment.rules.ProposalSiteRule;
import org.kuali.kra.proposaldevelopment.web.struts.form.CongressionalDistrictHelper;

public class ProposalDevelopmentCongressionalDistrictRule
extends ProposalSiteRule {
    Pattern districtValidationPattern = Pattern.compile("^[a-zA-Z][a-zA-Z]-[0-9]{1,3}|[a-zA-Z][a-zA-Z]-all|00-000|US-all$");

    public boolean processAddCongressionalDistrictRules(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent) {
        String siteIndexStr = addCongressionalDistrictEvent.getSiteIndex();
        boolean isValid = this.isIndexValid(siteIndexStr, "Site Index");
        CongressionalDistrictHelper proposalSiteHelper = null;
        int siteIndex = -1;
        if (isValid) {
            siteIndex = new Integer(siteIndexStr);
            proposalSiteHelper = (CongressionalDistrictHelper)addCongressionalDistrictEvent.getCongressionalDistrictHelpers().get(siteIndex);
            String stateCode = proposalSiteHelper.getNewState();
            String districtNumber = proposalSiteHelper.getNewDistrictNumber();
            CongressionalDistrict newDistrict = new CongressionalDistrict();
            newDistrict.setCongressionalDistrict(stateCode, districtNumber);
            String districtString = newDistrict.getCongressionalDistrict();
            if (!this.districtValidationPattern.matcher(districtString).matches()) {
                this.reportError("newDistrictNumber", "error.congressionalDistrict.format", new String[0]);
                isValid = false;
            }
        }
        if (isValid) {
            isValid = this.checkUniqueness(addCongressionalDistrictEvent, proposalSiteHelper);
        }
        return isValid;
    }

    private boolean checkUniqueness(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent, CongressionalDistrictHelper proposalSiteHelper) {
        boolean isValid = true;
        CongressionalDistrict newDistrict = new CongressionalDistrict();
        newDistrict.setCongressionalDistrict(proposalSiteHelper.getNewState(), proposalSiteHelper.getNewDistrictNumber());
        for (CongressionalDistrict existingDistrict : addCongressionalDistrictEvent.getProposalSite().getCongressionalDistricts()) {
            if (!StringUtils.equals((String)newDistrict.getCongressionalDistrict(), (String)existingDistrict.getCongressionalDistrict())) continue;
            this.reportError("newDistrictNumber", "error.congressionalDistrict.duplicate", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    public boolean processDeleteCongressionalDistrictRules(DeleteProposalCongressionalDistrictEvent deleteCongressionalDistrictEvent) {
        String siteIndexStr = deleteCongressionalDistrictEvent.getSiteIndex();
        String districtIndexStr = deleteCongressionalDistrictEvent.getDistrictIndex();
        return this.isIndexValid(siteIndexStr, "Site Index") && this.isIndexValid(districtIndexStr, "District Index");
    }
}

