/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalChangedData;
import org.kuali.kra.proposaldevelopment.bo.ProposalOverview;
import org.kuali.kra.proposaldevelopment.rule.ProposalDataOverrideRule;
import org.kuali.kra.proposaldevelopment.rule.event.ProposalDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentDataOverrideRule
extends ResearchDocumentRuleBase
implements ProposalDataOverrideRule {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentDataOverrideRule.class);
    private static Map<String, String> validationClasses = new HashMap();
    private static final String DATE = "DATE";

    public boolean processProposalDataOverrideRules(ProposalDataOverrideEvent proposalDataOverrideEvent) {
        ProposalChangedData proposalOverriddenData = proposalDataOverrideEvent.getProposalChangedData();
        boolean valid = true;
        DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        String overriddenValue = proposalOverriddenData.getChangedValue();
        KraPersistenceStructureService kraPersistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        Map columnToAttributesMap = kraPersistenceStructureService.getDBColumnToObjectAttributeMap(ProposalOverview.class);
        String overriddenName = dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, (String)columnToAttributesMap.get(proposalOverriddenData.getColumnName()));
        Boolean isRequiredField = dataDictionaryService.isAttributeRequired(DevelopmentProposal.class, (String)columnToAttributesMap.get(proposalOverriddenData.getColumnName()));
        if (StringUtils.isEmpty((String)proposalOverriddenData.getColumnName())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newProposalChangedData.columnName", "error.alterproposaldata.nofieldtoedit", new String[0]);
        }
        if (proposalOverriddenData != null && StringUtils.isNotEmpty((String)proposalOverriddenData.getChangedValue())) {
            valid &= this.validateAttributeFormat(proposalOverriddenData, dataDictionaryService);
        }
        if (isRequiredField.booleanValue() && StringUtils.isEmpty((String)overriddenValue)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.required", new String[]{overriddenName});
        }
        if (proposalOverriddenData != null && StringUtils.isNotEmpty((String)proposalOverriddenData.getComments())) {
            int commentsMaxLength = dataDictionaryService.getAttributeMaxLength(ProposalChangedData.class, "comments");
            String commentsLabel = dataDictionaryService.getAttributeLabel(ProposalChangedData.class, "comments");
            if (commentsMaxLength < proposalOverriddenData.getComments().length()) {
                GlobalVariables.getMessageMap().putError("newProposalChangedData.comments", "error.maxLength", new String[]{commentsLabel, commentsMaxLength + ""});
                return false;
            }
        }
        return valid;
    }

    private boolean validateAttributeFormat(ProposalChangedData proposalOverriddenData, DataDictionaryService dataDictionaryService) {
        String currentValueStr;
        Pattern validationExpression;
        ProposalDevelopmentService proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        DateTimeService dateTimeService = CoreApiServiceLocator.getDateTimeService();
        String overriddenValue = proposalOverriddenData.getChangedValue();
        String changedValueLabel = dataDictionaryService.getAttributeLabel(ProposalChangedData.class, "changedValue");
        String dataType = null;
        Integer maxLength = -1;
        if (proposalOverriddenData.getEditableColumn() != null) {
            dataType = proposalOverriddenData.getEditableColumn().getDataType();
            maxLength = proposalOverriddenData.getEditableColumn().getDataLength();
        }
        ValidationPattern validationPattern = null;
        if (DATE.equalsIgnoreCase(dataType)) {
            try {
                dateTimeService.convertToDate(overriddenValue);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        String validationClassName = (String)validationClasses.get(dataType);
        if (StringUtils.isNotEmpty((String)validationClassName)) {
            try {
                validationPattern = (ValidationPattern)Class.forName((String)validationClasses.get(dataType)).newInstance();
                if (dataType.equalsIgnoreCase("STRING")) {
                    ((AnyCharacterValidationPattern)validationPattern).setAllowWhitespace(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in instantiating a ValidationPatternClass for Proposal Data Overriding", e);
            }
        }
        if (validationPattern != null && (validationExpression = validationPattern.getRegexPattern()) != null && !validationExpression.pattern().equals(".*") && !validationExpression.matcher(overriddenValue).matches()) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
            return false;
        }
        if (maxLength != null && maxLength < overriddenValue.length()) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.maxLength", new String[]{changedValueLabel, maxLength.toString()});
            return false;
        }
        Object currentValue = proposalDevelopmentService.getProposalFieldValueFromDBColumnName(proposalOverriddenData.getProposalNumber(), proposalOverriddenData.getColumnName());
        String string = currentValueStr = currentValue != null ? currentValue.toString() : "";
        if (DATE.equalsIgnoreCase(proposalOverriddenData.getEditableColumn().getDataType()) && currentValue != null) {
            currentValueStr = dateTimeService.toString((Date)currentValue, "MM/dd/yyyy");
        }
        if (StringUtils.isNotEmpty((String)currentValueStr) && currentValueStr.equalsIgnoreCase(overriddenValue)) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.proposalData.override.samevalue", new String[]{proposalOverriddenData.getEditableColumn().getColumnLabel(), proposalOverriddenData.getDisplayValue() != null ? proposalOverriddenData.getDisplayValue() : overriddenValue});
            return false;
        }
        return true;
    }

    static {
        validationClasses.put("STRING", "org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern");
        validationClasses.put("NUMBER", "org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern");
    }
}

