/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AddInstituteAttachmentRule;
import org.kuali.kra.proposaldevelopment.rule.event.AddInstituteAttachmentEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentInstituteAttachmentRule
extends ResearchDocumentRuleBase
implements AddInstituteAttachmentRule {
    private static final String NARRATIVE_TYPE_ALLOWMULTIPLE_NO = "N";
    private static final String INSTITUTE = "Institute";
    private static final String NEW_INSTITUTE_ATTACHMENT = "newInstituteAttachment";
    private static final String NARRATIVE_TYPE_CODE = "narrativeTypeCode";
    private static final String NARRATIVE_FILE = ".narrativeFile";
    private static final String NARRATIVE_DESCRIPTION = ".moduleTitle";
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentInstituteAttachmentRule.class);
    private ParameterService parameterService;
    private transient KcAttachmentService kcAttachmentService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean processAddInstituteAttachmentBusinessRules(AddInstituteAttachmentEvent addInstituteAttachmentEvent) {
        String attachmentFileName;
        KcAttachmentService attachmentService;
        String invalidCharacters;
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)addInstituteAttachmentEvent.getDocument();
        Narrative narrative = addInstituteAttachmentEvent.getNarrative();
        boolean rulePassed = true;
        this.populateNarrativeType(narrative);
        String errorPath = NEW_INSTITUTE_ATTACHMENT;
        if (narrative.getNarrativeType() == null) {
            rulePassed = false;
        }
        GlobalVariables.getMessageMap().addToErrorPath(NEW_INSTITUTE_ATTACHMENT);
        DictionaryValidationService dictionaryValidationService = this.getKnsDictionaryValidationService();
        dictionaryValidationService.validateAttributeFormat(narrative.getClass().getName(), "moduleTitle", narrative.getModuleTitle(), "moduleTitle");
        if (GlobalVariables.getMessageMap().getPropertiesWithErrors().size() > 0) {
            rulePassed = false;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(NEW_INSTITUTE_ATTACHMENT);
        if (StringUtils.isBlank((String)narrative.getNarrativeTypeCode())) {
            rulePassed = false;
            this.reportError(errorPath + ".institutionalAttachmentTypeCode", "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (StringUtils.isBlank((String)narrative.getModuleStatusCode())) {
            rulePassed = false;
            this.reportError(errorPath + ".moduleStatusCode", "error.proposalAttachment.narrativeStatus.notSelected", new String[0]);
        }
        if (rulePassed) {
            this.populateNarrativeType(narrative);
            String[] param = new String[]{INSTITUTE, narrative.getNarrativeType().getDescription()};
            String instituteNarrativeTypeGroup = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "instituteNarrativeTypeGroup");
            if (narrative.getNarrativeType().getAllowMultiple().equalsIgnoreCase(NARRATIVE_TYPE_ALLOWMULTIPLE_NO)) {
                for (Narrative narr : document.getDevelopmentProposal().getInstituteAttachments()) {
                    if (narr == null || !StringUtils.equals((String)narr.getNarrativeTypeCode(), (String)narrative.getNarrativeTypeCode())) continue;
                    LOG.debug((Object)"error.proposalAttachment.narrativeType.allowMulitple");
                    this.reportError(errorPath + ".institutionalAttachmentTypeCode", "error.proposalAttachment.narrativeType.allowMulitple", param);
                    rulePassed = false;
                }
            } else if (StringUtils.isBlank((String)narrative.getModuleTitle())) {
                this.reportError(errorPath, "error.proposalAttachment.description.required", param);
                rulePassed = false;
            }
        }
        if (StringUtils.isBlank((String)narrative.getFileName())) {
            rulePassed = false;
            this.reportError(errorPath + NARRATIVE_FILE, "error.required.for.fileName", new String[]{"File Name"});
        }
        if (ObjectUtils.isNotNull((Object)(invalidCharacters = (attachmentService = this.getKcAttachmentService()).getInvalidCharacters(attachmentFileName = narrative.getFileName())))) {
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                rulePassed &= false;
                this.reportError(errorPath + NARRATIVE_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            } else {
                rulePassed &= true;
                this.reportWarning(errorPath + NARRATIVE_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            }
        }
        return rulePassed;
    }

    private void populateNarrativeType(Narrative narrative) {
        HashMap<String, String> narrativeTypeMap = new HashMap<String, String>();
        narrativeTypeMap.put(NARRATIVE_TYPE_CODE, narrative.getNarrativeTypeCode());
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        NarrativeType narrType = (NarrativeType)service.findByPrimaryKey(NarrativeType.class, narrativeTypeMap);
        if (narrType != null) {
            narrative.setNarrativeType(narrType);
        }
    }

    protected KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = (KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }
}

