/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.NarrativeRight;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeType;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AddNarrativeRule;
import org.kuali.kra.proposaldevelopment.rule.NewNarrativeUserRightsRule;
import org.kuali.kra.proposaldevelopment.rule.SaveNarrativesRule;
import org.kuali.kra.proposaldevelopment.rule.event.AddNarrativeEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveNarrativesEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentNarrativeRule
extends ResearchDocumentRuleBase
implements AddNarrativeRule,
SaveNarrativesRule,
NewNarrativeUserRightsRule {
    private static final String NARRATIVE_TYPE_ALLOWMULTIPLE_NO = "N";
    private static final String DOCUMENT_NARRATIVES = "document.narratives";
    private static final String PROPOSAL = "Proposal";
    private static final String NARRATIVE_TYPE_CODE = "narrativeTypeCode";
    private static final String MODULE_STATUS_CODE_COMPLETED = "C";
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentNarrativeRule.class);
    private transient KcPersonService kcPersonService;
    private transient PersonService personService;
    private transient ParameterService parameterService;
    private transient KcAttachmentService kcAttachmentService;

    public boolean processAddNarrativeBusinessRules(AddNarrativeEvent narrativeEvent) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)narrativeEvent.getDocument();
        Narrative narrative = narrativeEvent.getNarrative();
        boolean rulePassed = true;
        this.populateNarrativeType(narrative);
        MessageMap map = GlobalVariables.getMessageMap();
        if (narrative.getNarrativeType() == null) {
            rulePassed = false;
        }
        if (!StringUtils.isBlank((String)narrative.getModuleStatusCode()) && narrative.getModuleStatusCode().equalsIgnoreCase(MODULE_STATUS_CODE_COMPLETED) && StringUtils.isBlank((String)narrative.getFileName())) {
            LOG.debug((Object)"error.proposalAttachment.moduleStatusCode.invalid");
            this.reportError("newNarrative.moduleStatusCode", "error.proposalAttachment.moduleStatusCode.invalid", new String[0]);
            rulePassed = false;
        }
        if (StringUtils.isBlank((String)narrative.getFileName())) {
            rulePassed = false;
            this.reportError("newNarrative.narrativeFile", "error.required.for.fileName", new String[]{"File Name"});
        }
        String attachmentFileName = narrative.getFileName();
        KcAttachmentService attachmentService = this.getKcAttachmentService();
        String invalidCharacters = attachmentService.getInvalidCharacters(attachmentFileName);
        if (ObjectUtils.isNotNull((Object)invalidCharacters)) {
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                rulePassed &= false;
                this.reportError("newNarrative.narrativeFile", "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            } else {
                rulePassed &= true;
                this.reportWarning("newNarrative.narrativeFile", "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            }
        }
        map.addToErrorPath("newNarrative");
        this.getKnsDictionaryValidationService().validateBusinessObject((BusinessObject)narrative, false);
        map.removeFromErrorPath("newNarrative");
        int size = map.getErrorMessages().keySet().size();
        rulePassed &= size <= 0;
        return rulePassed &= this.checkNarrative(document.getDevelopmentProposal().getNarratives(), narrative);
    }

    public boolean processSaveNarrativesBusinessRules(SaveNarrativesEvent saveNarrativesEvent) {
        boolean rulePassed = this.checkUserRights(saveNarrativesEvent);
        List narrativeList = saveNarrativesEvent.getNarratives();
        int size = narrativeList.size();
        for (int i = 0; i < size; ++i) {
            Narrative narrative = (Narrative)narrativeList.get(0);
            narrativeList.remove(narrative);
            rulePassed &= this.checkNarrative(narrativeList, narrative);
        }
        Narrative narrative = saveNarrativesEvent.getNarrative();
        this.populateNarrativeType(narrative);
        if (!StringUtils.isBlank((String)narrative.getModuleStatusCode()) && narrative.getModuleStatusCode().equalsIgnoreCase(MODULE_STATUS_CODE_COMPLETED) && StringUtils.isBlank((String)narrative.getFileName())) {
            LOG.debug((Object)"error.proposalAttachment.moduleStatusCode.invalid");
            this.reportError("newNarrative.moduleStatusCode", "error.proposalAttachment.moduleStatusCode.invalid", new String[0]);
            rulePassed = false;
        }
        return rulePassed;
    }

    private boolean checkUserRights(SaveNarrativesEvent saveNarrativesEvent) {
        boolean isValid = true;
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        List narratives = saveNarrativesEvent.getNarratives();
        List originalNarratives = saveNarrativesEvent.getOriginalNarratives();
        for (Narrative origNarrative : originalNarratives) {
            Narrative narrative;
            NarrativeUserRights userRights = this.getUserRights(userId, origNarrative);
            if (userRights == null || !StringUtils.equals((String)userRights.getAccessType(), (String)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) && !StringUtils.equals((String)userRights.getAccessType(), (String)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType()) || origNarrative.equals((Object)(narrative = this.findNarrative(narratives, origNarrative)))) continue;
            isValid = false;
            this.reportError("newNarrative.narrativeTypeCode", "error.proposalAttachment.notAuthorized", new String[]{origNarrative.getNarrativeType().getDescription()});
        }
        return isValid;
    }

    private NarrativeUserRights getUserRights(String userId, Narrative narrative) {
        List userRightsList = narrative.getNarrativeUserRights();
        for (NarrativeUserRights userRights : userRightsList) {
            String personId = userRights.getUserId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            if (!StringUtils.equals((String)userId, (String)person.getPersonId())) continue;
            return userRights;
        }
        return null;
    }

    private Narrative findNarrative(List<Narrative> narratives, Narrative origNarrative) {
        for (Narrative narrative : narratives) {
            if (!narrative.getModuleNumber().equals(origNarrative.getModuleNumber())) continue;
            return narrative;
        }
        return null;
    }

    private boolean checkNarrative(List<Narrative> narrativeList, Narrative narrative) {
        String errorPath = DOCUMENT_NARRATIVES;
        boolean rulePassed = true;
        if (StringUtils.isBlank((String)narrative.getNarrativeTypeCode())) {
            rulePassed = false;
            this.reportError("newNarrative.narrativeTypeCode", "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (StringUtils.isBlank((String)narrative.getModuleStatusCode())) {
            rulePassed = false;
            this.reportError("newNarrative.moduleStatusCode", "error.proposalAttachment.narrativeStatus.notSelected", new String[0]);
        }
        if (rulePassed) {
            this.populateNarrativeType(narrative);
            String[] param = new String[]{PROPOSAL, narrative.getNarrativeType().getDescription()};
            if (narrative.getNarrativeType().getAllowMultiple().equalsIgnoreCase(NARRATIVE_TYPE_ALLOWMULTIPLE_NO)) {
                for (Narrative narr : narrativeList) {
                    if (narr == null || !StringUtils.equals((String)narr.getNarrativeTypeCode(), (String)narrative.getNarrativeTypeCode())) continue;
                    LOG.debug((Object)"error.proposalAttachment.narrativeType.allowMulitple");
                    this.reportError(errorPath, "error.proposalAttachment.narrativeType.allowMulitple", param);
                    rulePassed = false;
                }
            } else if (StringUtils.isBlank((String)narrative.getModuleTitle())) {
                this.reportError(errorPath, "error.proposalAttachment.description.required", param);
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    private void populateNarrativeType(Narrative narrative) {
        HashMap<String, String> narrativeTypeMap = new HashMap<String, String>();
        narrativeTypeMap.put(NARRATIVE_TYPE_CODE, narrative.getNarrativeTypeCode());
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        NarrativeType narrType = (NarrativeType)service.findByPrimaryKey(NarrativeType.class, narrativeTypeMap);
        if (narrType != null) {
            narrative.setNarrativeType(narrType);
        }
    }

    public boolean processNewNarrativeUserRightsBusinessRules(ProposalDevelopmentDocument document, List<NarrativeUserRights> newNarrativeUserRights, int narrativeIndex) {
        boolean isValid = true;
        if (!this.hasNarrativeRight(newNarrativeUserRights, NarrativeRight.MODIFY_NARRATIVE_RIGHT)) {
            isValid = false;
            this.reportError("newNarrativeUserRight", "error.narrative.one.modify", new String[0]);
        }
        for (NarrativeUserRights userRights : newNarrativeUserRights) {
            if (this.hasPermission(userRights, document)) continue;
            isValid = false;
            String personId = userRights.getUserId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            this.reportError("newNarrativeUserRight", "error.narrative.no.permission", new String[]{person.getFullName()});
        }
        return isValid;
    }

    private boolean hasNarrativeRight(List<NarrativeUserRights> narrativeUserRights, NarrativeRight narrativeRight) {
        for (NarrativeUserRights userRights : narrativeUserRights) {
            if (!StringUtils.equals((String)userRights.getAccessType(), (String)narrativeRight.getAccessType())) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(NarrativeUserRights userRights, ProposalDevelopmentDocument doc) {
        String personId = userRights.getUserId();
        return !(StringUtils.equals((String)userRights.getAccessType(), (String)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType()) ? !this.hasPermission(personId, doc, "Modify Narrative") : StringUtils.equals((String)userRights.getAccessType(), (String)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) && !this.hasPermission(personId, doc, "View Narratives"));
    }

    protected KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = (KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)KraServiceLocator.getService(PersonService.class);
        }
        return this.personService;
    }
}

