/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.PropPerDocType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.AddPersonnelAttachmentRule;
import org.kuali.kra.proposaldevelopment.rule.SavePersonnelAttachmentRule;
import org.kuali.kra.proposaldevelopment.rule.event.AddPersonnelAttachmentEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SavePersonnelAttachmentEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProposalDevelopmentPersonnelAttachmentRule
extends ResearchDocumentRuleBase
implements AddPersonnelAttachmentRule,
SavePersonnelAttachmentRule {
    public static final String OTHER_DOCUMENT_TYPE_DESCRIPTION = "Other";
    private static final String DOC_TYPE_DESCRIPTION = "description";
    private static final String DOCUMENT_TYPE_CODE = "documentTypeCode";
    private static final String FILE_NAME_PARM = "File Name";
    private static final String NEW_PROP_PERSON_BIO_PREFIX = "newPropPersonBio.";
    private static final String PERSONNEL_ATTACHMENT_FILE = "personnelAttachmentFile";
    private static final String PERSONNEL_DESCRIPTION = "description";
    private static final String PROPOSAL_PERSON_NUMBER = "proposalPersonNumber";
    private transient KcAttachmentService kcAttachmentService;
    private transient ParameterService parameterService;

    public static String buildErrorPath(String endPath) {
        return "newPropPersonBio." + endPath;
    }

    public boolean processAddPersonnelAttachmentBusinessRules(AddPersonnelAttachmentEvent addPersonnelAttachmentEvent) {
        String attachmentFileName;
        KcAttachmentService attachmentService;
        String invalidCharacters;
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)addPersonnelAttachmentEvent.getDocument();
        ProposalPersonBiography proposalPersonBiography = addPersonnelAttachmentEvent.getProposalPersonBiography();
        boolean rulePassed = true;
        if (StringUtils.isBlank((String)proposalPersonBiography.getDocumentTypeCode())) {
            rulePassed = false;
            this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"documentTypeCode"), "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (proposalPersonBiography.getProposalPersonNumber() == null || StringUtils.isBlank((String)proposalPersonBiography.getProposalPersonNumber().toString())) {
            rulePassed = false;
            this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"proposalPersonNumber"), "error.personnelAttachment.person.required", new String[0]);
        }
        if (StringUtils.isBlank((String)proposalPersonBiography.getFileName())) {
            rulePassed = false;
            this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"personnelAttachmentFile"), "error.required.for.fileName", new String[]{"File Name"});
        }
        if (ObjectUtils.isNotNull((Object)(invalidCharacters = (attachmentService = this.getKcAttachmentService()).getInvalidCharacters(attachmentFileName = proposalPersonBiography.getFileName())))) {
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                rulePassed &= false;
                this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"personnelAttachmentFile"), "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            } else {
                rulePassed &= true;
                this.reportWarning(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"personnelAttachmentFile"), "error.institutionalProposal.notesAndAttachments.fileName.invalid", new String[]{attachmentFileName, invalidCharacters});
            }
        }
        rulePassed &= this.checkForDescriptionWhenTypeIsOther(proposalPersonBiography);
        List existingPersonBiographyList = document.getDevelopmentProposal().getPropPersonBios();
        if (CollectionUtils.isNotEmpty((Collection)existingPersonBiographyList)) {
            for (ProposalPersonBiography personBiography : existingPersonBiographyList) {
                if (!personBiography.getProposalPersonNumber().equals(proposalPersonBiography.getProposalPersonNumber()) || !personBiography.getDocumentTypeCode().equals(proposalPersonBiography.getDocumentTypeCode())) continue;
                rulePassed = false;
                this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"documentTypeCode"), "error.personnelAttachment.person.duplicate", new String[0]);
            }
        }
        return rulePassed;
    }

    public boolean processSavePersonnelAttachmentBusinessRules(SavePersonnelAttachmentEvent savePersonnelAttachmentEvent) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)savePersonnelAttachmentEvent.getDocument();
        ProposalPersonBiography proposalPersonBiography = savePersonnelAttachmentEvent.getProposalPersonBiography();
        boolean rulePassed = true;
        List existingPersonBiographyList = document.getDevelopmentProposal().getPropPersonBios();
        if (CollectionUtils.isNotEmpty((Collection)existingPersonBiographyList)) {
            for (ProposalPersonBiography personBiography : existingPersonBiographyList) {
                if (personBiography.getProposalPersonNumber().equals(proposalPersonBiography.getProposalPersonNumber()) && personBiography.getDocumentTypeCode().equals(proposalPersonBiography.getDocumentTypeCode())) {
                    rulePassed = false;
                    this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"documentTypeCode"), "error.personnelAttachment.person.duplicate", new String[0]);
                }
                rulePassed &= this.checkForDescriptionWhenTypeIsOther(personBiography);
            }
        }
        return rulePassed;
    }

    protected PropPerDocType findPropPerDocTypeForOther() {
        HashMap<String, String> narrativeTypeMap = new HashMap<String, String>();
        narrativeTypeMap.put("description", "Other");
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        return (PropPerDocType)((List)service.findMatching(PropPerDocType.class, narrativeTypeMap)).get(0);
    }

    private boolean checkForDescriptionWhenTypeIsOther(ProposalPersonBiography proposalPersonBiography) {
        boolean rulePassed = true;
        if (this.findPropPerDocTypeForOther().getDocumentTypeCode().equalsIgnoreCase(proposalPersonBiography.getDocumentTypeCode())) {
            boolean bl = rulePassed = !StringUtils.isBlank((String)proposalPersonBiography.getDescription());
            if (!rulePassed) {
                this.reportError(ProposalDevelopmentPersonnelAttachmentRule.buildErrorPath((String)"description"), "error.personnelAttachment.description.required", new String[0]);
            }
        }
        return rulePassed;
    }

    protected KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = (KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

