/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentProposalAttachmentsAuditRule
implements DocumentAuditRule {
    public static final String AUDIT_CLUSTER_KEY = "proposalAttachmentsAuditWarnings";
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentProposalAttachmentsAuditRule.class);

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        valid &= this.checkForIncompleteAttachments(developmentProposal);
        valid &= this.checkNihRelatedAttachments(developmentProposal);
        return valid &= this.checkNsfRelatedAttachments(proposalDevelopmentDocument);
    }

    public boolean checkForIncompleteAttachments(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        int i = 0;
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (StringUtils.equals((String)narrative.getModuleStatusCode(), (String)"I")) {
                valid = false;
                this.getAuditErrors().add(new AuditError("document.developmentProposalList[0].narrative[" + i + "].moduleStatusCode", "error.document.narrativestatuscode.not.complete", "abstractsAttachments"));
            }
            ++i;
        }
        return valid;
    }

    public boolean checkNihRelatedAttachments(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        if (this.getSponsorService().isSponsorNihMultiplePi((Sponsorable)developmentProposal) && developmentProposal.getS2sOpportunity() != null) {
            boolean attachment = false;
            boolean hasPI = false;
            block0: for (ProposalPerson proposalPerson : developmentProposal.getInvestigators()) {
                if (proposalPerson.getProposalPersonRoleId().equals("PI")) {
                    hasPI = true;
                }
                if (!proposalPerson.isMultiplePi()) continue;
                attachment = true;
                for (Narrative narrative : developmentProposal.getNarratives()) {
                    if ((narrative.getNarrativeTypeCode() == null || !StringUtils.equals((String)narrative.getNarrativeTypeCode(), (String)"121")) && !StringUtils.equals((String)narrative.getNarrativeTypeCode(), (String)"46")) continue;
                    attachment = false;
                    continue block0;
                }
            }
            if (attachment && hasPI) {
                valid = false;
                this.getAuditErrors().add(new AuditError("document.developmentProposalList[0].narrative", "error.document.narrative.not.present", "abstractsAttachments"));
            }
        }
        return valid;
    }

    public boolean checkNsfRelatedAttachments(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getSponsorCode().equals(this.getParameterService().getParameterValueAsString("KC-GEN", "All", "NSF_SPONSOR_CODE")) && developmentProposal.getS2sOpportunity() != null) {
            boolean attachmentNotExists = true;
            try {
                String budgetCostElement = this.getParameterService().getParameterValueAsString("KC-GEN", "A", "POST_DOCTORAL_COSTELEMENT");
                BudgetDocument bdDoc = ((S2SBudgetCalculatorService)KraServiceLocator.getService(S2SBudgetCalculatorService.class)).getFinalBudgetVersion(proposalDevelopmentDocument);
                if (bdDoc != null && bdDoc.getBudget() != null && bdDoc.getBudget().getBudgetPeriods() != null) {
                    block2: for (BudgetPeriod budgetPeriod : bdDoc.getBudget().getBudgetPeriods()) {
                        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                            if (!budgetLineItem.getCostElement().equals(budgetCostElement)) continue;
                            for (Narrative narrative : developmentProposal.getNarratives()) {
                                if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 8 || !narrative.getName().equalsIgnoreCase("Mentoring Plan.pdf")) continue;
                                attachmentNotExists = false;
                                break;
                            }
                            if (!attachmentNotExists) continue;
                            valid = false;
                            this.getAuditErrors().add(new AuditError("document.developmentProposalList[0].narrative", "error.document.mentoringplan.narrative.not.present", "abstractsAttachments"));
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Unknown error while validating budget data", (Throwable)e);
            }
        }
        return valid;
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(AUDIT_CLUSTER_KEY)) {
            KNSGlobalVariables.getAuditErrorMap().put(AUDIT_CLUSTER_KEY, new AuditCluster("Abstracts and Attachments", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(AUDIT_CLUSTER_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }

    private ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    private SponsorService getSponsorService() {
        return (SponsorService)KraServiceLocator.getService(SponsorService.class);
    }
}

