/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentProposalRequiredFieldsAuditRule
implements DocumentAuditRule {
    private ParameterService parameterService;
    private ProposalDevelopmentService proposalDevelopmentService;
    private S2SUtilService s2sUtilService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        if (StringUtils.equalsIgnoreCase((String)proposal.getSponsorCode(), (String)"000340") && proposalDevelopmentDocument.getDevelopmentProposal().getTitle().length() > 81) {
            valid = false;
            auditErrors.add(new AuditError("document.developmentProposalList[0].title", "error.nih.sponsor.project.title.length", "proposal.RequiredFieldsforSavingDocument"));
        }
        InstitutionalProposal institutionalProposal = this.getProposalDevelopmentService().getProposalContinuedFromVersion(proposalDevelopmentDocument);
        String changeCorrectedType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.submissiontype.changedCorrected");
        if (proposal.getS2sOpportunity() != null && this.isProposalTypeNew(proposal.getProposalTypeCode()) && StringUtils.equals((String)proposal.getS2sOpportunity().getS2sSubmissionTypeCode(), (String)changeCorrectedType)) {
            String ggTrackingId = null;
            if (institutionalProposal != null) {
                ggTrackingId = this.getS2sUtilService().getGgTrackingIdFromProposal(institutionalProposal);
            }
            if (StringUtils.isBlank((String)proposal.getSponsorProposalNumber()) && StringUtils.isBlank((String)ggTrackingId)) {
                valid = false;
                auditErrors.add(new AuditError("document.developmentProposalList[0].continuedFrom", "error.proposal.require.id.changeapp", "proposal.RequiredFieldsforSavingDocument"));
            }
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("requiredFieldsAuditErrors", new AuditCluster("Required Fields for Saving Document ", auditErrors, "Validation Errors"));
        }
        return valid;
    }

    private boolean isProposalTypeNew(String proposalTypeCode) {
        String proposalTypeCodeNew = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.new");
        return !StringUtils.isEmpty((String)proposalTypeCode) && proposalTypeCode.equals(proposalTypeCodeNew);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalDevelopmentService getProposalDevelopmentService() {
        if (this.proposalDevelopmentService == null) {
            this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        }
        return this.proposalDevelopmentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    protected S2SUtilService getS2sUtilService() {
        if (this.s2sUtilService == null) {
            this.s2sUtilService = (S2SUtilService)KraServiceLocator.getService(S2SUtilService.class);
        }
        return this.s2sUtilService;
    }

    public void setS2sUtilService(S2SUtilService s2sUtilService) {
        this.s2sUtilService = s2sUtilService;
    }
}

