/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.rules;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProposalDevelopmentS2sQuestionnaireAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String PROPOSAL_S2S_QUESTIONS_KEY = "s2sQuestionnaireHelper.answerHeaders[%s].answers[0].answer";
    private static final String PROPOSAL_S2S_QUESTIONNAIRE_PANEL_KEY = "%s%s%s";
    private transient ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        S2sOpportunity opp = developmentProposal.getS2sOpportunity();
        if (opp != null && opp.getS2sOppForms() != null) {
            for (S2sOppForms oppforms : opp.getS2sOppForms()) {
                List usages = this.getProposalDevelopmentS2sQuestionnaireService().getQuestionnaireUsages(oppforms.getOppNameSpace(), oppforms.getFormName(), developmentProposal);
                if (usages.size() <= 0) continue;
                List headers = this.proposalDevelopmentS2sQuestionnaireService.getProposalAnswerHeaderForForm(developmentProposal, oppforms.getOppNameSpace(), oppforms.getFormName());
                for (int i = 0; i < headers.size(); ++i) {
                    AnswerHeader header = (AnswerHeader)headers.get(i);
                    if (header.getCompleted()) continue;
                    valid = false;
                    this.getProposalS2sAuditErrorsByGroup("s2sQuestionnaireHelper", ((QuestionnaireUsage)usages.get(0)).getQuestionnaireLabel(), Integer.valueOf(i)).add(new AuditError(String.format(PROPOSAL_S2S_QUESTIONS_KEY, i), "error.proposaldev.questionnaire.s2s.notcomplete", "questions." + ((QuestionnaireUsage)usages.get(0)).getQuestionnaireLabel(), new String[]{((QuestionnaireUsage)usages.get(0)).getQuestionnaireLabel()}));
                }
            }
        }
        return valid;
    }

    private synchronized ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        if (this.proposalDevelopmentS2sQuestionnaireService == null) {
            this.proposalDevelopmentS2sQuestionnaireService = (ProposalDevelopmentS2sQuestionnaireService)KraServiceLocator.getService(ProposalDevelopmentS2sQuestionnaireService.class);
        }
        return this.proposalDevelopmentS2sQuestionnaireService;
    }

    private List<AuditError> getProposalS2sAuditErrorsByGroup(String formProperty, String usageLabel, Integer answerHeaderIndex) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = String.format(PROPOSAL_S2S_QUESTIONNAIRE_PANEL_KEY, formProperty, usageLabel, answerHeaderIndex);
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster(usageLabel, auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }
}

