/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;

public class DevelopmentProposalLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 8611232870631352662L;
    private KraAuthorizationService kraAuthorizationService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List unboundedResults = super.getSearchResults(fieldValues);
        CollectionIncomplete filteredResults = new ArrayList();
        filteredResults = this.filterForPermissions(unboundedResults);
        if (unboundedResults instanceof CollectionIncomplete) {
            filteredResults = new CollectionIncomplete(filteredResults, ((CollectionIncomplete)unboundedResults).getActualSizeIfTruncated());
        }
        return filteredResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ProposalDevelopmentDocument document = ((DevelopmentProposal)businessObject).getProposalDocument();
        String currentUser = GlobalVariables.getUserSession().getPrincipalId();
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        boolean canModifyProposal = this.kraAuthorizationService.hasPermission(currentUser, (Permissionable)document, "Modify ProposalDevelopmentDocument");
        boolean canViewProposal = this.kraAuthorizationService.hasPermission(currentUser, (Permissionable)document, "View Proposal");
        if (canModifyProposal) {
            HtmlData.AnchorHtmlData editHtmlData = this.getViewLink((Document)document);
            String href = editHtmlData.getHref();
            href = href.replace("viewDocument=true", "viewDocument=false");
            editHtmlData.setHref(href);
            editHtmlData.setDisplayText("edit");
            htmlDataList.add((HtmlData)editHtmlData);
        }
        if (canViewProposal) {
            HtmlData.AnchorHtmlData viewLink = this.getViewLink((Document)document);
            htmlDataList.add((HtmlData)viewLink);
            htmlDataList.add((HtmlData)this.getCustomLink((Document)document, "actions", "copy", Boolean.valueOf(!canModifyProposal)));
        }
        if (canModifyProposal) {
            htmlDataList.add((HtmlData)this.getMedusaLink((Document)document, Boolean.valueOf(false)));
        } else if (canViewProposal) {
            htmlDataList.add((HtmlData)this.getMedusaLink((Document)document, Boolean.valueOf(true)));
        }
        return htmlDataList;
    }

    protected String getDocumentTypeName() {
        return "ProposalDevelopmentDocument";
    }

    protected String getHtmlAction() {
        return "proposalDevelopmentProposal.do";
    }

    protected String getKeyFieldName() {
        return "proposalNumber";
    }

    private List<DevelopmentProposal> filterForPermissions(List<DevelopmentProposal> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        ArrayList<DevelopmentProposal> filteredResults = new ArrayList<DevelopmentProposal>();
        for (DevelopmentProposal developmentProposal : results) {
            DocumentAuthorizer authorizer = this.getDocumentHelperService().getDocumentAuthorizer("ProposalDevelopmentDocument");
            if (!authorizer.canOpen((Document)developmentProposal.getProposalDocument(), user)) continue;
            filteredResults.add(developmentProposal);
        }
        return filteredResults;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    private DocumentHelperService getDocumentHelperService() {
        return (DocumentHelperService)KraServiceLocator.getService(DocumentHelperService.class);
    }
}

