/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.NarrativeRight;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.NarrativeAttachment;
import org.kuali.kra.proposaldevelopment.bo.NarrativeUserRights;
import org.kuali.kra.proposaldevelopment.dao.AttachmentDao;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.NarrativeAuthZService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class NarrativeServiceImpl
implements NarrativeService {
    private static final Log LOG = LogFactory.getLog(NarrativeServiceImpl.class);
    private NarrativeAuthZService narrativeAuthZService;
    private ProposalPersonService proposalPersonService;
    private BusinessObjectService businessObjectService;
    private SystemAuthorizationService systemAuthorizationService;
    private DateTimeService dateTimeService;
    private KcPersonService kcPersonService;
    private PersonService personService;
    private AttachmentDao attachmentDao;

    public void addNarrative(ProposalDevelopmentDocument proposaldevelopmentDocument, Narrative narrative) {
        narrative.setProposalNumber(proposaldevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        narrative.setModuleNumber(this.getNextModuleNumber(proposaldevelopmentDocument));
        narrative.setModuleSequenceNumber(this.getNextModuleSequenceNumber(proposaldevelopmentDocument));
        this.updateUserTimestamp((KraPersistableBusinessObjectBase)narrative);
        narrative.refreshReferenceObject("narrativeType");
        narrative.refreshReferenceObject("narrativeStatus");
        narrative.populateAttachment();
        this.populateNarrativeUserRights(proposaldevelopmentDocument, narrative);
        this.getBusinessObjectService().save((PersistableBusinessObject)narrative);
        narrative.clearAttachment();
        proposaldevelopmentDocument.getDevelopmentProposal().getNarratives().add(narrative);
    }

    protected Integer getNextModuleNumber(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        List narrativeList = proposaldevelopmentDocument.getDevelopmentProposal().getNarratives();
        List instituteAttachmentsList = proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments();
        ArrayList mergedNarrativeList = new ArrayList();
        mergedNarrativeList.addAll(narrativeList);
        mergedNarrativeList.addAll(instituteAttachmentsList);
        if (mergedNarrativeList.isEmpty()) {
            return 1;
        }
        Collections.sort(mergedNarrativeList, new /* Unavailable Anonymous Inner Class!! */);
        return ((Narrative)mergedNarrativeList.get(mergedNarrativeList.size() - 1)).getModuleNumber() + 1;
    }

    protected Integer getNextModuleSequenceNumber(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        List narrativeList = proposaldevelopmentDocument.getDevelopmentProposal().getNarratives();
        List instituteAttachmentsList = proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments();
        ArrayList mergedNarrativeList = new ArrayList();
        mergedNarrativeList.addAll(narrativeList);
        mergedNarrativeList.addAll(instituteAttachmentsList);
        if (mergedNarrativeList.isEmpty()) {
            return 1;
        }
        Collections.sort(mergedNarrativeList, new /* Unavailable Anonymous Inner Class!! */);
        return ((Narrative)mergedNarrativeList.get(mergedNarrativeList.size() - 1)).getModuleSequenceNumber() + 1;
    }

    protected void populateNarrativeUserRights(ProposalDevelopmentDocument proposalDevelopmentDocument, Narrative narrative) {
        List persons = this.getPersons(proposalDevelopmentDocument);
        List narrativeUserRights = narrative.getNarrativeUserRights();
        for (KcPerson person : persons) {
            if (this.isPersonInNarrativeRights(person, narrativeUserRights)) continue;
            NarrativeRight narrativeRight = this.narrativeAuthZService.getDefaultNarrativeRight(person.getPersonId(), proposalDevelopmentDocument);
            String personName = person.getFullName();
            NarrativeUserRights narrUserRight = new NarrativeUserRights();
            narrUserRight.setProposalNumber(narrative.getProposalNumber());
            narrUserRight.setModuleNumber(narrative.getModuleNumber());
            narrUserRight.setUserId(person.getPersonId());
            narrUserRight.setAccessType(narrativeRight.getAccessType());
            narrUserRight.setPersonName(personName);
            this.updateUserTimestamp((KraPersistableBusinessObjectBase)narrUserRight);
            narrativeUserRights.add(narrUserRight);
        }
    }

    protected boolean isPersonInNarrativeRights(KcPerson person, List<NarrativeUserRights> narrativeUserRights) {
        for (NarrativeUserRights right : narrativeUserRights) {
            if (!StringUtils.equals((String)right.getUserId(), (String)person.getPersonId())) continue;
            return true;
        }
        return false;
    }

    protected List<KcPerson> getPersons(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List proposalRoles = this.systemAuthorizationService.getRoles("KC-PD");
        KraAuthorizationService kraAuthorizationService = this.getKraAuthorizationService();
        ArrayList<KcPerson> allPersons = new ArrayList<KcPerson>();
        for (Role proposalRole : proposalRoles) {
            List persons = kraAuthorizationService.getPersonsInRole((Permissionable)proposalDevelopmentDocument, proposalRole.getName());
            for (KcPerson person : persons) {
                if (this.isPersonInList(person, allPersons)) continue;
                allPersons.add(person);
            }
        }
        return allPersons;
    }

    protected boolean isPersonInList(KcPerson person, List<KcPerson> persons) {
        for (KcPerson p : persons) {
            if (!StringUtils.equals((String)p.getPersonId(), (String)person.getPersonId())) continue;
            return true;
        }
        return false;
    }

    public void deleteProposalAttachment(ProposalDevelopmentDocument proposaldevelopmentDocument, int lineToDelete) {
        this.deleteAttachment(proposaldevelopmentDocument.getDevelopmentProposal().getNarratives(), lineToDelete);
    }

    public void deleteInstitutionalAttachment(ProposalDevelopmentDocument proposaldevelopmentDocument, int lineToDelete) {
        this.deleteAttachment(proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments(), lineToDelete);
    }

    protected void deleteAttachment(List<Narrative> narratives, int lineToDelete) {
        Narrative narrative = narratives.get(lineToDelete);
        this.getBusinessObjectService().delete((PersistableBusinessObject)narrative);
        NarrativeAttachment narrAtt = new NarrativeAttachment();
        narrAtt.setProposalNumber(narrative.getProposalNumber());
        narrAtt.setModuleNumber(narrative.getModuleNumber());
        if (narrative.getNarrativeAttachmentList().isEmpty()) {
            narrative.getNarrativeAttachmentList().add(narrAtt);
        } else {
            narrative.getNarrativeAttachmentList().set(0, narrAtt);
        }
        narratives.remove(lineToDelete);
    }

    public void addInstituteAttachment(ProposalDevelopmentDocument proposaldevelopmentDocument, Narrative narrative) {
        narrative.setProposalNumber(proposaldevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        narrative.setModuleNumber(this.getNextModuleNumber(proposaldevelopmentDocument));
        narrative.setModuleSequenceNumber(this.getNextModuleSequenceNumber(proposaldevelopmentDocument));
        narrative.refreshReferenceObject("narrativeType");
        narrative.populateAttachment();
        this.populateNarrativeUserRights(proposaldevelopmentDocument, narrative);
        this.getBusinessObjectService().save((PersistableBusinessObject)narrative);
        narrative.clearAttachment();
        proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments().add(narrative);
    }

    public void populatePersonNameForNarrativeUserRights(ProposalDevelopmentDocument proposaldevelopmentDocument, Narrative narrative) {
        List narrativeUserRights = narrative.getNarrativeUserRights();
        for (NarrativeUserRights narrativeUserRight : narrativeUserRights) {
            String personName = this.proposalPersonService.getPersonName(proposaldevelopmentDocument, narrativeUserRight.getUserId());
            narrativeUserRight.setPersonName(personName);
        }
    }

    public void replaceAttachment(Narrative narrative) {
        narrative.refreshReferenceObject("narrativeAttachmentList");
        narrative.populateAttachment();
        this.getBusinessObjectService().save((PersistableBusinessObject)narrative);
        narrative.clearAttachment();
    }

    public void populateNarrativeRightsForLoggedinUser(ProposalDevelopmentDocument proposaldevelopmentDocument) {
        List narrativeList = proposaldevelopmentDocument.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narrativeList) {
            this.populateNarrativeUserRights(proposaldevelopmentDocument, narrative);
        }
        List instituteAttachmentList = proposaldevelopmentDocument.getDevelopmentProposal().getInstituteAttachments();
        for (Narrative instituteAttachment : instituteAttachmentList) {
            this.populateNarrativeUserRights(proposaldevelopmentDocument, instituteAttachment);
        }
    }

    protected void updateUserTimestamp(KraPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
    }

    public NarrativeAuthZService getNarrativeAuthZService() {
        return this.narrativeAuthZService;
    }

    public void setNarrativeAuthZService(NarrativeAuthZService narrativeAuthZService) {
        this.narrativeAuthZService = narrativeAuthZService;
    }

    public ProposalPersonService getProposalPersonService() {
        return this.proposalPersonService;
    }

    public void setProposalPersonService(ProposalPersonService proposalPersonService) {
        this.proposalPersonService = proposalPersonService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)KraServiceLocator.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void deletePerson(String userId, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        block0: for (Narrative narrative : narratives) {
            List userRights = narrative.getNarrativeUserRights();
            for (NarrativeUserRights right : userRights) {
                if (!StringUtils.equals((String)right.getUserId(), (String)userId)) continue;
                userRights.remove(right);
                continue block0;
            }
        }
    }

    public void readjustRights(String userId, ProposalDevelopmentDocument proposalDevelopmentDocument, List<String> roleNames) {
        List narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        block0: for (Narrative narrative : narratives) {
            List userRights = narrative.getNarrativeUserRights();
            for (NarrativeUserRights right : userRights) {
                String accessType;
                NarrativeRight narrativeRight;
                if (!StringUtils.equals((String)right.getUserId(), (String)userId)) continue;
                String currentAccessType = right.getAccessType();
                if (StringUtils.equals((String)currentAccessType, (String)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType())) {
                    narrativeRight = this.narrativeAuthZService.getDefaultNarrativeRight(userId, proposalDevelopmentDocument);
                    accessType = narrativeRight.getAccessType();
                    if (StringUtils.equals((String)accessType, (String)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType())) {
                        right.setAccessType(NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType());
                        continue block0;
                    }
                    if (!StringUtils.equals((String)accessType, (String)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType())) continue block0;
                    right.setAccessType(NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType());
                    continue block0;
                }
                if (!StringUtils.equals((String)currentAccessType, (String)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) || !StringUtils.equals((String)(accessType = (narrativeRight = this.narrativeAuthZService.getDefaultNarrativeRight(userId, proposalDevelopmentDocument)).getAccessType()), (String)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType())) continue block0;
                right.setAccessType(NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType());
                continue block0;
            }
        }
    }

    public void addPerson(String userName, ProposalDevelopmentDocument proposalDevelopmentDocument, String roleName) {
        KcPerson person = this.kcPersonService.getKcPersonByUserName(userName);
        List narratives = proposalDevelopmentDocument.getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narratives) {
            List userRights = narrative.getNarrativeUserRights();
            NarrativeRight narrativeRight = this.narrativeAuthZService.getDefaultNarrativeRight(roleName);
            NarrativeUserRights narrUserRight = new NarrativeUserRights();
            narrUserRight.setProposalNumber(narrative.getProposalNumber());
            narrUserRight.setModuleNumber(narrative.getModuleNumber());
            narrUserRight.setUserId(person.getPersonId());
            narrUserRight.setAccessType(narrativeRight.getAccessType());
            narrUserRight.setPersonName(person.getFullName());
            this.updateUserTimestamp((KraPersistableBusinessObjectBase)narrUserRight);
            userRights.add(narrUserRight);
        }
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public AttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    public void setAttachmentDao(AttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }

    public void setNarrativeTimeStampUser(List<Narrative> narratives) {
        for (Narrative narrative : narratives) {
            Iterator personBioAtt = this.attachmentDao.getNarrativeTimeStampAndUploadUser(narrative.getModuleNumber(), narrative.getProposalNumber());
            if (!personBioAtt.hasNext()) continue;
            Object[] item = (Object[])personBioAtt.next();
            narrative.setTimestampDisplay((Timestamp)item[0]);
            narrative.setUploadUserDisplay((String)item[1]);
            Person person = this.personService.getPersonByPrincipalName(narrative.getUploadUserDisplay());
            narrative.setUploadUserFullName(ObjectUtils.isNull((Object)person) ? narrative.getUploadUserDisplay() + "(not found)" : person.getName());
        }
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        return (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

