/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.service.impl.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.service.PropDevJavaFunctionKrmsTermService;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.bo.S2sOppForms;

public class PropDevJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements PropDevJavaFunctionKrmsTermService {
    public Boolean specifiedGGForm(DevelopmentProposal developmentProposal, String formNames) {
        String[] formNamesArray = this.buildArrayFromCommaList(formNames);
        developmentProposal.refreshReferenceObject("s2sOppForms");
        List s2sOppForms = developmentProposal.getS2sOppForms();
        for (int i = 0; i < formNamesArray.length; ++i) {
            String formName = formNamesArray[i].trim();
            for (S2sOppForms s2sOppForm : s2sOppForms) {
                if (!s2sOppForm.getInclude().booleanValue() || !s2sOppForm.getFormName().equals(formName)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public String multiplePI(DevelopmentProposal developmentProposal) {
        List people = developmentProposal.getProposalPersons();
        for (ProposalPerson person : people) {
            if (!person.isMultiplePi()) continue;
            return "true";
        }
        return "false";
    }

    public String s2sBudgetRule(DevelopmentProposal developmentProposal, String formNames) {
        int li_count_s2s;
        String[] formNamesArray = this.buildArrayFromCommaList(formNames);
        int li_count_bud = 0;
        for (String formName : formNamesArray) {
            for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                if (!StringUtils.equalsIgnoreCase((String)formName, (String)form.getFormName()) || !form.getInclude().booleanValue()) continue;
                ++li_count_bud;
            }
        }
        int n = li_count_s2s = developmentProposal.getS2sOpportunity() != null ? 1 : 0;
        if (li_count_bud != 0 && li_count_s2s <= 0) {
            return "true";
        }
        return "false";
    }

    public String monitoredSponsorRule(DevelopmentProposal developmentProposal, String monitoredSponsorHirearchies) {
        String[] sponsoredHierarchyArray = this.buildArrayFromCommaList(monitoredSponsorHirearchies);
        ArrayList hierarchies = new ArrayList();
        for (String hierarchyName : sponsoredHierarchyArray) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("HIERARCH_NAME", hierarchyName);
            hierarchies.addAll(this.getBusinessObjectService().findMatching(SponsorHierarchy.class, fieldValues));
        }
        for (SponsorHierarchy sh : hierarchies) {
            if (!StringUtils.equalsIgnoreCase((String)sh.getSponsorCode(), (String)developmentProposal.getSponsor().getSponsorCode()) && !StringUtils.equalsIgnoreCase((String)sh.getSponsorCode(), (String)developmentProposal.getPrimeSponsor().getSponsorCode())) continue;
            return "true";
        }
        return "false";
    }

    public String s2sResplanRule(DevelopmentProposal developmentProposal, String narativeTypes, String maxNumber) {
        String[] narrativeTypesArray = this.buildArrayFromCommaList(narativeTypes);
        int[] narrativeCounts = new int[narrativeTypesArray.length];
        int maxNumberInt = Integer.parseInt(maxNumber);
        for (Narrative narrative : developmentProposal.getNarratives()) {
            int narrativePosition = 0;
            for (String narrativeType : narrativeTypesArray) {
                if (StringUtils.equalsIgnoreCase((String)narrativeType, (String)narrative.getNarrativeType().getDescription())) {
                    int n = narrativePosition;
                    narrativeCounts[n] = narrativeCounts[n] + 1;
                    if (narrativeCounts[narrativePosition] > maxNumberInt) {
                        return "true";
                    }
                }
                ++narrativePosition;
            }
        }
        return "false";
    }

    public String grantsFormRule(DevelopmentProposal developmentProposal, String formName) {
        for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
            if (!StringUtils.equalsIgnoreCase((String)formName, (String)form.getFormName())) continue;
            return "true";
        }
        return "false";
    }

    public String biosketchFileNameRule(DevelopmentProposal developmentProposal) {
        for (ProposalPersonBiography ppb : developmentProposal.getPropPersonBios()) {
            if (!StringUtils.equalsIgnoreCase((String)ppb.getPropPerDocType().getDescription(), (String)"Biosketch") || !StringUtils.equals((String)"false", (String)this.specialCharacterRule(ppb.getFileName()))) continue;
            return "false";
        }
        return "true";
    }

    public String ospAdminPropPersonRule(DevelopmentProposal developmentProposal) {
        List ospAdmins = developmentProposal.getUnit().getUnitAdministrators();
        if (ospAdmins != null && ospAdmins.size() > 0) {
            for (ProposalPerson person : developmentProposal.getProposalPersons()) {
                for (UnitAdministrator admin : ospAdmins) {
                    if (!StringUtils.equals((String)person.getPersonId(), (String)admin.getPersonId())) continue;
                    return "true";
                }
            }
        }
        return "false";
    }

    public String costElementVersionLimit(DevelopmentProposal developmentProposal, String versionNumber, String costElementName, String limit) {
        Long versionNumberLong = Long.parseLong(versionNumber);
        float limitLong = Float.parseFloat(limit);
        for (BudgetDocumentVersion bdv : developmentProposal.getProposalDocument().getBudgetDocumentVersions()) {
            if (!bdv.getVersionNumber().equals(versionNumberLong)) continue;
            try {
                BudgetDocument budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(bdv.getDocumentNumber());
                List budgets = budgetDocument.getBudgets();
                for (Budget budget : budgets) {
                    if (!budget.getVersionNumber().equals(versionNumberLong)) continue;
                    for (BudgetPeriod period : budget.getBudgetPeriods()) {
                        float costElementTotal = 0.0f;
                        for (BudgetLineItem item : period.getBudgetLineItems()) {
                            if (!StringUtils.equalsIgnoreCase((String)costElementName, (String)item.getCostElementName())) continue;
                            costElementTotal += item.getLineItemCost().getFloatValue();
                        }
                        if (!(costElementTotal > limitLong)) continue;
                        return "true";
                    }
                }
            }
            catch (Exception e) {
            }
        }
        return "false";
    }

    public String divisionCodeRule(DevelopmentProposal developmentProposal) {
        return StringUtils.isEmpty((String)developmentProposal.getActivityTypeCode()) ? "true" : "false";
    }

    public String divisionCodeIsFellowship(DevelopmentProposal developmentProposal, String fellowshipCodes) {
        String[] fellowShipCodeArray;
        for (String code : fellowShipCodeArray = this.buildArrayFromCommaList(fellowshipCodes)) {
            if (!StringUtils.equalsIgnoreCase((String)code, (String)developmentProposal.getActivityTypeCode())) continue;
            return "true";
        }
        return "false";
    }

    public String budgetSubawardOrganizationnameRule(DevelopmentProposal developmentProposal) {
        for (BudgetDocumentVersion bdv : developmentProposal.getProposalDocument().getBudgetDocumentVersions()) {
            try {
                BudgetDocument budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(bdv.getDocumentNumber());
                List budgets = budgetDocument.getBudgets();
                for (Budget budget : budgets) {
                    if (!budget.isFinalVersionFlag()) continue;
                    for (BudgetSubAwards bsa : budget.getBudgetSubAwards()) {
                        if (!StringUtils.equals((String)"false", (String)this.specialCharacterRule(bsa.getOrganizationName()))) continue;
                        return "false";
                    }
                }
            }
            catch (Exception e) {
            }
        }
        return "true";
    }

    public String checkProposalPerson(DevelopmentProposal developmentProposal, String personId) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            if (!StringUtils.equals((String)person.getPersonId(), (String)personId)) continue;
            return "true";
        }
        return "false";
    }

    public String agencyProgramCodeNullRule(DevelopmentProposal developmentProposal) {
        return StringUtils.isEmpty((String)developmentProposal.getAgencyProgramCode()) ? "true" : "false";
    }

    public String allProposalsRule(DevelopmentProposal developmentProposal) {
        return "true";
    }

    public String proposalLeadUnitInHierarchy(DevelopmentProposal developmentProposal, String unitNumberToCheck) {
        String leadUnitNumber = developmentProposal.getUnitNumber();
        if (StringUtils.equals((String)developmentProposal.getUnitNumber(), (String)unitNumberToCheck)) {
            return "true";
        }
        List units = this.getUnitService().getAllSubUnits(unitNumberToCheck);
        if (units != null && units.size() > 0) {
            for (Unit unit : units) {
                if (!StringUtils.equals((String)developmentProposal.getUnitNumber(), (String)unit.getUnitNumber())) continue;
                return "true";
            }
        }
        return "false";
    }

    public String s2sSubawardRule(DevelopmentProposal developmentProposal, String rrFormNames, String phsFromNames) {
        boolean foundRRforms = false;
        boolean foundPHSforms = false;
        String[] rrFormNamesArray = this.buildArrayFromCommaList(rrFormNames);
        String[] phsFromNamesArray = this.buildArrayFromCommaList(phsFromNames);
        for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
            if (!form.getInclude().booleanValue()) continue;
            for (String formName : rrFormNamesArray) {
                if (!StringUtils.equalsIgnoreCase((String)formName, (String)form.getFormName())) continue;
                foundRRforms = true;
            }
            for (String formName : phsFromNamesArray) {
                if (!StringUtils.equalsIgnoreCase((String)formName, (String)form.getFormName())) continue;
                foundPHSforms = true;
            }
        }
        return foundRRforms && foundPHSforms ? "true" : "false";
    }

    public String proposalGrantsRule(DevelopmentProposal developmentProposal) {
        return developmentProposal.getS2sAppSubmission().size() > 0 ? "true" : "false";
    }

    public String narrativeTypeRule(DevelopmentProposal developmentProposal, String narrativeTypeCode) {
        List narratives = developmentProposal.getNarratives();
        for (Narrative narrative : narratives) {
            if (!narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) continue;
            return "true";
        }
        return "false";
    }

    public String activityTypeRule(DevelopmentProposal developmentProposal, String activityTypeCode) {
        if (StringUtils.equals((String)developmentProposal.getActivityTypeCode(), (String)activityTypeCode)) {
            return "true";
        }
        return "false";
    }

    public String attachmentFileNameRule(DevelopmentProposal developmentProposal) {
        for (Narrative narr : developmentProposal.getNarratives()) {
            for (String character : restrictedElements) {
                if (!StringUtils.containsIgnoreCase((String)narr.getFileName(), (String)character)) continue;
                return "false";
            }
        }
        return "true";
    }

    public String checkProposalCoiRule(DevelopmentProposal developmentProposal, String principalId) {
        for (ProposalPerson person : developmentProposal.getInvestigators()) {
            if (!person.isInvestigator() || person.getRole().isPrincipalInvestigatorRole() || !StringUtils.equals((String)principalId, (String)person.getPersonId())) continue;
            return "true";
        }
        return "false";
    }

    public String checkProposalPiRule(DevelopmentProposal developmentProposal, String principalId) {
        for (ProposalPerson person : developmentProposal.getInvestigators()) {
            if (!person.isInvestigator() || !person.getRole().isPrincipalInvestigatorRole() || !StringUtils.equals((String)principalId, (String)person.getPersonId())) continue;
            return "true";
        }
        return "false";
    }

    public String costElement(DevelopmentProposal developmentProposal, String costElement) {
        for (BudgetDocumentVersion budgetVersion : developmentProposal.getProposalDocument().getBudgetDocumentVersions()) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("costElement", costElement);
            values.put("budgetId", budgetVersion.getBudgetVersionOverview().getBudgetId());
            List matchingLineItems = (List)this.getBusinessObjectService().findMatching(BudgetLineItem.class, values);
            if (matchingLineItems == null || matchingLineItems.isEmpty()) continue;
            return "true";
        }
        return "false";
    }

    public String leadUnitBelowRule(DevelopmentProposal developmentProposal, String unitNumber) {
        if (StringUtils.equals((String)developmentProposal.getUnitNumber(), (String)unitNumber)) {
            return "true";
        }
        for (Unit unit : this.getUnitService().getAllSubUnits(unitNumber)) {
            if (!StringUtils.equals((String)unit.getUnitNumber(), (String)developmentProposal.getUnitNumber())) continue;
            return "true";
        }
        return "false";
    }

    public String leadUnitRule(DevelopmentProposal developmentProposal, String unitNumber) {
        if (StringUtils.equals((String)developmentProposal.getUnitNumber(), (String)unitNumber)) {
            return "true";
        }
        return "false";
    }

    public String mtdcDeviation(DevelopmentProposal developmentProposal) {
        if (this.mtdcDeviationInBudget(developmentProposal.getProposalDocument().getFinalBudgetForThisProposal())) {
            return "true";
        }
        return "false";
    }

    public String mtdcDeviationInVersion(DevelopmentProposal developmentProposal, String versionNumber) {
        if (this.mtdcDeviationInBudget(this.getBudgetVersion(developmentProposal, versionNumber))) {
            return "true";
        }
        return "false";
    }

    protected Budget getBudgetVersion(DevelopmentProposal developmentProposal, String versionNumber) {
        Integer versionNumberLong = Integer.valueOf(versionNumber);
        for (BudgetDocumentVersion bdv : developmentProposal.getProposalDocument().getBudgetDocumentVersions()) {
            if (!bdv.getBudgetVersionOverview().getBudgetVersionNumber().equals(versionNumberLong)) continue;
            return (Budget)this.getBusinessObjectService().findBySinglePrimaryKey(Budget.class, (Object)bdv.getBudgetVersionOverview().getBudgetId());
        }
        return null;
    }

    protected boolean mtdcDeviationInBudget(Budget budget) {
        if (budget != null) {
            return StringUtils.equals((String)budget.getOhRateClassCode(), (String)"1");
        }
        return false;
    }

    public String nonFacultyPi(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getPrincipalInvestigator().getFacultyFlag().booleanValue()) {
            return "false";
        }
        return "true";
    }

    public String proposalAwardTypeRule(DevelopmentProposal developmentProposal, Integer awardTypeCode) {
        if (awardTypeCode.equals(developmentProposal.getAnticipatedAwardTypeCode())) {
            return "true";
        }
        return "false";
    }

    public String proposalTypeRule(DevelopmentProposal developmentProposal, String proposalTypeCode) {
        if (StringUtils.equals((String)developmentProposal.getProposalTypeCode(), (String)proposalTypeCode)) {
            return "true";
        }
        return "false";
    }

    public String proposalUnitRule(DevelopmentProposal developmentProposal, String unitNumber) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            for (ProposalPersonUnit unit : person.getUnits()) {
                if (!StringUtils.equals((String)unit.getUnitNumber(), (String)unitNumber)) continue;
                return "true";
            }
        }
        return "false";
    }

    public String s2sAttachmentNarrativeRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getS2sOpportunity() != null) {
            for (Narrative narrative : developmentProposal.getNarratives()) {
                if (!StringUtils.equals((String)narrative.getNarrativeTypeCode(), (String)"61") || narrative.getModuleTitle() != null) continue;
                return "false";
            }
        }
        return "true";
    }

    public String s2sExemptionRule(DevelopmentProposal developmentProposal) {
        boolean irbLinkingEnabled = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "irb.protocol.development.proposal.linking.enabled");
        if (!irbLinkingEnabled) {
            for (ProposalSpecialReview specialReview : developmentProposal.getPropSpecialReviews()) {
                if (specialReview.getApprovalTypeCode() != "4" || specialReview.getSpecialReviewTypeCode() != "1" || specialReview.getComments() != null && specialReview.getComments().matches("\\w*E[1-6](\\w*,\\w*E[1-6])*[\\w,]*")) continue;
                return "false";
            }
        }
        return "true";
    }

    public String s2sFederalIdRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getS2sOpportunity() != null) {
            String renewalType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "PROPOSAL_TYPE_CODE_RENEWAL");
            String continuationType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "PROPOSAL_TYPE_CODE_CONTINUATION");
            String revisionType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "PROPOSAL_TYPE_CODE_REVISION");
            String taskOrderType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "PROPOSAL_TYPE_CODE_TASK_ORDER");
            if ((StringUtils.equals((String)developmentProposal.getProposalTypeCode(), (String)renewalType) || StringUtils.equals((String)developmentProposal.getProposalTypeCode(), (String)renewalType) || StringUtils.equals((String)developmentProposal.getProposalTypeCode(), (String)renewalType) || StringUtils.equals((String)developmentProposal.getProposalTypeCode(), (String)renewalType)) && (StringUtils.isBlank((String)developmentProposal.getSponsorProposalNumber()) || !developmentProposal.getSponsorProposalNumber().matches("[a-zA-Z]{2}\\d{6}"))) {
                return "false";
            }
        }
        return "true";
    }

    public String s2sLeadershipRule(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getS2sOpportunity() != null) {
            int piNumber = 0;
            for (ProposalPerson person : developmentProposal.getProposalPersons()) {
                if (!person.isMultiplePi()) continue;
                ++piNumber;
            }
            if (piNumber > 0) {
                int neededAttachmentCount = 0;
                for (Narrative narrative : developmentProposal.getNarratives()) {
                    if (!StringUtils.equals((String)narrative.getNarrativeTypeCode(), (String)"46") && !StringUtils.equals((String)narrative.getNarrativeTypeCode(), (String)"121")) continue;
                    ++neededAttachmentCount;
                }
                if (neededAttachmentCount < 1) {
                    return "false";
                }
            }
        }
        return "true";
    }

    public String s2sModularBudgetRule(DevelopmentProposal developmentProposal) {
        List<String> allowedForms = Arrays.asList("PHS398 Modular Budget V1-1", "PHS398 Modular Budget V1-2");
        boolean s2sProp = developmentProposal.getS2sOpportunity() != null;
        Budget finalBudgetVersion = developmentProposal.getProposalDocument().getFinalBudgetForThisProposal();
        if (s2sProp && finalBudgetVersion != null && finalBudgetVersion.getModularBudgetFlag().booleanValue()) {
            int matchingForms = 0;
            for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                if (!form.getInclude().booleanValue() || !allowedForms.contains(form.getFormName())) continue;
                ++matchingForms;
            }
            if (matchingForms == 0) {
                return "false";
            }
            return "true";
        }
        return "true";
    }

    public String specialReviewRule(DevelopmentProposal developmentProposal, String specialReviewTypeCode) {
        for (ProposalSpecialReview review : developmentProposal.getPropSpecialReviews()) {
            if (!StringUtils.equals((String)review.getSpecialReviewTypeCode(), (String)specialReviewTypeCode)) continue;
            return "true";
        }
        return "false";
    }

    public String sponsor(DevelopmentProposal developmentProposal, String sponsorCode) {
        if (StringUtils.equals((String)developmentProposal.getSponsorCode(), (String)sponsorCode)) {
            return "true";
        }
        return "false";
    }

    public String sponsorGroupRule(DevelopmentProposal developmentProposal, String sponsorGroup) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hierarchyName", "Routing");
        values.put("sponsorCode", developmentProposal.getSponsorCode());
        List hierarchies = (List)this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        if (hierarchies != null && !hierarchies.isEmpty() && StringUtils.equals((String)((SponsorHierarchy)hierarchies.get(0)).getLevel1(), (String)sponsorGroup)) {
            return "true";
        }
        values.put("sponsorCode", developmentProposal.getPrimeSponsorCode());
        hierarchies = (List)this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        if (hierarchies != null && !hierarchies.isEmpty() && StringUtils.equals((String)((SponsorHierarchy)hierarchies.get(0)).getLevel1(), (String)sponsorGroup)) {
            return "true";
        }
        return "false";
    }

    public String s2s398CoverRule(DevelopmentProposal developmentProposal, String PHSCoverLetters, String narrativeTypeCode) {
        if (developmentProposal.getS2sAppSubmission().size() > 0) {
            boolean foundNarrative = false;
            for (Narrative narrative : developmentProposal.getNarratives()) {
                if (!StringUtils.equalsIgnoreCase((String)narrative.getNarrativeTypeCode(), (String)narrativeTypeCode)) continue;
                foundNarrative = true;
            }
            if (foundNarrative) {
                String[] coverLetters = this.buildArrayFromCommaList(PHSCoverLetters);
                boolean foundForm = false;
                for (S2sOppForms form : developmentProposal.getS2sOppForms()) {
                    for (String coverLetter : coverLetters) {
                        if (!StringUtils.equals((String)form.getFormName(), (String)coverLetter)) continue;
                        foundForm = true;
                    }
                }
                if (!foundForm) {
                    return "false";
                }
            }
        }
        return "true";
    }

    public String narrativeFileName(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (StringUtils.equalsIgnoreCase((String)narrative.getNarrativeType().getNarrativeTypeGroup(), (String)"P") && StringUtils.equals((String)"false", (String)this.specialCharacterRule(narrative.getFileName()))) {
                return "false";
            }
            if (!StringUtils.equalsIgnoreCase((String)narrative.getNarrativeTypeCode(), (String)"8") || !StringUtils.equals((String)"false", (String)this.specialCharacterRule(narrative.getModuleTitle()))) continue;
            return "false";
        }
        return "true";
    }

    public String costElementInVersion(DevelopmentProposal developmentProposal, String versionNumber, String costElement) {
        Long versionNumberLong = Long.parseLong(versionNumber);
        for (BudgetDocumentVersion bdv : developmentProposal.getProposalDocument().getBudgetDocumentVersions()) {
            if (!bdv.getVersionNumber().equals(versionNumberLong)) continue;
            try {
                BudgetDocument budgetDocument = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(bdv.getDocumentNumber());
                List budgets = budgetDocument.getBudgets();
                for (Budget budget : budgets) {
                    if (!budget.getVersionNumber().equals(versionNumberLong)) continue;
                    for (BudgetPeriod period : budget.getBudgetPeriods()) {
                        Iterator i$ = period.getBudgetLineItems().iterator();
                        if (!i$.hasNext()) continue;
                        BudgetLineItem item = (BudgetLineItem)i$.next();
                        return "true";
                    }
                }
            }
            catch (Exception e) {
            }
        }
        return "false";
    }

    public String investigatorKeyPersonCertificationRule(DevelopmentProposal developmentProposal) {
        QuestionnaireAnswerService questionnaireService = (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            ProposalPersonModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalPersonModuleQuestionnaireBean(developmentProposal, person);
            List answerHeaders = questionnaireService.getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean);
            for (AnswerHeader ah : answerHeaders) {
                if (ah.getCompleted()) continue;
                return "false";
            }
        }
        return "true";
    }

    public String sponsorTypeRule(DevelopmentProposal developmentProposal, String sponsorTypeCode) {
        if (StringUtils.equals((String)developmentProposal.getSponsor().getSponsorTypeCode(), (String)sponsorTypeCode)) {
            return "true";
        }
        return "false";
    }

    public String incompleteNarrativeRule(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (!StringUtils.equals((String)narrative.getModuleStatusCode(), (String)"I")) continue;
            return "false";
        }
        return "true";
    }
}

