/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncServiceImpl;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.proposaldevelopment.bo.CoPiInfoDO;
import org.kuali.kra.proposaldevelopment.bo.CostShareInfoDO;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalBudgetStatus;
import org.kuali.kra.proposaldevelopment.bo.ProposalColumnsToAlter;
import org.kuali.kra.proposaldevelopment.bo.ProposalOverview;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetColumnsToAlter;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentServiceImpl
implements ProposalDevelopmentService {
    protected final Log LOG = LogFactory.getLog(AwardSyncServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private UnitAuthorizationService unitAuthService;
    private KraPersistenceStructureService kraPersistenceStructureService;
    private BudgetService budgetService;
    private ParameterService parameterService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void initializeUnitOrganizationLocation(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalSite applicantOrganization = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization();
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getOwnedByUnitNumber() != null && applicantOrganization.getOrganization() == null) {
            developmentProposal.refreshReferenceObject("ownedByUnit");
            String applicantOrganizationId = developmentProposal.getOwnedByUnit().getOrganizationId();
            applicantOrganization = this.createProposalSite(applicantOrganizationId, this.getNextSiteNumber(proposalDevelopmentDocument));
            developmentProposal.setApplicantOrganization(applicantOrganization);
        }
        ProposalSite performingOrganization = developmentProposal.getPerformingOrganization();
        if (StringUtils.isEmpty((String)developmentProposal.getProposalNumber()) && performingOrganization.getOrganization() == null && developmentProposal.getOwnedByUnitNumber() != null) {
            String performingOrganizationId = developmentProposal.getOwnedByUnit().getOrganizationId();
            performingOrganization = this.createProposalSite(performingOrganizationId, this.getNextSiteNumber(proposalDevelopmentDocument));
            developmentProposal.setPerformingOrganization(performingOrganization);
        }
    }

    protected ProposalSite createProposalSite(String organizationId, int siteNumber) {
        ProposalSite proposalSite = new ProposalSite();
        proposalSite.setOrganizationId(organizationId);
        proposalSite.refreshReferenceObject("organization");
        proposalSite.setLocationName(proposalSite.getOrganization().getOrganizationName());
        proposalSite.initializeDefaultCongressionalDistrict();
        return proposalSite;
    }

    protected int getNextSiteNumber(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return proposalDevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalLocation.locationSequenceNumber");
    }

    public void initializeProposalSiteNumbers(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        for (ProposalSite proposalSite : proposalDevelopmentDocument.getDevelopmentProposal().getProposalSites()) {
            if (proposalSite.getSiteNumber() != null) continue;
            proposalSite.setSiteNumber(Integer.valueOf(this.getNextSiteNumber(proposalDevelopmentDocument)));
        }
    }

    public List<Unit> getDefaultModifyProposalUnitsForUser(String userId) {
        return this.unitAuthService.getUnits(userId, "KC-PD", "Create ProposalDevelopmentDocument");
    }

    protected Collection<Unit> getUnitsWithNumbers(String ... unitNumbers) {
        ArrayList<Unit> retval = new ArrayList<Unit>();
        for (String unitNumber : unitNumbers) {
            HashMap<String, String> query_map = new HashMap<String, String>();
            query_map.put("unitNumber", unitNumber);
            retval.add((Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, query_map));
        }
        return retval;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthService) {
        this.unitAuthService = unitAuthService;
    }

    public String populateProposalEditableFieldMetaDataForAjaxCall(String proposalNumber, String editableFieldDBColumn) {
        if (this.isAuthorizedToAccess(proposalNumber)) {
            if (StringUtils.isNotBlank((String)proposalNumber) && proposalNumber.contains(":")) {
                proposalNumber = StringUtils.split((String)proposalNumber, (String)":")[0];
            }
            return this.populateProposalEditableFieldMetaData(proposalNumber, editableFieldDBColumn);
        }
        return "";
    }

    public String populateBudgetEditableFieldMetaDataForAjaxCall(String proposalNumber, String documentNumber, String editableFieldDBColumn) {
        if (this.isAuthorizedToAccess(proposalNumber) && StringUtils.isNotBlank((String)documentNumber) && StringUtils.isNotBlank((String)editableFieldDBColumn)) {
            return this.populateBudgetEditableFieldMetaData(documentNumber, editableFieldDBColumn);
        }
        return "";
    }

    protected ProposalOverview getProposalOverview(String proposalNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        ProposalOverview currentProposal = (ProposalOverview)this.businessObjectService.findByPrimaryKey(ProposalOverview.class, primaryKeys);
        return currentProposal;
    }

    protected BudgetVersionOverview getBudgetVersionOverview(String documentNumber) {
        BudgetVersionOverview currentBudget = null;
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("documentNumber", documentNumber);
        Collection currentBudgets = this.businessObjectService.findMatching(BudgetVersionOverview.class, primaryKeys);
        for (BudgetVersionOverview budgetVersionOverview : currentBudgets) {
            if (!budgetVersionOverview.isFinalVersionFlag()) continue;
            currentBudget = budgetVersionOverview;
            break;
        }
        return currentBudget;
    }

    protected String getLookupDisplayValue(String lookupClassName, String value, String displayAttributeName) {
        HashMap primaryKeys = new HashMap();
        List lookupClassPkFields = null;
        Class<?> lookupClass = null;
        String displayValue = "";
        String returnValue = "";
        PersistableBusinessObject businessObject = null;
        if (StringUtils.isNotEmpty((String)lookupClassName)) {
            try {
                lookupClass = Class.forName(lookupClassName);
                lookupClassPkFields = this.kraPersistenceStructureService.getPrimaryKeys(lookupClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (CollectionUtils.isNotEmpty(lookupClassPkFields)) {
                String string = returnValue = StringUtils.isNotEmpty((String)((String)lookupClassPkFields.get(0))) ? (String)lookupClassPkFields.get(0) : "";
                if (StringUtils.isNotEmpty((String)value)) {
                    primaryKeys.put(lookupClassPkFields.get(0), value);
                    businessObject = (PersistableBusinessObject)this.businessObjectService.findByPrimaryKey(lookupClass, primaryKeys);
                    if (businessObject != null) {
                        displayValue = this.getPropertyValue((BusinessObject)businessObject, displayAttributeName);
                        displayValue = StringUtils.isNotEmpty((String)displayValue) ? displayValue : "";
                    }
                }
            }
        }
        return returnValue + "," + displayAttributeName + "," + displayValue;
    }

    public String getDataOverrideLookupDisplayReturnValue(String lookupClassName) {
        List lookupClassPkFields = null;
        String returnValue = "";
        Class<?> lookupClass = null;
        if (StringUtils.isNotEmpty((String)lookupClassName)) {
            try {
                lookupClass = Class.forName(lookupClassName);
                lookupClassPkFields = this.kraPersistenceStructureService.getPrimaryKeys(lookupClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (CollectionUtils.isNotEmpty(lookupClassPkFields)) {
                returnValue = StringUtils.isNotEmpty((String)((String)lookupClassPkFields.get(0))) ? (String)lookupClassPkFields.get(0) : "";
            }
        }
        return returnValue;
    }

    public String getDataOverrideLookupDisplayDisplayValue(String lookupClassName, String value, String displayAttributeName) {
        HashMap primaryKeys = new HashMap();
        List lookupClassPkFields = null;
        Class<?> lookupClass = null;
        String displayValue = "";
        PersistableBusinessObject businessObject = null;
        if (StringUtils.isNotEmpty((String)lookupClassName)) {
            try {
                lookupClass = Class.forName(lookupClassName);
                lookupClassPkFields = this.kraPersistenceStructureService.getPrimaryKeys(lookupClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (CollectionUtils.isNotEmpty(lookupClassPkFields) && StringUtils.isNotEmpty((String)value)) {
                primaryKeys.put(lookupClassPkFields.get(0), value);
                businessObject = (PersistableBusinessObject)this.businessObjectService.findByPrimaryKey(lookupClass, primaryKeys);
                if (businessObject != null) {
                    displayValue = this.getPropertyValue((BusinessObject)businessObject, displayAttributeName);
                    displayValue = StringUtils.isNotEmpty((String)displayValue) ? displayValue : "";
                }
            }
        }
        return displayValue;
    }

    protected String getPropertyValue(BusinessObject businessObject, String fieldName) {
        String displayValue = "";
        try {
            displayValue = (String)ObjectUtils.getPropertyValue((Object)businessObject, (String)fieldName);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        return displayValue;
    }

    public Object getProposalFieldValueFromDBColumnName(String proposalNumber, String dbColumnName) {
        ProposalOverview currentProposal;
        Object fieldValue = null;
        Map fieldMap = this.kraPersistenceStructureService.getDBColumnToObjectAttributeMap(ProposalOverview.class);
        String proposalAttributeName = (String)fieldMap.get(dbColumnName);
        if (StringUtils.isNotEmpty((String)proposalAttributeName) && (currentProposal = this.getProposalOverview(proposalNumber)) != null) {
            fieldValue = ObjectUtils.getPropertyValue((Object)currentProposal, (String)proposalAttributeName);
        }
        return fieldValue;
    }

    public Object getBudgetFieldValueFromDBColumnName(String documentNumber, String dbColumnName) {
        BudgetVersionOverview currentBudget;
        Object fieldValue = null;
        Map fieldMap = this.kraPersistenceStructureService.getDBColumnToObjectAttributeMap(BudgetVersionOverview.class);
        String budgetAttributeName = (String)fieldMap.get(dbColumnName);
        if (StringUtils.isNotEmpty((String)budgetAttributeName) && (currentBudget = this.getBudgetVersionOverview(documentNumber)) != null) {
            fieldValue = ObjectUtils.getPropertyValue((Object)currentBudget, (String)budgetAttributeName);
        }
        return fieldValue;
    }

    protected String populateProposalEditableFieldMetaData(String proposalNumber, String editableFieldDBColumn) {
        String returnValue = "";
        if (GlobalVariables.getMessageMap() != null) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
        Object fieldValue = this.getProposalFieldValueFromDBColumnName(proposalNumber, editableFieldDBColumn);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("columnName", editableFieldDBColumn);
        ProposalColumnsToAlter editableColumn = (ProposalColumnsToAlter)this.businessObjectService.findByPrimaryKey(ProposalColumnsToAlter.class, primaryKeys);
        returnValue = editableColumn.getHasLookup() ? this.getDataOverrideLookupDisplayReturnValue(editableColumn.getLookupClass()) + "," + editableColumn.getLookupReturn() + "," + this.getDataOverrideLookupDisplayDisplayValue(editableColumn.getLookupClass(), fieldValue != null ? fieldValue.toString() : "", editableColumn.getLookupReturn()) : (fieldValue != null && editableColumn.getDataType().equalsIgnoreCase("DATE") ? ",," + CoreApiServiceLocator.getDateTimeService().toString((Date)fieldValue, "MM/dd/yyyy") : (fieldValue != null ? ",," + fieldValue.toString() : ",,"));
        returnValue = returnValue + "," + editableColumn.getDataType();
        returnValue = returnValue + "," + editableColumn.getHasLookup();
        returnValue = returnValue + "," + editableColumn.getLookupClass();
        return returnValue;
    }

    public Award getProposalCurrentAwardVersion(ProposalDevelopmentDocument proposal) {
        String awardNumber = proposal.getDevelopmentProposal().getCurrentAwardNumber();
        VersionHistory vh = this.versionHistoryService.findActiveVersion(Award.class, awardNumber);
        Award award = null;
        if (vh != null) {
            award = (Award)vh.getSequenceOwner();
        } else {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("awardNumber", awardNumber);
            List awards = (List)this.businessObjectService.findMatching(Award.class, valueMap);
            if (awards != null && !awards.isEmpty()) {
                award = (Award)awards.get(0);
            }
        }
        return award;
    }

    public InstitutionalProposal getProposalContinuedFromVersion(ProposalDevelopmentDocument proposal) {
        String proposalNumber = proposal.getDevelopmentProposal().getContinuedFrom();
        VersionHistory vh = this.versionHistoryService.findActiveVersion(InstitutionalProposal.class, proposalNumber);
        InstitutionalProposal ip = null;
        if (vh != null) {
            ip = (InstitutionalProposal)vh.getSequenceOwner();
        } else if (StringUtils.isNotEmpty((String)proposalNumber)) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("proposalNumber", proposalNumber);
            List proposals = (List)this.businessObjectService.findMatching(InstitutionalProposal.class, valueMap);
            if (proposals != null && !proposals.isEmpty()) {
                ip = (InstitutionalProposal)proposals.get(0);
            }
        }
        return ip;
    }

    public KraPersistenceStructureService getKraPersistenceStructureService() {
        return this.kraPersistenceStructureService;
    }

    public void setKraPersistenceStructureService(KraPersistenceStructureService kraPersistenceStructureService) {
        this.kraPersistenceStructureService = kraPersistenceStructureService;
    }

    public BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public boolean isGrantsGovEnabledForProposal(DevelopmentProposal devProposal) {
        String federalSponsorTypeCode = this.parameterService.getParameterValueAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE");
        return !devProposal.isChild() && devProposal.getSponsor() != null && StringUtils.equals((String)devProposal.getSponsor().getSponsorTypeCode(), (String)federalSponsorTypeCode);
    }

    public boolean isGrantsGovEnabledOnSponsorChange(String proposalNumber, String sponsorCode) {
        String federalSponsorTypeCode = this.parameterService.getParameterValueAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE");
        DevelopmentProposal proposal = (DevelopmentProposal)this.getBusinessObjectService().findBySinglePrimaryKey(DevelopmentProposal.class, (Object)proposalNumber);
        Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sponsorCode);
        boolean enableGrantsGov = proposal == null || !proposal.isChild();
        return enableGrantsGov &= sponsor != null && StringUtils.equals((String)sponsor.getSponsorTypeCode(), (String)federalSponsorTypeCode);
    }

    public void deleteProposal(ProposalDevelopmentDocument proposalDocument) throws WorkflowException {
        ListIterator iter = proposalDocument.getBudgetDocumentVersions().listIterator();
        while (iter.hasNext()) {
            BudgetDocumentVersion budgetVersion = (BudgetDocumentVersion)iter.next();
            this.deleteProposalBudget(budgetVersion.getDocumentNumber(), proposalDocument);
            iter.remove();
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("proposalNumber", proposalDocument.getDevelopmentProposal().getProposalNumber());
        this.getBusinessObjectService().deleteMatching(ProposalBudgetStatus.class, keyValues);
        proposalDocument.getDevelopmentProposalList().clear();
        proposalDocument.getBudgetDocumentVersions().clear();
        proposalDocument.setProposalDeleted(true);
        this.getBusinessObjectService().save((PersistableBusinessObject)proposalDocument);
        this.getDocumentService().cancelDocument((Document)proposalDocument, "Delete Proposal");
    }

    protected void deleteProposalBudget(String budgetDocumentNumber, ProposalDevelopmentDocument parentDocument) {
        try {
            BudgetDocument document = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(budgetDocumentNumber);
            document.getBudgets().clear();
            document.setParentDocument((BudgetParentDocument)parentDocument);
            document.setBudgetDeleted(true);
            this.getDocumentService().saveDocument((Document)document);
        }
        catch (WorkflowException e) {
            this.LOG.warn((Object)"Error getting budget document to delete", (Throwable)e);
        }
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    private boolean isAuthorizedToAccess(String proposalNumber) {
        boolean isAuthorized = true;
        if (proposalNumber.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                Map editModes;
                Object formObj;
                String[] invalues = StringUtils.split((String)proposalNumber, (String)":");
                String docFormKey = invalues[1];
                isAuthorized = StringUtils.isBlank((String)docFormKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof ProposalDevelopmentForm) ? false : BooleanUtils.toBoolean((String)((String)(editModes = ((ProposalDevelopmentForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))) || BooleanUtils.toBoolean((String)((String)editModes.get("modifyProposal"))));
            } else {
                this.LOG.info((Object)"dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }

    public Budget getFinalBudget(DevelopmentProposal proposal) {
        List budgetDocuments = proposal.getProposalDocument().getBudgetDocumentVersions();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Budget budget = null;
        if (budgetDocuments != null && budgetDocuments.size() > 0) {
            for (BudgetDocumentVersion budgetDocument : budgetDocuments) {
                fieldValues.clear();
                fieldValues.put("document_number", budgetDocument.getDocumentNumber());
                List budgets = (List)this.getBusinessObjectService().findMatching(Budget.class, fieldValues);
                budget = (Budget)budgets.get(0);
                if (!budget.getFinalVersionFlag().booleanValue()) continue;
                break;
            }
        }
        return budget;
    }

    public List<CoPiInfoDO> getCoPiPiInfo(DevelopmentProposal proposal) {
        List proposalPersons = proposal.getProposalPersons();
        ArrayList<CoPiInfoDO> coPiInfos = new ArrayList<CoPiInfoDO>();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            CoPiInfoDO coPiInfo = new CoPiInfoDO();
            coPiInfo.setCoPiUnit(proposalPerson.getHomeUnit());
            coPiInfo.setCoPiName(proposalPerson.getFullName());
            coPiInfos.add(coPiInfo);
        }
        return coPiInfos;
    }

    public List<CostShareInfoDO> getCostShareInfo(Budget budget) {
        List costShares = budget.getBudgetCostShares();
        ArrayList<CostShareInfoDO> costShareInfos = new ArrayList<CostShareInfoDO>();
        if (costShares != null && costShares.size() > 0) {
            for (BudgetCostShare costShare : costShares) {
                if ("3RD-PRTY".equals(costShare.getSourceUnit())) continue;
                CostShareInfoDO costShareInfo = new CostShareInfoDO();
                costShareInfo.setCostShareUnit(costShare.getSourceUnit());
                costShareInfo.setCostShareAmount(costShare.getShareAmount());
                costShareInfos.add(costShareInfo);
            }
        }
        return costShareInfos;
    }

    public InstitutionalProposal getInstitutionalProposal(String devProposalNumber) {
        Object instProposalId = null;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("devProposalNumber", devProposalNumber);
        Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, values);
        Iterator iter = proposalAdminDetails.iterator();
        if (iter.hasNext()) {
            ProposalAdminDetails pad = (ProposalAdminDetails)iter.next();
            pad.refreshReferenceObject("institutionalProposal");
            return pad.getInstitutionalProposal();
        }
        return null;
    }

    protected String populateBudgetEditableFieldMetaData(String documentNumber, String editableFieldDBColumn) {
        String returnValue = "";
        if (GlobalVariables.getMessageMap() != null) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
        Object fieldValue = this.getBudgetFieldValueFromDBColumnName(documentNumber, editableFieldDBColumn);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("columnName", editableFieldDBColumn);
        BudgetColumnsToAlter editableColumn = (BudgetColumnsToAlter)this.businessObjectService.findByPrimaryKey(BudgetColumnsToAlter.class, primaryKeys);
        returnValue = editableColumn.getHasLookup() ? this.getDataOverrideLookupDisplayReturnValue(editableColumn.getLookupClass()) + "," + editableColumn.getLookupReturn() + "," + this.getDataOverrideLookupDisplayDisplayValue(editableColumn.getLookupClass(), fieldValue != null ? fieldValue.toString() : "", editableColumn.getLookupReturn()) : (fieldValue != null && editableColumn.getDataType().equalsIgnoreCase("DATE") ? ",," + CoreApiServiceLocator.getDateTimeService().toString((Date)fieldValue, "MM/dd/yyyy") : (fieldValue != null ? ",," + fieldValue.toString() : ",,"));
        if (fieldValue instanceof Boolean) {
            editableColumn.setDataType("boolean");
        }
        returnValue = returnValue + "," + editableColumn.getDataType();
        returnValue = returnValue + "," + editableColumn.getHasLookup();
        returnValue = returnValue + "," + editableColumn.getLookupClass();
        return returnValue;
    }
}

