/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.kim.service.ProposalRoleService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalRoleTemplateService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalRoleTemplateServiceImpl
implements ProposalRoleTemplateService {
    private KraAuthorizationService kraAuthorizationService;
    private RoleService roleManagementService;
    private ProposalRoleService proposalRoleService;

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setProposalRoleService(ProposalRoleService proposalRoleService) {
        this.proposalRoleService = proposalRoleService;
    }

    public void addUsers(ProposalDevelopmentDocument doc) {
        String creatorUserId = this.getCreator(doc);
        HashMap<String, String> roleIdMap = new HashMap<String, String>();
        Role role = null;
        Collection proposalRoleTemplates = this.getRoleTemplates(doc.getDevelopmentProposal().getOwnedByUnitNumber());
        for (RoleMembership proposalRoleTemplate : proposalRoleTemplates) {
            String personId = proposalRoleTemplate.getMemberId();
            if (personId == null || StringUtils.equals((String)personId, (String)creatorUserId)) continue;
            if (StringUtils.isEmpty((String)((String)roleIdMap.get(proposalRoleTemplate.getRoleId())))) {
                role = this.roleManagementService.getRole(proposalRoleTemplate.getRoleId());
                roleIdMap.put(proposalRoleTemplate.getRoleId(), role.getName());
            }
            this.kraAuthorizationService.addRole(personId, (String)roleIdMap.get(proposalRoleTemplate.getRoleId()), (Permissionable)doc);
        }
    }

    public String getCreator(ProposalDevelopmentDocument doc) {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected Collection<RoleMembership> getRoleTemplates(String unitNumber) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", unitNumber);
        List proposalRoles = this.proposalRoleService.getRolesForDisplay();
        ArrayList<RoleMembership> membershipInfoList = new ArrayList<RoleMembership>();
        Collection memberIds = null;
        RoleMembership.Builder roleMembershipBuilder = null;
        for (Role role : proposalRoles) {
            memberIds = this.roleManagementService.getRoleMemberPrincipalIds(role.getNamespaceCode(), role.getName(), qualifiedRoleAttributes);
            if (!CollectionUtils.isNotEmpty((Collection)memberIds)) continue;
            for (String memberId : memberIds) {
                roleMembershipBuilder = RoleMembership.Builder.create((String)role.getId(), null, (String)memberId, (MemberType)MemberType.PRINCIPAL, null);
                membershipInfoList.add(roleMembershipBuilder.build());
            }
            roleMembershipBuilder = null;
            memberIds = null;
        }
        return membershipInfoList;
    }
}

