/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.SponsorFormTemplate;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewLinkEvent;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.common.web.struts.form.ReportHelperBean;
import org.kuali.kra.common.web.struts.form.ReportHelperBeanContainer;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.kim.service.KcGroupService;
import org.kuali.kra.printing.service.CurrentAndPendingReportService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalChangedData;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.bo.ProposalOverview;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetChangedData;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationContext;
import org.kuali.kra.proposaldevelopment.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.kra.proposaldevelopment.printing.service.ProposalDevelopmentPrintingService;
import org.kuali.kra.proposaldevelopment.rule.event.BudgetDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.rule.event.CopyProposalEvent;
import org.kuali.kra.proposaldevelopment.rule.event.ProposalDataOverrideEvent;
import org.kuali.kra.proposaldevelopment.rules.ProposalDevelopmentRejectionRule;
import org.kuali.kra.proposaldevelopment.service.ProposalCopyService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.ProposalStateService;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalDevelopmentRejectionBean;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentActionsAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.service.PrintService;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraPersistenceStructureService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.util.AutoPopulatingList;

public class ProposalDevelopmentActionsAction
extends ProposalDevelopmentAction
implements AuditModeAction {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentActionsAction.class);
    private static final String DOCUMENT_APPROVE_QUESTION = "DocApprove";
    private static final String DOCUMENT_ROUTE_QUESTION = "DocRoute";
    private static final String DOCUMENT_REJECT_QUESTION = "DocReject";
    private static final String DOCUMENT_DELETE_QUESTION = "ProposalDocDelete";
    private static final String CONFIRM_SUBMISSION_WITH_WARNINGS_KEY = "submitApplication";
    private static final String EMPTY_STRING = "";
    private static final String SUPER_USER_ACTION_REQUESTS = "superUserActionRequests";
    private static final int OK = 0;
    private static final int WARNING = 1;
    private static final int ERROR = 2;
    private static final String MAPPING_PROPOSAL = "proposal";
    private static final String ROUTING_WARNING_MESSAGE = "Validation Warning Exists.Are you sure want to submit to workflow routing.";
    private transient KraWorkflowService kraWorkflowService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!StringUtils.equals((String)((String)request.getAttribute("methodToCallAttribute")), (String)"methodToCall.route")) {
            // empty if block
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (!StringUtils.equals((String)((String)request.getAttribute("methodToCallAttribute")), (String)"methodToCall.reload")) {
            this.populateSponsorForms(form);
        }
        return actionForward;
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        WorkflowDocument workflowDoc = proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument();
        proposalDevelopmentForm.setAuditActivated(true);
        ActionForward forward = mapping.findForward("basic");
        boolean forwardToSubmitToSponsor = false;
        int status = this.isValidSubmission(proposalDevelopmentForm);
        if (status == 2) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            forward = mapping.findForward("basic");
        } else {
            forward = this.canGenerateRequestsInFuture(workflowDoc, GlobalVariables.getUserSession().getPrincipalId()) ? this.promptUserForInput(workflowDoc, "approve", mapping, form, request, response) : super.approve(mapping, form, request, response);
            if (proposalDevelopmentForm.getEditingMode().containsKey("submitToSponsor") && this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "autoSubmitToSponsorOnFinalApproval").booleanValue() && this.getKraWorkflowService().isFinalApproval(workflowDoc)) {
                forwardToSubmitToSponsor = true;
            }
            ProposalDevelopmentDocument proposalDevelopmentDocument = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument();
            if (this.autogenerateInstitutionalProposal() && proposalDevelopmentDocument.getInstitutionalProposalNumber() != null) {
                if ("5".equals(proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode())) {
                    KNSGlobalVariables.getMessageList().add("message.institutionalproposal.versioned", new String[]{proposalDevelopmentDocument.getInstitutionalProposalNumber()});
                } else {
                    String proposalNumber = proposalDevelopmentDocument.getInstitutionalProposalNumber();
                    KNSGlobalVariables.getMessageList().add("message.institutionalproposal.created", new String[]{proposalNumber});
                }
            }
        }
        ArrayList<ActionForward> acceptedForwards = new ArrayList<ActionForward>();
        String routeHeaderId = ((ProposalDevelopmentForm)form).getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "actions", "ProposalDevelopmentDocument");
        if (forwardToSubmitToSponsor) {
            returnLocation = returnLocation.replace("proposalDevelopmentProposal", "proposalDevelopmentActions");
            returnLocation = returnLocation.replace("docHandler", "autoSubmitToSponsor");
            String workflowBase = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            String actionListUrl = workflowBase + "/ActionList.do";
            acceptedForwards.add(new ActionForward(actionListUrl, true));
        }
        acceptedForwards.add(mapping.findForward("portal"));
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(acceptedForwards, forward, holdingPageForward, returnLocation);
    }

    private ActionForward promptUserForInput(WorkflowDocument workflowDoc, String action, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (!DOCUMENT_APPROVE_QUESTION.equals(question)) {
            return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_APPROVE_QUESTION, KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("document.question.approve.text"), "confirmationQuestion", methodToCall, EMPTY_STRING);
        }
        if (DOCUMENT_APPROVE_QUESTION.equals(question) && "1".equals(buttonClicked)) {
            workflowDoc.setDoNotReceiveFutureRequests();
        } else if (DOCUMENT_APPROVE_QUESTION.equals(question)) {
            workflowDoc.setReceiveFutureRequests();
        }
        if (StringUtils.equals((String)action, (String)"approve")) {
            return super.approve(mapping, form, request, response);
        }
        if (StringUtils.equals((String)action, (String)"route")) {
            return super.route(mapping, form, request, response);
        }
        throw new UnsupportedOperationException(String.format("promptUserForInput does not know how to forward for action %s.", action));
    }

    private boolean canGenerateRequestsInFuture(WorkflowDocument workflowDoc, String principalId) throws Exception {
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(principalId));
        WorkflowDocumentService workflowDocumentService = (WorkflowDocumentService)KRADServiceLocatorWeb.getService((String)"workflowDocumentService");
        String currentRouteNodeNames = workflowDocumentService.getCurrentRouteNodeNames(workflowDoc);
        return this.hasAskedToNotReceiveFutureRequests(workflowDoc, principalId) && this.canGenerateMultipleApprovalRequests(reportCriteriaBuilder.build(), principalId, currentRouteNodeNames);
    }

    private boolean hasAskedToNotReceiveFutureRequests(WorkflowDocument workflowDoc, String principalId) {
        boolean receiveFutureRequests = false;
        boolean doNotReceiveFutureRequests = false;
        Map variables = workflowDoc.getVariables();
        if (variables != null && CollectionUtils.isNotEmpty(variables.keySet())) {
            for (String variableKey : variables.keySet()) {
                String variableValue = (String)variables.get(variableKey);
                if (variableKey.startsWith("_receive_future_requests") && variableValue.toUpperCase().equals("YES") && variableKey.contains(principalId)) {
                    receiveFutureRequests = true;
                    break;
                }
                if (!variableKey.startsWith("_receive_future_requests") || !variableValue.toUpperCase().equals("NO") || !variableKey.contains(principalId)) continue;
                doNotReceiveFutureRequests = true;
                break;
            }
        }
        return !receiveFutureRequests && !doNotReceiveFutureRequests;
    }

    private boolean canGenerateMultipleApprovalRequests(RoutingReportCriteria reportCriteria, String loggedInPrincipalId, String currentRouteNodeNames) throws Exception {
        int approvalRequestsCount = 0;
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        DocumentDetail results1 = info.executeSimulation(reportCriteria);
        for (ActionRequest actionRequest : results1.getActionRequests()) {
            if (!actionRequest.isPending() || !actionRequest.getActionRequested().getCode().equalsIgnoreCase("A") || !this.recipientMatchesUser(actionRequest, loggedInPrincipalId) || StringUtils.contains((String)currentRouteNodeNames, (String)actionRequest.getNodeName())) continue;
            ++approvalRequestsCount;
        }
        return approvalRequestsCount > 0;
    }

    private boolean recipientMatchesUser(ActionRequest actionRequest, String loggedInPrincipalId) {
        KcGroupService groupService = (KcGroupService)KraServiceLocator.getService(KcGroupService.class);
        if (actionRequest != null && loggedInPrincipalId != null) {
            List actionRequests = Collections.singletonList(actionRequest);
            if (actionRequest.isRoleRequest()) {
                actionRequests = actionRequest.getChildRequests();
            }
            for (ActionRequest cActionRequest : actionRequests) {
                String recipientUser = cActionRequest.getPrincipalId();
                if ((recipientUser == null || !recipientUser.equals(loggedInPrincipalId)) && (!StringUtils.isNotBlank((String)cActionRequest.getGroupId()) || !groupService.isMemberOfGroup(loggedInPrincipalId, cActionRequest.getGroupId()))) continue;
                return true;
            }
        }
        return false;
    }

    public ActionForward addProposalChangedData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        KraPersistenceStructureService kraPersistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        ActionForward forward = mapping.findForward("basic");
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDocument = pdForm.getProposalDevelopmentDocument();
        ProposalChangedData newProposalChangedData = pdForm.getNewProposalChangedData();
        newProposalChangedData.setProposalNumber(pdDocument.getDevelopmentProposal().getProposalNumber());
        newProposalChangedData.setChangeNumber(Integer.valueOf(this.getNextChangeNumber(boService, newProposalChangedData.getProposalNumber(), newProposalChangedData.getColumnName())));
        if (StringUtils.isEmpty((String)newProposalChangedData.getDisplayValue()) && StringUtils.isNotEmpty((String)newProposalChangedData.getChangedValue())) {
            newProposalChangedData.setDisplayValue(newProposalChangedData.getChangedValue());
        }
        String tmpLookupReturnPk = EMPTY_STRING;
        if (newProposalChangedData.getEditableColumn() != null) {
            tmpLookupReturnPk = newProposalChangedData.getEditableColumn().getLookupPkReturn();
        }
        newProposalChangedData.refreshReferenceObject("editableColumn");
        newProposalChangedData.getEditableColumn().setLookupPkReturn(tmpLookupReturnPk);
        if (newProposalChangedData.getEditableColumn() != null && !newProposalChangedData.getEditableColumn().getHasLookup()) {
            newProposalChangedData.setDisplayValue(newProposalChangedData.getChangedValue());
        }
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new ProposalDataOverrideEvent(pdForm.getProposalDevelopmentDocument(), newProposalChangedData))) {
            boService.save((PersistableBusinessObject)newProposalChangedData);
            ProposalOverview proposalWrapper = this.createProposalWrapper(pdDocument);
            Map columnToAttributesMap = kraPersistenceStructureService.getDBColumnToObjectAttributeMap(ProposalOverview.class);
            String proposalAttributeToPersist = (String)columnToAttributesMap.get(newProposalChangedData.getColumnName());
            ObjectUtils.setObjectProperty((Object)proposalWrapper, (String)proposalAttributeToPersist, (Object)newProposalChangedData.getChangedValue());
            ObjectUtils.setObjectProperty((Object)pdDocument.getDevelopmentProposal(), (String)proposalAttributeToPersist, (Object)newProposalChangedData.getChangedValue());
            boService.save((PersistableBusinessObject)proposalWrapper);
            pdForm.getProposalDevelopmentDocument().setVersionNumber(proposalWrapper.getVersionNumber());
            pdForm.setNewProposalChangedData(new ProposalChangedData());
            this.growProposalChangedHistory(pdDocument, newProposalChangedData);
            ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(pdDocument.getDevelopmentProposal(), "103", "Proposal Data Override");
            ((ProposalDevelopmentNotificationRenderer)context.getRenderer()).setProposalChangedData(newProposalChangedData);
            if (pdForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
                pdForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                forward = mapping.findForward("notificationEditor");
            } else {
                this.getNotificationService().sendNotification((NotificationContext)context);
            }
        }
        return forward;
    }

    private void growProposalChangedHistory(ProposalDevelopmentDocument pdDocument, ProposalChangedData newProposalChangedData) {
        Map changeHistory = pdDocument.getDevelopmentProposal().getProposalChangeHistory();
        if (changeHistory.get(newProposalChangedData.getEditableColumn().getColumnLabel()) == null) {
            changeHistory.put(newProposalChangedData.getEditableColumn().getColumnLabel(), new ArrayList());
        }
        ((List)changeHistory.get(newProposalChangedData.getEditableColumn().getColumnLabel())).add(0, newProposalChangedData);
    }

    private ProposalOverview createProposalWrapper(ProposalDevelopmentDocument pdDocument) throws Exception {
        ProposalOverview proposalWrapper = new ProposalOverview();
        PersistenceStructureService persistentStructureService = (PersistenceStructureService)KraServiceLocator.getService(PersistenceStructureService.class);
        List fieldsToUpdate = persistentStructureService.listFieldNames(ProposalOverview.class);
        for (String field : fieldsToUpdate) {
            boolean noSuchFieldPD = false;
            boolean noSuchFieldBO = false;
            Object tempVal = null;
            try {
                tempVal = ObjectUtils.getPropertyValue((Object)pdDocument, (String)field);
            }
            catch (Exception e) {
                noSuchFieldPD = true;
            }
            try {
                tempVal = ObjectUtils.getPropertyValue((Object)pdDocument.getDevelopmentProposal(), (String)field);
            }
            catch (Exception e) {
                noSuchFieldBO = true;
            }
            if (tempVal == null && noSuchFieldPD && noSuchFieldBO) {
                LOG.warn((Object)("Could not find property " + field + " in ProposalDevelopmentDocument or DevelopmnentProposal bo."));
            }
            ObjectUtils.setObjectProperty((Object)proposalWrapper, (String)field, (Object)(tempVal != null ? tempVal : null));
        }
        return proposalWrapper;
    }

    private int getNextChangeNumber(BusinessObjectService boService, String proposalNumber, String columnName) {
        int changeNumber = 0;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("proposalNumber", proposalNumber);
        keyMap.put("columnName", columnName);
        List changedDataList = (List)boService.findMatchingOrderBy(ProposalChangedData.class, keyMap, "changeNumber", true);
        if (CollectionUtils.isNotEmpty((Collection)changedDataList)) {
            changeNumber = ((ProposalChangedData)changedDataList.get(changedDataList.size() - 1)).getChangeNumber();
        }
        return ++changeNumber;
    }

    public ActionForward copyProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward nextWebPage = null;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalCopyCriteria criteria = proposalDevelopmentForm.getCopyCriteria();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new CopyProposalEvent(doc, criteria));
        if (!rulePassed) {
            nextWebPage = mapping.findForward("basic");
        } else {
            ProposalCopyService proposalCopyService = (ProposalCopyService)KraServiceLocator.getService((String)"proposalCopyService");
            KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
            if (proposalCopyService == null) {
                nextWebPage = mapping.findForward("basic");
            } else {
                String newDocId = proposalCopyService.copyProposal(doc, criteria);
                ((PessimisticLockService)KraServiceLocator.getService(PessimisticLockService.class)).releaseAllLocksForUser(doc.getPessimisticLocks(), GlobalVariables.getUserSession().getPerson());
                proposalDevelopmentForm.setDocId(newDocId);
                this.loadDocument((KualiDocumentFormBase)proposalDevelopmentForm);
                ProposalDevelopmentDocument copiedDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
                this.initializeProposalUsers(copiedDocument);
                copiedDocument.getDevelopmentProposal().setS2sAppSubmission(new ArrayList());
                DocumentService docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
                docService.saveDocument((Document)copiedDocument);
                kraAuthService.forceFlushRoleCaches();
                nextWebPage = mapping.findForward(MAPPING_PROPOSAL);
                proposalDevelopmentForm.clearDocumentRelatedState();
                proposalDevelopmentForm.setViewOnly(false);
            }
        }
        return nextWebPage;
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.setUnitRulesMessages(this.getUnitRulesMessages(proposalDevelopmentForm.getProposalDevelopmentDocument()));
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((ProposalDevelopmentForm)form), true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentForm)form).clearUnitRulesMessages();
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((ProposalDevelopmentForm)form), false);
    }

    public ActionForward reject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        ((ProposalDevelopmentForm)form).setShowRejectionConfirmation(true);
        return mapping.findForward("basic");
    }

    public ActionForward rejectNo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentForm)form).setShowRejectionConfirmation(false);
        ((ProposalDevelopmentForm)form).setProposalDevelopmentRejectionBean(new ProposalDevelopmentRejectionBean());
        return mapping.findForward("basic");
    }

    public ActionForward rejectYes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        ProposalDevelopmentDocument pDoc = (ProposalDevelopmentDocument)kualiDocumentFormBase.getDocument();
        ProposalDevelopmentRejectionBean bean = ((ProposalDevelopmentForm)form).getProposalDevelopmentRejectionBean();
        if (new ProposalDevelopmentRejectionRule().proccessProposalDevelopmentRejection(bean)) {
            ProposalHierarchyService phService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
            phService.rejectProposalDevelopmentDocument(pDoc.getDevelopmentProposal().getProposalNumber(), bean.getRejectReason(), GlobalVariables.getUserSession().getPrincipalId(), bean.getRejectFile());
            ((ProposalDevelopmentForm)form).setShowRejectionConfirmation(false);
            return super.returnToSender(request, mapping, kualiDocumentFormBase);
        }
        return mapping.findForward("basic");
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        proposalDevelopmentForm.setAuditActivated(true);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        ActionForward forward = mapping.findForward("basic");
        int status = this.isValidSubmission(proposalDevelopmentForm);
        boolean userSaysOk = false;
        if (status == 1) {
            if (status == 1 && question == null) {
                forward = this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, ROUTING_WARNING_MESSAGE, "confirmationQuestion", methodToCall, EMPTY_STRING);
            } else if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                userSaysOk = true;
            } else if (DOCUMENT_APPROVE_QUESTION.equals(question)) {
                userSaysOk = true;
            }
        }
        if (status == 0 || userSaysOk) {
            WorkflowDocument workflowDoc = proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument();
            forward = this.canGenerateRequestsInFuture(workflowDoc, GlobalVariables.getUserSession().getPrincipalId()) ? this.promptUserForInput(workflowDoc, "route", mapping, form, request, response) : super.route(mapping, (ActionForm)proposalDevelopmentForm, request, response);
        } else if (status != 1) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            if (pdDoc.getDevelopmentProposal().getContinuedFrom() != null && this.isNewProposalType(pdDoc) && this.isSubmissionApplication(pdDoc)) {
                GlobalVariables.getMessageMap().putError("someKey", "error.resubmission.invalidProposalTypeSubmissionType", new String[0]);
            }
            forward = mapping.findForward("basic");
        }
        String routeHeaderId = proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "actions", "ProposalDevelopmentDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    public ActionForward autoSubmitToSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (proposalDevelopmentForm.getProposalDevelopmentDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, proposalDevelopmentForm);
            this.loadDocument(proposalDevelopmentForm.getProposalDevelopmentDocument());
        }
        return this.submitToSponsor(mapping, form, request, response);
    }

    public ActionForward submitToSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (!this.userCanCreateInstitutionalProposal()) {
            return mapping.findForward("basic");
        }
        proposalDevelopmentForm.setAuditActivated(true);
        ActionForward forward = mapping.findForward("basic");
        int status = this.isValidSubmission(proposalDevelopmentForm);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        if ((question == null || buttonClicked == null) && status == 1 && proposalDevelopmentForm.getResubmissionOption() == null) {
            StrutsConfirmation qst = this.buildSubmitToGrantsGovWithWarningsQuestion(mapping, form, request, response);
            forward = this.confirm(qst, CONFIRM_SUBMISSION_WITH_WARNINGS_KEY, EMPTY_STRING);
            proposalDevelopmentForm.setResubmissionOption(null);
            proposalDevelopmentForm.setInstitutionalProposalToVersion(null);
        } else if (!"1".equals(buttonClicked)) {
            if (("0".equals(buttonClicked) || status == 0) && this.requiresResubmissionPrompt(proposalDevelopmentForm)) {
                return mapping.findForward("resubmissionPrompt");
            }
            forward = this.submitApplication(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward submitToGrantsGov(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentService proposalDevelopmentService;
        InstitutionalProposal institutionalProposal;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ActionForward forward = mapping.findForward("basic");
        proposalDevelopmentForm.setGrantsGovSubmitFlag(true);
        if (!proposalDevelopmentDocument.getDevelopmentProposal().getSubmitFlag().booleanValue()) {
            forward = this.submitToSponsor(mapping, form, request, response);
        }
        if ((institutionalProposal = (proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class)).getInstitutionalProposal(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber())) != null) {
            try {
                this.submitS2sApplication(proposalDevelopmentDocument);
                proposalDevelopmentForm.setShowSubmissionDetails(true);
                if (proposalDevelopmentDocument.getDevelopmentProposal().getSubmitFlag().booleanValue()) {
                    forward = mapping.findForward("grantsGov");
                }
            }
            catch (S2SException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                KNSGlobalVariables.getMessageList().add((Object)new ErrorMessage("error.on.grantsGov.submission", new String[0]));
                return mapping.findForward("basic");
            }
        }
        return forward;
    }

    private boolean requiresResubmissionPrompt(ProposalDevelopmentForm proposalDevelopmentForm) {
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        return ("2".equals(developmentProposal.getProposalTypeCode()) || "4".equals(developmentProposal.getProposalTypeCode()) || "5".equals(developmentProposal.getProposalTypeCode()) || this.isSubmissionChangeCorrected(developmentProposal)) && proposalDevelopmentForm.getResubmissionOption() == null;
    }

    private boolean isSubmissionChangeCorrected(DevelopmentProposal developmentProposal) {
        if (developmentProposal.getS2sOpportunity() != null) {
            return "3".equals(developmentProposal.getS2sOpportunity().getS2sSubmissionTypeCode());
        }
        return false;
    }

    private int isValidSubmission(ProposalDevelopmentForm proposalDevelopmentForm) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        int state = 0;
        if (!proposalDevelopmentForm.isUnitRulesErrorsExist() && proposalDevelopmentForm.isAuditActivated()) {
            proposalDevelopmentForm.setUnitRulesMessages(this.getUnitRulesMessages(proposalDevelopmentForm.getProposalDevelopmentDocument()));
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom() != null && this.isNewProposalType(proposalDevelopmentDocument) && this.isSubmissionApplication(proposalDevelopmentDocument)) {
            state = 2;
        } else if (proposalDevelopmentForm.isUnitRulesErrorsExist()) {
            state = 2;
        } else {
            boolean auditPassed = new AuditActionHelper().auditUnconditionally((Document)proposalDevelopmentDocument);
            boolean s2sPassed = true;
            if (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null) {
                S2SService s2sService = (S2SService)KraServiceLocator.getService(S2SService.class);
                try {
                    s2sPassed = s2sService.validateApplication(proposalDevelopmentDocument);
                }
                catch (S2SException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    s2sPassed = false;
                }
            }
            if (!auditPassed || !s2sPassed) {
                state = 1;
                Iterator iter = KNSGlobalVariables.getAuditErrorMap().keySet().iterator();
                while (iter.hasNext()) {
                    AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(iter.next());
                    if (StringUtils.equalsIgnoreCase((String)auditCluster.getCategory(), (String)"Warnings")) continue;
                    state = 2;
                    GlobalVariables.getMessageMap().putError("noKey", "validation.errors.before.grantsGov.submission", new String[0]);
                    break;
                }
            }
        }
        return state;
    }

    private PermissionService getPermissionService() {
        return KimApiServiceLocator.getPermissionService();
    }

    private boolean userCanCreateInstitutionalProposal() {
        boolean hasPermission = true;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "InstitutionalProposalDocument");
        if (!this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-IP", "Create Institutional Proposal")) {
            hasPermission = false;
            GlobalVariables.getMessageMap().putError("emptyProp", "error.proposalDevelopment.permission.submitToSponsor", new String[]{GlobalVariables.getUserSession().getPrincipalName(), "Create Institutional Proposal"});
        }
        if (!this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-IP", "Submit Institutional Proposal")) {
            hasPermission = false;
            GlobalVariables.getMessageMap().putError("emptyProp", "error.proposalDevelopment.permission.submitToSponsor", new String[]{GlobalVariables.getUserSession().getPrincipalName(), "Submit Institutional Proposal"});
        }
        return hasPermission;
    }

    private boolean isNewProposalType(ProposalDevelopmentDocument doc) {
        String newProposalTypeValue = this.getProposalParameterValue("proposaldevelopment.proposaltype.new");
        return StringUtils.equalsIgnoreCase((String)doc.getDevelopmentProposal().getProposalTypeCode(), (String)newProposalTypeValue);
    }

    private boolean isSubmissionApplication(ProposalDevelopmentDocument doc) {
        if (doc.getDevelopmentProposal().getS2sOpportunity() != null) {
            String applicationSubmissionValue = this.getProposalParameterValue("s2s.submissiontype.application");
            return StringUtils.equalsIgnoreCase((String)doc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode(), (String)applicationSubmissionValue);
        }
        return false;
    }

    private String getProposalParameterValue(String parameterName) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, parameterName);
    }

    public ActionForward submitApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ActionForward forward = mapping.findForward("basic");
        boolean isIPProtocolLinkingEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.institute.proposal.linking.enabled");
        List specialReviews = proposalDevelopmentDocument.getDevelopmentProposal().getPropSpecialReviews();
        if (!isIPProtocolLinkingEnabled || this.applyRules((KualiDocumentEvent)new SaveSpecialReviewLinkEvent((Document)proposalDevelopmentDocument, specialReviews))) {
            if (!this.autogenerateInstitutionalProposal() || !"X".equals(proposalDevelopmentForm.getResubmissionOption())) {
                proposalDevelopmentDocument.getDevelopmentProposal().setSubmitFlag(Boolean.valueOf(true));
                ProposalStateService proposalStateService = (ProposalStateService)KraServiceLocator.getService(ProposalStateService.class);
                if ("13".equals(proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode())) {
                    proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("6");
                } else {
                    proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode(proposalStateService.getProposalStateTypeCode(proposalDevelopmentDocument, false, false));
                }
            } else if (proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("13");
            } else {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode("2");
            }
            String pCode = proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode();
            DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
            documentService.saveDocument((Document)proposalDevelopmentDocument);
            if (!StringUtils.equals((String)pCode, (String)proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode())) {
                proposalDevelopmentDocument.getDevelopmentProposal().setProposalStateTypeCode(pCode);
                proposalDevelopmentDocument.getDevelopmentProposal().refresh();
                ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).save((PersistableBusinessObject)proposalDevelopmentDocument.getDevelopmentProposal());
            }
            if (this.autogenerateInstitutionalProposal()) {
                this.generateInstitutionalProposal(proposalDevelopmentForm, isIPProtocolLinkingEnabled);
                ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(proposalDevelopmentDocument.getDevelopmentProposal(), "101", "Proposal Submitted");
                if (proposalDevelopmentForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
                    proposalDevelopmentForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotification((NotificationContext)context);
                }
            }
        }
        return forward;
    }

    private void generateInstitutionalProposal(ProposalDevelopmentForm proposalDevelopmentForm, boolean isIPProtocolLinkingEnabled) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if ("X".equals(proposalDevelopmentForm.getResubmissionOption())) {
            if (proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
                KNSGlobalVariables.getMessageList().add("message.institutionalproposal.not.created", new String[0]);
            } else {
                KNSGlobalVariables.getMessageList().add("message.institutionalproposal.not.created.inroute", new String[0]);
            }
            return;
        }
        if ("O".equals(proposalDevelopmentForm.getResubmissionOption())) {
            proposalDevelopmentForm.setInstitutionalProposalToVersion(proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom());
        }
        if ("O".equals(proposalDevelopmentForm.getResubmissionOption()) || "A".equals(proposalDevelopmentForm.getResubmissionOption())) {
            String versionNumber = this.createInstitutionalProposalVersion(proposalDevelopmentForm.getInstitutionalProposalToVersion(), proposalDevelopmentDocument.getDevelopmentProposal(), proposalDevelopmentDocument.getFinalBudgetForThisProposal());
            KNSGlobalVariables.getMessageList().add("message.institutionalproposal.versioned", new String[]{versionNumber, proposalDevelopmentForm.getInstitutionalProposalToVersion()});
            Long institutionalProposalId = this.getActiveProposalId(proposalDevelopmentForm.getInstitutionalProposalToVersion());
            this.persistProposalAdminDetails(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber(), institutionalProposalId);
            this.persistSpecialReviewProtocolFundingSourceLink(institutionalProposalId, isIPProtocolLinkingEnabled);
        } else {
            String proposalNumber = this.createInstitutionalProposal(proposalDevelopmentDocument.getDevelopmentProposal(), proposalDevelopmentDocument.getFinalBudgetForThisProposal());
            KNSGlobalVariables.getMessageList().add("message.institutionalproposal.created", new String[]{proposalNumber});
            Long institutionalProposalId = this.getActiveProposalId(proposalNumber);
            this.persistProposalAdminDetails(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber(), institutionalProposalId);
            this.persistSpecialReviewProtocolFundingSourceLink(institutionalProposalId, isIPProtocolLinkingEnabled);
        }
    }

    private Long getActiveProposalId(String proposalNumber) {
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        Collection ips = service.findMatching(InstitutionalProposal.class, this.getFieldValues(proposalNumber, "proposalNumber"));
        Long proposalId = ((InstitutionalProposal)ips.toArray()[0]).getProposalId();
        return proposalId;
    }

    private Long findInstProposalNumber(String devProposalNumber) {
        Long instProposalId;
        block0: {
            instProposalId = null;
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            Collection proposalAdminDetails = businessObjectService.findMatching(ProposalAdminDetails.class, this.getFieldValues(devProposalNumber, "devProposalNumber"));
            Iterator iter = proposalAdminDetails.iterator();
            if (!iter.hasNext()) break block0;
            ProposalAdminDetails pad = (ProposalAdminDetails)iter.next();
            instProposalId = pad.getInstProposalId();
        }
        return instProposalId;
    }

    private Map<String, String> getFieldValues(String value, String fieldName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(fieldName, value);
        return map;
    }

    private void persistProposalAdminDetails(String devProposalNumber, Long instProposalId) {
        ProposalAdminDetails proposalAdminDetails = new ProposalAdminDetails();
        proposalAdminDetails.setDevProposalNumber(devProposalNumber);
        proposalAdminDetails.setInstProposalId(instProposalId);
        String loggedInUser = GlobalVariables.getUserSession().getPrincipalName();
        proposalAdminDetails.setSignedBy(loggedInUser);
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        businessObjectService.save((PersistableBusinessObject)proposalAdminDetails);
    }

    private void persistSpecialReviewProtocolFundingSourceLink(Long institutionalProposalId, boolean isIPProtocolLinkingEnabled) {
        if (isIPProtocolLinkingEnabled) {
            SpecialReviewService specialReviewService = (SpecialReviewService)KraServiceLocator.getService(SpecialReviewService.class);
            InstitutionalProposal institutionalProposal = (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)institutionalProposalId);
            for (InstitutionalProposalSpecialReview specialReview : institutionalProposal.getSpecialReviews()) {
                String fundingSourceTypeCode;
                String fundingSourceNumber;
                String protocolNumber;
                if (!"1".equals(specialReview.getSpecialReviewTypeCode()) || specialReviewService.isLinkedToProtocolFundingSource(protocolNumber = specialReview.getProtocolNumber(), fundingSourceNumber = institutionalProposal.getProposalNumber(), fundingSourceTypeCode = "5")) continue;
                String fundingSourceName = institutionalProposal.getSponsorName();
                String fundingSourceTitle = institutionalProposal.getTitle();
                specialReviewService.addProtocolFundingSourceForSpecialReview(protocolNumber, fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
            }
        }
    }

    private void submitS2sApplication(ProposalDevelopmentDocument proposalDevelopmentDocument) throws Exception {
        S2SService s2sService = (S2SService)KraServiceLocator.getService(S2SService.class);
        s2sService.submitApplication(proposalDevelopmentDocument);
    }

    private StrutsConfirmation buildSubmitToGrantsGovWithWarningsQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SUBMISSION_WITH_WARNINGS_KEY, "question.submitOpportunityWithWarnings.text", new String[0]);
    }

    private String createInstitutionalProposal(DevelopmentProposal developmentProposal, Budget budget) {
        InstitutionalProposalService institutionalProposalService = (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
        String proposalNumber = institutionalProposalService.createInstitutionalProposal(developmentProposal, budget);
        return proposalNumber;
    }

    private String createInstitutionalProposalVersion(String proposalNumber, DevelopmentProposal developmentProposal, Budget budget) {
        InstitutionalProposalService institutionalProposalService = (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
        String versionNumber = institutionalProposalService.createInstitutionalProposalVersion(proposalNumber, developmentProposal, budget);
        return versionNumber;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        this.populateSponsorForms(form);
        return forward;
    }

    public void populateSponsorForms(ActionForm form) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalDevelopmentPrintingService printService = (ProposalDevelopmentPrintingService)KraServiceLocator.getService(ProposalDevelopmentPrintingService.class);
        printService.populateSponsorForms(proposalDevelopmentForm.getSponsorFormTemplates(), proposalDevelopmentDocument.getDevelopmentProposal().getSponsorCode());
    }

    public ActionForward printSponsorForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ActionForward actionForward = mapping.findForward("basic");
        String proposalNumber = proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber();
        List sponsorFormTemplateLists = proposalDevelopmentForm.getSponsorFormTemplates();
        ProposalDevelopmentPrintingService printService = (ProposalDevelopmentPrintingService)KraServiceLocator.getService(ProposalDevelopmentPrintingService.class);
        List printFormTemplates = new ArrayList();
        printFormTemplates = printService.getSponsorFormTemplates(sponsorFormTemplateLists);
        HashMap reportParameters = new HashMap();
        reportParameters.put("Selected Templates", printFormTemplates);
        try {
            AttachmentDataSource dataStream = printService.printProposalDevelopmentReport((KraPersistableBusinessObjectBase)proposalDevelopmentDocument.getDevelopmentProposal(), "Print Proposal Sponsor Forms", reportParameters);
            this.streamToResponse(dataStream, response);
            return null;
        }
        catch (NullPointerException npe) {
            LOG.error((Object)"Error generating print stream for proposal forms", (Throwable)npe);
            GlobalVariables.getMessageMap().putError("print.nofield", "error.printing.unknown", new String[0]);
            return mapping.findForward("basic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamToResponse(List<SponsorFormTemplate> printFormTemplates, String proposalNumber, String contentType, String ReportName, HttpServletResponse response) throws Exception {
        byte[] sftByteStream = ((PrintService)KraServiceLocator.getService(PrintService.class)).printProposalSponsorForms(proposalNumber, printFormTemplates);
        if (sftByteStream == null) {
            return;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(sftByteStream.length);
            baos.write(sftByteStream);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)contentType, (ByteArrayOutputStream)baos, (String)ReportName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
        }
    }

    public ActionForward printForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.printForms(mapping, form, request, response);
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetPersonnel.do?auditActivated=true&");
        return new ActionForward(forward, true);
    }

    public ActionForward budgetDistributionAndIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetDistributionAndIncome.do?auditActivated=true&");
        return new ActionForward(forward, true);
    }

    public ActionForward parameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetParameters.do?auditActivated=true&");
        return new ActionForward(forward, true);
    }

    public ActionForward resubmit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("resubmit");
    }

    public ActionForward budgetExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        String activePanelName = (String)request.getAttribute("activePanelName");
        String viewBudgetPeriodParam = null;
        if (StringUtils.isNotBlank((String)methodToCallAttribute)) {
            int idx = methodToCallAttribute.indexOf("&viewBudgetPeriod=");
            if (idx > 0) {
                viewBudgetPeriodParam = "viewBudgetPeriod=" + methodToCallAttribute.substring(methodToCallAttribute.indexOf("=", idx) + 1, methodToCallAttribute.indexOf(".", idx)) + "&";
            }
            if ((idx = methodToCallAttribute.indexOf("&activePanelName=")) > 0) {
                activePanelName = methodToCallAttribute.substring(methodToCallAttribute.indexOf("=", idx) + 1, methodToCallAttribute.indexOf(".", idx));
            }
        }
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetExpenses.do?auditActivated=true&");
        if (viewBudgetPeriodParam != null) {
            forward = StringUtils.replace((String)forward, (String)"budgetExpenses.do?", (String)("budgetExpenses.do?" + viewBudgetPeriodParam));
        }
        if (StringUtils.isNotBlank((String)activePanelName) && "Personnel".equals(activePanelName)) {
            forward = StringUtils.replace((String)forward, (String)"budgetExpenses.do?", (String)("budgetPersonnel.do?activePanelName=" + activePanelName + "&"));
        }
        return new ActionForward(forward, true);
    }

    public ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetParameters.do?auditActivated=true&");
        return new ActionForward(forward, true);
    }

    public ActionForward budgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = this.getForwardToBudgetUrl(form);
        forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)("budgetRates.do?auditActivated=true&anchor=" + ((KualiForm)form).getAnchor() + "&"));
        return new ActionForward(forward, true);
    }

    public ActionForward saveProposalActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.save(mapping, form, request, response);
    }

    private String getForwardToBudgetUrl(ActionForm form) {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        BudgetDocument budgetDocument = null;
        String forward = null;
        try {
            for (BudgetDocumentVersion budgetDocumentVersion : pdDoc.getBudgetDocumentVersions()) {
                BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
                if (!budgetVersion.isFinalVersionFlag()) continue;
                DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
                budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetVersion.getDocumentNumber());
            }
            String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
            forward = this.buildForwardUrl(routeHeaderId);
        }
        catch (Exception e) {
            LOG.info((Object)("forward to budgetsummary " + e.getStackTrace()));
        }
        return forward;
    }

    public ActionForward linkChildToHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal hierarchyProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        DevelopmentProposal newChildProposal = this.getHierarchyHelper().getDevelopmentProposal(pdForm.getNewHierarchyChildProposalNumber());
        String hierarchyBudgetTypeCode = pdForm.getNewHierarchyBudgetTypeCode();
        if (newChildProposal == null) {
            GlobalVariables.getMessageMap().putError("newHierarchyChildProposalNumber", "error.required", new String[]{"Link Child Proposal"});
        } else {
            this.getHierarchyHelper().linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode);
            pdForm.setNewHierarchyChildProposalNumber(EMPTY_STRING);
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncAllHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        this.getHierarchyHelper().syncAllHierarchy(pdForm.getProposalDevelopmentDocument());
        if (GlobalVariables.getMessageMap().containsMessageKey("question.hierarchy.extendDate.confirm")) {
            return this.doEndDateConfirmation(mapping, form, request, response, "syncAllHierarchy", "syncAllHierarchyConfirm");
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncAllHierarchyConfirm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        this.getHierarchyHelper().syncAllHierarchy(pdForm.getProposalDevelopmentDocument(), true);
        return mapping.findForward("basic");
    }

    public ActionForward removeFromHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "removeFromHierarchy", "question.hierarchy.remove.confirm", new String[0]);
        return this.confirm(question, "removeFromHierarchyConfirmed", "hierarchyActionCanceled");
    }

    public ActionForward removeFromHierarchyConfirmed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal childProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        this.getHierarchyHelper().removeFromHierarchy(childProposal);
        return mapping.findForward("basic");
    }

    public ActionForward hierarchyActionCanceled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KNSGlobalVariables.getMessageList().add("message.hierarchy.action.cancel", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward syncToHierarchyParent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal childProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        this.getHierarchyHelper().syncToHierarchyParent(childProposal);
        if (GlobalVariables.getMessageMap().containsMessageKey("question.hierarchy.extendDate.confirm")) {
            return this.doEndDateConfirmation(mapping, form, request, response, "syncToHierarchyParent", "syncToHierarchyParentConfirm");
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncToHierarchyParentConfirm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal childProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        this.getHierarchyHelper().syncToHierarchyParent(childProposal, true);
        return mapping.findForward("basic");
    }

    public ActionForward createHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal initialChildProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        this.getHierarchyHelper().createHierarchy(initialChildProposal);
        return mapping.findForward("basic");
    }

    public ActionForward linkToHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal hierarchyProposal = this.getHierarchyHelper().getDevelopmentProposal(pdForm.getNewHierarchyProposalNumber());
        DevelopmentProposal newChildProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        String hierarchyBudgetTypeCode = pdForm.getNewHierarchyBudgetTypeCode();
        if (hierarchyProposal == null) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposalNumber", "error.required", new String[]{"Link to Hierarchy"});
        } else {
            this.getHierarchyHelper().linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode);
            if (GlobalVariables.getMessageMap().containsMessageKey("question.hierarchy.extendDate.confirm")) {
                return this.doEndDateConfirmation(mapping, form, request, response, "linkToHierarchy", "linkToHierarchyConfirm");
            }
            pdForm.setNewHierarchyProposalNumber(EMPTY_STRING);
        }
        return mapping.findForward("basic");
    }

    public ActionForward linkToHierarchyConfirm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal hierarchyProposal = this.getHierarchyHelper().getDevelopmentProposal(pdForm.getNewHierarchyProposalNumber());
        DevelopmentProposal newChildProposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        String hierarchyBudgetTypeCode = pdForm.getNewHierarchyBudgetTypeCode();
        if (hierarchyProposal == null) {
            GlobalVariables.getMessageMap().putError("newHierarchyProposalNumber", "error.required", new String[]{"Link to Hierarchy"});
        } else {
            this.getHierarchyHelper().linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode, true);
            pdForm.setNewHierarchyProposalNumber(EMPTY_STRING);
        }
        return mapping.findForward("basic");
    }

    public ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        pdDoc.prepareForSave();
        return super.cancel(mapping, form, request, response);
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long instPropId;
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        ActionForward forward = super.disapprove(mapping, form, request, response);
        if (StringUtils.isNotBlank((String)request.getParameter("reason")) && (instPropId = this.findInstProposalNumber(pdDoc.getDevelopmentProposal().getProposalNumber())) != null) {
            InstitutionalProposal instProp = (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)instPropId);
            GlobalVariables.getUserSession().addObject("DISAPPROVED_PD_WITH_LINKED_IP", (Object)Boolean.TRUE);
            String versionNumber = this.createInstitutionalProposalVersion(instProp.getProposalNumber(), pdDoc.getDevelopmentProposal(), pdDoc.getFinalBudgetForThisProposal());
            GlobalVariables.getUserSession().removeObject("DISAPPROVED_PD_WITH_LINKED_IP");
            KNSGlobalVariables.getMessageList().add("message.institutionalproposal.versioned", new String[]{versionNumber, pdForm.getInstitutionalProposalToVersion()});
            boolean isIPProtocolLinkingEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.institute.proposal.linking.enabled");
            Long institutionalProposalId = this.getActiveProposalId(instProp.getProposalNumber());
            this.persistProposalAdminDetails(pdDoc.getDevelopmentProposal().getProposalNumber(), institutionalProposalId);
            this.persistSpecialReviewProtocolFundingSourceLink(institutionalProposalId, isIPProtocolLinkingEnabled);
        }
        return forward;
    }

    public ActionForward fyi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentForm)form).getDocument().prepareForSave();
        return super.fyi(mapping, form, request, response);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnForward = super.blanketApprove(mapping, form, request, response);
        String routeHeaderId = ((ProposalDevelopmentForm)form).getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "actions", "ProposalDevelopmentDocument");
        ActionForward forward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(forward, returnForward, holdingPageForward, returnLocation);
    }

    public ActionForward acknowledge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentForm)form).getDocument().prepareForSave();
        return super.acknowledge(mapping, form, request, response);
    }

    public ActionForward printCurrentReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = (CurrentAndPendingReportService)KraServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printCurrentAndPendingSupportReport("Current Report", reportParameters);
        this.streamToResponse(dataStream.getContent(), dataStream.getFileName(), null, response);
        return null;
    }

    public ActionForward printPendingReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = (CurrentAndPendingReportService)KraServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printCurrentAndPendingSupportReport("Pending Report", reportParameters);
        this.streamToResponse(dataStream.getContent(), dataStream.getFileName(), null, response);
        return null;
    }

    public ActionForward prepareCurrentReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("currentReportRows", (Object)helper.prepareCurrentReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    public ActionForward preparePendingReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("pendingReportRows", (Object)helper.preparePendingReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    private ActionForward doEndDateConfirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String yesMethodName) throws Exception {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getErrorMessagesForProperty("newHierarchyChildProposalNumber");
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        for (ErrorMessage error : errors) {
            if (!error.getErrorKey().equals("question.hierarchy.extendDate.confirm")) continue;
            proposalNumbers.add(error.getMessageParameters()[0]);
        }
        String proposalNumberList = StringUtils.join(proposalNumbers, (char)',');
        StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, questionId, "question.hierarchy.extendDate.confirm", new String[]{proposalNumberList});
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        GlobalVariables.getMessageMap().getWarningMessages().clear();
        GlobalVariables.getMessageMap().getInfoMessages().clear();
        return this.confirm(question, yesMethodName, "hierarchyActionCanceled");
    }

    private boolean autogenerateInstitutionalProposal() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "proposaldevelopment.autogenerate.institutionalproposal");
    }

    public ActionForward deleteProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().isInHierarchy()) {
            KNSGlobalVariables.getMessageList().add((Object)new ErrorMessage("error.proposalDevelopment.deleteproposal.inhierarchy", new String[0]));
            return mapping.findForward("basic");
        }
        StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, DOCUMENT_DELETE_QUESTION, "document.question.deleteProposal.text", new String[0]);
        return this.confirm(question, "confirmDeleteProposal", EMPTY_STRING);
    }

    public ActionForward confirmDeleteProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm propDevForm = (ProposalDevelopmentForm)form;
        ((ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class)).deleteProposal(propDevForm.getProposalDevelopmentDocument());
        return mapping.findForward("portal");
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        ProposalDevelopmentNotificationRenderer renderer = new ProposalDevelopmentNotificationRenderer(developmentProposal);
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(developmentProposal, null, "Ad-Hoc Notification", (NotificationRenderer)renderer);
        proposalDevelopmentForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
        return mapping.findForward("notificationEditor");
    }

    protected KraWorkflowService getKraWorkflowService() {
        if (this.kraWorkflowService == null) {
            this.kraWorkflowService = (KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class);
        }
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KraWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }

    public ActionForward addProposalBudgetChangedData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetDocument budgetDocument = null;
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        KraPersistenceStructureService kraPersistenceStructureService = (KraPersistenceStructureService)KraServiceLocator.getService(KraPersistenceStructureService.class);
        ActionForward forward = mapping.findForward("basic");
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDocument = pdForm.getProposalDevelopmentDocument();
        HashMap<String, String> budgetMap = new HashMap<String, String>();
        budgetMap.put("parentDocumentKey", pdDocument.getDocumentNumber());
        BudgetChangedData newBudgetChangedData = pdForm.getNewBudgetChangedData();
        newBudgetChangedData.setProposalNumber(pdDocument.getDevelopmentProposal().getProposalNumber());
        Collection budgetDocuments = boService.findMatching(BudgetDocument.class, budgetMap);
        for (BudgetDocument document : budgetDocuments) {
            if (!document.getBudget().getFinalVersionFlag().booleanValue()) continue;
            budgetDocument = document;
            break;
        }
        newBudgetChangedData.setChangeNumber(Integer.valueOf(this.getBudgetNextChangeNumber(boService, newBudgetChangedData.getProposalNumber(), newBudgetChangedData.getColumnName())));
        if (StringUtils.isEmpty((String)newBudgetChangedData.getDisplayValue()) && StringUtils.isNotEmpty((String)newBudgetChangedData.getChangedValue())) {
            newBudgetChangedData.setDisplayValue(newBudgetChangedData.getChangedValue());
        }
        String tmpLookupReturnPk = EMPTY_STRING;
        if (newBudgetChangedData.getEditableColumn() != null) {
            tmpLookupReturnPk = newBudgetChangedData.getEditableColumn().getLookupPkReturn();
        }
        newBudgetChangedData.refreshReferenceObject("editableColumn");
        newBudgetChangedData.getEditableColumn().setLookupPkReturn(tmpLookupReturnPk);
        if (newBudgetChangedData.getEditableColumn() != null && !newBudgetChangedData.getEditableColumn().getHasLookup()) {
            newBudgetChangedData.setDisplayValue(newBudgetChangedData.getChangedValue());
        }
        if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new BudgetDataOverrideEvent(pdForm.getProposalDevelopmentDocument(), newBudgetChangedData))) {
            boService.save((PersistableBusinessObject)newBudgetChangedData);
            BudgetVersionOverview budgetVersionWrapper = this.createProposalBudgetWrapper(budgetDocument);
            Map columnToAttributesMap = kraPersistenceStructureService.getDBColumnToObjectAttributeMap(BudgetVersionOverview.class);
            String proposalAttributeToPersist = (String)columnToAttributesMap.get(newBudgetChangedData.getColumnName());
            ObjectUtils.setObjectProperty((Object)budgetVersionWrapper, (String)proposalAttributeToPersist, (Object)newBudgetChangedData.getChangedValue());
            ObjectUtils.setObjectProperty((Object)budgetDocument.getBudget(), (String)proposalAttributeToPersist, (Object)newBudgetChangedData.getChangedValue());
            boService.save((PersistableBusinessObject)budgetVersionWrapper);
            budgetDocument.setVersionNumber(budgetVersionWrapper.getVersionNumber());
            pdForm.setNewBudgetChangedData(new BudgetChangedData());
            this.growProposalBudgetChangedHistory(pdDocument, newBudgetChangedData);
        }
        return forward;
    }

    private void growProposalBudgetChangedHistory(ProposalDevelopmentDocument proposalDevelopmentDocument, BudgetChangedData newBudgetChangedData) {
        Map changeHistory = proposalDevelopmentDocument.getDevelopmentProposal().getBudgetChangeHistory();
        if (changeHistory.get(newBudgetChangedData.getEditableColumn().getColumnLabel()) == null) {
            changeHistory.put(newBudgetChangedData.getEditableColumn().getColumnLabel(), new ArrayList());
        }
        ((List)changeHistory.get(newBudgetChangedData.getEditableColumn().getColumnLabel())).add(0, newBudgetChangedData);
    }

    private BudgetVersionOverview createProposalBudgetWrapper(BudgetDocument budgetDocument) throws Exception {
        BudgetVersionOverview budgetVersionWrapper = new BudgetVersionOverview();
        PersistenceStructureService persistentStructureService = (PersistenceStructureService)KraServiceLocator.getService(PersistenceStructureService.class);
        List fieldsToUpdate = persistentStructureService.listFieldNames(BudgetVersionOverview.class);
        for (String field : fieldsToUpdate) {
            boolean noSuchFieldPD = false;
            boolean noSuchFieldBO = false;
            Object tempVal = null;
            try {
                tempVal = ObjectUtils.getPropertyValue((Object)budgetDocument, (String)field);
            }
            catch (Exception e) {
                noSuchFieldPD = true;
            }
            try {
                tempVal = ObjectUtils.getPropertyValue((Object)budgetDocument.getBudget(), (String)field);
            }
            catch (Exception e) {
                noSuchFieldBO = true;
            }
            if (tempVal == null && noSuchFieldPD && noSuchFieldBO) {
                LOG.warn((Object)("Could not find property " + field + " in BudgettDocument or Budget bo."));
            }
            ObjectUtils.setObjectProperty((Object)budgetVersionWrapper, (String)field, (Object)(tempVal != null ? tempVal : null));
        }
        return budgetVersionWrapper;
    }

    private int getBudgetNextChangeNumber(BusinessObjectService boService, String proposalNumber, String columnName) {
        int changeNumber = 0;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("proposalNumber", proposalNumber);
        keyMap.put("columnName", columnName);
        List changedDataList = (List)boService.findMatchingOrderBy(BudgetChangedData.class, keyMap, "changeNumber", true);
        if (CollectionUtils.isNotEmpty((Collection)changedDataList)) {
            changeNumber = ((BudgetChangedData)changedDataList.get(changedDataList.size() - 1)).getChangeNumber();
        }
        return ++changeNumber;
    }

    public ActionForward takeSuperUserActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.TAKE_SUPER_USER_ACTIONS, mapping, form, request, response);
    }

    public ActionForward saveXml(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)proposalDevelopmentForm.getDocument();
        proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(Boolean.valueOf(true));
        proposalDevelopmentForm.setDocument((Document)proposalDevelopmentDocument);
        return super.printForms(mapping, (ActionForm)proposalDevelopmentForm, request, response);
    }

    public ActionForward superUserApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.SUPER_USER_APPROVE, mapping, form, request, response);
    }

    protected ActionForward superUserActionHelper(SuperUserAction actionName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        ActionForward forward = mapping.findForward("basic");
        if (!pdDoc.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            proposalDevelopmentForm.setAuditActivated(true);
            int status = this.isValidSubmission(proposalDevelopmentForm);
            boolean userSaysOk = false;
            if (status == 1) {
                if (question == null) {
                    List selectedActionRequests = proposalDevelopmentForm.getSelectedActionRequests();
                    GlobalVariables.getUserSession().addObject(SUPER_USER_ACTION_REQUESTS, (Object)selectedActionRequests);
                    try {
                        forward = this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, ROUTING_WARNING_MESSAGE, "confirmationQuestion", methodToCall, EMPTY_STRING);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                    proposalDevelopmentForm.setSelectedActionRequests((List)GlobalVariables.getUserSession().retrieveObject(SUPER_USER_ACTION_REQUESTS));
                    GlobalVariables.getUserSession().removeObject(SUPER_USER_ACTION_REQUESTS);
                    userSaysOk = true;
                } else if (DOCUMENT_APPROVE_QUESTION.equals(question)) {
                    userSaysOk = true;
                }
            }
            if (status == 0 || userSaysOk) {
                switch (1.$SwitchMap$org$kuali$kra$proposaldevelopment$web$struts$action$ProposalDevelopmentActionsAction$SuperUserAction[actionName.ordinal()]) {
                    case 1: {
                        forward = super.superUserApprove(mapping, (ActionForm)proposalDevelopmentForm, request, response);
                        break;
                    }
                    case 2: {
                        forward = super.takeSuperUserActions(mapping, (ActionForm)proposalDevelopmentForm, request, response);
                    }
                }
            } else if (status != 1) {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
                if (pdDoc.getDevelopmentProposal().getContinuedFrom() != null && this.isNewProposalType(pdDoc) && this.isSubmissionApplication(pdDoc)) {
                    GlobalVariables.getMessageMap().putError("someKey", "error.resubmission.invalidProposalTypeSubmissionType", new String[0]);
                }
                forward = mapping.findForward("basic");
            }
        } else {
            switch (1.$SwitchMap$org$kuali$kra$proposaldevelopment$web$struts$action$ProposalDevelopmentActionsAction$SuperUserAction[actionName.ordinal()]) {
                case 1: {
                    forward = super.superUserApprove(mapping, (ActionForm)proposalDevelopmentForm, request, response);
                    break;
                }
                case 2: {
                    forward = super.takeSuperUserActions(mapping, (ActionForm)proposalDevelopmentForm, request, response);
                }
            }
        }
        return forward;
    }
}

