/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.sql.Date;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarcyActionHelper;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentBudgetVersionsAction
extends ProposalDevelopmentAction {
    private static final String TOGGLE_TAB = "toggleTab";
    private static final String CONFIRM_SYNCH_BUDGET_RATE = "confirmSynchBudgetRate";
    private static final String NO_SYNCH_BUDGET_RATE = "noSynchBudgetRate";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("rateClassMap", (Object)this.getBudgetRatesService().getBudgetRateClassMap("O"));
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        if (TOGGLE_TAB.equals(pdForm.getMethodToCall())) {
            BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
            tdcValidator.validateGeneratingWarnings((BudgetParentDocument)pdDoc);
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward addBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        BudgetDocument budgetDocument = this.getBudgetService().addBudgetVersion((BudgetParentDocument)pdDoc, pdForm.getNewBudgetVersionName());
        pdForm.setNewBudgetVersionName("");
        return mapping.findForward("basic");
    }

    private BudgetService getBudgetService() {
        return (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }

    public ActionForward openBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        if (StringUtils.equalsIgnoreCase((String)"TRUE", (String)((String)pdForm.getEditingMode().get("modifyProposalBudget")))) {
            this.save(mapping, form, request, response);
        }
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        BudgetDocumentVersion budgetDocumentToOpen = pdDoc.getBudgetDocumentVersion(this.getSelectedLine(request));
        BudgetVersionOverview budgetToOpen = budgetDocumentToOpen.getBudgetVersionOverview();
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        if (parentDocument == null) {
            budgetDocument.refreshReferenceObject("parentDocument");
        }
        this.checkProjectStartEndDateWarning(budgetDocument);
        Budget budget = budgetDocument.getBudget();
        Collection allPropRates = budgetService.getSavedBudgetRates(budget);
        if (budgetService.checkActivityTypeChange(allPropRates, pdDoc.getDevelopmentProposal().getActivityTypeCode())) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        if (CollectionUtils.isEmpty((Collection)allPropRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        String forward = this.buildForwardUrl(routeHeaderId);
        if (pdForm.isAuditActivated()) {
            forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetParameters.do?auditActivated=true&");
        }
        return new ActionForward(forward, true);
    }

    public void checkProjectStartEndDateWarning(BudgetDocument budgetDocument) {
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        if (parentDocument == null) {
            return;
        }
        Budget aBudget = budgetDocument.getBudget();
        List aList = aBudget.getBudgetPeriods();
        if (parentDocument != null) {
            Date parentStartDate = parentDocument.getBudgetParent().getRequestedStartDateInitial();
            Date parentEndDate = parentDocument.getBudgetParent().getRequestedEndDateInitial();
            Boolean aFlag = false;
            for (BudgetPeriod aBP : aList) {
                if (!parentStartDate.after(aBP.getStartDate()) && !parentEndDate.before(aBP.getEndDate())) continue;
                aFlag = true;
                break;
            }
            if (aFlag.booleanValue()) {
                ErrorReporter errorReporter = new ErrorReporter();
                errorReporter.reportSoftError("projectDatesChanged", "error.project.start.end.date.changed", new String[0]);
            }
        }
    }

    public ActionForward confirmSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, true);
    }

    public ActionForward noSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, false);
    }

    private ActionForward synchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean confirm) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        BudgetDocumentVersion budgetDocumentToOpen = pdDoc.getBudgetDocumentVersion(this.getSelectedLine(request));
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetDocumentToOpen.getDocumentNumber());
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            budgetDocument.getBudget().setActivityTypeCode(pdDoc.getDevelopmentProposal().getActivityTypeCode());
            forward = forward.replace("budgetParameters.do?", "budgetParameters.do?syncBudgetRate=Y&");
        }
        if (pdForm.isAuditActivated()) {
            forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetParameters.do?auditActivated=true&");
        }
        return new ActionForward(forward, true);
    }

    public ActionForward copyBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        BudgetVersionOverview versionToCopy = this.getSelectedVersion(pdForm, request);
        if (StringUtils.isNotBlank((String)request.getParameter("questionIndex"))) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("1".equals(buttonClicked)) {
                return this.copyBudgetPeriodOne(mapping, form, request, response);
            }
            if ("0".equals(buttonClicked)) {
                return this.copyBudgetAllPeriods(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        pdForm.setSaveAfterCopy(true);
        return this.performQuestionWithoutInput(mapping, form, request, response, "copyBudgetQuestion", "A new version of the budget will be created based on version " + versionToCopy.getBudgetVersionNumber() + ".", "copyPeriodsQuestion", pdForm.getMethodToCall(), "");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = pdForm.getProposalDevelopmentDocument();
        boolean valid = true;
        if (!new ProposalHierarcyActionHelper().checkParentChildStatusMatch(pdDoc)) {
            return mapping.findForward("basic");
        }
        if (pdForm.isSaveAfterCopy()) {
            List overviews = pdForm.getProposalDevelopmentDocument().getBudgetDocumentVersions();
            BudgetDocumentVersion copiedDocumentOverview = (BudgetDocumentVersion)overviews.get(overviews.size() - 1);
            BudgetVersionOverview copiedOverview = copiedDocumentOverview.getBudgetVersionOverview();
            String copiedName = copiedOverview.getDocumentDescription();
            copiedOverview.setDocumentDescription("copied placeholder");
            BufferedLogger.debug((Object[])new Object[]{"validating ", copiedName});
            valid = this.getBudgetService().isBudgetVersionNameValid((BudgetParentDocument)pdForm.getProposalDevelopmentDocument(), copiedName);
            copiedOverview.setDocumentDescription(copiedName);
            pdForm.setSaveAfterCopy(!valid);
        }
        if (!(valid &= this.getBudgetService().validateBudgetAuditRuleBeforeSaveBudgetVersion((BudgetParentDocument)pdForm.getProposalDevelopmentDocument()))) {
            int errorBudgetVersion = this.getTentativeFinalBudgetVersion(pdForm);
            if (errorBudgetVersion != -1) {
                GlobalVariables.getMessageMap().putError("document.budgetDocumentVersion[" + (errorBudgetVersion - 1) + "].budgetVersionOverview.budgetStatus", "clear.audit.error.before.change.status.to.complete", new String[0]);
                for (BudgetDocumentVersion budgetDocumentVersion : pdDoc.getBudgetDocumentVersions()) {
                    BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
                    String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
                    budgetVersion.setBudgetStatus(budgetStatusIncompleteCode);
                }
            }
            return mapping.findForward("basic");
        }
        this.setBudgetParentStatus((BudgetParentDocument)pdForm.getProposalDevelopmentDocument());
        ActionForward forward = super.save(mapping, form, request, response);
        if (forward != null && forward.getName().equalsIgnoreCase("actions")) {
            pdForm.setMethodToCall("actions");
            if (pdForm.isAuditActivated()) {
                KNSGlobalVariables.getAuditErrorMap().clear();
            }
        }
        return forward;
    }

    private int getTentativeFinalBudgetVersion(ProposalDevelopmentForm pdForm) {
        if (pdForm.getFinalBudgetVersion() != null) {
            return pdForm.getFinalBudgetVersion();
        }
        ProposalDevelopmentDocument document = pdForm.getProposalDevelopmentDocument();
        int i = 1;
        if (document != null && CollectionUtils.isNotEmpty((Collection)document.getBudgetDocumentVersions())) {
            for (BudgetDocumentVersion budgetDocumentVersion : document.getBudgetDocumentVersions()) {
                BudgetVersionOverview budget = budgetDocumentVersion.getBudgetVersionOverview();
                if (budget.isFinalVersionFlag()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        pdForm.setFinalBudgetVersion(this.getFinalBudgetVersion(pdForm.getProposalDevelopmentDocument().getBudgetDocumentVersions()));
        this.setBudgetStatuses((BudgetParentDocument)pdForm.getProposalDevelopmentDocument());
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        tdcValidator.validateGeneratingWarnings((BudgetParentDocument)pdForm.getProposalDevelopmentDocument());
        return forward;
    }

    public ActionForward copyBudgetPeriodOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyBudgetAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, false);
        }
        return mapping.findForward("basic");
    }

    private BudgetVersionOverview getSelectedVersion(ProposalDevelopmentForm proposalDevelopmentForm, HttpServletRequest request) {
        return proposalDevelopmentForm.getProposalDevelopmentDocument().getBudgetDocumentVersion(this.getSelectedLine(request)).getBudgetVersionOverview();
    }

    private void copyBudget(ActionForm form, HttpServletRequest request, boolean copyPeriodOneOnly) throws WorkflowException {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument pdDoc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        BudgetVersionOverview budgetToCopy = this.getSelectedVersion(proposalDevelopmentForm, request);
        this.copyBudget((BudgetParentDocument)pdDoc, budgetToCopy, copyPeriodOneOnly);
    }

    private StrutsConfirmation syncBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNCH_BUDGET_RATE, message, new String[]{""});
    }

    private BudgetRatesService getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    private ProposalDevelopmentService getProposalDevelopmentService() {
        return (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
    }
}

