/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalDevelopmentHierarchyAction
extends ProposalDevelopmentAction {
    private static final String FORWARD_PROPOSAL_SUMMARY = "ajaxProposalSummary";
    private static final String FORWARD_BUDGET_SUMMARY = "ajaxBudgetSummary";
    private transient ProposalHierarchyService proposalHierarchyService;

    public ActionForward loadProposalSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        String proposalNumber = pdForm.getProposalNumberToSummarize();
        DevelopmentProposal proposal = null;
        if (proposalNumber != null && !proposalNumber.equals("")) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("proposalNumber", proposalNumber);
            proposal = (DevelopmentProposal)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(DevelopmentProposal.class, primaryKeys);
            if (proposal != null) {
                ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).loadBudgetStatus(proposal);
            }
        }
        pdForm.setProposalToSummarize(proposal);
        pdForm.setProposalSummary(this.getProposalHierarchyService().getProposalSummary(proposalNumber));
        return mapping.findForward(FORWARD_PROPOSAL_SUMMARY);
    }

    public ActionForward loadBudgetSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdForm = (ProposalDevelopmentForm)form;
        String budgetIdString = pdForm.getBudgetNumberToSummarize();
        Long budgetId = null;
        Budget budget = null;
        try {
            budgetId = Long.valueOf(budgetIdString);
        }
        catch (NumberFormatException x) {
            budgetId = null;
        }
        if (budgetId != null) {
            HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
            primaryKeys.put("budgetId", budgetId);
            budget = (Budget)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(ProposalDevelopmentBudgetExt.class, primaryKeys);
            if (budget != null) {
                ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudgetSummaryTotals(budget);
                if (budget.getFinalVersionFlag() != null && Boolean.TRUE.equals(budget.getFinalVersionFlag())) {
                    DevelopmentProposal proposal = (DevelopmentProposal)budget.getBudgetDocument().getParentDocument().getBudgetParent();
                    ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).loadBudgetStatus(proposal);
                    budget.setBudgetStatus(proposal.getBudgetStatus());
                } else {
                    String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
                    budget.setBudgetStatus(budgetStatusIncompleteCode);
                }
            }
        }
        pdForm.setBudgetToSummarize(budget);
        pdForm.setProposalHierarchyIndirectObjectCode(this.getParameterService().getParameterValueAsString(BudgetDocument.class, "proposalHierarchySubProjectIndirectCostElement"));
        return mapping.findForward(FORWARD_BUDGET_SUMMARY);
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }
}

